"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isEnabled = exports.CELLTEST_RULES = exports.CELLTEST_TOOL_EDITOR_CLASS = exports.CELLTEST_TOOL_RULES_CLASS = exports.CELLTEST_TOOL_CONTROLS_CLASS = exports.CELLTEST_TOOL_CLASS = exports.CELLTESTS_LINT_CAPTION = exports.CELLTESTS_TEST_CAPTION = exports.CELLTESTS_LINT_ID = exports.CELLTESTS_TEST_ID = exports.CELLTESTS_CATEGORY = void 0;
exports.CELLTESTS_CATEGORY = "Celltests";
exports.CELLTESTS_TEST_ID = "celltests:test";
exports.CELLTESTS_LINT_ID = "celltests:lint";
exports.CELLTESTS_TEST_CAPTION = "Run Celltests";
exports.CELLTESTS_LINT_CAPTION = "Run Lint";
exports.CELLTEST_TOOL_CLASS = "CelltestTool";
exports.CELLTEST_TOOL_CONTROLS_CLASS = "CelltestsControls";
exports.CELLTEST_TOOL_RULES_CLASS = "CelltestsRules";
exports.CELLTEST_TOOL_EDITOR_CLASS = "CelltestsEditor";
exports.CELLTEST_RULES = [
    // TODO fetch from server
    { label: "Lines per Cell", key: "lines_per_cell", min: 1, step: 1, value: 10 },
    { label: "Cells per Notebook", key: "cells_per_notebook", min: 1, step: 1, value: 20 },
    { label: "Function definitions", key: "function_definitions", min: 0, step: 1, value: 10 },
    { label: "Class definitions", key: "class_definitions", min: 0, step: 1, value: 5 },
    { label: "Cell test coverage (%)", key: "cell_coverage", min: 1, max: 100, step: 1, value: 50 },
];
function isEnabled(app, docManager) {
    return () => (app.shell.currentWidget &&
        docManager.contextForWidget(app.shell.currentWidget) &&
        docManager.contextForWidget(app.shell.currentWidget).model) ? true : false;
}
exports.isEnabled = isEnabled;
