"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StripeWebhook = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const cdk_secret_key_1 = require("@cloudcomponents/cdk-secret-key");
class StripeWebhook extends core_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const secretKey = typeof props.secretKey === 'string' ? cdk_secret_key_1.SecretKey.fromPlainText(props.secretKey) : props.secretKey;
        const handler = new aws_lambda_1.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: 'e9db3870-d793-4cd2-96a9-efe2e318ebbc',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'stripe-webhook')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::StripeWebhook',
            timeout: core_1.Duration.minutes(15),
        });
        if (secretKey.grantRead) {
            secretKey.grantRead(handler);
        }
        if (props.endpointSecretStore) {
            props.endpointSecretStore.grantWrite(handler);
        }
        const cr = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::StripeWebhook',
            pascalCaseProperties: true,
            properties: {
                url: props.url,
                description: props.description,
                events: props.events,
                logLevel: props.logLevel,
                secretKeyString: secretKey.serialize(),
                endpointSecretStoreString: (_b = props.endpointSecretStore) === null || _b === void 0 ? void 0 : _b.serialize(),
            },
        });
        this.id = cr.ref;
    }
}
exports.StripeWebhook = StripeWebhook;
_a = JSII_RTTI_SYMBOL_1;
StripeWebhook[_a] = { fqn: "@cloudcomponents/cdk-stripe-webhook.StripeWebhook", version: "1.38.1" };
//# sourceMappingURL=data:application/json;base64,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