#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.id3',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20211208',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    ('Support for ID3 tags. A cs.binary based parser/transcriber for ID3 tags and '    
 "a convenience wrapper for Doug Zongker's pyid3lib: "    
 'http://pyid3lib.sourceforge.net/'),
  long_description =
    ('Support for ID3 tags.\n'    
 'A cs.binary based parser/transcriber for ID3 tags\n'    
 "and a convenience wrapper for Doug Zongker's pyid3lib:\n"    
 'http://pyid3lib.sourceforge.net/\n'    
 '\n'    
 '*Latest release 20211208*:\n'    
 '* ID3V1 and ID3V2 support.\n'    
 '* ID3V1Frame,ID3V2Frame: new .tagset() method to return a TagSet.\n'    
 '* ID3V1Frame.parse: trim trailing NULs from the comment field.\n'    
 '* Assorted other small changes.\n'    
 '\n'    
 '## Class '    
 '`EnhancedTagFrame(cs.binary.SimpleBinary,types.SimpleNamespace,cs.binary.AbstractBinary,cs.binary.BinaryMixin)`\n'    
 '\n'    
 'An Enhanced Tag.\n'    
 '\n'    
 '### Method `EnhancedTagFrame.parse(bfr)`\n'    
 '\n'    
 'Parse an enhanced tag.\n'    
 '\n'    
 '### Method `EnhancedTagFrame.transcribe(self)`\n'    
 '\n'    
 'Transcribe the enhanced tag.\n'    
 '\n'    
 '## Class `ID3(types.SimpleNamespace)`\n'    
 '\n'    
 'Wrapper for pyid3lib.tag.\n'    
 '\n'    
 'OBSOLETE.\n'    
 "Going away when I'm sure the other classes cover all this stuff off.\n"    
 '\n'    
 '### Method `ID3.__getitem__(self, key)`\n'    
 '\n'    
 'Fetch the text of the specified frame.\n'    
 '\n'    
 '### Method `ID3.__setitem__(self, key, value)`\n'    
 '\n'    
 'Set a frame text to `value`.\n'    
 '\n'    
 '### Method `ID3.clean(self, attr)`\n'    
 '\n'    
 'Strip NULs and leading and trailing whitespace.\n'    
 '\n'    
 '### Method `ID3.flush(self, *a, **kw)`\n'    
 '\n'    
 'Update the ID3 tags in the file if modified, otherwise no-op.\n'    
 'Clears the modified flag.\n'    
 '\n'    
 '### Method `ID3.get_frame(self, frameid)`\n'    
 '\n'    
 'Return the frame with the specified `frameid`, or None.\n'    
 '\n'    
 '### Property `ID3.tag`\n'    
 '\n'    
 'The tag mapping from `self.pathname`.\n'    
 '\n'    
 '## Class '    
 '`ID3V1Frame(cs.binary.SimpleBinary,types.SimpleNamespace,cs.binary.AbstractBinary,cs.binary.BinaryMixin)`\n'    
 '\n'    
 'An ID3V1 or ID3v1.1 data frame as described in wikipedia:\n'    
 'https://en.wikipedia.org/wiki/ID3\n'    
 '\n'    
 'The following fields are defined:\n'    
 '* `title`: up to 30 ASCII characters\n'    
 '* `artist`: up to 30 ASCII characters\n'    
 '* `album`: up to 30 ASCII characters\n'    
 '* `year`: 4 digit ASCII year\n'    
 '* `comment`: up to 30 ASCII bytes, NUL or whitespace padded,\n'    
 '  up to 28 ASCII bytes if `track` is nonzero\n'    
 '* `track`: 0 for no track, a number from 1 through 255 otherwise;\n'    
 '  if nonzero then the comment field may only be up to 28 bytes long\n'    
 '* `genre_id`: a number value from 0 to 255\n'    
 '\n'    
 '### Method `ID3V1Frame.parse(bfr)`\n'    
 '\n'    
 'Parse a 128 byte ID3V1 or ID3v1.1 record.\n'    
 '\n'    
 '### Method `ID3V1Frame.tagset(self)`\n'    
 '\n'    
 'Return a `TagSet` with the ID3 tag information.\n'    
 '\n'    
 '### Method `ID3V1Frame.transcribe(self)`\n'    
 '\n'    
 'Transcribe the ID3V1 frame.\n'    
 '\n'    
 '## Class '    
 '`ID3V22TagDataFrame(cs.binary.SimpleBinary,types.SimpleNamespace,cs.binary.AbstractBinary,cs.binary.BinaryMixin)`\n'    
 '\n'    
 'An ID3 v2.2.0 tag data frame.\n'    
 '\n'    
 'Reference doc: https://id3.org/id3v2-00\n'    
 '\n'    
 '### Method `ID3V22TagDataFrame.tag_id_class(tag_id)`\n'    
 '\n'    
 'Return the `AbstractBinary` subclass to decode the a tag body from its tag '    
 'id.\n'    
 'Return `None` for unrecognised ids.\n'    
 '\n'    
 '## Class '    
 '`ID3V23TagDataFrame(cs.binary.SimpleBinary,types.SimpleNamespace,cs.binary.AbstractBinary,cs.binary.BinaryMixin)`\n'    
 '\n'    
 'An ID3 v2.3.0 tag data frame.\n'    
 '\n'    
 'Reference doc: https://id3.org/id3v2.3.0\n'    
 '\n'    
 '### Method `ID3V23TagDataFrame.tag_id_class(tag_id)`\n'    
 '\n'    
 'Return the `AbstractBinary` subclass to decode the a tag body from its tag '    
 'id.\n'    
 'Return `None` for unrecognised ids.\n'    
 '\n'    
 '## Class '    
 '`ID3V2Frame(cs.binary.SimpleBinary,types.SimpleNamespace,cs.binary.AbstractBinary,cs.binary.BinaryMixin)`\n'    
 '\n'    
 'An ID3v2 frame, based on the document at:\n'    
 'https://web.archive.org/web/20120527211939/http://www.unixgods.org/~tilo/ID3/docs/id3v2-00.html\n'    
 '\n'    
 '### Method `ID3V2Frame.parse(bfr)`\n'    
 '\n'    
 'Return an ID3v2 frame as described here:\n'    
 '\n'    
 '### Method `ID3V2Frame.tagset(self)`\n'    
 '\n'    
 'Return a `TagSet` with the ID3 tag information.\n'    
 '\n'    
 '### Method `ID3V2Frame.transcribe(self)`\n'    
 '\n'    
 'Transcribe the ID3v2 frame.\n'    
 '\n'    
 '## Class '    
 '`ID3V2Size(cs.binary.BinarySingleValue,cs.binary.AbstractBinary,cs.binary.BinaryMixin)`\n'    
 '\n'    
 'An ID3v2 size field,\n'    
 'a big endian 4 byte field of 7-bit values, high bit 0.\n'    
 '\n'    
 '### Method `ID3V2Size.parse_value(bfr)`\n'    
 '\n'    
 'Read an ID3V2 size field from `bfr`, return the size.\n'    
 '\n'    
 '### Method `ID3V2Size.transcribe_value(size)`\n'    
 '\n'    
 'Transcribe a size in ID3v2 format.\n'    
 '\n'    
 '## Class `ID3V2Tags(types.SimpleNamespace)`\n'    
 '\n'    
 'An `ID3V2Tags` maps ID3V2 tag information as a `SimpleNamespace`.\n'    
 '\n'    
 '### Method `ID3V2Tags.__getattr__(self, attr)`\n'    
 '\n'    
 'Catch frame id attrs and their wordier versions.\n'    
 '\n'    
 '### Method `ID3V2Tags.__setattr__(self, attr, value)`\n'    
 '\n'    
 'Map attributes to frame ids, set the corresponding `__dict__` entry.\n'    
 '\n'    
 '## Class '    
 '`ISO8859_1NULString(cs.binary.BinarySingleValue,cs.binary.AbstractBinary,cs.binary.BinaryMixin)`\n'    
 '\n'    
 'A NUL terminated string encoded with ISO8859-1.\n'    
 '\n'    
 '### Method `ISO8859_1NULString.transcribe_value(s)`\n'    
 '\n'    
 'pylint: disable=arguments-differ\n'    
 '\n'    
 "## Function `padded_text(text, length, encoding='ascii')`\n"    
 '\n'    
 'Encode `text` using `encoding`,\n'    
 'crop to a maximum of `length` bytes,\n'    
 'pad with NULs to `length` if necessary.\n'    
 '\n'    
 "## Function `parse_padded_text(bfr, length, encoding='ascii')`\n"    
 '\n'    
 'Fetch `length` bytes from `bfr`,\n'    
 'strip trailing NULs,\n'    
 "decode using `encoding` (default `'ascii'`),\n"    
 'strip trailling whitepsace.\n'    
 '\n'    
 '## Class '    
 '`TextEncodingClass(cs.binary.BinarySingleValue,cs.binary.AbstractBinary,cs.binary.BinaryMixin)`\n'    
 '\n'    
 'A trite class to parse the single byte text encoding field.\n'    
 '\n'    
 '## Class '    
 '`TextInformationFrameBody(cs.binary.SimpleBinary,types.SimpleNamespace,cs.binary.AbstractBinary,cs.binary.BinaryMixin)`\n'    
 '\n'    
 'A text information frame.\n'    
 '\n'    
 '### Method `TextInformationFrameBody.parse(bfr)`\n'    
 '\n'    
 'Parse the text from the frame.\n'    
 '\n'    
 '### Method `TextInformationFrameBody.transcribe(self)`\n'    
 '\n'    
 'Transcribe the frame.\n'    
 '\n'    
 '## Class '    
 '`UCS2NULString(cs.binary.BinarySingleValue,cs.binary.AbstractBinary,cs.binary.BinaryMixin)`\n'    
 '\n'    
 'A NUL terminated string encoded with UCS-2.\n'    
 '\n'    
 "We're cheating and using UTF16 for this.\n"    
 '\n'    
 '### Method `UCS2NULString.transcribe_value(s)`\n'    
 '\n'    
 'Transcribe text as UTF-16-LE with leading BOM and trailing NUL.\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20211208*:\n'    
 '* ID3V1 and ID3V2 support.\n'    
 '* ID3V1Frame,ID3V2Frame: new .tagset() method to return a TagSet.\n'    
 '* ID3V1Frame.parse: trim trailing NULs from the comment field.\n'    
 '* Assorted other small changes.\n'    
 '\n'    
 '*Release 20160828*:\n'    
 'Use "install_requires" instead of "requires" in DISTINFO.\n'    
 '\n'    
 '*Release 20150116.2*:\n'    
 'pyid3lib not on PyPI, remove from requirements and mention in README\n'    
 '\n'    
 '*Release 20150116*:\n'    
 'Initial PyPI release.'),
  install_requires = ['cs.binary', 'cs.buffer', 'cs.logutils', 'cs.pfx', 'cs.threads'],
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  keywords = ['python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.id3'],
)
