# Generated by Django 3.1.2 on 2020-10-20 11:59

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import imicusfat.models


class Migration(migrations.Migration):

    replaces = [
        ("imicusfat", "0001_initial"),
        ("imicusfat", "0002_manualfat"),
        ("imicusfat", "0003_auto_20180911_0831"),
        ("imicusfat", "0004_clickfatduration"),
        ("imicusfat", "0005_auto_20200816_2042"),
        ("imicusfat", "0006_auto_20200820_2013"),
        ("imicusfat", "0007_auto_20200826_1537"),
        ("imicusfat", "0008_auto_20200912_1121"),
        ("imicusfat", "0009_ifatlink_is_esilink"),
        ("imicusfat", "0010_ifatlinktype_is_enabled"),
        ("imicusfat", "0011_auto_20201004_0936"),
        ("imicusfat", "0012_basic_module_access_permissions"),
        ("imicusfat", "0013_auto_20201019_1649"),
    ]

    initial = True

    dependencies = [
        ("eveonline", "0012_index_additions"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("eveonline", "0010_alliance_ticker"),
    ]

    operations = [
        migrations.CreateModel(
            name="IFatLinkType",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "name",
                    models.CharField(
                        help_text="Descriptive name of your fleet type", max_length=254
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, help_text="Has this been deleted?", null=True
                    ),
                ),
                ("is_enabled", models.BooleanField(db_index=True, default=True)),
            ],
            options={
                "abstract": False,
                "default_permissions": (),
                "verbose_name": "FAT Link Type",
                "verbose_name_plural": "FAT Link Types",
            },
        ),
        migrations.CreateModel(
            name="IFatLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "ifattime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="When was this fatlink created",
                    ),
                ),
                (
                    "fleet",
                    models.CharField(
                        help_text="The fatlinks fleet name", max_length=254, null=True
                    ),
                ),
                (
                    "hash",
                    models.CharField(help_text="The fatlinks hash", max_length=254),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        help_text="Who created the fatlink?",
                        on_delete=models.SET(imicusfat.models.get_sentinel_user),
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, help_text="Has been deleted or not", null=True
                    ),
                ),
                (
                    "link_type",
                    models.ForeignKey(
                        help_text="The fatlinks fleet type, if it's set",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="imicusfat.ifatlinktype",
                    ),
                ),
                (
                    "is_esilink",
                    models.BooleanField(
                        default=False,
                        help_text="Whether this fatlink was created via ESI or not",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("manage_imicusfat", "Can manage the imicusfat module"),
                    ("stats_corp_own", "Can see own corp stats"),
                    ("stats_corp_other", "Can see stats of other corps."),
                    (
                        "stats_char_other",
                        "Can see stats of characters not associated with current user.",
                    ),
                ),
                "ordering": ("-ifattime",),
                "verbose_name": "FAT Link",
                "verbose_name_plural": "FAT Links",
            },
        ),
        migrations.CreateModel(
            name="ClickIFatDuration",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("duration", models.PositiveIntegerField()),
                (
                    "fleet",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="imicusfat.ifatlink",
                    ),
                ),
            ],
            options={
                "verbose_name": "FAT Duration",
                "verbose_name_plural": "FAT Durations",
            },
        ),
        migrations.CreateModel(
            name="ManualIFat",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "character",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveonline.evecharacter",
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        on_delete=models.SET(imicusfat.models.get_sentinel_user),
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "ifatlink",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="imicusfat.ifatlink",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        blank=True,
                        help_text="Time this FAT has been added manually",
                        null=True,
                    ),
                ),
            ],
            options={
                "verbose_name": "Manual FAT Log",
                "verbose_name_plural": "Manual FAT Logs",
            },
        ),
        migrations.CreateModel(
            name="IFat",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "system",
                    models.CharField(
                        help_text="The system the character is in",
                        max_length=100,
                        null=True,
                    ),
                ),
                (
                    "shiptype",
                    models.CharField(
                        help_text="The ship the character was flying",
                        max_length=100,
                        null=True,
                    ),
                ),
                (
                    "character",
                    models.ForeignKey(
                        help_text="Character who registered this fat",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveonline.evecharacter",
                    ),
                ),
                (
                    "ifatlink",
                    models.ForeignKey(
                        help_text="The fatlink the character registered with",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="imicusfat.ifatlink",
                    ),
                ),
                (
                    "deleted_at",
                    models.DateTimeField(
                        blank=True, help_text="Has been deleted or not", null=True
                    ),
                ),
            ],
            options={
                "unique_together": {("character", "ifatlink")},
                "verbose_name": "FAT",
                "verbose_name_plural": "FATs",
            },
        ),
        migrations.CreateModel(
            name="AaImicusFAT",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "verbose_name": "Alliance Auth ImicusFAT",
                "permissions": (
                    ("basic_access", "Can access the Alliance Auth ImicusFAT module"),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="IFatDelLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("deltype", models.BooleanField(default=0)),
                ("string", models.CharField(max_length=100)),
                (
                    "remover",
                    models.ForeignKey(
                        on_delete=models.SET(imicusfat.models.get_sentinel_user),
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "default_permissions": (),
                "verbose_name": "Delete Log",
                "verbose_name_plural": "Delete Logs",
            },
        ),
    ]
