"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

# Represents a chunk of data sent by the transfer service. Includes fields for
# configuring the transfer parameters.
#
# Notation: (Read|Write) (→|←)
#   X → Means client sending data to the server.
#   X ← Means server sending data to the client.
class Chunk(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    TRANSFER_ID_FIELD_NUMBER: builtins.int
    PENDING_BYTES_FIELD_NUMBER: builtins.int
    MAX_CHUNK_SIZE_BYTES_FIELD_NUMBER: builtins.int
    MIN_DELAY_MICROSECONDS_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    REMAINING_BYTES_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    # Represents the source or destination of the data. May be ephemeral or
    # stable depending on the implementation. Sent in every request to identify
    # the transfer target.
    #
    #  Read → ID of transfer
    #  Read ← ID of transfer
    # Write → ID of transfer
    # Write ← ID of transfer
    transfer_id: builtins.int = ...
    # Used by the receiver to indicate how many bytes it can accept. The
    # transmitter sends this much data, divided into chunks no larger than
    # max_chunk_size_bytes. The receiver then starts another window by sending
    # request_bytes again with a new offset.
    #
    #  Read → The client requests this many bytes to be sent.
    #  Read ← N/A
    # Write → N/A
    # Write ← The server requests this many bytes to be sent.
    pending_bytes: builtins.int = ...
    # Maximum size of an individual chunk. The transmitter may send smaller
    # chunks if required.
    #
    #  Read → Set maximum size for subsequent chunks.
    #  Read ← N/A
    # Write → N/A
    # Write ← Set maximum size for subsequent chunks.
    max_chunk_size_bytes: builtins.int = ...
    # Minimum required delay between chunks. The transmitter may delay longer if
    # desired.
    #
    #  Read → Set minimum delay for subsequent chunks.
    #  Read ← N/A
    # Write → N/A
    # Write ← Set minimum delay for subsequent chunks.
    min_delay_microseconds: builtins.int = ...
    # On writes, the offset of the data. On reads, the offset at which to read.
    #
    #  Read → Read data starting at this offset.
    #  Read ← Offset of the data.
    # Write → Offset of the data.
    # Write ← Write data starting at this offset.
    offset: builtins.int = ...
    # The data that was read or the data to write.
    #
    #  Read → N/A
    #  Read ← Data read
    # Write → Data to write
    # Write ← N/A
    data: builtins.bytes = ...
    # Estimated bytes remaining to read/write. Optional except for the last data
    # chunk, for which remaining_bytes must be set to 0.
    #
    # The sender can set remaining_bytes at the beginning of a read/write so that
    # the receiver can track progress or cancel the transaction if the value is
    # too large.
    #
    #  Read → N/A
    #  Read ← Remaining bytes to read, excluding any data in this chunk. Set to
    #         0 for the last chunk.
    # Write → Reamining bytes to write, excluding any data in is chunk. Set to
    #         0 for the last chunk.
    # Write ← N/A
    remaining_bytes: builtins.int = ...
    # Pigweed status code indicating the completion of a transfer. This is only
    # present in the final packet sent by either the transmitter or receiver.
    #
    # The possible status codes and their meanings are listed below:
    #
    #   OK: Transfer completed successfully.
    #   DATA_LOSS: Transfer data could not be read/written (e.g. corruption).
    #   INVALID_ARGUMENT: Received malformed chunk.
    #   NOT_FOUND: The requested transfer ID is not registered (read/write).
    #   OUT_OF_RANGE: The requested offset is larger than the data (read/write).
    #   RESOURCE_EXHAUSTED: Concurrent transfer limit reached.
    #   UNIMPLEMENTED: Transfer ID does not support requested operation (e.g.
    #       trying to write to a read-only transfer).
    #
    #  Read → Transfer complete.
    #  Read ← Transfer complete.
    # Write → Transfer complete.
    # Write ← Transfer complete.
    status: builtins.int = ...
    def __init__(self,
        *,
        transfer_id : builtins.int = ...,
        pending_bytes : builtins.int = ...,
        max_chunk_size_bytes : builtins.int = ...,
        min_delay_microseconds : builtins.int = ...,
        offset : builtins.int = ...,
        data : builtins.bytes = ...,
        remaining_bytes : builtins.int = ...,
        status : builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"_max_chunk_size_bytes",b"_max_chunk_size_bytes",u"_min_delay_microseconds",b"_min_delay_microseconds",u"_pending_bytes",b"_pending_bytes",u"_remaining_bytes",b"_remaining_bytes",u"_status",b"_status",u"max_chunk_size_bytes",b"max_chunk_size_bytes",u"min_delay_microseconds",b"min_delay_microseconds",u"pending_bytes",b"pending_bytes",u"remaining_bytes",b"remaining_bytes",u"status",b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"_max_chunk_size_bytes",b"_max_chunk_size_bytes",u"_min_delay_microseconds",b"_min_delay_microseconds",u"_pending_bytes",b"_pending_bytes",u"_remaining_bytes",b"_remaining_bytes",u"_status",b"_status",u"data",b"data",u"max_chunk_size_bytes",b"max_chunk_size_bytes",u"min_delay_microseconds",b"min_delay_microseconds",u"offset",b"offset",u"pending_bytes",b"pending_bytes",u"remaining_bytes",b"remaining_bytes",u"status",b"status",u"transfer_id",b"transfer_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_max_chunk_size_bytes",b"_max_chunk_size_bytes"]) -> typing.Optional[typing_extensions.Literal["max_chunk_size_bytes"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_min_delay_microseconds",b"_min_delay_microseconds"]) -> typing.Optional[typing_extensions.Literal["min_delay_microseconds"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_pending_bytes",b"_pending_bytes"]) -> typing.Optional[typing_extensions.Literal["pending_bytes"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_remaining_bytes",b"_remaining_bytes"]) -> typing.Optional[typing_extensions.Literal["remaining_bytes"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_status",b"_status"]) -> typing.Optional[typing_extensions.Literal["status"]]: ...
global___Chunk = Chunk
