/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.Map;
import netscape.javascript.JSObject;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlArgusReader
extends XmlReader {
    String[] argusImplementedAttributes = new String[]{"order"};
    String[] keepCharsList = new String[]{"name", "x", "y", "z", "formalchg", "atomkey", "atsym"};
    String atomName1;
    String atomName2;
    int bondOrder;
    int elementContext;
    static final int UNSET = 0;
    static final int MOLECULE = 1;
    static final int ATOM = 2;
    static final int BOND = 3;

    XmlArgusReader() {
    }

    @Override
    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, XMLReader xMLReader) {
        this.parent = xmlReader;
        this.reader = bufferedReader;
        this.atomSetCollection = atomSetCollection;
        new ArgusHandler(xMLReader);
        this.parseReaderXML(xMLReader);
    }

    @Override
    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, JSObject jSObject) {
        this.parent = xmlReader;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = this.argusImplementedAttributes;
        new ArgusHandler().walkDOMTree(jSObject);
    }

    @Override
    public void processStartElement(String string, String string2, String string3, Map<String, String> map) {
        int n = this.keepCharsList.length;
        while (--n >= 0) {
            if (!this.keepCharsList[n].equals(string2)) continue;
            this.setKeepChars(true);
            break;
        }
        if ("molecule".equals(string2)) {
            this.atomSetCollection.newAtomSet();
            return;
        }
        if ("atom".equals(string2)) {
            this.elementContext = 2;
            this.atom = new Atom();
            return;
        }
        if ("bond".equals(string2)) {
            this.elementContext = 3;
            this.atomName1 = null;
            this.atomName2 = null;
            this.bondOrder = this.parseBondToken(map.get("order"));
            return;
        }
    }

    int parseBondToken(String string) {
        float f = this.parseFloat(string);
        if (Float.isNaN(f) && string.length() >= 1) {
            string = string.toUpperCase();
            switch (string.charAt(0)) {
                case 'S': {
                    return 1;
                }
                case 'D': {
                    return 2;
                }
                case 'T': {
                    return 3;
                }
                case 'A': {
                    return 515;
                }
            }
            return this.parseInt(string);
        }
        if ((double)f == 1.5) {
            return 515;
        }
        if (f == 2.0f) {
            return 2;
        }
        if (f == 3.0f) {
            return 3;
        }
        return 1;
    }

    @Override
    public void processEndElement(String string, String string2, String string3) {
        if (this.chars != null && this.chars.length() > 0 && this.chars.charAt(this.chars.length() - 1) == '\n') {
            this.chars = this.chars.substring(0, this.chars.length() - 1);
        }
        if ("molecule".equals(string2)) {
            this.elementContext = 0;
            return;
        }
        if ("atom".equals(string2)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            this.elementContext = 0;
            return;
        }
        if ("bond".equals(string2)) {
            if (this.atomName2 != null) {
                this.atomSetCollection.addNewBond(this.atomName1, this.atomName2, this.bondOrder);
            }
            this.elementContext = 0;
            return;
        }
        if (this.elementContext == 1) {
            if ("name".equals(string2)) {
                this.atomSetCollection.setAtomSetName(this.chars);
                this.setKeepChars(false);
            }
            return;
        }
        if (this.atom != null && this.elementContext == 2) {
            if ("x".equals(string2)) {
                this.atom.x = this.parseFloat(this.chars);
            } else {
                if ("y".equals(string2)) {
                    this.atom.y = this.parseFloat(this.chars);
                    return;
                }
                if ("z".equals(string2)) {
                    this.atom.z = this.parseFloat(this.chars);
                    return;
                }
                if ("atsym".equals(string2)) {
                    this.atom.elementSymbol = this.chars;
                    return;
                }
                if ("formalchg".equals(string2)) {
                    this.atom.formalCharge = this.parseInt(this.chars);
                } else if ("atomkey".equals(string2)) {
                    this.atom.atomName = this.chars;
                }
            }
            this.setKeepChars(false);
            return;
        }
        if (this.elementContext == 3) {
            if ("atomkey".equals(string2)) {
                if (this.atomName1 == null) {
                    this.atomName1 = this.chars;
                } else {
                    this.atomName2 = this.chars;
                }
                this.setKeepChars(false);
            }
            return;
        }
    }

    class ArgusHandler
    extends XmlReader.JmolXmlHandler {
        ArgusHandler() {
            super(XmlArgusReader.this);
        }

        ArgusHandler(XMLReader xMLReader) {
            super(XmlArgusReader.this);
            this.setHandler(xMLReader, this);
        }
    }
}

