/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Platform3D;

public class Text3D {
    private int height;
    private int ascent;
    private int width;
    private int mapWidth;
    private int size;
    private int[] bitmap;
    private boolean isInvalid;
    private static final Map<Font3D, Map<String, Text3D>> htFont3d = new Hashtable<Font3D, Map<String, Text3D>>();
    private static final Map<Font3D, Map<String, Text3D>> htFont3dAntialias = new Hashtable<Font3D, Map<String, Text3D>>();
    private static boolean working;

    public int getWidth() {
        return this.width;
    }

    public static int plot(int n, int n2, int n3, int n4, String string, Font3D font3D, Graphics3D graphics3D, JmolRendererInterface jmolRendererInterface, boolean bl) {
        if (string.length() == 0) {
            return 0;
        }
        if (string.indexOf("<su") >= 0) {
            return Text3D.plotByCharacter(n, n2, n3, n4, string, font3D, graphics3D, jmolRendererInterface, bl);
        }
        int n5 = font3D.fontMetrics.getAscent();
        Text3D text3D = Text3D.getText3D(n, n2 -= n5, graphics3D, string, font3D, bl);
        if (text3D.isInvalid) {
            return text3D.width;
        }
        if (bl && (n4 & 0xC0C0C0) == 0) {
            n4 |= 0x40404;
        }
        if (jmolRendererInterface != null || n < 0 || n + text3D.width > graphics3D.width || n2 < 0 || n2 + text3D.height > graphics3D.height) {
            Text3D.plotClipped(n, n2, n3, n4, graphics3D, jmolRendererInterface, text3D.mapWidth, text3D.height, text3D.bitmap);
        } else {
            Text3D.plotUnclipped(n, n2, n3, n4, graphics3D, text3D.mapWidth, text3D.height, text3D.bitmap);
        }
        return text3D.width;
    }

    public static void plotImage(int n, int n2, int n3, Image image, Graphics3D graphics3D, JmolRendererInterface jmolRendererInterface, boolean bl, int n4, int n5, int n6) {
        int n7;
        boolean bl2 = n == Integer.MIN_VALUE;
        int n8 = image.getWidth(null);
        int n9 = image.getHeight(null);
        int n10 = n7 = bl2 ? graphics3D.bgcolor : n4;
        if (bl2) {
            n = 0;
            n3 = 0x7FFFFFFE;
            n5 = graphics3D.width;
            n6 = graphics3D.height;
        }
        if (n + n5 <= 0 || n >= graphics3D.width || n2 + n6 <= 0 || n2 >= graphics3D.height) {
            return;
        }
        graphics3D.platform.checkOffscreenSize(n5, n6);
        Graphics graphics = graphics3D.platform.gOffscreen;
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(5, 1.0f));
            graphics.setColor(bl2 ? new Color(n7) : new Color(0, 0, 0, 0));
            graphics.fillRect(0, 0, n5, n6);
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics.drawImage(image, 0, 0, n5, n6, 0, 0, n8, n9, null);
        } else {
            graphics.clearRect(0, 0, n5, n6);
            graphics.drawImage(image, 0, 0, n5, n6, 0, 0, n8, n9, null);
        }
        PixelGrabber pixelGrabber = new PixelGrabber(graphics3D.platform.imageOffscreen, 0, 0, n5, n6, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        int[] nArray = (int[])pixelGrabber.getPixels();
        if (jmolRendererInterface != null || n < 0 || n + n5 > graphics3D.width || n2 < 0 || n2 + n6 > graphics3D.height) {
            Text3D.plotImageClipped(n, n2, n3, graphics3D, jmolRendererInterface, n5, n6, nArray, n7);
        } else {
            Text3D.plotImageUnClipped(n, n2, n3, graphics3D, n5, n6, nArray, n7);
        }
    }

    private static void plotImageClipped(int n, int n2, int n3, Graphics3D graphics3D, JmolRendererInterface jmolRendererInterface, int n4, int n5, int[] nArray, int n6) {
        if (jmolRendererInterface == null) {
            jmolRendererInterface = graphics3D;
        }
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n8;
                if ((n8 = nArray[n7++]) != n6 && (n8 & 0xFF000000) == -16777216) {
                    jmolRendererInterface.plotPixelClippedNoSlab(n8, n + j, n2 + i, n3);
                    continue;
                }
                if (n8 != 0 || n6 == 0) continue;
                jmolRendererInterface.plotPixelClippedNoSlab(n6, n + j, n2 + i, n3);
            }
        }
    }

    private static void plotImageUnClipped(int n, int n2, int n3, Graphics3D graphics3D, int n4, int n5, int[] nArray, int n6) {
        int[] nArray2 = graphics3D.zbuf;
        int n7 = graphics3D.width;
        int n8 = n2 * n7 + n;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n9 < n5) {
            while (n10 < n4) {
                if (n3 < nArray2[n8]) {
                    int n12 = nArray[n11];
                    if (n12 != n6 && (n12 & 0xFF000000) == -16777216) {
                        graphics3D.addPixel(n8, n3, n12);
                    } else if (n12 == 0 && n6 != 0) {
                        graphics3D.addPixel(n8, n3, n6);
                    }
                }
                ++n11;
                ++n10;
                ++n8;
            }
            ++n9;
            n10 -= n4;
            n8 += n7 - n4;
        }
    }

    private static int plotByCharacter(int n, int n2, int n3, int n4, String string, Font3D font3D, Graphics3D graphics3D, JmolRendererInterface jmolRendererInterface, boolean bl) {
        int n5 = 0;
        int n6 = string.length();
        int n7 = (int)((double)font3D.fontMetrics.getHeight() * 0.25);
        int n8 = -((int)((double)font3D.fontMetrics.getHeight() * 0.3));
        for (int i = 0; i < n6; ++i) {
            if (string.charAt(i) == '<') {
                if (i + 4 < n6 && string.substring(i, i + 5).equals("<sub>")) {
                    i += 4;
                    n2 += n7;
                    continue;
                }
                if (i + 4 < n6 && string.substring(i, i + 5).equals("<sup>")) {
                    i += 4;
                    n2 += n8;
                    continue;
                }
                if (i + 5 < n6 && string.substring(i, i + 6).equals("</sub>")) {
                    i += 5;
                    n2 -= n7;
                    continue;
                }
                if (i + 5 < n6 && string.substring(i, i + 6).equals("</sup>")) {
                    i += 5;
                    n2 -= n8;
                    continue;
                }
            }
            int n9 = Text3D.plot(n + n5, n2, n3, n4, string.substring(i, i + 1), font3D, graphics3D, jmolRendererInterface, bl);
            n5 += n9;
        }
        return n5;
    }

    private static void plotUnclipped(int n, int n2, int n3, int n4, Graphics3D graphics3D, int n5, int n6, int[] nArray) {
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int[] nArray2 = graphics3D.zbuf;
        int n11 = graphics3D.width;
        int n12 = n2 * n11 + n;
        while (n9 < n6) {
            while (n10 < n5) {
                if ((n7 & 0x1F) == 0) {
                    n8 = nArray[n7 >> 5];
                }
                if (n8 == 0) {
                    int n13 = 32 - (n7 & 0x1F);
                    n10 += n13;
                    n7 += n13;
                    n12 += n13;
                    continue;
                }
                if (n8 < 0 && n3 < nArray2[n12]) {
                    graphics3D.addPixel(n12, n3, n4);
                }
                n8 <<= 1;
                ++n7;
                ++n10;
                ++n12;
            }
            while (n10 >= n5) {
                ++n9;
                n10 -= n5;
                n12 += n11 - n5;
            }
        }
    }

    private static void plotClipped(int n, int n2, int n3, int n4, Graphics3D graphics3D, JmolRendererInterface jmolRendererInterface, int n5, int n6, int[] nArray) {
        if (jmolRendererInterface == null) {
            jmolRendererInterface = graphics3D;
        }
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n9 < n6) {
            while (n10 < n5) {
                if ((n7 & 0x1F) == 0) {
                    n8 = nArray[n7 >> 5];
                }
                if (n8 == 0) {
                    int n11 = 32 - (n7 & 0x1F);
                    n10 += n11;
                    n7 += n11;
                    continue;
                }
                if (n8 < 0) {
                    jmolRendererInterface.plotPixelClippedNoSlab(n4, n + n10, n2 + n9, n3);
                }
                n8 <<= 1;
                ++n7;
                ++n10;
            }
            while (n10 >= n5) {
                ++n9;
                n10 -= n5;
            }
        }
    }

    private Text3D(String string, Font3D font3D, boolean bl) {
        FontMetrics fontMetrics = font3D.fontMetrics;
        this.ascent = fontMetrics.getAscent();
        this.height = this.ascent + fontMetrics.getDescent();
        this.width = fontMetrics.stringWidth(string);
        if (this.width == 0) {
            return;
        }
        this.mapWidth = this.width;
        this.size = this.mapWidth * this.height;
    }

    private void renderOffscreen(String string, Font3D font3D, Platform3D platform3D, boolean bl) {
        Graphics graphics = platform3D.gOffscreen;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.mapWidth, this.height);
        graphics.setColor(Color.white);
        graphics.setFont(font3D.font);
        graphics.drawString(string, 0, this.ascent);
    }

    private void rasterize(Platform3D platform3D, boolean bl) {
        PixelGrabber pixelGrabber = new PixelGrabber(platform3D.imageOffscreen, 0, 0, this.mapWidth, this.height, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        int[] nArray = (int[])pixelGrabber.getPixels();
        int n = this.size + 31 >> 5;
        this.bitmap = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            if ((nArray[n3] & 0xFFFFFF) != 0) {
                n2 |= 1;
            }
            if ((n3 & 0x1F) == 31) {
                this.bitmap[n3 >> 5] = n2;
            }
            ++n3;
            n2 <<= 1;
        }
        if ((n3 & 0x1F) != 0) {
            this.bitmap[n3 >> 5] = n2 <<= 31 - (n3 & 0x1F);
        }
    }

    public static synchronized void clearFontCache() {
        if (working) {
            return;
        }
        htFont3d.clear();
        htFont3dAntialias.clear();
    }

    private static synchronized Text3D getText3D(int n, int n2, Graphics3D graphics3D, String string, Font3D font3D, boolean bl) {
        working = true;
        Map<Font3D, Map<String, Text3D>> map = bl ? htFont3dAntialias : htFont3d;
        Map<String, Text3D> map2 = map.get(font3D);
        Text3D text3D = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (map2 != null) {
            text3D = map2.get(string);
        } else {
            map2 = new Hashtable<String, Text3D>();
            bl2 = true;
        }
        if (text3D == null) {
            text3D = new Text3D(string, font3D, bl);
            bl3 = true;
        }
        boolean bl4 = text3D.isInvalid = text3D.width == 0 || n + text3D.width <= 0 || n >= graphics3D.width || n2 + text3D.height <= 0 || n2 >= graphics3D.height;
        if (text3D.isInvalid) {
            return text3D;
        }
        if (bl2) {
            map.put(font3D, map2);
        }
        if (bl3) {
            text3D.setBitmap(string, font3D, graphics3D.platform, bl);
            map2.put(string, text3D);
        }
        working = false;
        return text3D;
    }

    private void setBitmap(String string, Font3D font3D, Platform3D platform3D, boolean bl) {
        platform3D.checkOffscreenSize(this.mapWidth, this.height);
        this.renderOffscreen(string, font3D, platform3D, bl);
        this.rasterize(platform3D, bl);
    }
}

