/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.api;

import java.io.BufferedReader;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.api.JmolFileReaderInterface;
import org.jmol.modelset.Group;
import org.jmol.util.Elements;
import org.jmol.viewer.JmolConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JmolAdapter {
    public static final short ORDER_COVALENT_SINGLE = 1;
    public static final short ORDER_COVALENT_DOUBLE = 2;
    public static final short ORDER_COVALENT_TRIPLE = 3;
    public static final short ORDER_AROMATIC = 515;
    public static final short ORDER_AROMATIC_SINGLE = 513;
    public static final short ORDER_AROMATIC_DOUBLE = 514;
    public static final short ORDER_HBOND = 2048;
    public static final short ORDER_STEREO_NEAR = 1025;
    public static final short ORDER_STEREO_FAR = 1041;
    public static final short ORDER_PARTIAL01 = 33;
    public static final short ORDER_PARTIAL12 = 66;
    public static final short ORDER_PARTIAL23 = 97;
    public static final short ORDER_PARTIAL32 = 100;
    public static final short ORDER_UNSPECIFIED = 17;
    public static final int SHELL_S = 0;
    public static final int SHELL_P = 1;
    public static final int SHELL_SP = 2;
    public static final int SHELL_L = 2;
    public static final int SHELL_D_SPHERICAL = 3;
    public static final int SHELL_D_CARTESIAN = 4;
    public static final int SHELL_F_SPHERICAL = 5;
    public static final int SHELL_F_CARTESIAN = 6;
    public static final String SUPPORTED_BASIS_FUNCTIONS = "SPLDF";
    String adapterName;

    public static String getElementSymbol(int n) {
        return Elements.elementSymbolFromNumber(n);
    }

    public static short getElementNumber(String string) {
        return Elements.elementNumberFromSymbol(string, false);
    }

    public static boolean isHetero(String string) {
        return JmolConstants.isHetero(string);
    }

    public static int getQuantumShellTagID(String string) {
        return JmolConstants.getQuantumShellTagID(string);
    }

    public static int getQuantumShellTagIDSpherical(String string) {
        return JmolConstants.getQuantumShellTagIDSpherical(string);
    }

    public static final short lookupGroupID(String string) {
        return Group.lookupGroupID(string);
    }

    public JmolAdapter(String string) {
        this.adapterName = string;
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public abstract Object getAtomSetCollectionReader(String var1, String var2, BufferedReader var3, Map<String, Object> var4);

    public abstract Object getAtomSetCollection(Object var1);

    public abstract Object getAtomSetCollectionReaders(JmolFileReaderInterface var1, String[] var2, String[] var3, Map<String, Object> var4, boolean var5);

    public abstract Object getAtomSetCollectionFromSet(Object var1, Object var2, Map<String, Object> var3);

    public abstract Object getAtomSetCollectionOrBufferedReaderFromZip(InputStream var1, String var2, String[] var3, Map<String, Object> var4, boolean var5);

    public Object getAtomSetCollectionFromReader(String string, String string2, BufferedReader bufferedReader, Map<String, Object> map) {
        Object object;
        if (map == null) {
            map = new Hashtable<String, Object>();
        }
        if ((object = this.getAtomSetCollectionReader(string, string2, bufferedReader, map)) instanceof String) {
            return object;
        }
        return this.getAtomSetCollection(object);
    }

    public Object openBufferedReader(String string, BufferedReader bufferedReader) {
        return this.getAtomSetCollectionFromReader(string, null, bufferedReader, null);
    }

    public Object openBufferedReader(String string, BufferedReader bufferedReader, Map<String, Object> map) {
        return this.getAtomSetCollectionFromReader(string, null, bufferedReader, map);
    }

    public Object openBufferedReader(String string, String string2, BufferedReader bufferedReader) {
        return this.getAtomSetCollectionFromReader(string, string2, bufferedReader, null);
    }

    public abstract Object getAtomSetCollectionFromDOM(Object var1, Map<String, Object> var2);

    public void finish(Object object) {
    }

    public abstract String getFileTypeName(Object var1);

    public abstract String getAtomSetCollectionName(Object var1);

    public abstract Map<String, Object> getAtomSetCollectionAuxiliaryInfo(Object var1);

    public abstract int getAtomSetCount(Object var1);

    public abstract int getAtomSetNumber(Object var1, int var2);

    public abstract String getAtomSetName(Object var1, int var2);

    public abstract Map<String, Object> getAtomSetAuxiliaryInfo(Object var1, int var2);

    public abstract int getAtomCount(Object var1);

    public abstract boolean coordinatesAreFractional(Object var1);

    public abstract float[] getNotionalUnitcell(Object var1);

    public abstract float[] getPdbScaleMatrix(Object var1);

    public abstract float[] getPdbScaleTranslate(Object var1);

    public abstract AtomIterator getAtomIterator(Object var1);

    public abstract BondIterator getBondIterator(Object var1);

    public abstract StructureIterator getStructureIterator(Object var1);

    public static final char canonizeAlphaDigit(char c) {
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
            return c;
        }
        return '\u0000';
    }

    public static final char canonizeChainID(char c) {
        return JmolAdapter.canonizeAlphaDigit(c);
    }

    public static final char canonizeInsertionCode(char c) {
        return JmolAdapter.canonizeAlphaDigit(c);
    }

    public static final char canonizeAlternateLocationID(char c) {
        return JmolAdapter.canonizeAlphaDigit(c);
    }

    public String[] specialLoad(String string, String string2) {
        return null;
    }

    public abstract class StructureIterator {
        public abstract boolean hasNext();

        public abstract int getModelIndex();

        public abstract String getStructureType();

        public abstract String getStructureID();

        public abstract int getSerialID();

        public abstract int getStrandCount();

        public abstract char getStartChainID();

        public abstract int getStartSequenceNumber();

        public abstract char getStartInsertionCode();

        public abstract char getEndChainID();

        public abstract int getEndSequenceNumber();

        public abstract char getEndInsertionCode();
    }

    public abstract class BondIterator {
        public abstract boolean hasNext();

        public abstract Object getAtomUniqueID1();

        public abstract Object getAtomUniqueID2();

        public abstract int getEncodedOrder();
    }

    public abstract class AtomIterator {
        public abstract boolean hasNext();

        public int getAtomSetIndex() {
            return 0;
        }

        public BitSet getAtomSymmetry() {
            return null;
        }

        public int getAtomSite() {
            return Integer.MIN_VALUE;
        }

        public abstract Object getUniqueID();

        public short getElementNumber() {
            return -1;
        }

        public String getElementSymbol() {
            return null;
        }

        public String getAtomName() {
            return null;
        }

        public int getFormalCharge() {
            return 0;
        }

        public float getPartialCharge() {
            return Float.NaN;
        }

        public Object[] getEllipsoid() {
            return null;
        }

        public float getRadius() {
            return Float.NaN;
        }

        public abstract float getX();

        public abstract float getY();

        public abstract float getZ();

        public float getVectorX() {
            return Float.NaN;
        }

        public float getVectorY() {
            return Float.NaN;
        }

        public float getVectorZ() {
            return Float.NaN;
        }

        public float getBfactor() {
            return Float.NaN;
        }

        public int getOccupancy() {
            return 100;
        }

        public boolean getIsHetero() {
            return false;
        }

        public int getAtomSerial() {
            return Integer.MIN_VALUE;
        }

        public char getChainID() {
            return '\u0000';
        }

        public char getAlternateLocationID() {
            return '\u0000';
        }

        public String getGroup3() {
            return null;
        }

        public int getSequenceNumber() {
            return Integer.MIN_VALUE;
        }

        public char getInsertionCode() {
            return '\u0000';
        }
    }
}

