"""
Setup script para ANNA Protocol SDK
"""

from setuptools import setup, find_packages
import os

# Ler README para descriÃ§Ã£o longa
with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

# Dependências do SDK (correto!)
requirements = [
    "web3>=6.0.0",
    "eth-account>=0.9.0", 
    "python-dotenv>=1.0.0"
]  # ✅

setup(
    name="anna-protocol-sdk",
    version="1.2.8",
    author="ANNA Protocol Team",
    author_email="support@annaprotocol.com",
    description="SDK oficial em Python para o ANNA Protocol - Identidade e ReputaÃ§Ã£o para Agentes de IA",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://annaprotocol.com",
    project_urls={
        "Documentation": "https://annaprotocol.com",
        "Source Code": "https://github.com/anna-protocol/sdk-python",
        
    },
    packages=find_packages(exclude=["tests", "tests.*", "examples"]),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: System :: Distributed Computing",
        "Topic :: Security :: Cryptography",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.10",
    install_requires=requirements,
    extras_require={
        "dev": [
            "pytest>=7.4.0",
            "pytest-cov>=4.1.0",
            "black>=23.0.0",
            "mypy>=1.5.0",
            "flake8>=6.1.0",
            "isort>=5.12.0",
        ],
        "docs": [
            "sphinx>=7.0.0",
            "sphinx-rtd-theme>=1.3.0",
        ],
    },
    entry_points={
        "console_scripts": [
            "anna-cli=anna_sdk.cli:main",
        ],
    },
    keywords=[
        "blockchain",
        "ethereum",
        "polygon",
        "artificial-intelligence",
        "ai",
        "identity",
        "reputation",
        "attestation",
        "decentralized",
        "web3",
        "smart-contracts"
    ],
    include_package_data=True,
    zip_safe=False,
)