# ANNA Protocol SDK

**Making AI Decisions Accountable**

ANNA Protocol is a blockchain infrastructure that makes AI decisions auditable, traceable, and trustworthy.

## 🚀 Quick Start

### Installation
```bash
pip install anna-protocol
```

### Basic Usage
```python
from anna_protocol import ANNAClient, create_reasoning

# Initialize client
client = ANNAClient(
    private_key="0x...",
    network="polygon-amoy"
)

# Create reasoning
reasoning = create_reasoning(
    input_text="Credit analysis for customer #123",
    steps=[
        ("Score verification", "Credit score: 750"),
        ("Income analysis", "Monthly income: $5,000"),
        ("Decision", "APPROVED - Low risk profile")
    ],
    conclusion="Credit APPROVED",
    confidence=0.95
)

# Submit attestation
result = client.submit_attestation(
    content="Customer #123 credit analysis",
    reasoning=reasoning,
    category="credit_analysis"
)

print(f"Registered on blockchain!")
print(f"Attestation ID: {result.attestation_id}")
```

## 📚 Features

- ✅ **Blockchain-based Audit Trail** - Immutable record of AI decisions
- ✅ **Easy Integration** - Add 10 lines of code to your existing AI
- ✅ **Reputation System** - Build trust through verified decisions
- ✅ **LGPD/GDPR Compliant** - Only hashes on-chain, data stays private
- ✅ **Multi-chain Support** - Polygon Amoy (testnet) and Mainnet

## 🎯 Use Cases

- **FinTech** - Credit analysis, fraud detection
- **LegalTech** - Contract review, legal advice
- **HealthTech** - Medical triage, diagnosis support
- **InsurTech** - Risk assessment, claims processing
- **RegTech** - KYC/AML compliance

## 📖 Documentation

Full documentation: https://annaprotocol.github.io/annaprotocol/

## 🔐 Security

- EIP-712 signature validation
- On-chain verification system
- Audited smart contracts
- Privacy-preserving architecture

## 📞 Support

- Website: https://annaprotocol.github.io/annaprotocol/
- Email: support@annaprotocol.com
- Telegram: https://t.me/AntonioRufino27

## 📜 License

MIT License - see LICENSE file for details