/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.model;

import com.raphtory.arrowcore.implementation.ArrowPropertyIterator;
import com.raphtory.arrowcore.implementation.EdgeIterator;
import com.raphtory.arrowcore.implementation.EntityFieldAccessor;
import com.raphtory.arrowcore.implementation.RaphtoryArrowPartition;
import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import com.raphtory.arrowcore.model.Entity;

public class Edge
extends Entity {
    protected boolean _srcIsGlobal;
    protected boolean _dstIsGlobal;
    protected long _src;
    protected long _dst;
    protected long _prevIncomingPtr = -1L;
    protected long _prevOutgoingPtr = -1L;
    protected EdgeIterator _edgeIterator;

    public Edge(RaphtoryArrowPartition raphtoryArrowPartition, EntityFieldAccessor[] entityFieldAccessorArray, VersionedEntityPropertyAccessor[] versionedEntityPropertyAccessorArray) {
        super(raphtoryArrowPartition, entityFieldAccessorArray, versionedEntityPropertyAccessorArray);
    }

    public void init(long l, boolean bl, long l2) {
        super.init(l, l, bl, l2);
    }

    @Override
    public void decRefCount() {
        if (--this._refCount == 0) {
            this._rap.putEdge(this);
        }
    }

    public long getDstVertex() {
        return this._dst;
    }

    public long getSrcVertex() {
        return this._src;
    }

    public long getPrevIncomingPtr() {
        return this._prevIncomingPtr;
    }

    public long getPrevOutgoingPtr() {
        return this._prevOutgoingPtr;
    }

    @Override
    public void clear() {
        super.clear();
        this._src = -1L;
        this._dst = -1L;
        this._prevOutgoingPtr = -1L;
        this._prevIncomingPtr = -1L;
    }

    @Override
    public void recycle() {
        super.recycle();
    }

    public void resetEdgeData(long l, long l2, long l3, long l4, boolean bl, boolean bl2) {
        this._src = l;
        this._dst = l2;
        this._srcIsGlobal = bl;
        this._dstIsGlobal = bl2;
        this._prevIncomingPtr = l3;
        this._prevOutgoingPtr = l4;
    }

    protected void makeClone(Edge edge) {
        super.makeClone(edge);
        edge._srcIsGlobal = this._srcIsGlobal;
        edge._dstIsGlobal = this._dstIsGlobal;
        edge._src = this._src;
        edge._dst = this._dst;
    }

    public boolean isSplitEdge() {
        return this._srcIsGlobal || this._dstIsGlobal;
    }

    public boolean isSrcGlobal() {
        return this._srcIsGlobal;
    }

    public boolean isDstGlobal() {
        return this._dstIsGlobal;
    }

    public String toString() {
        return "Edge: " + this._localId + ": src=" + this._src + ", dst=" + this._dst;
    }

    public ArrowPropertyIterator getPropertyHistory(int n) {
        if (this._edgeIterator == null) {
            this._edgeIterator = this._rap.getNewAllEdgesIterator();
        }
        this._edgeIterator.reset(this._localId);
        return this._edgeIterator.getPropertyHistory(n);
    }
}

