/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.VertexHistoryIterator;
import com.raphtory.arrowcore.implementation.VertexHistoryStore;
import com.raphtory.arrowcore.implementation.VertexIterator;
import com.raphtory.arrowcore.implementation.VertexPartition;
import com.raphtory.arrowcore.implementation.VertexPartitionManager;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.arrow.algorithm.search.VectorRangeSearcher;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.types.pojo.Schema;

public class VertexHistoryPartition {
    private static final ThreadLocal<IntArrayList> _tmpListTL = ThreadLocal.withInitial(IntArrayList::new);
    private static final ThreadLocal<HistoryTimeComparatorIAL> _timeCmpTL = ThreadLocal.withInitial(() -> new HistoryTimeComparatorIAL());
    private static final ThreadLocal<HistoryVertexTimeComparatorIAL> _vertexTimeCmpTL = ThreadLocal.withInitial(() -> new HistoryVertexTimeComparatorIAL());
    private static final ThreadLocal<TimeWindowComparator> _timeWindowComparatorTL = ThreadLocal.withInitial(() -> new TimeWindowComparator());
    private static final ThreadLocal<VertexEdgeTimeWindowComparator> _vertexTimeEdgeWindowComparatorTL = ThreadLocal.withInitial(() -> new VertexEdgeTimeWindowComparator());
    private static final ThreadLocal<VertexTimeWindowComparator> _timeVertexWindowComparatorTL = ThreadLocal.withInitial(() -> new VertexTimeWindowComparator());
    private final int _partitionId;
    private final VertexPartition _avp;
    private final VertexPartitionManager _apm;
    private VertexHistoryStore _history;
    private VectorSchemaRoot _historyRO;
    private ArrowFileReader _historyReader;
    private boolean _modified = false;
    private boolean _sorted = false;

    public VertexHistoryPartition(int n, VertexPartition vertexPartition) {
        this._partitionId = n;
        this._avp = vertexPartition;
        this._apm = vertexPartition._apm;
        this._history = new VertexHistoryStore();
    }

    public void initialize() {
        this._historyRO = VectorSchemaRoot.create((Schema)VertexHistoryStore.HISTORY_SCHEMA, (BufferAllocator)this._apm.getAllocator());
        this._history.init(this._historyRO);
    }

    public int addHistory(int n, long l, boolean bl, boolean bl2, int n2, long l2, boolean bl3) {
        long l3;
        this._modified = true;
        this._sorted = false;
        boolean bl4 = n2 != -1 ? l >= (l3 = this._history._times.get(n2)) : true;
        if (bl2) {
            // empty if block
        }
        int n3 = bl4 ? this.takeSnapshot() : this.generateSnapshot();
        int n4 = this._history.addHistory(n, l, bl, bl2, n2, l2, bl3, n3);
        return n4;
    }

    private int takeSnapshot() {
        return -1;
    }

    private int generateSnapshot() {
        return -1;
    }

    public int getHistoryRowIdBySortedIndex(int n) {
        int n2 = this._history._sortedTimeIndices.get(n);
        return n2;
    }

    public int getEdgeHistoryRowIdBySortedIndex(int n) {
        int n2 = this._history._sortedVertexTimeIndices.get(n);
        return n2;
    }

    public boolean getIsAliveByHistoryRowId(int n) {
        return this._history._states.get(n) != 0;
    }

    public long getModificationTimeByHistoryRowId(int n) {
        return this._history._times.get(n);
    }

    public int getVertexLocalRowIdByHistoryRowId(int n) {
        return this._history._vertexRowIds.get(n);
    }

    public void close() {
        this.clearReader();
    }

    public void saveToFile() {
        try {
            if (!this._sorted) {
                this.sortHistoryTimes();
            }
            if (this._modified) {
                this._historyRO.syncSchema();
                this._historyRO.setRowCount(this._history._maxRow);
                File file = this._apm.getHistoryFile(this._partitionId);
                ArrowFileWriter arrowFileWriter = new ArrowFileWriter(this._historyRO, null, (WritableByteChannel)new FileOutputStream(file).getChannel());
                arrowFileWriter.start();
                arrowFileWriter.writeBatch();
                arrowFileWriter.end();
                arrowFileWriter.close();
            }
            this._modified = false;
            this._sorted = true;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public boolean loadFromFile() {
        File file = this._apm.getHistoryFile(this._partitionId);
        if (!file.exists()) {
            return false;
        }
        try {
            this.clearReader();
            this._historyReader = new ArrowFileReader((SeekableByteChannel)new FileInputStream(file).getChannel(), this._apm.getAllocator(), this._apm.getCompressionFactory());
            this._historyReader.loadNextBatch();
            this._historyRO = this._historyReader.getVectorSchemaRoot();
            this._historyRO.syncSchema();
            this._history.init(this._historyRO);
            this._history._maxRow = this._historyRO.getRowCount();
            this._modified = false;
            this._sorted = true;
            return true;
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    private void clearReader() {
        try {
            if (this._history != null) {
                this._history.init(null);
            }
            if (this._historyRO != null) {
                this._historyRO.clear();
                this._historyRO.close();
                this._historyRO = null;
            }
            if (this._historyReader != null) {
                this._historyReader.close();
                this._historyReader = null;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public long getEdgeIdByHistoryRowId(int n) {
        return this._history._edgeIds.get(n);
    }

    public boolean getIsOutgoingByHistoryRowId(int n) {
        return this._history._isOutgoings.get(n) != 0;
    }

    protected void sortHistoryTimes() {
        int n;
        int n2 = this._history._maxRow;
        IntArrayList intArrayList = _tmpListTL.get();
        intArrayList.clear();
        intArrayList.ensureCapacity(n2);
        intArrayList.size(n2);
        int[] nArray = intArrayList.elements();
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i;
        }
        HistoryVertexTimeComparatorIAL historyVertexTimeComparatorIAL = _vertexTimeCmpTL.get();
        historyVertexTimeComparatorIAL.init(this);
        intArrayList.sort((IntComparator)historyVertexTimeComparatorIAL);
        IntVector intVector = this._history._sortedVertexTimeIndices;
        intVector.setValueCount(n2);
        for (n = 0; n < n2; ++n) {
            intVector.set(n, nArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        HistoryTimeComparatorIAL historyTimeComparatorIAL = _timeCmpTL.get();
        historyTimeComparatorIAL.init(this);
        intArrayList.sort((IntComparator)historyTimeComparatorIAL);
        IntVector intVector2 = this._history._sortedTimeIndices;
        intVector2.setValueCount(n2);
        for (int i = 0; i < n2; ++i) {
            intVector2.set(i, nArray[i]);
        }
        this._sorted = true;
    }

    protected void isAliveAtWithWindowVector(VertexIterator.WindowedVertexIterator windowedVertexIterator) {
        if (this._historyRO == null) {
            windowedVertexIterator._firstIndex = -1;
            windowedVertexIterator._lastIndex = -1;
            return;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        TimeWindowComparator timeWindowComparator = _timeWindowComparatorTL.get();
        timeWindowComparator.init(this._history._sortedTimeIndices, this._history._times, windowedVertexIterator._minTime, windowedVertexIterator._maxTime);
        int n = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedTimeIndices, (VectorValueComparator)timeWindowComparator, null, (int)0);
        if (n < 0) {
            windowedVertexIterator._firstIndex = -1;
            windowedVertexIterator._lastIndex = -1;
            return;
        }
        int n2 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedTimeIndices, (VectorValueComparator)timeWindowComparator, null, (int)0);
        windowedVertexIterator._firstIndex = n;
        windowedVertexIterator._lastIndex = n2;
    }

    private void dump() {
        IntVector intVector = this._history._sortedVertexTimeIndices;
        int n = this._history._maxRow;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            int n2 = intVector.get(i);
            l = this._history._times.get(n2);
            System.out.println(i + ": " + n2 + ", v=" + this._history._vertexRowIds.get(n2) + ", e=" + this._history._edgeIds.get(n2) + ", t=" + l);
        }
    }

    protected void isAliveAtWithWindowVector(VertexIterator.WindowedVertexEdgeIterator windowedVertexEdgeIterator) {
        if (this._historyRO == null) {
            windowedVertexEdgeIterator._firstIndex = -1;
            windowedVertexEdgeIterator._lastIndex = -1;
            return;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        VertexEdgeTimeWindowComparator vertexEdgeTimeWindowComparator = _vertexTimeEdgeWindowComparatorTL.get();
        vertexEdgeTimeWindowComparator.init(windowedVertexEdgeIterator._vertexRowId, this._history._vertexRowIds, this._history._sortedVertexTimeIndices, this._history._times, windowedVertexEdgeIterator._minTime, windowedVertexEdgeIterator._maxTime);
        int n = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedVertexTimeIndices, (VectorValueComparator)vertexEdgeTimeWindowComparator, null, (int)0);
        if (n < 0) {
            windowedVertexEdgeIterator._firstIndex = -1;
            windowedVertexEdgeIterator._lastIndex = -1;
        } else {
            int n2 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedVertexTimeIndices, (VectorValueComparator)vertexEdgeTimeWindowComparator, null, (int)0);
            windowedVertexEdgeIterator._firstIndex = n;
            windowedVertexEdgeIterator._lastIndex = n2;
        }
    }

    protected void findHistory(VertexHistoryIterator.WindowedVertexHistoryIterator windowedVertexHistoryIterator) {
        if (this._historyRO == null) {
            windowedVertexHistoryIterator._firstIndex = -1;
            windowedVertexHistoryIterator._lastIndex = -1;
            return;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        if (windowedVertexHistoryIterator._vertexId == -1L) {
            TimeWindowComparator timeWindowComparator = _timeWindowComparatorTL.get();
            timeWindowComparator.init(this._history._sortedTimeIndices, this._history._times, windowedVertexHistoryIterator._minTime, windowedVertexHistoryIterator._maxTime);
            int n = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedTimeIndices, (VectorValueComparator)timeWindowComparator, null, (int)0);
            if (n < 0) {
                windowedVertexHistoryIterator._firstIndex = -1;
                windowedVertexHistoryIterator._lastIndex = -1;
            } else {
                int n2 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedTimeIndices, (VectorValueComparator)timeWindowComparator, null, (int)0);
                windowedVertexHistoryIterator._firstIndex = n;
                windowedVertexHistoryIterator._lastIndex = n2;
            }
        } else {
            VertexEdgeTimeWindowComparator vertexEdgeTimeWindowComparator = _vertexTimeEdgeWindowComparatorTL.get();
            vertexEdgeTimeWindowComparator.init(this._apm.getRowId(windowedVertexHistoryIterator._vertexId), this._history._vertexRowIds, this._history._sortedVertexTimeIndices, this._history._times, windowedVertexHistoryIterator._minTime, windowedVertexHistoryIterator._maxTime);
            int n = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedVertexTimeIndices, (VectorValueComparator)vertexEdgeTimeWindowComparator, null, (int)0);
            if (n < 0) {
                windowedVertexHistoryIterator._firstIndex = -1;
                windowedVertexHistoryIterator._lastIndex = -1;
            } else {
                int n3 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedVertexTimeIndices, (VectorValueComparator)vertexEdgeTimeWindowComparator, null, (int)0);
                windowedVertexHistoryIterator._firstIndex = n;
                windowedVertexHistoryIterator._lastIndex = n3;
            }
        }
    }

    public long getLowestTime() {
        if (this._history._maxRow == 0) {
            return Long.MAX_VALUE;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        int n = this._history._sortedTimeIndices.get(0);
        return this._history._times.get(n);
    }

    public long getHighestTime() {
        if (this._history._maxRow == 0) {
            return Long.MIN_VALUE;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        int n = this._history._sortedTimeIndices.get(this._history._maxRow - 1);
        return this._history._times.get(n);
    }

    public long getNHistoryItems() {
        int n = this._history._maxRow;
        return n + 1;
    }

    protected VertexHistoryStore getHistoryStore() {
        return this._history;
    }

    public long getVertexMinHistoryTime(int n) {
        if (this._historyRO == null) {
            return Long.MIN_VALUE;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        VertexEdgeTimeWindowComparator vertexEdgeTimeWindowComparator = _vertexTimeEdgeWindowComparatorTL.get();
        vertexEdgeTimeWindowComparator.init(n, this._history._vertexRowIds, this._history._sortedVertexTimeIndices, this._history._times, Long.MIN_VALUE, Long.MAX_VALUE);
        int n2 = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedVertexTimeIndices, (VectorValueComparator)vertexEdgeTimeWindowComparator, null, (int)0);
        if (n2 >= 0) {
            int n3 = this._history._sortedVertexTimeIndices.get(n2);
            return this._history._times.get(n3);
        }
        return Long.MIN_VALUE;
    }

    public long getVertexMaxHistoryTime(int n) {
        if (this._historyRO == null) {
            return Long.MAX_VALUE;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        VertexEdgeTimeWindowComparator vertexEdgeTimeWindowComparator = _vertexTimeEdgeWindowComparatorTL.get();
        vertexEdgeTimeWindowComparator.init(n, this._history._vertexRowIds, this._history._sortedVertexTimeIndices, this._history._times, Long.MIN_VALUE, Long.MAX_VALUE);
        int n2 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedVertexTimeIndices, (VectorValueComparator)vertexEdgeTimeWindowComparator, null, (int)0);
        if (n2 >= 0) {
            int n3 = this._history._sortedVertexTimeIndices.get(n2);
            return this._history._times.get(n3);
        }
        return Long.MAX_VALUE;
    }

    private static class VertexTimeWindowComparator
    extends VectorValueComparator<IntVector> {
        private int _vertexRowId;
        private IntVector _rowIds;
        private IntVector _sortedIndices;
        private BigIntVector _creationTimes;

        private VertexTimeWindowComparator() {
        }

        public void init(int n, IntVector intVector, IntVector intVector2, BigIntVector bigIntVector) {
            this._vertexRowId = n;
            this._rowIds = intVector;
            this._sortedIndices = intVector2;
            this._creationTimes = bigIntVector;
        }

        public int compare(int n, int n2) {
            boolean bl = ((IntVector)this.vector2).isNull(n2);
            if (!bl) {
                return this.compareNotNull(n, n2);
            }
            return 1;
        }

        public int compareNotNull(int n, int n2) {
            long l;
            int n3 = this._sortedIndices.get(n2);
            int n4 = this._rowIds.get(n3);
            if (this._vertexRowId != n4) {
                return this._vertexRowId < n4 ? -1 : 1;
            }
            int n5 = this._sortedIndices.get(n);
            long l2 = this._creationTimes.get(n5);
            if (l2 > (l = this._creationTimes.get(n3))) {
                return 1;
            }
            if (l2 < l) {
                return -1;
            }
            return 0;
        }

        public VectorValueComparator<IntVector> createNew() {
            return new VertexEdgeTimeWindowComparator();
        }
    }

    private static class VertexEdgeTimeWindowComparator
    extends VectorValueComparator<IntVector> {
        private int _vertexRowId;
        private long _minTime;
        private long _maxTime;
        private IntVector _rowIds;
        private IntVector _sortedIndices;
        private BigIntVector _creationTimes;

        private VertexEdgeTimeWindowComparator() {
        }

        public void init(int n, IntVector intVector, IntVector intVector2, BigIntVector bigIntVector, long l, long l2) {
            this._vertexRowId = n;
            this._rowIds = intVector;
            this._sortedIndices = intVector2;
            this._creationTimes = bigIntVector;
            this._minTime = l;
            this._maxTime = l2;
        }

        public int compare(int n, int n2) {
            boolean bl = ((IntVector)this.vector2).isNull(n2);
            if (!bl) {
                return this.compareNotNull(n, n2);
            }
            return 1;
        }

        public int compareNotNull(int n, int n2) {
            int n3 = this._sortedIndices.get(n2);
            int n4 = this._rowIds.get(n3);
            if (this._vertexRowId != n4) {
                return this._vertexRowId < n4 ? -1 : 1;
            }
            long l = this._creationTimes.get(n3);
            if (l < this._minTime) {
                return 1;
            }
            if (l > this._maxTime) {
                return -1;
            }
            return 0;
        }

        public VectorValueComparator<IntVector> createNew() {
            return new VertexEdgeTimeWindowComparator();
        }
    }

    private static class TimeWindowComparator
    extends VectorValueComparator<IntVector> {
        private long _minTime;
        private long _maxTime;
        private IntVector _sortedIndices;
        private BigIntVector _creationTimes;

        private TimeWindowComparator() {
        }

        public void init(IntVector intVector, BigIntVector bigIntVector, long l, long l2) {
            this._sortedIndices = intVector;
            this._creationTimes = bigIntVector;
            this._minTime = l;
            this._maxTime = l2;
        }

        public int compare(int n, int n2) {
            boolean bl = ((IntVector)this.vector2).isNull(n2);
            if (!bl) {
                return this.compareNotNull(n, n2);
            }
            return 1;
        }

        public int compareNotNull(int n, int n2) {
            int n3 = this._sortedIndices.get(n2);
            long l = this._creationTimes.get(n3);
            if (l < this._minTime) {
                return 1;
            }
            if (l > this._maxTime) {
                return -1;
            }
            return 0;
        }

        public VectorValueComparator<IntVector> createNew() {
            return new TimeWindowComparator();
        }
    }

    private static class HistoryVertexTimeComparatorIAL
    implements IntComparator {
        private VertexHistoryPartition _avhpm;
        private BigIntVector _times;
        private BigIntVector _edgeIds;
        private IntVector _vertexRowIds;

        private HistoryVertexTimeComparatorIAL() {
        }

        public void init(VertexHistoryPartition vertexHistoryPartition) {
            this._avhpm = vertexHistoryPartition;
            this._times = vertexHistoryPartition._history._times;
            this._edgeIds = vertexHistoryPartition._history._edgeIds;
            this._vertexRowIds = vertexHistoryPartition._history._vertexRowIds;
        }

        public int compare(int n, int n2) {
            long l;
            int n3;
            int n4 = this._vertexRowIds.get(n);
            int n5 = Integer.compare(n4, n3 = this._vertexRowIds.get(n2));
            if (n5 != 0) {
                return n5;
            }
            long l2 = this._times.get(n);
            n5 = Long.compare(l2, l = this._times.get(n2));
            if (n5 != 0) {
                return n5;
            }
            long l3 = this._edgeIds.get(n);
            long l4 = this._edgeIds.get(n2);
            return Long.compare(l3, l4);
        }
    }

    private static class HistoryTimeComparatorIAL
    implements IntComparator {
        private VertexHistoryPartition _avhpm;
        private BigIntVector _times;

        private HistoryTimeComparatorIAL() {
        }

        public void init(VertexHistoryPartition vertexHistoryPartition) {
            this._avhpm = vertexHistoryPartition;
            this._times = vertexHistoryPartition._history._times;
        }

        public int compare(int n, int n2) {
            long l = this._times.get(n);
            long l2 = this._times.get(n2);
            int n3 = Long.compare(l, l2);
            return n3;
        }
    }
}

