/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.VertexHistoryStore;
import com.raphtory.arrowcore.implementation.VertexPartition;
import com.raphtory.arrowcore.implementation.VertexPartitionManager;

public abstract class VertexHistoryIterator {
    private boolean _hasNext = false;
    private boolean _getNext = true;
    protected VertexPartitionManager _avpm;
    protected VertexPartition _vertexPartition;
    protected VertexHistoryStore _historyStore;
    protected int _partitionId = -1;
    protected long _vertexId;
    protected int _historyRow;

    protected void init(VertexPartitionManager vertexPartitionManager) {
        this._avpm = vertexPartitionManager;
        this._vertexPartition = null;
        this._partitionId = -1;
        this._vertexId = -1L;
        this._historyStore = null;
        this._historyRow = -1;
        this._hasNext = false;
        this._getNext = true;
    }

    protected void init(VertexPartitionManager vertexPartitionManager, long l) {
        this._avpm = vertexPartitionManager;
        this._vertexId = l;
        this._partitionId = this._avpm.getPartitionId(l);
        this._vertexPartition = this._avpm.getPartition(this._partitionId);
        this._historyStore = this._vertexPartition._history.getHistoryStore();
        this._historyRow = -1;
        this._hasNext = false;
        this._getNext = true;
    }

    public final long next() {
        if (this._getNext) {
            this.moveToNext();
        }
        this._getNext = true;
        return this._vertexId;
    }

    public final boolean hasNext() {
        if (this._getNext) {
            this._hasNext = this.moveToNext();
            this._getNext = false;
        }
        return this._hasNext;
    }

    protected abstract boolean moveToNext();

    public long getVertexId() {
        return this._vertexId;
    }

    public long getModificationTime() {
        return this._historyStore._times.get(this._historyRow);
    }

    public boolean wasActive() {
        return this._historyStore._states.get(this._historyRow) != 0;
    }

    public boolean wasUpdated() {
        return this._historyStore._updates.get(this._historyRow) != 0;
    }

    public long getEdgeId() {
        return this._historyStore._edgeIds.get(this._historyRow);
    }

    public boolean isOutgoingEdge() {
        return this._historyStore._isOutgoings.get(this._historyRow) != 0;
    }

    public static class WindowedVertexHistoryIterator
    extends VertexHistoryIterator {
        protected long _minTime;
        protected long _maxTime;
        protected int _firstIndex;
        protected int _lastIndex;
        protected int _index;
        protected boolean _firstTime = true;
        protected boolean _getNextPartition = false;
        protected boolean _vertexIdSupplied = false;

        protected WindowedVertexHistoryIterator() {
        }

        protected WindowedVertexHistoryIterator(VertexPartitionManager vertexPartitionManager, long l, long l2) {
            this.init(vertexPartitionManager, l, l2);
        }

        protected WindowedVertexHistoryIterator(VertexPartitionManager vertexPartitionManager, long l, long l2, long l3) {
            this.init(vertexPartitionManager, l, l2, l3);
        }

        protected void init(VertexPartitionManager vertexPartitionManager, long l, long l2) {
            super.init(vertexPartitionManager);
            this._minTime = l;
            this._maxTime = l2;
            this._firstTime = true;
            this._index = -1;
            this._getNextPartition = true;
            this._vertexIdSupplied = false;
        }

        protected void init(VertexPartitionManager vertexPartitionManager, long l, long l2, long l3) {
            super.init(vertexPartitionManager, l);
            this._minTime = l2;
            this._maxTime = l3;
            this._firstTime = true;
            this._firstIndex = -1;
            this._lastIndex = -1;
            this._index = -1;
            this._historyRow = -1;
            this._getNextPartition = false;
            this._vertexIdSupplied = true;
        }

        private long getNext() {
            while (true) {
                if (this._vertexPartition == null && this._getNextPartition) {
                    this._vertexPartition = this._avpm.getPartition(++this._partitionId);
                    this._firstIndex = -1;
                    this._lastIndex = -1;
                    this._index = -1;
                    this._vertexId = -1L;
                    this._historyRow = -1;
                    this._historyStore = null;
                }
                if (this._vertexPartition == null) {
                    this._vertexId = -1L;
                    this._historyRow = -1;
                    this._historyStore = null;
                    return -1L;
                }
                if (this._lastIndex != -1) {
                    if (this._index >= this._firstIndex) {
                        this._historyRow = this._vertexIdSupplied ? this._vertexPartition._history.getEdgeHistoryRowIdBySortedIndex(this._index) : this._vertexPartition._history.getHistoryRowIdBySortedIndex(this._index);
                        int n = this._vertexPartition._history.getVertexLocalRowIdByHistoryRowId(this._historyRow);
                        return this._vertexPartition._getLocalVertexIdByRow(n);
                    }
                    this._firstIndex = -1;
                    this._lastIndex = -1;
                    this._index = -1;
                    this._vertexPartition = null;
                    this._vertexId = -1L;
                    this._historyRow = -1;
                    this._historyStore = null;
                    continue;
                }
                this._vertexPartition._history.findHistory(this);
                if (this._lastIndex == -1) {
                    this._vertexPartition = null;
                    this._vertexId = -1L;
                    this._historyRow = -1;
                    this._historyStore = null;
                    continue;
                }
                this._index = this._lastIndex;
                this._historyStore = this._vertexPartition._history.getHistoryStore();
            }
        }

        @Override
        protected boolean moveToNext() {
            if (!this._firstTime) {
                --this._index;
            } else {
                this._firstTime = false;
            }
            this._vertexId = this.getNext();
            return this._vertexId != -1L;
        }
    }
}

