/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import java.util.ArrayList;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class VertexEdgeIndexArrowStore {
    protected static Schema INDEX_SCHEMA = new Schema(VertexEdgeIndexArrowStore.createIndexFields());
    protected int _partitionId;
    protected VectorSchemaRoot _indexRoot;
    protected int _maxRow = 0;
    protected IntVector _vertexRowIds;
    protected BigIntVector _dstVertexIds;
    protected BigIntVector _edgeIds;
    protected BitVector _isGlobals;
    protected IntVector _sortedIndex;

    public static ArrayList<Field> createIndexFields() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        arrayList.add(new Field("vertex_row", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        arrayList.add(new Field("dst_vertex_id", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("edge_id", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("dst_is_global", new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null));
        arrayList.add(new Field("sorted_vertex_dst_index", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        return arrayList;
    }

    protected void init(int n, VectorSchemaRoot vectorSchemaRoot) {
        this._partitionId = n;
        this._indexRoot = vectorSchemaRoot;
        if (vectorSchemaRoot != null) {
            this._vertexRowIds = (IntVector)this._indexRoot.getVector("vertex_row");
            this._dstVertexIds = (BigIntVector)this._indexRoot.getVector("dst_vertex_id");
            this._edgeIds = (BigIntVector)this._indexRoot.getVector("edge_id");
            this._sortedIndex = (IntVector)this._indexRoot.getVector("sorted_vertex_dst_index");
            this._isGlobals = (BitVector)this._indexRoot.getVector("dst_is_global");
        } else {
            this._vertexRowIds = null;
            this._dstVertexIds = null;
            this._edgeIds = null;
            this._sortedIndex = null;
            this._isGlobals = null;
        }
    }

    public void addIndexRecord(int n, long l, long l2, boolean bl) {
        int n2 = this._maxRow++;
        this._vertexRowIds.setSafe(n2, n);
        this._dstVertexIds.setSafe(n2, l);
        this._edgeIds.setSafe(n2, l2);
        this._sortedIndex.setSafe(n2, n2);
        this._isGlobals.setSafe(n2, bl ? 1 : 0);
    }

    public long getEdgeId(int n) {
        if (this._edgeIds.isSet(n) != 0) {
            return this._edgeIds.get(n);
        }
        return -1L;
    }
}

