/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.sources;

import cats.effect.kernel.Async;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph;
import com.raphtory.api.input.Graph$;
import com.raphtory.api.input.GraphBuilder;
import com.raphtory.api.input.Source;
import com.raphtory.api.input.Spout;
import com.raphtory.api.input.Type;
import com.raphtory.protocol.PartitionService;
import com.raphtory.sources.JSONEdgeListSource$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;
import ujson.package$;

@Scaladoc(value="/**\n  * JSONEdgeListSource is for building graphs in Raphtory from JSON data with no nested classes in JSON objects.\n  *\n  * @param spout : state where to ingest your data from (Mandatory field)\n  * @param sourceKey : state the key of the source ID in your JSON data (default = \"source\")\n  * @param sourceType : state what type of value the source is (default = None)\n  * @param targetKey : state the key of the target ID in your JSON data (default = \"target\")\n  * @param targetType : state what type of value the target is (default = None)\n  * @param edgeRelationship : state what the edge relationship is (default = None)\n  * @param timeKey : state the key of the timestamp in your JSON data, timestamp must be in datetime format (default = \"time\")\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001\u0002\u0016,\u0001IB\u0001\"\u0011\u0001\u0003\u0006\u0004%\tE\u0011\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0007\"A!\u000b\u0001B\u0001B\u0003%a\t\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003G\u0011!!\u0006A!A!\u0002\u00131\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u0011Y\u0003!\u0011!Q\u0001\n\u0019C\u0001b\u0016\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u00061\u0002!\t!W\u0003\u0005G\u0002\u0001c\tC\u0003e\u0001\u0011\u0005SmB\u0003xW!\u0005\u0001PB\u0003+W!\u0005\u0011\u0010C\u0003Y\u001b\u0011\u0005!\u0010C\u0003|\u001b\u0011\u0005A\u0010C\u0005\u0002\n5\t\n\u0011\"\u0001\u0002\f!I\u0011\u0011E\u0007\u0012\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003Gi\u0011\u0013!C\u0001\u0003\u0017A\u0011\"!\n\u000e#\u0003%\t!a\u0003\t\u0013\u0005\u001dR\"%A\u0005\u0002\u0005-\u0001\"CA\u0015\u001bE\u0005I\u0011AA\u0006\u0011\u001d\tY#\u0004C\u0001\u0003[A\u0011\"a\u0010\u000e#\u0003%\t!a\u0003\t\u0013\u0005\u0005S\"%A\u0005\u0002\u0005-\u0001\"CA\"\u001bE\u0005I\u0011AA\u0006\u0011%\t)%DI\u0001\n\u0003\tY\u0001C\u0005\u0002H5\t\n\u0011\"\u0001\u0002\f!I\u0011\u0011J\u0007\u0012\u0002\u0013\u0005\u00111\u0002\u0005\b\u0003\u0017jA\u0011AA'\u0011%\ti&DI\u0001\n\u0003\tY\u0001C\u0005\u0002`5\t\n\u0011\"\u0001\u0002\f!I\u0011\u0011M\u0007\u0012\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003Gj\u0011\u0013!C\u0001\u0003\u0017A\u0011\"!\u001a\u000e#\u0003%\t!a\u0003\t\u0013\u0005\u001dT\"%A\u0005\u0002\u0005-\u0001\"CA5\u001bE\u0005I\u0011AA\u0006\u0011%\tY'DI\u0001\n\u0003\tY\u0001C\u0005\u0002n5\t\n\u0011\"\u0001\u0002\f!I\u0011qN\u0007\u0012\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003cj\u0011\u0013!C\u0001\u0003\u0017A\u0011\"a\u001d\u000e#\u0003%\t!a\u0003\u0003%)\u001bvJT#eO\u0016d\u0015n\u001d;T_V\u00148-\u001a\u0006\u0003Y5\nqa]8ve\u000e,7O\u0003\u0002/_\u0005A!/\u00199ii>\u0014\u0018PC\u00011\u0003\r\u0019w.\\\u0002\u0001'\r\u00011'\u000f\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014!B5oaV$(B\u0001 .\u0003\r\t\u0007/[\u0005\u0003\u0001n\u0012aaU8ve\u000e,\u0017!B:q_V$X#A\"\u0011\u0007i\"e)\u0003\u0002Fw\t)1\u000b]8viB\u0011qI\u0014\b\u0003\u00112\u0003\"!S\u001b\u000e\u0003)S!aS\u0019\u0002\rq\u0012xn\u001c;?\u0013\tiU'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'6\u0003\u0019\u0019\bo\\;uA\u0005I1o\\;sG\u0016\\U-_\u0001\u000bg>,(oY3UsB,\u0017!\u0003;be\u001e,GoS3z\u0003)!\u0018M]4fiRK\b/Z\u0001\u0011K\u0012<WMU3mCRLwN\\:iSB\fq\u0001^5nK.+\u00170\u0001\u0004=S:LGO\u0010\u000b\t5rkfl\u00181bEB\u00111\fA\u0007\u0002W!)\u0011)\u0003a\u0001\u0007\"9!+\u0003I\u0001\u0002\u00041\u0005bB*\n!\u0003\u0005\rA\u0012\u0005\b)&\u0001\n\u00111\u0001G\u0011\u001d)\u0016\u0002%AA\u0002\u0019CqAV\u0005\u0011\u0002\u0003\u0007a\tC\u0004X\u0013A\u0005\t\u0019\u0001$\u0003\u00175+7o]1hKRK\b/Z\u0001\bEVLG\u000eZ3s+\u00051\u0007c\u0001\u001eh\r&\u0011\u0001n\u000f\u0002\r\u000fJ\f\u0007\u000f\u001b\"vS2$WM\u001d\u0015\u0005\u0001)$X\u000f\u0005\u0002le6\tAN\u0003\u0002n]\u0006A1oY1mC\u0012|7M\u0003\u0002pa\u00069A/Y6fu>,'BA90\u0003\u00199\u0017\u000e\u001e5vE&\u00111\u000f\u001c\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\na/ACt_)R#\u0002\t\u0011+A)\u001bvJT#eO\u0016d\u0015n\u001d;T_V\u00148-\u001a\u0011jg\u00022wN\u001d\u0011ck&dG-\u001b8hA\u001d\u0014\u0018\r\u001d5tA%t\u0007EU1qQR|'/\u001f\u0011ge>l\u0007ES*P\u001d\u0002\"\u0017\r^1!o&$\b\u000e\t8pA9,7\u000f^3eA\rd\u0017m]:fg\u0002Jg\u000e\t&T\u001f:\u0003sN\u00196fGR\u001chF\u0003\u0011!U)\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011ta>,H\u000f\t\u001e!gR\fG/\u001a\u0011xQ\u0016\u0014X\r\t;pA%tw-Z:uAe|WO\u001d\u0011eCR\f\u0007E\u001a:p[\u0002BS*\u00198eCR|'/\u001f\u0011gS\u0016dG-\u000b\u0006!A)\u0002\u0003\t]1sC6\u00043o\\;sG\u0016\\U-\u001f\u0011;AM$\u0018\r^3!i\",\u0007e[3zA=4\u0007\u0005\u001e5fAM|WO]2fA%#\u0005%\u001b8!s>,(\u000f\t&T\u001f:\u0003C-\u0019;bA!\"WMZ1vYR\u0004S\b\t\u0012t_V\u00148-\u001a\u0012*\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000eI:pkJ\u001cW\rV=qK\u0002R\u0004e\u001d;bi\u0016\u0004s\u000f[1uAQL\b/\u001a\u0011pM\u00022\u0018\r\\;fAQDW\rI:pkJ\u001cW\rI5tA!\"WMZ1vYR\u0004S\b\t(p]\u0016L#\u0002\t\u0011+A\u0001\u0003\u0018M]1nAQ\f'oZ3u\u0017\u0016L\bE\u000f\u0011ti\u0006$X\r\t;iK\u0002ZW-\u001f\u0011pM\u0002\"\b.\u001a\u0011uCJ<W\r\u001e\u0011J\t\u0002Jg\u000eI=pkJ\u0004#jU(OA\u0011\fG/\u0019\u0011)I\u00164\u0017-\u001e7uAu\u0002#\u0005^1sO\u0016$(%\u000b\u0006!A)\u0002\u0003\t]1sC6\u0004C/\u0019:hKR$\u0016\u0010]3!u\u0001\u001aH/\u0019;fA]D\u0017\r\u001e\u0011usB,\u0007e\u001c4!m\u0006dW/\u001a\u0011uQ\u0016\u0004C/\u0019:hKR\u0004\u0013n\u001d\u0011)I\u00164\u0017-\u001e7uAu\u0002cj\u001c8fS)\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011fI\u001e,'+\u001a7bi&|gn\u001d5ja\u0002R\u0004e\u001d;bi\u0016\u0004s\u000f[1uAQDW\rI3eO\u0016\u0004#/\u001a7bi&|gn\u001d5ja\u0002J7\u000f\t\u0015eK\u001a\fW\u000f\u001c;!{\u0001ruN\\3*\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000e\t;j[\u0016\\U-\u001f\u0011;AM$\u0018\r^3!i\",\u0007e[3zA=4\u0007\u0005\u001e5fAQLW.Z:uC6\u0004\b%\u001b8!s>,(\u000f\t&T\u001f:\u0003C-\u0019;bY\u0001\"\u0018.\\3ti\u0006l\u0007\u000fI7vgR\u0004#-\u001a\u0011j]\u0002\"\u0017\r^3uS6,\u0007EZ8s[\u0006$\b\u0005\u000b3fM\u0006,H\u000e\u001e\u0011>A\t\"\u0018.\\3#S)\u0001\u0003EK\u0018\u0002%)\u001bvJT#eO\u0016d\u0015n\u001d;T_V\u00148-\u001a\t\u000376\u0019\"!D\u001a\u0015\u0003a\fQ!\u00199qYf$BBW?\u007f\u007f\u0006\u0005\u00111AA\u0003\u0003\u000fAQ!Q\bA\u0002\rCqAU\b\u0011\u0002\u0003\u0007a\tC\u0004T\u001fA\u0005\t\u0019\u0001$\t\u000fQ{\u0001\u0013!a\u0001\r\"9Qk\u0004I\u0001\u0002\u00041\u0005b\u0002,\u0010!\u0003\u0005\rA\u0012\u0005\b/>\u0001\n\u00111\u0001G\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012TCAA\u0007U\r1\u0015qB\u0016\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"A\u0005v]\u000eDWmY6fI*\u0019\u00111D\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002 \u0005U!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001c\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uI]\n\u0001B\u001a:p[\u001aKG.\u001a\u000b\u00105\u0006=\u00121GA\u001b\u0003o\tI$a\u000f\u0002>!1\u0011\u0011\u0007\fA\u0002\u0019\u000bA\u0001]1uQ\"9!K\u0006I\u0001\u0002\u00041\u0005bB*\u0017!\u0003\u0005\rA\u0012\u0005\b)Z\u0001\n\u00111\u0001G\u0011\u001d)f\u0003%AA\u0002\u0019CqA\u0016\f\u0011\u0002\u0003\u0007a\tC\u0004X-A\u0005\t\u0019\u0001$\u0002%\u0019\u0014x.\u001c$jY\u0016$C-\u001a4bk2$HEM\u0001\u0013MJ|WNR5mK\u0012\"WMZ1vYR$3'\u0001\nge>lg)\u001b7fI\u0011,g-Y;mi\u0012\"\u0014A\u00054s_64\u0015\u000e\\3%I\u00164\u0017-\u001e7uIU\n!C\u001a:p[\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%m\u0005\u0011bM]8n\r&dW\r\n3fM\u0006,H\u000e\u001e\u00138\u000311'o\\7SKN|WO]2f)=Q\u0016qJA)\u0003'\n)&a\u0016\u0002Z\u0005m\u0003BBA\u0019;\u0001\u0007a\tC\u0004S;A\u0005\t\u0019\u0001$\t\u000fMk\u0002\u0013!a\u0001\r\"9A+\bI\u0001\u0002\u00041\u0005bB+\u001e!\u0003\u0005\rA\u0012\u0005\b-v\u0001\n\u00111\u0001G\u0011\u001d9V\u0004%AA\u0002\u0019\u000baC\u001a:p[J+7o\\;sG\u0016$C-\u001a4bk2$HEM\u0001\u0017MJ|WNU3t_V\u00148-\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u00051bM]8n%\u0016\u001cx.\u001e:dK\u0012\"WMZ1vYR$C'\u0001\fge>l'+Z:pkJ\u001cW\r\n3fM\u0006,H\u000e\u001e\u00136\u0003Y1'o\\7SKN|WO]2fI\u0011,g-Y;mi\u00122\u0014A\u00064s_6\u0014Vm]8ve\u000e,G\u0005Z3gCVdG\u000fJ\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\u000e")
public class JSONEdgeListSource
implements Source {
    private final Spout<String> spout;
    private final String sourceKey;
    private final String sourceType;
    private final String targetKey;
    private final String targetType;
    private final String edgeRelationship;
    private final String timeKey;

    public static String $lessinit$greater$default$7() {
        return JSONEdgeListSource$.MODULE$.$lessinit$greater$default$7();
    }

    public static String $lessinit$greater$default$6() {
        return JSONEdgeListSource$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return JSONEdgeListSource$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return JSONEdgeListSource$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return JSONEdgeListSource$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return JSONEdgeListSource$.MODULE$.$lessinit$greater$default$2();
    }

    public static String fromResource$default$7() {
        return JSONEdgeListSource$.MODULE$.fromResource$default$7();
    }

    public static String fromResource$default$6() {
        return JSONEdgeListSource$.MODULE$.fromResource$default$6();
    }

    public static String fromResource$default$5() {
        return JSONEdgeListSource$.MODULE$.fromResource$default$5();
    }

    public static String fromResource$default$4() {
        return JSONEdgeListSource$.MODULE$.fromResource$default$4();
    }

    public static String fromResource$default$3() {
        return JSONEdgeListSource$.MODULE$.fromResource$default$3();
    }

    public static String fromResource$default$2() {
        return JSONEdgeListSource$.MODULE$.fromResource$default$2();
    }

    public static JSONEdgeListSource fromResource(String path, String sourceKey, String sourceType, String targetKey, String targetType, String edgeRelationship, String timeKey) {
        return JSONEdgeListSource$.MODULE$.fromResource(path, sourceKey, sourceType, targetKey, targetType, edgeRelationship, timeKey);
    }

    public static String fromFile$default$7() {
        return JSONEdgeListSource$.MODULE$.fromFile$default$7();
    }

    public static String fromFile$default$6() {
        return JSONEdgeListSource$.MODULE$.fromFile$default$6();
    }

    public static String fromFile$default$5() {
        return JSONEdgeListSource$.MODULE$.fromFile$default$5();
    }

    public static String fromFile$default$4() {
        return JSONEdgeListSource$.MODULE$.fromFile$default$4();
    }

    public static String fromFile$default$3() {
        return JSONEdgeListSource$.MODULE$.fromFile$default$3();
    }

    public static String fromFile$default$2() {
        return JSONEdgeListSource$.MODULE$.fromFile$default$2();
    }

    public static JSONEdgeListSource fromFile(String path, String sourceKey, String sourceType, String targetKey, String targetType, String edgeRelationship, String timeKey) {
        return JSONEdgeListSource$.MODULE$.fromFile(path, sourceKey, sourceType, targetKey, targetType, edgeRelationship, timeKey);
    }

    public static String apply$default$7() {
        return JSONEdgeListSource$.MODULE$.apply$default$7();
    }

    public static String apply$default$6() {
        return JSONEdgeListSource$.MODULE$.apply$default$6();
    }

    public static String apply$default$5() {
        return JSONEdgeListSource$.MODULE$.apply$default$5();
    }

    public static String apply$default$4() {
        return JSONEdgeListSource$.MODULE$.apply$default$4();
    }

    public static String apply$default$3() {
        return JSONEdgeListSource$.MODULE$.apply$default$3();
    }

    public static String apply$default$2() {
        return JSONEdgeListSource$.MODULE$.apply$default$2();
    }

    public static JSONEdgeListSource apply(Spout<String> spout, String sourceKey, String sourceType, String targetKey, String targetType, String edgeRelationship, String timeKey) {
        return JSONEdgeListSource$.MODULE$.apply(spout, sourceKey, sourceType, targetKey, targetType, edgeRelationship, timeKey);
    }

    @Override
    public Class<?> getBuilderClass() {
        return Source.getBuilderClass$(this);
    }

    @Override
    public <F> F make(String graphID, int id, Map<Object, PartitionService<F>> partitions, Async<F> evidence$1) {
        return (F)Source.make$(this, graphID, id, partitions, evidence$1);
    }

    public Spout<String> spout() {
        return this.spout;
    }

    public GraphBuilder<String> builder() {
        return new GraphBuilder<String>(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ JSONEdgeListSource $outer;

            public final <F> F make(String graphID, int sourceID, Map<Object, PartitionService<F>> partitions, Async<F> evidence$1) {
                return (F)GraphBuilder.make$(this, graphID, sourceID, partitions, evidence$1);
            }

            public boolean apply$mcZDD$sp(double v1, double v2) {
                return Function2.apply$mcZDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return Function2.apply$mcDDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public float apply$mcFDD$sp(double v1, double v2) {
                return Function2.apply$mcFDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public int apply$mcIDD$sp(double v1, double v2) {
                return Function2.apply$mcIDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public long apply$mcJDD$sp(double v1, double v2) {
                return Function2.apply$mcJDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public void apply$mcVDD$sp(double v1, double v2) {
                Function2.apply$mcVDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public boolean apply$mcZDI$sp(double v1, int v2) {
                return Function2.apply$mcZDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public double apply$mcDDI$sp(double v1, int v2) {
                return Function2.apply$mcDDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public float apply$mcFDI$sp(double v1, int v2) {
                return Function2.apply$mcFDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public int apply$mcIDI$sp(double v1, int v2) {
                return Function2.apply$mcIDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public long apply$mcJDI$sp(double v1, int v2) {
                return Function2.apply$mcJDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public void apply$mcVDI$sp(double v1, int v2) {
                Function2.apply$mcVDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public boolean apply$mcZDJ$sp(double v1, long v2) {
                return Function2.apply$mcZDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public double apply$mcDDJ$sp(double v1, long v2) {
                return Function2.apply$mcDDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public float apply$mcFDJ$sp(double v1, long v2) {
                return Function2.apply$mcFDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public int apply$mcIDJ$sp(double v1, long v2) {
                return Function2.apply$mcIDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public long apply$mcJDJ$sp(double v1, long v2) {
                return Function2.apply$mcJDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public void apply$mcVDJ$sp(double v1, long v2) {
                Function2.apply$mcVDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public boolean apply$mcZID$sp(int v1, double v2) {
                return Function2.apply$mcZID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public double apply$mcDID$sp(int v1, double v2) {
                return Function2.apply$mcDID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public float apply$mcFID$sp(int v1, double v2) {
                return Function2.apply$mcFID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public int apply$mcIID$sp(int v1, double v2) {
                return Function2.apply$mcIID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public long apply$mcJID$sp(int v1, double v2) {
                return Function2.apply$mcJID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public void apply$mcVID$sp(int v1, double v2) {
                Function2.apply$mcVID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public boolean apply$mcZII$sp(int v1, int v2) {
                return Function2.apply$mcZII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public double apply$mcDII$sp(int v1, int v2) {
                return Function2.apply$mcDII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public float apply$mcFII$sp(int v1, int v2) {
                return Function2.apply$mcFII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return Function2.apply$mcIII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public long apply$mcJII$sp(int v1, int v2) {
                return Function2.apply$mcJII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public void apply$mcVII$sp(int v1, int v2) {
                Function2.apply$mcVII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public boolean apply$mcZIJ$sp(int v1, long v2) {
                return Function2.apply$mcZIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public double apply$mcDIJ$sp(int v1, long v2) {
                return Function2.apply$mcDIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public float apply$mcFIJ$sp(int v1, long v2) {
                return Function2.apply$mcFIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public int apply$mcIIJ$sp(int v1, long v2) {
                return Function2.apply$mcIIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public long apply$mcJIJ$sp(int v1, long v2) {
                return Function2.apply$mcJIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public void apply$mcVIJ$sp(int v1, long v2) {
                Function2.apply$mcVIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public boolean apply$mcZJD$sp(long v1, double v2) {
                return Function2.apply$mcZJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public double apply$mcDJD$sp(long v1, double v2) {
                return Function2.apply$mcDJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public float apply$mcFJD$sp(long v1, double v2) {
                return Function2.apply$mcFJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public int apply$mcIJD$sp(long v1, double v2) {
                return Function2.apply$mcIJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public long apply$mcJJD$sp(long v1, double v2) {
                return Function2.apply$mcJJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public void apply$mcVJD$sp(long v1, double v2) {
                Function2.apply$mcVJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public boolean apply$mcZJI$sp(long v1, int v2) {
                return Function2.apply$mcZJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public double apply$mcDJI$sp(long v1, int v2) {
                return Function2.apply$mcDJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public float apply$mcFJI$sp(long v1, int v2) {
                return Function2.apply$mcFJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public int apply$mcIJI$sp(long v1, int v2) {
                return Function2.apply$mcIJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public long apply$mcJJI$sp(long v1, int v2) {
                return Function2.apply$mcJJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public void apply$mcVJI$sp(long v1, int v2) {
                Function2.apply$mcVJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public boolean apply$mcZJJ$sp(long v1, long v2) {
                return Function2.apply$mcZJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public double apply$mcDJJ$sp(long v1, long v2) {
                return Function2.apply$mcDJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public float apply$mcFJJ$sp(long v1, long v2) {
                return Function2.apply$mcFJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public int apply$mcIJJ$sp(long v1, long v2) {
                return Function2.apply$mcIJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public long apply$mcJJJ$sp(long v1, long v2) {
                return Function2.apply$mcJJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public void apply$mcVJJ$sp(long v1, long v2) {
                Function2.apply$mcVJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public Function1<Graph, Function1<String, BoxedUnit>> curried() {
                return Function2.curried$((Function2)this);
            }

            public Function1<Tuple2<Graph, String>, BoxedUnit> tupled() {
                return Function2.tupled$((Function2)this);
            }

            public String toString() {
                return Function2.toString$((Function2)this);
            }

            public final void apply(Graph v1, String v2) {
                this.$outer.com$raphtory$sources$JSONEdgeListSource$$$anonfun$builder$1(v1, v2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Function2.$init$((Function2)this);
                GraphBuilder.$init$(this);
            }
        };
    }

    public final /* synthetic */ void com$raphtory$sources$JSONEdgeListSource$$$anonfun$builder$1(Graph graph, String jsonString) {
        block2: {
            String str = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(jsonString));
            Value json = package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(str), package$.MODULE$.read$default$2());
            String src = json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(this.sourceKey)).toString();
            String dst = json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(this.targetKey)).toString();
            long timestamp = graph.parseDatetime(json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector(this.timeKey)).toString().replace("\"", ""), graph.parseDatetime$default$2());
            long srcID = Graph$.MODULE$.assignID(src);
            long dstID = Graph$.MODULE$.assignID(dst);
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(src))) {
                graph.addVertex(timestamp, srcID, new Type(this.sourceType));
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(dst))) {
                graph.addVertex(timestamp, dstID, new Type(this.targetType));
            }
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(src)) || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(dst))) break block2;
            graph.addEdge(timestamp, srcID, dstID, new Type(this.edgeRelationship));
        }
    }

    public JSONEdgeListSource(Spout<String> spout, String sourceKey, String sourceType, String targetKey, String targetType, String edgeRelationship, String timeKey) {
        this.spout = spout;
        this.sourceKey = sourceKey;
        this.sourceType = sourceType;
        this.targetKey = targetKey;
        this.targetType = targetType;
        this.edgeRelationship = edgeRelationship;
        this.timeKey = timeKey;
        Source.$init$(this);
    }
}

