/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.sinks;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.output.format.Format;
import com.raphtory.api.output.sink.FormatAgnosticSink;
import com.raphtory.api.output.sink.SinkConnector;
import com.raphtory.sinks.FileSink$;
import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** A [[com.raphtory.api.output.sink.Sink Sink]] that writes a `Table` into files using the given `format`.\n  *\n  * This sink creates a directory named after the jobID inside the provided `filepath`. Each partition on the server then writes into its own file within this directory.\n  *\n  * @param filePath the filepath to write the table into\n  * @param format the format to be used by this sink (`CsvFormat` by default)\n  *\n  * @example\n  * {{{\n  * import com.raphtory.algorithms.generic.EdgeList\n  * import com.raphtory.sinks.FileSink\n  * import com.raphtory.spouts.FileSpout\n  *\n  * val graphBuilder = new YourGraphBuilder()\n  * val graph = Raphtory.stream(FileSpout(\"/path/to/your/file\"), graphBuilder)\n  * val testDir = \"/tmp/raphtoryTest\"\n  * val sink = FileSink(testDir)\n  *\n  * graph.execute(EdgeList()).writeTo(sink)\n  * }}}\n  * @see [[com.raphtory.api.output.sink.Sink Sink]]\n  *      [[com.raphtory.api.output.format.Format Format]]\n  *      [[com.raphtory.formats.CsvFormat CsvFormat]]\n  *      [[com.raphtory.api.analysis.table.Table Table]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001\u0002\u000f\u001e\u0001\u0012B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0007\"AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u001d\u0019\b!!A\u0005\u0002QDqa\u001e\u0001\u0012\u0002\u0013\u0005\u0001\u0010C\u0005\u0002\b\u0001\t\n\u0011\"\u0001\u0002\n!I\u0011Q\u0002\u0001\u0002\u0002\u0013\u0005\u0013q\u0002\u0005\n\u0003?\u0001\u0011\u0011!C\u0001\u0003CA\u0011\"a\t\u0001\u0003\u0003%\t!!\n\t\u0013\u0005E\u0002!!A\u0005B\u0005M\u0002\"CA!\u0001\u0005\u0005I\u0011AA\"\u0011%\ti\u0005AA\u0001\n\u0003\ny\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0011\u0002V!I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\f\u0005\n\u00037\u0002\u0011\u0011!C!\u0003;:\u0011\"! \u001e\u0003\u0003E\t!a \u0007\u0011qi\u0012\u0011!E\u0001\u0003\u0003Ca\u0001\u0016\u000b\u0005\u0002\u0005e\u0005\"CA,)\u0005\u0005IQIA-\u0011%\tY\nFA\u0001\n\u0003\u000bi\nC\u0005\u0002$R\t\n\u0011\"\u0001\u0002\n!I\u0011Q\u0015\u000b\u0002\u0002\u0013\u0005\u0015q\u0015\u0005\n\u0003s#\u0012\u0013!C\u0001\u0003\u0013A\u0011\"a/\u0015\u0003\u0003%I!!0\u0003\u0011\u0019KG.Z*j].T!AH\u0010\u0002\u000bMLgn[:\u000b\u0005\u0001\n\u0013\u0001\u0003:ba\"$xN]=\u000b\u0003\t\n1aY8n\u0007\u0001\u0019B\u0001A\u00130kA\u0011a%L\u0007\u0002O)\u0011\u0001&K\u0001\u0005g&t7N\u0003\u0002+W\u00051q.\u001e;qkRT!\u0001L\u0010\u0002\u0007\u0005\u0004\u0018.\u0003\u0002/O\t\u0011bi\u001c:nCR\fuM\\8ti&\u001c7+\u001b8l!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u000e \u000f\u0005]bdB\u0001\u001d<\u001b\u0005I$B\u0001\u001e$\u0003\u0019a$o\\8u}%\t!'\u0003\u0002>c\u00059\u0001/Y2lC\u001e,\u0017BA A\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ti\u0014'\u0001\u0005gS2,\u0007+\u0019;i+\u0005\u0019\u0005C\u0001#I\u001d\t)e\t\u0005\u00029c%\u0011q)M\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002Hc\u0005Ia-\u001b7f!\u0006$\b\u000eI\u0001\u0007M>\u0014X.\u0019;\u0016\u00039\u0003\"aT)\u000e\u0003AS!\u0001T\u0015\n\u0005I\u0003&A\u0002$pe6\fG/A\u0004g_Jl\u0017\r\u001e\u0011\u0002\rqJg.\u001b;?)\r1\u0006,\u0017\t\u0003/\u0002i\u0011!\b\u0005\u0006\u0003\u0016\u0001\ra\u0011\u0005\b\u0019\u0016\u0001\n\u00111\u0001O\u00039\u0011W/\u001b7e\u0007>tg.Z2u_J$b\u0001X0bM>\f\bC\u0001\u0014^\u0013\tqvEA\u0007TS:\\7i\u001c8oK\u000e$xN\u001d\u0005\u0006A\u001a\u0001\raQ\u0001\u0006U>\u0014\u0017\n\u0012\u0005\u0006E\u001a\u0001\raY\u0001\fa\u0006\u0014H/\u001b;j_:LE\t\u0005\u00021I&\u0011Q-\r\u0002\u0004\u0013:$\b\"B4\u0007\u0001\u0004A\u0017AB2p]\u001aLw\r\u0005\u0002j[6\t!N\u0003\u0002hW*\u0011A.I\u0001\tif\u0004Xm]1gK&\u0011aN\u001b\u0002\u0007\u0007>tg-[4\t\u000bA4\u0001\u0019A\"\u0002\u001b%$X-\u001c#fY&l\u0017\u000e^3s\u0011\u0015\u0011h\u00011\u0001D\u000351\u0017\u000e\\3FqR,gn]5p]\u0006!1m\u001c9z)\r1VO\u001e\u0005\b\u0003\u001e\u0001\n\u00111\u0001D\u0011\u001dau\u0001%AA\u00029\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001zU\t\u0019%pK\u0001|!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00012\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u000bi(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u0006U\tq%0A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0003mC:<'BAA\u000e\u0003\u0011Q\u0017M^1\n\u0007%\u000b)\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001d\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\n\u0002.A\u0019\u0001'!\u000b\n\u0007\u0005-\u0012GA\u0002B]fD\u0001\"a\f\r\u0003\u0003\u0005\raY\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0002CBA\u001c\u0003{\t9#\u0004\u0002\u0002:)\u0019\u00111H\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002@\u0005e\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0012\u0002LA\u0019\u0001'a\u0012\n\u0007\u0005%\u0013GA\u0004C_>dW-\u00198\t\u0013\u0005=b\"!AA\u0002\u0005\u001d\u0012A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0005\u0002R!A\u0011qF\b\u0002\u0002\u0003\u00071-\u0001\u0005iCND7i\u001c3f)\u0005\u0019\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002F\u0005}\u0003\"CA\u0018%\u0005\u0005\t\u0019AA\u0014Q\u001d\u0001\u00111MA<\u0003s\u0002B!!\u001a\u0002t5\u0011\u0011q\r\u0006\u0005\u0003S\nY'\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\u0011\ti'a\u001c\u0002\u000fQ\f7.\u001a>pK*\u0019\u0011\u0011O\u0011\u0002\r\u001dLG\u000f[;c\u0013\u0011\t)(a\u001a\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#!a\u001f\u0002\u0011\u000fz#F\u000b\u0011BAm[6m\\7/e\u0006\u0004\b\u000e^8ss:\n\u0007/\u001b\u0018pkR\u0004X\u000f\u001e\u0018tS:\\gfU5oW\u0002\u001a\u0016N\\6^;\u0002\"\b.\u0019;!oJLG/Z:!C\u0002\u0002G+\u00192mK\u0002\u0004\u0013N\u001c;pA\u0019LG.Z:!kNLgn\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u0002gm\u001c:nCR\u0004gF\u0003\u0011!U)\u0001\u0003E\u000b\u0011UQ&\u001c\be]5oW\u0002\u001a'/Z1uKN\u0004\u0013\r\t3je\u0016\u001cGo\u001c:zA9\fW.\u001a3!C\u001a$XM\u001d\u0011uQ\u0016\u0004#n\u001c2J\t\u0002Jgn]5eK\u0002\"\b.\u001a\u0011qe>4\u0018\u000eZ3eA\u00014\u0017\u000e\\3qCRD\u0007M\f\u0011FC\u000eD\u0007\u0005]1si&$\u0018n\u001c8!_:\u0004C\u000f[3!g\u0016\u0014h/\u001a:!i\",g\u000eI<sSR,7\u000fI5oi>\u0004\u0013\u000e^:!_^t\u0007EZ5mK\u0002:\u0018\u000e\u001e5j]\u0002\"\b.[:!I&\u0014Xm\u0019;peft#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000e\t4jY\u0016\u0004\u0016\r\u001e5!i\",\u0007EZ5mKB\fG\u000f\u001b\u0011u_\u0002:(/\u001b;fAQDW\r\t;bE2,\u0007%\u001b8u_*\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011g_Jl\u0017\r\u001e\u0011uQ\u0016\u0004cm\u001c:nCR\u0004Co\u001c\u0011cK\u0002*8/\u001a3!Ef\u0004C\u000f[5tAMLgn\u001b\u0011)A\u000e\u001bhOR8s[\u0006$\b\r\t2zA\u0011,g-Y;mi&R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005Q3yC6\u0004H.\u001a\u0006!A)\u00023p_>\u000bA\u0001R\u0003%[7q_J$\beY8n]I\f\u0007\u000f\u001b;peft\u0013\r\\4pe&$\b.\\:/O\u0016tWM]5d]\u0015#w-\u001a'jgRT\u0001\u0005\t\u0016!S6\u0004xN\u001d;!G>lgF]1qQR|'/\u001f\u0018tS:\\7O\f$jY\u0016\u001c\u0016N\\6\u000bA\u0001R\u0003%[7q_J$\beY8n]I\f\u0007\u000f\u001b;peft3\u000f]8viNtc)\u001b7f'B|W\u000f\u001e\u0006!A)R\u0001\u0005\t\u0016!m\u0006d\u0007e\u001a:ba\"\u0014U/\u001b7eKJ\u0004S\b\t8fo\u0002Jv.\u001e:He\u0006\u0004\bNQ;jY\u0012,'\u000fK\u0015\u000bA\u0001R\u0003E^1mA\u001d\u0014\u0018\r\u001d5!{\u0001\u0012\u0016\r\u001d5u_JLhf\u001d;sK\u0006l\u0007FR5mKN\u0003x.\u001e;)E=\u0002\u0018\r\u001e50i>|\u0013p\\;s_\u0019LG.\u001a\u0012*Y\u0001:'/\u00199i\u0005VLG\u000eZ3sS)\u0001\u0003E\u000b\u0011wC2\u0004C/Z:u\t&\u0014\b%\u0010\u0011#_Ql\u0007o\f:ba\"$xN]=UKN$(E\u0003\u0011!U\u00012\u0018\r\u001c\u0011tS:\\\u0007%\u0010\u0011GS2,7+\u001b8lQQ,7\u000f\u001e#je&R\u0001\u0005\t\u0016\u000bA\u0001R\u0003e\u001a:ba\"tS\r_3dkR,\u0007&\u00123hK2K7\u000f\u001e\u0015*S9:(/\u001b;f)>D3/\u001b8lS)\u0001\u0003E\u000b\u0011~{vT\u0001\u0005\t\u0016!\u0001N,W\rI.\\G>lgF]1qQR|'/\u001f\u0018ba&ts.\u001e;qkRt3/\u001b8l]MKgn\u001b\u0011TS:\\W,\u0018\u0006!A)\u0002\u0003\u0005\t\u0011!Am[6m\\7/e\u0006\u0004\b\u000e^8ss:\n\u0007/\u001b\u0018pkR\u0004X\u000f\u001e\u0018g_Jl\u0017\r\u001e\u0018G_Jl\u0017\r\u001e\u0011G_Jl\u0017\r^/^\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\u00023lW2p[:\u0012\u0018\r\u001d5u_JLhFZ8s[\u0006$8OL\"tm\u001a{'/\\1uA\r\u001bhOR8s[\u0006$X,\u0018\u0006!A)\u0002\u0003\u0005\t\u0011!Am[6m\\7/e\u0006\u0004\b\u000e^8ss:\n\u0007/\u001b\u0018b]\u0006d\u0017p]5t]Q\f'\r\\3/)\u0006\u0014G.\u001a\u0011UC\ndW-X/\u000bA\u0001Rs&\u0001\u0005GS2,7+\u001b8l!\t9FcE\u0003\u0015\u0003\u0007\u000by\tE\u0004\u0002\u0006\u0006-5I\u0014,\u000e\u0005\u0005\u001d%bAAEc\u00059!/\u001e8uS6,\u0017\u0002BAG\u0003\u000f\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\t\t*a&\u000e\u0005\u0005M%\u0002BAK\u00033\t!![8\n\u0007}\n\u0019\n\u0006\u0002\u0002\u0000\u0005)\u0011\r\u001d9msR)a+a(\u0002\"\")\u0011i\u0006a\u0001\u0007\"9Aj\u0006I\u0001\u0002\u0004q\u0015aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011VA[!\u0015\u0001\u00141VAX\u0013\r\ti+\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bA\n\tl\u0011(\n\u0007\u0005M\u0016G\u0001\u0004UkBdWM\r\u0005\t\u0003oK\u0012\u0011!a\u0001-\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ty\f\u0005\u0003\u0002\u0014\u0005\u0005\u0017\u0002BAb\u0003+\u0011aa\u00142kK\u000e$\b")
public class FileSink
extends FormatAgnosticSink
implements Product,
Serializable {
    private final String filePath;
    private final Format format;

    public static Format $lessinit$greater$default$2() {
        return FileSink$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<String, Format>> unapply(FileSink x$0) {
        return FileSink$.MODULE$.unapply(x$0);
    }

    public static Format apply$default$2() {
        return FileSink$.MODULE$.apply$default$2();
    }

    public static FileSink apply(String filePath, Format format) {
        return FileSink$.MODULE$.apply(filePath, format);
    }

    public static Function1<Tuple2<String, Format>, FileSink> tupled() {
        return FileSink$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Format, FileSink>> curried() {
        return FileSink$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String filePath() {
        return this.filePath;
    }

    public Format format() {
        return this.format;
    }

    @Override
    public SinkConnector buildConnector(String jobID, int partitionID, Config config, String itemDelimiter, String fileExtension) {
        return new SinkConnector(this, jobID, partitionID, fileExtension, itemDelimiter){
            private final String workDirectory;
            private final String file;
            private final FileChannel fileWriter;
            private final String itemDelimiter$1;

            private String workDirectory() {
                return this.workDirectory;
            }

            private String file() {
                return this.file;
            }

            private FileChannel fileWriter() {
                return this.fileWriter;
            }

            public void write(String value) {
                this.fileWriter().write(ByteBuffer.wrap(value.getBytes()));
            }

            public void closeItem() {
                this.fileWriter().write(ByteBuffer.wrap(this.itemDelimiter$1.getBytes()));
            }

            public void close() {
                this.fileWriter().close();
            }
            {
                this.itemDelimiter$1 = itemDelimiter$1;
                this.workDirectory = new StringBuilder(1).append($outer.filePath()).append("/").append(jobID$1).toString();
                new File(this.workDirectory()).mkdirs();
                this.file = new StringBuilder(12).append(this.workDirectory()).append("/partition-").append(partitionID$1).append(".").append(fileExtension$1).toString();
                this.fileWriter = FileChannel.open(Path.of(this.file(), new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            }
        };
    }

    public FileSink copy(String filePath, Format format) {
        return new FileSink(filePath, format);
    }

    public String copy$default$1() {
        return this.filePath();
    }

    public Format copy$default$2() {
        return this.format();
    }

    public String productPrefix() {
        return "FileSink";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.filePath();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FileSink;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "filePath";
                break;
            }
            case 1: {
                string = "format";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FileSink)) return false;
        boolean bl = true;
        if (!bl) return false;
        FileSink fileSink = (FileSink)x$1;
        String string = this.filePath();
        String string2 = fileSink.filePath();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Format format = this.format();
        Format format2 = fileSink.format();
        if (format == null) {
            if (format2 != null) {
                return false;
            }
        } else if (!format.equals(format2)) return false;
        if (!fileSink.canEqual(this)) return false;
        return true;
    }

    public FileSink(String filePath, Format format) {
        this.filePath = filePath;
        this.format = format;
        super(format);
        Product.$init$((Product)this);
    }
}

