/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.storage.pojograph;

import com.raphtory.api.input.ImmutableString;
import com.raphtory.api.input.MutableBoolean;
import com.raphtory.api.input.MutableDouble;
import com.raphtory.api.input.MutableFloat;
import com.raphtory.api.input.MutableInteger;
import com.raphtory.api.input.MutableLong;
import com.raphtory.api.input.MutableString;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Property;
import com.raphtory.api.input.Type;
import com.raphtory.internals.graph.GraphPartition;
import com.raphtory.internals.graph.LensInterface;
import com.raphtory.internals.storage.pojograph.PojoGraphLens;
import com.raphtory.internals.storage.pojograph.entities.external.vertex.PojoExVertex;
import com.raphtory.internals.storage.pojograph.entities.internal.PojoEdge;
import com.raphtory.internals.storage.pojograph.entities.internal.PojoEntity;
import com.raphtory.internals.storage.pojograph.entities.internal.PojoVertex;
import com.raphtory.internals.storage.pojograph.entities.internal.SplitEdge;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.parallel.CollectionConverters;
import scala.collection.parallel.CollectionConverters$;
import scala.collection.parallel.mutable.ParMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e!B\b\u0011\u0001YQ\u0002\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u0011A\u0002!\u0011!Q\u0001\nEB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006}\u0001!\ta\u0010\u0005\b\u000b\u0002\u0011\r\u0011\"\u0003G\u0011\u0019Q\u0006\u0001)A\u0005\u000f\")1\f\u0001C\u00019\")1\u000f\u0001C!i\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\tI\u0004\u0001C!\u0003wAq!a\u0013\u0001\t\u0003\ni\u0005C\u0004\u0002^\u0001!\t%a\u0018\u0003%A{'n\u001c\"bg\u0016$\u0007+\u0019:uSRLwN\u001c\u0006\u0003#I\t\u0011\u0002]8k_\u001e\u0014\u0018\r\u001d5\u000b\u0005M!\u0012aB:u_J\fw-\u001a\u0006\u0003+Y\t\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005]A\u0012\u0001\u0003:ba\"$xN]=\u000b\u0003e\t1aY8n'\t\u00011\u0004\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f)\u0005)qM]1qQ&\u0011\u0001%\b\u0002\u000f\u000fJ\f\u0007\u000f\u001b)beRLG/[8o\u0003\u001d9'/\u00199i\u0013\u0012\u001b\u0001\u0001\u0005\u0002%[9\u0011Qe\u000b\t\u0003M%j\u0011a\n\u0006\u0003Q\t\na\u0001\u0010:p_Rt$\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J\u0013A\u0002)sK\u0012,g-\u0003\u0002/_\t11\u000b\u001e:j]\u001eT!\u0001L\u0015\u0002\u0013A\f'\u000f^5uS>t\u0007C\u0001\u001a4\u001b\u0005I\u0013B\u0001\u001b*\u0005\rIe\u000e^\u0001\u0005G>tg\r\u0005\u00028y5\t\u0001H\u0003\u0002:u\u000511m\u001c8gS\u001eT!a\u000f\r\u0002\u0011QL\b/Z:bM\u0016L!!\u0010\u001d\u0003\r\r{gNZ5h\u0003\u0019a\u0014N\\5u}Q!\u0001IQ\"E!\t\t\u0005!D\u0001\u0011\u0011\u0015\tC\u00011\u0001$\u0011\u0015\u0001D\u00011\u00012\u0011\u0015)D\u00011\u00017\u0003!1XM\u001d;jG\u0016\u001cX#A$\u0011\t!kuJU\u0007\u0002\u0013*\u0011!jS\u0001\b[V$\u0018M\u00197f\u0015\ta\u0015&\u0001\u0006d_2dWm\u0019;j_:L!AT%\u0003\u00075\u000b\u0007\u000f\u0005\u00023!&\u0011\u0011+\u000b\u0002\u0005\u0019>tw\r\u0005\u0002T16\tAK\u0003\u0002V-\u0006A\u0011N\u001c;fe:\fGN\u0003\u0002X!\u0005AQM\u001c;ji&,7/\u0003\u0002Z)\nQ\u0001k\u001c6p-\u0016\u0014H/\u001a=\u0002\u0013Y,'\u000f^5dKN\u0004\u0013!D1eIB\u0013x\u000e]3si&,7\u000fF\u0003^A\n$\u0017\u000e\u0005\u00023=&\u0011q,\u000b\u0002\u0005+:LG\u000fC\u0003b\u000f\u0001\u0007q*A\u0004ng\u001e$\u0016.\\3\t\u000b\r<\u0001\u0019A(\u0002\u000b%tG-\u001a=\t\u000b\u0015<\u0001\u0019\u00014\u0002\r\u0015tG/\u001b;z!\t\u0019v-\u0003\u0002i)\nQ\u0001k\u001c6p\u000b:$\u0018\u000e^=\t\u000b)<\u0001\u0019A6\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0002mc6\tQN\u0003\u0002o_\u0006)\u0011N\u001c9vi*\u0011\u0001OF\u0001\u0004CBL\u0017B\u0001:n\u0005)\u0001&o\u001c9feRLWm]\u0001\nC\u0012$g+\u001a:uKb$r!X;xqf\\H\u0010C\u0003w\u0011\u0001\u0007q*\u0001\u0005t_V\u00148-Z%E\u0011\u0015\t\u0007\u00021\u0001P\u0011\u0015\u0019\u0007\u00021\u0001P\u0011\u0015Q\b\u00021\u0001P\u0003\u0015\u0019(oY%e\u0011\u0015Q\u0007\u00021\u0001l\u0011\u0015i\b\u00021\u0001\u007f\u0003)1XM\u001d;fqRK\b/\u001a\t\u0005e}\f\u0019!C\u0002\u0002\u0002%\u0012aa\u00149uS>t\u0007c\u00017\u0002\u0006%\u0019\u0011qA7\u0003\tQK\b/Z\u0001\u0012C\u0012$g+\u001a:uKbLe\u000e^3s]\u0006dGc\u0003*\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+AQ!Y\u0005A\u0002=CQaY\u0005A\u0002=CQA_\u0005A\u0002=CQA[\u0005A\u0002-DQ!`\u0005A\u0002y\facZ3u-\u0016\u0014H/\u001a=PeBc\u0017mY3i_2$WM\u001d\u000b\b%\u0006m\u0011QDA\u0010\u0011\u0015\t'\u00021\u0001P\u0011\u0015\u0019'\u00021\u0001P\u0011\u0019\t\tC\u0003a\u0001\u001f\u0006\u0011\u0011\u000eZ\u0001\rC\u0012$Gj\\2bY\u0016#w-\u001a\u000b\u0010;\u0006\u001d\u0012\u0011FA\u0016\u0003[\ty#a\r\u00026!)ao\u0003a\u0001\u001f\")\u0011m\u0003a\u0001\u001f\")1m\u0003a\u0001\u001f\")!p\u0003a\u0001\u001f\"1\u0011\u0011G\u0006A\u0002=\u000bQ\u0001Z:u\u0013\u0012DQA[\u0006A\u0002-Da!a\u000e\f\u0001\u0004q\u0018\u0001C3eO\u0016$\u0016\u0010]3\u0002\u001f\u0005$GmT;uO>LgnZ#eO\u0016$r\"XA\u001f\u0003\u007f\t\t%a\u0011\u0002F\u0005\u001d\u0013\u0011\n\u0005\u0006m2\u0001\ra\u0014\u0005\u0006C2\u0001\ra\u0014\u0005\u0006G2\u0001\ra\u0014\u0005\u0006u2\u0001\ra\u0014\u0005\u0007\u0003ca\u0001\u0019A(\t\u000b)d\u0001\u0019A6\t\r\u0005]B\u00021\u0001\u007f\u0003=\tG\rZ%oG>l\u0017N\\4FI\u001e,GcD/\u0002P\u0005E\u00131KA+\u0003/\nI&a\u0017\t\u000bYl\u0001\u0019A(\t\u000b\u0005l\u0001\u0019A(\t\u000b\rl\u0001\u0019A(\t\u000bil\u0001\u0019A(\t\r\u0005ER\u00021\u0001P\u0011\u0015QW\u00021\u0001l\u0011\u0019\t9$\u0004a\u0001}\u0006Yq-\u001a;WKJ$\u0018nY3t)!\t\t'a\u001d\u0002~\u0005\u0005\u0005#\u0002%N\u001f\u0006\r\u0004\u0003BA3\u0003_j!!a\u001a\u000b\t\u0005%\u00141N\u0001\u0007m\u0016\u0014H/\u001a=\u000b\u0007\u00055d+\u0001\u0005fqR,'O\\1m\u0013\u0011\t\t(a\u001a\u0003\u0019A{'n\\#y-\u0016\u0014H/\u001a=\t\u000f\u0005Ud\u00021\u0001\u0002x\u0005!A.\u001a8t!\ra\u0012\u0011P\u0005\u0004\u0003wj\"!\u0004'f]NLe\u000e^3sM\u0006\u001cW\r\u0003\u0004\u0002\u00009\u0001\raT\u0001\u0006gR\f'\u000f\u001e\u0005\u0007\u0003\u0007s\u0001\u0019A(\u0002\u0007\u0015tG\r")
public class PojoBasedPartition
extends GraphPartition {
    private final int partition;
    private final Map<Object, PojoVertex> vertices;

    private Map<Object, PojoVertex> vertices() {
        return this.vertices;
    }

    public void addProperties(long msgTime, long index, PojoEntity entity, Properties properties) {
        properties.properties().foreach((Function1 & Serializable)x0$1 -> {
            PojoBasedPartition.$anonfun$addProperties$1(entity, msgTime, index, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void addVertex(long sourceID, long msgTime, long index, long srcId, Properties properties, Option<Type> vertexType) {
        Map<Object, PojoVertex> map = this.vertices();
        synchronized (map) {
            BoxedUnit boxedUnit;
            this.addVertexInternal(msgTime, index, srcId, properties, vertexType);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Added vertex {}", (Object)BoxesRunTime.boxToLong((long)srcId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public PojoVertex addVertexInternal(long msgTime, long index, long srcId, Properties properties, Option<Type> vertexType) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        PojoVertex pojoVertex;
        Option option = this.vertices().get((Object)BoxesRunTime.boxToLong((long)srcId));
        if (option instanceof Some) {
            BoxedUnit boxedUnit3;
            Some some = (Some)option;
            PojoVertex v = (PojoVertex)some.value();
            v.revive(msgTime, index);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("History point added to vertex: {}", (Object)BoxesRunTime.boxToLong((long)srcId));
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            pojoVertex = v;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit4;
            PojoVertex v = new PojoVertex(msgTime, index, srcId, true);
            this.vertices().$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)srcId), (Object)v));
            v.setType((Option<String>)vertexType.map((Function1 & Serializable)x$1 -> x$1.name()));
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("New vertex created {}", (Object)BoxesRunTime.boxToLong((long)srcId));
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            pojoVertex = v;
        } else {
            throw new MatchError((Object)option);
        }
        PojoVertex vertex = pojoVertex;
        this.addProperties(msgTime, index, vertex, properties);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Properties added: {}", (Object)properties);
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Vertex returned: {}", (Object)BoxesRunTime.boxToLong((long)vertex.vertexId()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return vertex;
    }

    private PojoVertex getVertexOrPlaceholder(long msgTime, long index, long id) {
        PojoVertex pojoVertex;
        Option option = this.vertices().get((Object)BoxesRunTime.boxToLong((long)id));
        if (option instanceof Some) {
            PojoVertex vertex;
            Some some = (Some)option;
            pojoVertex = vertex = (PojoVertex)some.value();
        } else if (None$.MODULE$.equals(option)) {
            PojoVertex vertex = new PojoVertex(msgTime, index, id, true);
            this.vertices().put((Object)BoxesRunTime.boxToLong((long)id), (Object)vertex);
            vertex.wipe();
            pojoVertex = vertex;
        } else {
            throw new MatchError((Object)option);
        }
        return pojoVertex;
    }

    @Override
    public void addLocalEdge(long sourceID, long msgTime, long index, long srcId, long dstId, Properties properties, Option<Type> edgeType) {
        Map<Object, PojoVertex> map = this.vertices();
        synchronized (map) {
            BoxedUnit boxedUnit;
            PojoVertex srcVertex = this.addVertexInternal(msgTime, index, srcId, new Properties((Seq<Property>)Nil$.MODULE$), (Option<Type>)None$.MODULE$);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Src ID: {} created and revived", (Object)BoxesRunTime.boxToLong((long)srcId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            PojoVertex dstVertex = srcId != dstId ? this.addVertexInternal(msgTime, index, dstId, new Properties((Seq<Property>)Nil$.MODULE$), (Option<Type>)None$.MODULE$) : srcVertex;
            Option<PojoEdge> option = srcVertex.getOutgoingEdge(dstId);
            if (option instanceof Some) {
                BoxedUnit boxedUnit2;
                Some some = (Some)option;
                PojoEdge edge = (PojoEdge)some.value();
                edge.revive(msgTime, index);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Edge {} - {} revived", new Object[]{BoxesRunTime.boxToLong((long)edge.getSrcId()), BoxesRunTime.boxToLong((long)edge.getDstId())});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.addProperties(msgTime, index, edge, properties);
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit4;
                BoxedUnit boxedUnit5;
                PojoEdge newEdge = new PojoEdge(msgTime, index, srcId, dstId, true);
                newEdge.setType((Option<String>)edgeType.map((Function1 & Serializable)x$2 -> x$2.name()));
                srcVertex.addOutgoingEdge(newEdge);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Added edge {} to vertex {}", new Object[]{newEdge, srcVertex});
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                dstVertex.addIncomingEdge(newEdge);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("added {} to {}", new Object[]{newEdge, dstVertex});
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                this.addProperties(msgTime, index, newEdge, properties);
                BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
    }

    @Override
    public void addOutgoingEdge(long sourceID, long msgTime, long index, long srcId, long dstId, Properties properties, Option<Type> edgeType) {
        Map<Object, PojoVertex> map = this.vertices();
        synchronized (map) {
            BoxedUnit boxedUnit;
            PojoVertex srcVertex = this.addVertexInternal(msgTime, index, srcId, new Properties((Seq<Property>)Nil$.MODULE$), (Option<Type>)None$.MODULE$);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Src ID: {} created and revived", (Object)BoxesRunTime.boxToLong((long)srcId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option<PojoEdge> option = srcVertex.getOutgoingEdge(dstId);
            if (option instanceof Some) {
                BoxedUnit boxedUnit2;
                Some some = (Some)option;
                PojoEdge edge = (PojoEdge)some.value();
                edge.revive(msgTime, index);
                this.addProperties(msgTime, index, edge, properties);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Edge {} - {} revived", new Object[]{BoxesRunTime.boxToLong((long)edge.getSrcId()), BoxesRunTime.boxToLong((long)edge.getDstId())});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit2;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit4;
                BoxedUnit boxedUnit5;
                SplitEdge newEdge = new SplitEdge(msgTime, index, srcId, dstId, true);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Split edge {} - {} between partitions created", new Object[]{BoxesRunTime.boxToLong((long)srcId), BoxesRunTime.boxToLong((long)dstId)});
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                newEdge.setType((Option<String>)edgeType.map((Function1 & Serializable)x$3 -> x$3.name()));
                srcVertex.addOutgoingEdge(newEdge);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Added edge {} to vertex {}", new Object[]{newEdge, srcVertex});
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                this.addProperties(msgTime, index, newEdge, properties);
                BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
    }

    @Override
    public void addIncomingEdge(long sourceID, long msgTime, long index, long srcId, long dstId, Properties properties, Option<Type> edgeType) {
        Map<Object, PojoVertex> map = this.vertices();
        synchronized (map) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            PojoEdge pojoEdge;
            BoxedUnit boxedUnit3;
            PojoVertex dstVertex = this.addVertexInternal(msgTime, index, dstId, new Properties((Seq<Property>)Nil$.MODULE$), (Option<Type>)None$.MODULE$);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("created and revived destination vertex: {}", (Object)BoxesRunTime.boxToLong((long)dstId));
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            Option<PojoEdge> option = dstVertex.getIncomingEdge(srcId);
            if (option instanceof Some) {
                BoxedUnit boxedUnit4;
                Some some = (Some)option;
                PojoEdge edge = (PojoEdge)some.value();
                edge.revive(msgTime, index);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Edge {} {} already existed in partition {} for syncNewEdgeAdd", new Object[]{BoxesRunTime.boxToLong((long)srcId), BoxesRunTime.boxToLong((long)dstId), BoxesRunTime.boxToInteger((int)this.partition)});
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                pojoEdge = edge;
            } else if (None$.MODULE$.equals(option)) {
                SplitEdge e = new SplitEdge(msgTime, index, srcId, dstId, true);
                dstVertex.addIncomingEdge(e);
                pojoEdge = e;
            } else {
                throw new MatchError(option);
            }
            PojoEdge edge = pojoEdge;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("added {} to {}", new Object[]{edge, dstVertex});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.addProperties(msgTime, index, edge, properties);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Added properties {}", (Object)properties);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            edge.setType((Option<String>)edgeType.map((Function1 & Serializable)x$4 -> x$4.name()));
        }
    }

    @Override
    public Map<Object, PojoExVertex> getVertices(LensInterface lens, long start, long end) {
        Map map;
        Map<Object, PojoVertex> map2 = this.vertices();
        synchronized (map2) {
            PojoGraphLens lenz = (PojoGraphLens)lens;
            map = ((ParMap)CollectionConverters.MutableMapIsParallelizable$.MODULE$.par$extension(CollectionConverters$.MODULE$.MutableMapIsParallelizable(this.vertices())).collect((PartialFunction)new Serializable(null, start, end, lenz){
                private static final long serialVersionUID = 0L;
                private final long start$1;
                private final long end$1;
                private final PojoGraphLens lenz$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Object, PojoVertex>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        long id = A1._1$mcJ$sp();
                        PojoVertex vertex = (PojoVertex)A1._2();
                        if (vertex.aliveBetween(this.start$1, this.end$1)) {
                            object = new Tuple2((Object)BoxesRunTime.boxToLong((long)id), (Object)vertex.viewBetween(this.start$1, this.end$1, this.lenz$1));
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<Object, PojoVertex> x1) {
                    PojoVertex vertex;
                    Tuple2<Object, PojoVertex> tuple2 = x1;
                    boolean bl = tuple2 != null && (vertex = (PojoVertex)tuple2._2()).aliveBetween(this.start$1, this.end$1);
                    return bl;
                }
                {
                    this.start$1 = start$1;
                    this.end$1 = end$1;
                    this.lenz$1 = lenz$1;
                }
            })).seq();
        }
        return map;
    }

    public static final /* synthetic */ void $anonfun$addProperties$1(PojoEntity entity$1, long msgTime$1, long index$1, Property x0$1) {
        Property property = x0$1;
        if (property instanceof MutableString) {
            MutableString mutableString = (MutableString)property;
            String key = mutableString.key();
            String value = mutableString.value();
            entity$1.$plus(msgTime$1, index$1, false, key, value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (property instanceof MutableLong) {
            MutableLong mutableLong = (MutableLong)property;
            String key = mutableLong.key();
            long value = mutableLong.value();
            entity$1.$plus(msgTime$1, index$1, false, key, BoxesRunTime.boxToLong((long)value));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (property instanceof MutableDouble) {
            MutableDouble mutableDouble = (MutableDouble)property;
            String key = mutableDouble.key();
            double value = mutableDouble.value();
            entity$1.$plus(msgTime$1, index$1, false, key, BoxesRunTime.boxToDouble((double)value));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (property instanceof MutableFloat) {
            MutableFloat mutableFloat = (MutableFloat)property;
            String key = mutableFloat.key();
            float value = mutableFloat.value();
            entity$1.$plus(msgTime$1, index$1, false, key, BoxesRunTime.boxToFloat((float)value));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (property instanceof MutableBoolean) {
            MutableBoolean mutableBoolean = (MutableBoolean)property;
            String key = mutableBoolean.key();
            boolean value = mutableBoolean.value();
            entity$1.$plus(msgTime$1, index$1, false, key, BoxesRunTime.boxToBoolean((boolean)value));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (property instanceof MutableInteger) {
            MutableInteger mutableInteger = (MutableInteger)property;
            String key = mutableInteger.key();
            int value = mutableInteger.value();
            entity$1.$plus(msgTime$1, index$1, false, key, BoxesRunTime.boxToInteger((int)value));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (property instanceof ImmutableString) {
            ImmutableString immutableString = (ImmutableString)property;
            String key = immutableString.key();
            String value = immutableString.value();
            entity$1.$plus(msgTime$1, index$1, true, key, value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)property);
        }
    }

    public PojoBasedPartition(String graphID, int partition, Config conf) {
        this.partition = partition;
        super(graphID, partition, conf);
        this.vertices = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

