/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.time;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.time.DiscreteInterval;
import com.raphtory.api.time.Interval;
import com.raphtory.api.time.TimeInterval$;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.Ordered;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001B\u000f\u001f\u0001\u001eB\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0007\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005X\u0001\tE\t\u0015!\u0003P\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015I\u0007\u0001\"\u0015k\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u001d\u0001\b!!A\u0005\u0002EDq\u0001\u001e\u0001\u0012\u0002\u0013\u0005Q\u000fC\u0005\u0002\u0002\u0001\t\n\u0011\"\u0001\u0002\u0004!I\u0011q\u0001\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0002\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/A\u0011\"a\b\u0001\u0003\u0003%\t!!\t\t\u0013\u0005\u001d\u0002!!A\u0005B\u0005%\u0002\"CA\u001c\u0001\u0005\u0005I\u0011AA\u001d\u0011%\t\u0019\u0005AA\u0001\n\u0003\n)\u0005C\u0005\u0002J\u0001\t\t\u0011\"\u0011\u0002L!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0013qJ\u0004\n\u0003'r\u0012\u0011!E\u0001\u0003+2\u0001\"\b\u0010\u0002\u0002#\u0005\u0011q\u000b\u0005\u00071^!\t!a\u001c\t\u0013\u0005Et#!A\u0005F\u0005M\u0004\"CA;/\u0005\u0005I\u0011QA<\u0011%\tihFA\u0001\n\u0003\u000by\bC\u0005\u0002\u0012^\t\t\u0011\"\u0003\u0002\u0014\naA+[7f\u0013:$XM\u001d<bY*\u0011q\u0004I\u0001\u0005i&lWM\u0003\u0002\"E\u0005\u0019\u0011\r]5\u000b\u0005\r\"\u0013\u0001\u0003:ba\"$xN]=\u000b\u0003\u0015\n1aY8n\u0007\u0001\u0019R\u0001\u0001\u0015/eU\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0007CA\u00181\u001b\u0005q\u0012BA\u0019\u001f\u0005!Ie\u000e^3sm\u0006d\u0007CA\u00154\u0013\t!$FA\u0004Qe>$Wo\u0019;\u0011\u0005YrdBA\u001c=\u001d\tA4(D\u0001:\u0015\tQd%\u0001\u0004=e>|GOP\u0005\u0002W%\u0011QHK\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002>U\u0005!1/\u001b>f+\u0005\u0019\u0005C\u0001#K\u001b\u0005)%B\u0001$H\u0003!!X-\u001c9pe\u0006d'BA\u0010I\u0015\u0005I\u0015\u0001\u00026bm\u0006L!aS#\u0003\u001dQ+W\u000e]8sC2\fUn\\;oi\u0006)1/\u001b>fA\u0005!a.Y7f+\u0005y\u0005C\u0001)U\u001d\t\t&\u000b\u0005\u00029U%\u00111KK\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002TU\u0005)a.Y7fA\u00051A(\u001b8jiz\"2AW.]!\ty\u0003\u0001C\u0003B\u000b\u0001\u00071\tC\u0003N\u000b\u0001\u0007q*\u0001\u0007v]\u0006\u0014\u0018p\u0018\u0013nS:,8/F\u0001/\u0003\u0019!C/[7fgR\u0011a&\u0019\u0005\u0006E\u001e\u0001\raY\u0001\u0007]Vl'-\u001a:\u0011\u0005%\"\u0017BA3+\u0005\u0011auN\\4\u0002\t\u0011\"\u0017N\u001e\u000b\u0003]!DQA\u0019\u0005A\u0002\r\fa\u0001^8M_:<W#A2\u0002\r=,H\u000f];u+\u0005i\u0007CA\u0015o\u0013\ty'FA\u0002B]f\fAaY8qsR\u0019!L]:\t\u000f\u0005[\u0001\u0013!a\u0001\u0007\"9Qj\u0003I\u0001\u0002\u0004y\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002m*\u00121i^\u0016\u0002qB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\nk:\u001c\u0007.Z2lK\u0012T!! \u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002\u0000u\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0001\u0016\u0003\u001f^\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t\u0011\u0006!A.\u00198h\u0013\r)\u0016qB\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00033\u00012!KA\u000e\u0013\r\tiB\u000b\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004[\u0006\r\u0002\"CA\u0013!\u0005\u0005\t\u0019AA\r\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0006\t\u0006\u0003[\t\u0019$\\\u0007\u0003\u0003_Q1!!\r+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003k\tyC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001e\u0003\u0003\u00022!KA\u001f\u0013\r\tyD\u000b\u0002\b\u0005>|G.Z1o\u0011!\t)CEA\u0001\u0002\u0004i\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0003\u0002H!I\u0011QE\n\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011D\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m\u0012\u0011\u000b\u0005\t\u0003K)\u0012\u0011!a\u0001[\u0006aA+[7f\u0013:$XM\u001d<bYB\u0011qfF\n\u0006/\u0005e\u0013Q\r\t\b\u00037\n\tgQ([\u001b\t\tiFC\u0002\u0002`)\nqA];oi&lW-\u0003\u0003\u0002d\u0005u#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011qMA7\u001b\t\tIGC\u0002\u0002l!\u000b!![8\n\u0007}\nI\u0007\u0006\u0002\u0002V\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\f\u0005)\u0011\r\u001d9msR)!,!\u001f\u0002|!)\u0011I\u0007a\u0001\u0007\")QJ\u0007a\u0001\u001f\u00069QO\\1qa2LH\u0003BAA\u0003\u001b\u0003R!KAB\u0003\u000fK1!!\"+\u0005\u0019y\u0005\u000f^5p]B)\u0011&!#D\u001f&\u0019\u00111\u0012\u0016\u0003\rQ+\b\u000f\\33\u0011!\tyiGA\u0001\u0002\u0004Q\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q\u0013\t\u0005\u0003\u001b\t9*\u0003\u0003\u0002\u001a\u0006=!AB(cU\u0016\u001cG\u000f")
public class TimeInterval
implements Interval,
Product,
Serializable {
    private final TemporalAmount size;
    private final String name;

    public static Option<Tuple2<TemporalAmount, String>> unapply(TimeInterval x$0) {
        return TimeInterval$.MODULE$.unapply(x$0);
    }

    public static TimeInterval apply(TemporalAmount size, String name) {
        return TimeInterval$.MODULE$.apply(size, name);
    }

    public static Function1<Tuple2<TemporalAmount, String>, TimeInterval> tupled() {
        return TimeInterval$.MODULE$.tupled();
    }

    public static Function1<TemporalAmount, Function1<String, TimeInterval>> curried() {
        return TimeInterval$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    @Scaladoc(value="/** Returns a `String` representation of this `Interval`. */")
    public String toString() {
        return Interval.toString$(this);
    }

    @Override
    public int compare(Interval that) {
        return Interval.compare$(this, that);
    }

    public boolean $less(Object that) {
        return Ordered.$less$((Ordered)this, (Object)that);
    }

    public boolean $greater(Object that) {
        return Ordered.$greater$((Ordered)this, (Object)that);
    }

    public boolean $less$eq(Object that) {
        return Ordered.$less$eq$((Ordered)this, (Object)that);
    }

    public boolean $greater$eq(Object that) {
        return Ordered.$greater$eq$((Ordered)this, (Object)that);
    }

    public int compareTo(Object that) {
        return Ordered.compareTo$((Ordered)this, (Object)that);
    }

    public TemporalAmount size() {
        return this.size;
    }

    public String name() {
        return this.name;
    }

    public Interval unary_$minus() {
        TemporalAmount temporalAmount;
        TemporalAmount temporalAmount2 = this.size();
        if (temporalAmount2 instanceof Duration) {
            Duration duration = (Duration)temporalAmount2;
            temporalAmount = duration.negated();
        } else if (temporalAmount2 instanceof Period) {
            Period period = (Period)temporalAmount2;
            temporalAmount = period.negated();
        } else {
            throw new Exception("Unknown interval type");
        }
        return new TimeInterval(temporalAmount, this.name());
    }

    @Override
    public Interval $times(long number) {
        TemporalAmount temporalAmount;
        TemporalAmount temporalAmount2 = this.size();
        if (temporalAmount2 instanceof Duration) {
            Duration duration = (Duration)temporalAmount2;
            temporalAmount = duration.multipliedBy(number);
        } else if (temporalAmount2 instanceof Period) {
            Period period = (Period)temporalAmount2;
            temporalAmount = period.multipliedBy((int)number);
        } else {
            throw new Exception("Unknown interval type");
        }
        return new TimeInterval(temporalAmount, this.name());
    }

    @Override
    public Interval $div(long number) {
        Product product;
        TemporalAmount temporalAmount = this.size();
        if (temporalAmount instanceof Duration) {
            Duration duration = (Duration)temporalAmount;
            product = new TimeInterval(duration.dividedBy(number), this.name());
        } else if (temporalAmount instanceof Period) {
            product = new DiscreteInterval(this.toLong() / number);
        } else {
            throw new Exception("Unknown interval type");
        }
        return product;
    }

    @Override
    public long toLong() {
        return Instant.ofEpochMilli(0L).plus(this.size()).toEpochMilli();
    }

    @Override
    public Object output() {
        return this.name();
    }

    public TimeInterval copy(TemporalAmount size, String name) {
        return new TimeInterval(size, name);
    }

    public TemporalAmount copy$default$1() {
        return this.size();
    }

    public String copy$default$2() {
        return this.name();
    }

    public String productPrefix() {
        return "TimeInterval";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.size();
                break;
            }
            case 1: {
                object = this.name();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimeInterval;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "size";
                break;
            }
            case 1: {
                string = "name";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimeInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimeInterval timeInterval = (TimeInterval)x$1;
        TemporalAmount temporalAmount = this.size();
        TemporalAmount temporalAmount2 = timeInterval.size();
        if (temporalAmount == null) {
            if (temporalAmount2 != null) {
                return false;
            }
        } else if (!temporalAmount.equals(temporalAmount2)) return false;
        String string = this.name();
        String string2 = timeInterval.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!timeInterval.canEqual(this)) return false;
        return true;
    }

    public TimeInterval(TemporalAmount size, String name) {
        this.size = size;
        this.name = name;
        Ordered.$init$((Ordered)this);
        Interval.$init$(this);
        Product.$init$((Product)this);
    }
}

