/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.progresstracker;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.TableOutput;
import com.raphtory.api.analysis.table.TableOutput$;
import com.raphtory.api.progresstracker.QueryProgressTracker;
import com.raphtory.api.progresstracker.QueryProgressTrackerWithIterator$;
import com.raphtory.api.progresstracker.QueryProgressTrackerWithIterator$TableOutputIterator$;
import com.raphtory.internals.graph.Perspective;
import com.raphtory.protocol.PerspectiveCompleted;
import com.raphtory.protocol.PerspectiveFailed;
import com.raphtory.protocol.QueryCompleted;
import com.raphtory.protocol.QueryFailed;
import com.raphtory.protocol.QueryUpdate;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Scaladoc(value="/**\n  * Iterator over perspective results with additional query tracking functionality.\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001\u0002\u0014(\u0001AB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005m!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001di\u0006A1A\u0005\nyCa!\u001a\u0001!\u0002\u0013y\u0006b\u00024\u0001\u0001\u0004%Ia\u001a\u0005\bY\u0002\u0001\r\u0011\"\u0003n\u0011\u0019\u0019\b\u0001)Q\u0005Q\"9A\u000f\u0001a\u0001\n\u0013)\bbB=\u0001\u0001\u0004%IA\u001f\u0005\u0007y\u0002\u0001\u000b\u0015\u0002<\t\u000fu\u0004\u0001\u0019!C\u0005}\"I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\b\u00037\u0001\u0001\u0015)\u0003\u0000\u0011%\ti\u0002\u0001b\u0001\n\u0013\ty\u0002\u0003\u0005\u0002:\u0001\u0001\u000b\u0011BA\u0011\u0011\u001d\tY\u0004\u0001C!\u0003{Aa!a\u0014\u0001\t\u0003:\u0007bBA)\u0001\u0011%\u00111K\u0004\b\u0003+\u0002\u0001\u0012AA,\r\u001d\tY\u0006\u0001E\u0001\u0003;BaAV\f\u0005\u0002\u0005]\u0004BBA=/\u0011\u0005s\rC\u0004\u0002|]!\t%! \b\u000f\u0005}t\u0003#\u0003\u0002\u0002\u001a9\u0011QQ\f\t\n\u0005\u001d\u0005B\u0002,\u001d\t\u0003\tII\u0002\u0004\u0002\fr\u0001\u0011Q\u0012\u0005\t\u0007z\u0011\t\u0011)A\u0005m!I\u0011Q\u0013\u0010\u0003\u0002\u0003\u0006IA\u000e\u0005\u0007-z!\t!a&\b\u000f\u0005uv\u0005#\u0001\u0002@\u001a1ae\nE\u0001\u0003\u0003DaAV\u0012\u0005\u0002\u0005\r\u0007bBAcG\u0011\u0005\u0011q\u0019\u0002!#V,'/\u001f)s_\u001e\u0014Xm]:Ue\u0006\u001c7.\u001a:XSRD\u0017\n^3sCR|'O\u0003\u0002)S\u0005y\u0001O]8he\u0016\u001c8\u000f\u001e:bG.,'O\u0003\u0002+W\u0005\u0019\u0011\r]5\u000b\u00051j\u0013\u0001\u0003:ba\"$xN]=\u000b\u00039\n1aY8n\u0007\u0001\u0019\"\u0001A\u0019\u0011\u0005I\u001aT\"A\u0014\n\u0005Q:#\u0001F)vKJL\bK]8he\u0016\u001c8\u000f\u0016:bG.,'/A\u0004he\u0006\u0004\b.\u0013#\u0011\u0005]\u0002eB\u0001\u001d?!\tID(D\u0001;\u0015\tYt&\u0001\u0004=e>|GO\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\bP\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@y\u0005)!n\u001c2J\t\u0006!1m\u001c8g!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u00156\n\u0001\u0002^=qKN\fg-Z\u0005\u0003\u0019\u001e\u0013aaQ8oM&<\u0017a\u0002;j[\u0016|W\u000f\u001e\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0003'r\n!bY8oGV\u0014(/\u001a8u\u0013\t)\u0006K\u0001\u0005EkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q)\u0001,\u0017.\\9B\u0011!\u0007\u0001\u0005\u0006k\u0015\u0001\rA\u000e\u0005\u0006\u0007\u0016\u0001\rA\u000e\u0005\u0006\t\u0016\u0001\r!\u0012\u0005\u0006\u001b\u0016\u0001\rAT\u0001\u0007Y><w-\u001a:\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!AY%\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\n\u0005\u0011\f'A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0015=,H\u000f];u\t>tW-F\u0001i!\tI'.D\u0001=\u0013\tYGHA\u0004C_>dW-\u00198\u0002\u001d=,H\u000f];u\t>tWm\u0018\u0013fcR\u0011a.\u001d\t\u0003S>L!\u0001\u001d\u001f\u0003\tUs\u0017\u000e\u001e\u0005\be&\t\t\u00111\u0001i\u0003\rAH%M\u0001\f_V$\b/\u001e;E_:,\u0007%\u0001\u0005k_\n\u001cHi\u001c8f+\u00051\bCA5x\u0013\tAHHA\u0002J]R\fAB[8cg\u0012{g.Z0%KF$\"A\\>\t\u000fId\u0011\u0011!a\u0001m\u0006I!n\u001c2t\t>tW\rI\u0001\u000b]\u0016DHOU3tk2$X#A@\u0011\u000b%\f\t!!\u0002\n\u0007\u0005\rAH\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\u0015!\u0018M\u00197f\u0015\r\ty!K\u0001\tC:\fG._:jg&!\u00111CA\u0005\u0005-!\u0016M\u00197f\u001fV$\b/\u001e;\u0002\u001d9,\u0007\u0010\u001e*fgVdGo\u0018\u0013fcR\u0019a.!\u0007\t\u000fI|\u0011\u0011!a\u0001\u007f\u0006Ya.\u001a=u%\u0016\u001cX\u000f\u001c;!\u0003A\u0019w.\u001c9mKR,GMU3tk2$8/\u0006\u0002\u0002\"A1\u00111EA\u0018\u0003gi!!!\n\u000b\u0007M\u000b9C\u0003\u0003\u0002*\u0005-\u0012\u0001B;uS2T!!!\f\u0002\t)\fg/Y\u0005\u0005\u0003c\t)CA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4Rk\u0016,X\rE\u0002j\u0003kI1!a\u000e=\u0005\r\te._\u0001\u0012G>l\u0007\u000f\\3uK\u0012\u0014Vm];miN\u0004\u0013!\u00055b]\u0012dW-U;fef,\u0006\u000fZ1uKR\u0019a.a\u0010\t\u000f\u0005\u00053\u00031\u0001\u0002D\u0005\u0019Qn]4\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013,\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA'\u0003\u000f\u00121\"U;fef,\u0006\u000fZ1uK\u0006I\u0011n\u001d&pE\u0012{g.Z\u0001\u0012o\u0006LGOR8s\u001d\u0016DHOU3tk2$HCAA\u001a\u0003M!\u0016M\u00197f\u001fV$\b/\u001e;Ji\u0016\u0014\u0018\r^8s!\r\tIfF\u0007\u0002\u0001\t\u0019B+\u00192mK>+H\u000f];u\u0013R,'/\u0019;peN)q#a\u0018\u0002fA\u0019\u0011.!\u0019\n\u0007\u0005\rDH\u0001\u0004B]f\u0014VM\u001a\t\u0007\u0003O\n\t(!\u0002\u000f\t\u0005%\u0014Q\u000e\b\u0004s\u0005-\u0014\"A\u001f\n\u0007\u0005=D(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0014Q\u000f\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011q\u000e\u001f\u0015\u0005\u0005]\u0013a\u00025bg:+\u0007\u0010^\u0001\u0005]\u0016DH\u000f\u0006\u0002\u0002\u0006\u0005aB+\u00192mK>+H\u000f];u\u0013R,'/\u0019;pe\u0016C8-\u001a9uS>t\u0007cAAB95\tqC\u0001\u000fUC\ndWmT;uaV$\u0018\n^3sCR|'/\u0012=dKB$\u0018n\u001c8\u0014\u0007q\ty\u0006\u0006\u0002\u0002\u0002\n\u0011\"j\u001c2GC&dW\rZ#yG\u0016\u0004H/[8o'\rq\u0012q\u0012\t\u0005\u0003O\n\t*\u0003\u0003\u0002\u0014\u0006U$\u0001\u0005*v]RLW.Z#yG\u0016\u0004H/[8o\u0003\u0019\u0011X-Y:p]R1\u0011\u0011TAO\u0003?\u00032!a'\u001f\u001b\u0005a\u0002\"B\"\"\u0001\u00041\u0004BBAKC\u0001\u0007a\u0007K\u0004\u0001\u0003G\u000b9,!/\u0011\t\u0005\u0015\u00161W\u0007\u0003\u0003OSA!!+\u0002,\u0006A1oY1mC\u0012|7M\u0003\u0003\u0002.\u0006=\u0016a\u0002;bW\u0016Tx.\u001a\u0006\u0004\u0003ck\u0013AB4ji\",(-\u0003\u0003\u00026\u0006\u001d&\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\u0005m\u0016\u0001X\u0018+U)\u0001\u0003E\u000b\u0011Ji\u0016\u0014\u0018\r^8sA=4XM\u001d\u0011qKJ\u001c\b/Z2uSZ,\u0007E]3tk2$8\u000fI<ji\"\u0004\u0013\r\u001a3ji&|g.\u00197!cV,'/\u001f\u0011ue\u0006\u001c7.\u001b8hA\u0019,hn\u0019;j_:\fG.\u001b;z])\u0001\u0003EK\u0018\u0002AE+XM]=Qe><'/Z:t)J\f7m[3s/&$\b.\u0013;fe\u0006$xN\u001d\t\u0003e\r\u001a2aIA0)\t\ty,A\u0003baBd\u0017\u0010F\u0005Y\u0003\u0013\fY-!4\u0002P\")Q'\na\u0001m!)1)\na\u0001m!)A)\na\u0001\u000b\")Q*\na\u0001\u001d\u0002")
public class QueryProgressTrackerWithIterator
extends QueryProgressTracker {
    private volatile QueryProgressTrackerWithIterator$TableOutputIterator$ TableOutputIterator$module;
    public final String com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$jobID;
    private final Config conf;
    private final Duration timeout;
    private final Logger com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger;
    private boolean com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone;
    private int jobsDone;
    private Option<TableOutput> com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$nextResult;
    private final LinkedBlockingQueue<Object> completedResults;

    public static QueryProgressTrackerWithIterator apply(String graphID, String jobID, Config conf, Duration timeout) {
        return QueryProgressTrackerWithIterator$.MODULE$.apply(graphID, jobID, conf, timeout);
    }

    public QueryProgressTrackerWithIterator$TableOutputIterator$ TableOutputIterator() {
        if (this.TableOutputIterator$module == null) {
            this.TableOutputIterator$lzycompute$1();
        }
        return this.TableOutputIterator$module;
    }

    public Logger com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger() {
        return this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger;
    }

    public boolean com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone() {
        return this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone;
    }

    public void com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone_$eq(boolean x$1) {
        this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone = x$1;
    }

    private int jobsDone() {
        return this.jobsDone;
    }

    private void jobsDone_$eq(int x$1) {
        this.jobsDone = x$1;
    }

    public Option<TableOutput> com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$nextResult() {
        return this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$nextResult;
    }

    public void com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$nextResult_$eq(Option<TableOutput> x$1) {
        this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$nextResult = x$1;
    }

    private LinkedBlockingQueue<Object> completedResults() {
        return this.completedResults;
    }

    @Override
    public void handleQueryUpdate(QueryUpdate msg) {
        Boolean bl;
        QueryUpdate queryUpdate = msg;
        if (queryUpdate instanceof PerspectiveCompleted) {
            BoxedUnit boxedUnit;
            PerspectiveCompleted perspectiveCompleted = (PerspectiveCompleted)queryUpdate;
            Perspective perspective = perspectiveCompleted.perspective();
            Seq<Row> rows = perspectiveCompleted.rows();
            if (this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().isDebugEnabled()) {
                this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().debug("received message {}", (Object)msg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = BoxesRunTime.boxToBoolean((boolean)this.completedResults().add(TableOutput$.MODULE$.apply(this.getJobId(), perspective, (Row[])rows.toArray(ClassTag$.MODULE$.apply(Row.class)), this.conf)));
        } else {
            boolean bl2 = queryUpdate instanceof QueryCompleted ? true : queryUpdate instanceof QueryFailed;
            if (bl2) {
                bl = BoxesRunTime.boxToBoolean((boolean)this.completedResults().add(msg));
            } else if (queryUpdate instanceof PerspectiveFailed) {
                BoxedUnit boxedUnit;
                PerspectiveFailed perspectiveFailed = (PerspectiveFailed)queryUpdate;
                Perspective perspective = perspectiveFailed.perspective();
                String reason = perspectiveFailed.reason();
                if (this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().isErrorEnabled()) {
                    this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().error("perspective {} failed: {}", new Object[]{perspective, reason});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = BoxesRunTime.boxToBoolean((boolean)this.completedResults().add(TableOutput$.MODULE$.apply(this.getJobId(), perspective, (Row[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Row.class)), this.conf)));
            } else {
                BoxedUnit boxedUnit;
                if (this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().isErrorEnabled()) {
                    this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().error("unknown {}", (Object)msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = boxedUnit;
            }
        }
        super.handleQueryUpdate(msg);
    }

    @Override
    public boolean isJobDone() {
        return this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone();
    }

    public Object com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$waitForNextResult() {
        BoxedUnit boxedUnit;
        if (this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().isDebugEnabled()) {
            this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger().underlying().debug("waiting for result");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.timeout.isFinite() ? Option$.MODULE$.apply(this.completedResults().poll(this.timeout.length(), this.timeout.unit())) : Option$.MODULE$.apply(this.completedResults().take());
    }

    private final void TableOutputIterator$lzycompute$1() {
        QueryProgressTrackerWithIterator queryProgressTrackerWithIterator = this;
        synchronized (queryProgressTrackerWithIterator) {
            if (this.TableOutputIterator$module == null) {
                this.TableOutputIterator$module = new QueryProgressTrackerWithIterator$TableOutputIterator$(this);
            }
        }
    }

    public QueryProgressTrackerWithIterator(String graphID, String jobID, Config conf, Duration timeout) {
        this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$jobID = jobID;
        this.conf = conf;
        this.timeout = timeout;
        super(graphID, jobID, conf);
        this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
        this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$outputDone = false;
        this.jobsDone = 0;
        this.com$raphtory$api$progresstracker$QueryProgressTrackerWithIterator$$nextResult = None$.MODULE$;
        this.completedResults = new LinkedBlockingQueue();
    }
}

