/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.output.sink;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.output.sink.SinkExecutor;
import com.typesafe.config.Config;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Base trait for sinks.\n  *\n  * A sink defines a way to output a table generated by Raphtory from a graph.\n  * In order to do this, concrete implementations need to override the `executor` method creating their own `SinkExecutor`.\n  * This is the class holding the actual code required to connect and output to the sink.\n  *\n  * @see [[com.raphtory.sinks.FileSink FileSink]], [[PulsarSink PulsarSink]],\n  *      [[com.raphtory.api.analysis.table.Table Table]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u001d3qAA\u0002\u0011\u0002G\u0005a\u0002C\u0003\u0016\u0001\u0019\u0005aC\u0001\u0003TS:\\'B\u0001\u0003\u0006\u0003\u0011\u0019\u0018N\\6\u000b\u0005\u00199\u0011AB8viB,HO\u0003\u0002\t\u0013\u0005\u0019\u0011\r]5\u000b\u0005)Y\u0011\u0001\u0003:ba\"$xN]=\u000b\u00031\t1aY8n\u0007\u0001\u0019\"\u0001A\b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g\u0003!)\u00070Z2vi>\u0014H\u0003B\f\u001cQ5\u0002\"\u0001G\r\u000e\u0003\rI!AG\u0002\u0003\u0019MKgn[#yK\u000e,Ho\u001c:\t\u000bq\t\u0001\u0019A\u000f\u0002\u000b)|'-\u0013#\u0011\u0005y)cBA\u0010$!\t\u0001\u0013#D\u0001\"\u0015\t\u0011S\"\u0001\u0004=e>|GOP\u0005\u0003IE\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0014(\u0005\u0019\u0019FO]5oO*\u0011A%\u0005\u0005\u0006S\u0005\u0001\rAK\u0001\fa\u0006\u0014H/\u001b;j_:LE\t\u0005\u0002\u0011W%\u0011A&\u0005\u0002\u0004\u0013:$\b\"\u0002\u0018\u0002\u0001\u0004y\u0013AB2p]\u001aLw\r\u0005\u00021i5\t\u0011G\u0003\u0002/e)\u00111gC\u0001\tif\u0004Xm]1gK&\u0011Q'\r\u0002\u0007\u0007>tg-[4)\t\u00059\u0014I\u0011\t\u0003q}j\u0011!\u000f\u0006\u0003um\n\u0001b]2bY\u0006$wn\u0019\u0006\u0003yu\nq\u0001^1lKj|WM\u0003\u0002?\u0017\u00051q-\u001b;ik\nL!\u0001Q\u001d\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f\u0013aQ\u0001\u0003\u0002>R#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E[8c\u0013\u0012\u0003C\u000f[3!\u0013\u0012\u0003sN\u001a\u0011uQ\u0016\u0004#n\u001c2!i\"\fG\u000fI4f]\u0016\u0014\u0018\r^3eAQDW\r\t;bE2,'\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004\u0003/\u0019:uSRLwN\\%EAQDW\rI%EA=4\u0007\u0005\u001e5fAA\f'\u000f^5uS>t\u0007e\u001c4!i\",\u0007\u0005^1cY\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u001awN\u001c4jO\u0002\"\b.\u001a\u0011d_:4\u0017nZ;sCRLwN\u001c\u0011qe>4\u0018\u000eZ3eA\tL\b\u0005\u001e5fAU\u001cXM\u001d\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t;pa&\u001c7\u000f\t;iK\u0002\"x\u000e]5dAI,\u0007o\\:ji>\u0014\u0018\u0010I8gAQDW\r\t3fa2|\u00170\\3oi*\u0001\u0003\u0005\t\u0011+A\u0001\u0013X\r^;s]\u0002\"\b.\u001a\u0011a'&t7.\u0012=fGV$xN\u001d1!i>\u0004#-\u001a\u0011vg\u0016$\u0007EZ8sA]\u0014\u0018\u000e^5oO\u0002zW\u000f\u001e\u0011sKN,H\u000e^:\u000bA\u0001\u0002\u0003EK\u0018)\t\u00019\u0014)R\u0011\u0002\r\u0006\u0019)k\f\u0016+A\t\u000b7/\u001a\u0011ue\u0006LG\u000f\t4pe\u0002\u001a\u0018N\\6t])\u0001\u0003E\u000b\u0006!A)\u0002\u0013\tI:j].\u0004C-\u001a4j]\u0016\u001c\b%\u0019\u0011xCf\u0004Co\u001c\u0011pkR\u0004X\u000f\u001e\u0011bAQ\f'\r\\3!O\u0016tWM]1uK\u0012\u0004#-\u001f\u0011SCBDGo\u001c:zA\u0019\u0014x.\u001c\u0011bA\u001d\u0014\u0018\r\u001d5/\u0015\u0001\u0002#\u0006I%oA=\u0014H-\u001a:!i>\u0004Cm\u001c\u0011uQ&\u001cH\u0006I2p]\u000e\u0014X\r^3!S6\u0004H.Z7f]R\fG/[8og\u0002rW-\u001a3!i>\u0004sN^3se&$W\r\t;iK\u0002\u0002W\r_3dkR|'\u000f\u0019\u0011nKRDw\u000e\u001a\u0011de\u0016\fG/\u001b8hAQDW-\u001b:!_^t\u0007\u0005Y*j].,\u00050Z2vi>\u0014\bM\f\u0006!A)\u0002C\u000b[5tA%\u001c\b\u0005\u001e5fA\rd\u0017m]:!Q>dG-\u001b8hAQDW\rI1diV\fG\u000eI2pI\u0016\u0004#/Z9vSJ,G\r\t;pA\r|gN\\3di\u0002\ng\u000e\u001a\u0011pkR\u0004X\u000f\u001e\u0011u_\u0002\"\b.\u001a\u0011tS:\\gF\u0003\u0011!U)\u0001\u0003E\u000b\u0011Ag\u0016,\u0007eW.d_6t#/\u00199ii>\u0014\u0018PL:j].\u001chFR5mKNKgn\u001b\u0011GS2,7+\u001b8l;vc\u0003eW.Qk2\u001c\u0018M]*j].\u0004\u0003+\u001e7tCJ\u001c\u0016N\\6^;2R\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005I.\\G>lgF]1qQR|'/\u001f\u0018ba&t\u0013M\\1msNL7O\f;bE2,g\u0006V1cY\u0016\u0004C+\u00192mKvk&\u0002\t\u0011+_\u0001")
public interface Sink {
    @Scaladoc(value="/**\n    * @param jobID the ID of the job that generated the table\n    * @param partitionID the ID of the partition of the table\n    * @param config the configuration provided by the user\n    * @param topics the topic repository of the deployment\n    * @return the `SinkExecutor` to be used for writing out results\n    */")
    public SinkExecutor executor(String var1, int var2, Config var3);
}

