/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.input;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph$;
import com.raphtory.api.input.MaybeType;
import com.raphtory.api.input.NoType$;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Property;
import com.raphtory.api.input.Type;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.internals.management.telemetry.TelemetryReporter$;
import com.raphtory.internals.time.DateTimeParser$;
import io.prometheus.client.Counter;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@Scaladoc(value="/** trait for creating a Graph by adding and deleting vertices and edges.\n  *\n  * An implementation of `GraphBuilder` needs to override `parseTuple(tuple: T)` to define parsing of input data.\n  * The input data is generated using a [[com.raphtory.api.input.Spout Spout]] and passed to the\n  * `parseTuple` method which is responsible for turning the raw data into a list of graph updates. Inside the\n  * `parseTuple` implementation, use methods `addVertex` and `addEdge`\n  * for adding vertices and edges. The resulting graph updates are send to the partitions responsible for\n  * handling the vertices and edges.\n  *\n  * @example\n  * {{{\n  * class TwitterGraphBuilder() extends GraphBuilder[String] {\n  *   override def parseTuple(fileLine: String): Unit = {\n  *     val sourceNode = fileLine(0)\n  *     val srcID      = sourceNode.toLong\n  *     val targetNode = fileLine(1)\n  *     val tarID      = targetNode.toLong\n  *     val timeStamp  = fileLine(2).toLong\n  *\n  *     addVertex(timeStamp, srcID, Properties(ImmutableProperty(\"name\", sourceNode)), Type(\"User\"))\n  *     addVertex(timeStamp, tarID, Properties(ImmutableProperty(\"name\", targetNode)), Type(\"User\"))\n  *     addEdge(timeStamp, srcID, tarID, Type(\"Follows\"))\n  *   }\n  * }\n  * }}}\n  * @see [[Properties]] [[Spout]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005=gaB\u000e\u001d!\u0003\r\t!\n\u0005\u0006Y\u0001!\t!\f\u0005\u0006c\u00011\tA\r\u0005\u0006m\u00011\tb\u000e\u0005\u0006!\u00021\tB\r\u0005\u0006#\u00021\tA\u0015\u0005\u0006-\u00021\ta\u0016\u0005\u0006A\u0002!I!\u0019\u0005\u0006]\u0002!I!\u0019\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0007_\u0002!\t!a\u0005\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011q\u0007\u0001\u0005\u0002\u0005E\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\t\u0003_\u0002A\u0011\u0001\u0011\u0002r!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0004\"CAE\u0001E\u0005I\u0011AAF\u0011%\t\t\u000bAI\u0001\n\u0003\t\u0019\u000bC\u0005\u0002(\u0002\t\n\u0011\"\u0001\u0002*\"I\u0011Q\u0016\u0001\u0012\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003_\u0003\u0011\u0013!C\u0001\u0003GC\u0011\"!-\u0001#\u0003%\t!!+\t\u0013\u0005M\u0006!%A\u0005\u0002\u0005UvaBA`9!\u0005\u0011\u0011\u0019\u0004\u00077qA\t!a1\t\u000f\u0005\u0015\u0007\u0004\"\u0001\u0002H\"9\u0011\u0011\r\r\u0005\u0002\u0005%'!B$sCBD'BA\u000f\u001f\u0003\u0015Ig\u000e];u\u0015\ty\u0002%A\u0002ba&T!!\t\u0012\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011aI\u0001\u0004G>l7\u0001A\n\u0003\u0001\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u0001/!\t9s&\u0003\u00021Q\t!QK\\5u\u0003=!x\u000e^1m!\u0006\u0014H/\u001b;j_:\u001cX#A\u001a\u0011\u0005\u001d\"\u0014BA\u001b)\u0005\rIe\u000e^\u0001\u0012Q\u0006tG\r\\3He\u0006\u0004\b.\u00169eCR,GC\u0001\u00189\u0011\u0015I4\u00011\u0001;\u0003\u0019)\b\u000fZ1uKB\u00111(\u0014\b\u0003y)s!!P$\u000f\u0005y*eBA E\u001d\t\u00015)D\u0001B\u0015\t\u0011E%\u0001\u0004=e>|GOP\u0005\u0002G%\u0011\u0011EI\u0005\u0003\r\u0002\n\u0011\"\u001b8uKJt\u0017\r\\:\n\u0005!K\u0015!B4sCBD'B\u0001$!\u0013\tYE*A\bHe\u0006\u0004\b.\u00117uKJ\fG/[8o\u0015\tA\u0015*\u0003\u0002O\u001f\nYqI]1qQV\u0003H-\u0019;f\u0015\tYE*\u0001\u0005t_V\u00148-Z%E\u0003\u0015Ig\u000eZ3y+\u0005\u0019\u0006CA\u0014U\u0013\t)\u0006F\u0001\u0003M_:<\u0017aB4sCBD\u0017\nR\u000b\u00021B\u0011\u0011,\u0018\b\u00035n\u0003\"\u0001\u0011\u0015\n\u0005qC\u0013A\u0002)sK\u0012,g-\u0003\u0002_?\n11\u000b\u001e:j]\u001eT!\u0001\u0018\u0015\u0002!Y,'\u000f^3y\u0003\u0012$7i\\;oi\u0016\u0014X#\u00012\u0011\u0005\rdW\"\u00013\u000b\u0005\u00154\u0017aB\"pk:$XM\u001d\u0006\u0003O\"\faa\u00197jK:$(BA5k\u0003)\u0001(o\\7fi\",Wo\u001d\u0006\u0002W\u0006\u0011\u0011n\\\u0005\u0003[\u0012\u0014Qa\u00115jY\u0012\fa\"\u001a3hK\u0006#GmQ8v]R,'/A\u0005bI\u00124VM\u001d;fqR!a&]:v\u0011\u0015\u0011\u0018\u00021\u0001T\u0003))\b\u000fZ1uKRKW.\u001a\u0005\u0006i&\u0001\raU\u0001\u0006gJ\u001c\u0017\n\u001a\u0005\u0006m&\u0001\ra^\u0001\u000ba>\u001cH+\u001f9f\u0003J<\u0007C\u0001=z\u001b\u0005a\u0012B\u0001>\u001d\u0005\u0011!\u0016\u0010]3)\r%a\u0018QBA\b!\ri\u0018\u0011B\u0007\u0002}*\u0019q0!\u0001\u0002\u0011M\u001c\u0017\r\\1e_\u000eTA!a\u0001\u0002\u0006\u00059A/Y6fu>,'bAA\u0004E\u00051q-\u001b;ik\nL1!a\u0003\u007f\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017EAA\t\u0003\u0005\u001dxF\u000b\u0016!\u0003\u0012$7\u000fI1!]\u0016<\bE^3si\u0016D\b\u0005^8!i\",\u0007e\u001a:ba\"\u0004sN\u001d\u0011va\u0012\fG/Z:!C:\u0004S\r_5ti&tw\r\t<feR,\u0007P\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004S\u000f\u001d3bi\u0016$\u0016.\\3!i&lWm\u001d;b[B\u0004cm\u001c:!m\u0016\u0014H/\u001a=!kB$\u0017\r^3\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011te\u000eLE\r\t\u0011!A\u0001\u0002\u0013\n\u0012\u0011pM\u00022XM\u001d;fq\u0002\"x\u000eI1eI>*\b\u000fZ1uK*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAA|7\u000fV=qK\u0006\u0013x\rI:qK\u000eLg-\u001f\u0011bAm[F+\u001f9fAQK\b/Z/^A\u0019|'\u000f\t;iK\u00022XM\u001d;fq*\u0001\u0003\u0005\t\u0011+_QYa&!\u0006\u0002\u0018\u0005e\u00111EA\u0017\u0011\u0015\u0011(\u00021\u0001T\u0011\u0015!(\u00021\u0001T\u0011%\tYB\u0003I\u0001\u0002\u0004\ti\"\u0001\u0006qe>\u0004XM\u001d;jKN\u00042\u0001_A\u0010\u0013\r\t\t\u0003\b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"CA\u0013\u0015A\u0005\t\u0019AA\u0014\u0003)1XM\u001d;fqRK\b/\u001a\t\u0004q\u0006%\u0012bAA\u00169\tIQ*Y=cKRK\b/\u001a\u0005\t\u0003_Q\u0001\u0013!a\u0001'\u0006q1/Z2p]\u0012\f'/_%oI\u0016D\bF\u0002\u0006}\u0003\u001b\t\u0019$\t\u0002\u00026\u0005!Yi\f\u0016+A\u0005#Gm\u001d\u0011bA9,w\u000f\t<feR,\u0007\u0010\t;pAQDW\rI4sCBD\u0007e\u001c:!kB$\u0017\r^3tA\u0005t\u0007%\u001a=jgRLgn\u001a\u0011wKJ$X\r\u001f\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007%\u001e9eCR,G+[7fAQLW.Z:uC6\u0004\bEZ8sAY,'\u000f^3yAU\u0004H-\u0019;f\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!gJ\u001c\u0017\n\u001a\u0011!A\u0001\u0002\u0003%\u0013#!_\u001a\u0004c/\u001a:uKb\u0004Co\u001c\u0011bI\u0012|S\u000f\u001d3bi\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u0002(o\u001c9feRLWm\u001d\u0011PaRLwN\\1mYf\u00043\u000f]3dS\u001aL\bE^3si\u0016D\b\u0005\u001d:pa\u0016\u0014H/[3tA\u0019|'\u000f\t;iK\u0002*\b\u000fZ1uK\u0002B3/Z3!7n\u001bw.\u001c\u0018sCBDGo\u001c:z]\u0005\u0004\u0018NL5oaV$h\u0006\u0015:pa\u0016\u0014H/[3tAA\u0013x\u000e]3si&,7/X/!M>\u0014\b\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u0019<bS2\f'\r\\3!aJ|\u0007/\u001a:us\u0002\"\u0018\u0010]3tS)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAY,'\u000f^3y)f\u0004X\rI(qi&|g.\u00197ms\u0002\u001a\b/Z2jMf\u0004\u0013\rI.\\)f\u0004X\r\t+za\u0016lV\f\t4pe\u0002\"\b.\u001a\u0011wKJ$X\r\u001f\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI:fG>tG-\u0019:z\u0013:$W\r\u001f\u0011PaRLwN\\1mYf\u00043\u000f]3dS\u001aL\b%\u0019\u0011tK\u000e|g\u000eZ1ss\u0002Jg\u000eZ3yAQD\u0017\r\u001e\u0011jg\u0002*8/\u001a3!i>\u0004C-\u001a;fe6Lg.\u001a\u0011uQ\u0016\u0004sN\u001d3fe\u0002zg\rI;qI\u0006$Xm\u001d\u0011xSRD\u0007\u0005\u001e5fAM\fW.\u001a\u0011akB$\u0017\r^3US6,\u0007M\u0003\u0011!A\u0001Rs&A\u0004bI\u0012,EmZ3\u0015\u001b9\nY$!\u0010\u0002@\u0005\r\u0013QIA%\u0011\u0015\u00118\u00021\u0001T\u0011\u0015!8\u00021\u0001T\u0011\u0019\t\te\u0003a\u0001'\u0006)Am\u001d;JI\"I\u00111D\u0006\u0011\u0002\u0003\u0007\u0011Q\u0004\u0005\n\u0003\u000fZ\u0001\u0013!a\u0001\u0003O\t\u0001\"\u001a3hKRK\b/\u001a\u0005\t\u0003_Y\u0001\u0013!a\u0001'\"21\u0002`A\u0007\u0003\u001b\n#!a\u0014\u0002\t\u007f{#F\u000b\u0011BI\u0012\u001c\b%\u0019\u0011oK^\u0004S\rZ4fAQ|\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5!_J\u0004S\u000f\u001d3bi\u0016\u001c\b%\u00198!KbL7\u000f^5oO\u0002*GmZ3\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI;qI\u0006$X\rV5nK\u0002\"\u0018.\\3ti\u0006l\u0007\u000f\t4pe\u0002*GmZ3!kB$\u0017\r^3\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011te\u000eLE\r\t\u0011!A\u0001\u0002\u0013\n\u0012\u0011pM\u0002\u001ax.\u001e:dK\u00022XM\u001d;fq\u0002zg\r\t;iK\u0002*GmZ3\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011egRLE\r\t\u0011!A\u0001\u0002\u0013\n\u0012\u0011pM\u0002\"Wm\u001d;j]\u0006$\u0018n\u001c8!m\u0016\u0014H/\u001a=!_\u001a\u0004C\u000f[3!K\u0012<WM\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007\u0005\u001d:pa\u0016\u0014H/[3tA\u0015$w-\u001a\u0011qe>\u0004XM\u001d;jKN\u0004cm\u001c:!i\",\u0007%\u001e9eCR,\u0007\u0005K:fK\u0002Z6lY8n]I\f\u0007\u000f\u001b;peft\u0013\r]5/S:\u0004X\u000f\u001e\u0018Qe>\u0004XM\u001d;jKN\u0004\u0003K]8qKJ$\u0018.Z:^;\u00022wN\u001d\u0011uQ\u0016T\u0001\u0005\t\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011bm\u0006LG.\u00192mK\u0002\u0002(o\u001c9feRL\b\u0005^=qKNL#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004S\rZ4f)f\u0004X\r\t\u0011!gB,7-\u001b4zA\u0005\u00043l\u0017+za\u0016\u0004C+\u001f9f;v\u0003cm\u001c:!i\",\u0007%\u001a3hK*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAM,7m\u001c8eCJL\u0018J\u001c3fq\u0002z\u0005\u000f^5p]\u0006dG.\u001f\u0011ta\u0016\u001c\u0017NZ=!C\u0002\u001aXmY8oI\u0006\u0014\u0018\u0010I5oI\u0016D\b\u0005\u001e5bi\u0002J7\u000fI;tK\u0012\u0004Co\u001c\u0011eKR,'/\\5oK\u0002\"\b.\u001a\u0011pe\u0012,'\u000fI8gAU\u0004H-\u0019;fg\u0002:\u0018\u000e\u001e5!i\",\u0007e]1nK\u0002\u0002W\u000f\u001d3bi\u0016$\u0016.\\3a\u0015\u0001\u0002\u0003\u0005\t\u00160)%q\u00131KA+\u0003/\nI\u0006C\u0003s\u0019\u0001\u00071\u000bC\u0003u\u0019\u0001\u00071\u000b\u0003\u0004\u0002B1\u0001\ra\u0015\u0005\u0006m2\u0001\ra\u001e\u0015\u0007\u0019q\fi!!\u0018\"\u0005\u0005}\u0013Aa\u00180U)\u0002\u0013\t\u001a3tA\u0005\u0004c.Z<!K\u0012<W\r\t;pAQDW\rI4sCBD\u0007e\u001c:!kB$\u0017\r^3tA\u0005t\u0007%\u001a=jgRLgn\u001a\u0011fI\u001e,'\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002*\b\u000fZ1uKRKW.\u001a\u0011uS6,7\u000f^1na\u00022wN\u001d\u0011fI\u001e,\u0007%\u001e9eCR,'\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u00043O]2JI\u0002\u0002\u0003\u0005\t\u0011!\u0013\u0012\u0003sN\u001a\u0011t_V\u00148-\u001a\u0011wKJ$X\r\u001f\u0011pM\u0002\"\b.\u001a\u0011fI\u001e,'\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004Cm\u001d;JI\u0002\u0002\u0003\u0005\t\u0011!\u0013\u0012\u0003sN\u001a\u0011eKN$\u0018N\\1uS>t\u0007E^3si\u0016D\be\u001c4!i\",\u0007%\u001a3hK*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAA|7\u000fV=qK\u0006\u0013x\r\t\u0011!gB,7-\u001b4zA\u0005\u00043l\u0017+za\u0016\u0004C+\u001f9f;v\u0003cm\u001c:!i\",\u0007%\u001a3hK*\u0001\u0003\u0005\t\u0011+_\u0005A\u0011m]:jO:LE\tF\u0002T\u0003KBa!a\u001a\u000e\u0001\u0004A\u0016aC;oSF,Xm\u00115beNDc!\u0004?\u0002\u000e\u0005-\u0014EAA7\u0003\tmsF\u000b\u0016!\u0007>tg/\u001a8jK:\u001cW\rI7fi\"|G\r\t4pe\u0002:WM\\3sCRLgn\u001a\u0011v]&\fX/\u001a\u0011J\tN\u0004#-Y:fI\u0002zg\u000e\t<feR,\u0007\u0010\t8b[\u0016\u001c(\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001*6/\u001a\u0011pM\u0002\"\b.[:![\u0016$\bn\u001c3!SN\u0004s\u000e\u001d;j_:\fGN\f\u0011BA\u0001<%/\u00199i\u0005VLG\u000eZ3sA\u0002J7\u000f\t4sK\u0016\u0004Co\u001c\u0011bgNLwM\u001c\u0011wKJ$X\r\u001f\u0011J\tN\u0004\u0013N\u001c\u0011eS\u001a4WM]3oi\u0002:\u0018-_:-AA\u0014xN^5eK\u0012T\u0001\u0005\t\u0011!U\u0001\"\b.\u0019;!K\u0006\u001c\u0007\u000e\t<feR,\u0007\u0010I5tA\u0005\u001c8/[4oK\u0012\u0004\u0013\rI;oSF,X\rI%EA=4\u0007\u0005^=qK\u0002\u0002Gj\u001c8hA:R\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nAUt\u0017.];f\u0007\"\f'o\u001d\u0011WKJ$X\r\u001f\u0011oC6,'\u0002\t\u0011!A)z\u0013!E4fiB\u000b'\u000f^5uS>tgi\u001c:JIR\u00191'a\u001d\t\r\u0005Ud\u00021\u0001T\u0003\tIG-A\u0007qCJ\u001cX\rR1uKRLW.\u001a\u000b\u0006'\u0006m\u0014q\u0010\u0005\u0007\u0003{z\u0001\u0019\u0001-\u0002\u0011\u0011\fG/\u001a+j[\u0016D\u0001\"!!\u0010!\u0003\u0005\r\u0001W\u0001\u0007M>\u0014X.\u0019;)\r=a\u0018QBACC\t\t9)ABf_)R\u0003eQ8om\u0016t\u0017.\u001a8dK\u0002jW\r\u001e5pI\u00022wN\u001d\u0011d_:4XM\u001d;j]\u001e\u0004C-\u0019;fg\u0002Jg\u000e^8!KB|7\r[:!i>\u0004#-\u001a\u0011vg\u0016$\u0007%\u001b8uKJt\u0017\r\u001c7zA\tL\bEU1qQR|'/\u001f\u0018!)\"L7\u000fI5tAQDW\rI:b[\u0016\u0004c-\u001e8di&|gN\u0003\u0011!A\u0001R\u0003%^:fI\u0002\u0012\u0017\u0010\t;iK\u0002\u0002\u0017\r\u001a3!m\u0016\u0014H/\u001a=aA\u0005tG\r\t1bI\u0012\u0004S\rZ4fA\u00022WO\\2uS>t7\u000f\f\u0011t_\u0002\u001a\u0017M\u001c\u0011cK\u0002\u001a\u0017\r\u001c7fI\u0002*\u0007\u0010\u001d7jG&$H.\u001f\u0011j]\u0002\n\u0007e\u001a:ba\"\u0004#-^5mI\u0016\u0014(\u0002\t\u0011!A)\u0002Co\u001c\u0011sK\u0012,8-\u001a\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011d_:4XM]:j_:\u001c\be\u001e5f]\u0002\u0002XM\u001d4pe6Lgn\u001a\u0011nk2$\u0018\u000e\u001d7fAU\u0004H-\u0019;fg\u0002\u0002XM\u001d\u0011ukBdWM\f\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007\u0005Z1uKRKW.\u001a\u0011UQ\u0016\u0004C-\u0019;fAM$(/\u001b8hAe|W\u000fI<jg\"\u0004Co\u001c\u0011d_:4XM\u001d;\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011g_Jl\u0017\r\u001e\u0011UQ\u0016\u0004cm\u001c:nCR\u0004sN\u001a\u0011uQ\u0016\u0004C-\u0019;fAM$(/\u001b8h]\u0001\"\u0006.\u001a\u0011eK\u001a\fW\u000f\u001c;!E\u0016Lgn\u001a\u0011#sfL\u00180L'N[\u0011$7\f\t%Iu5l'h]:\\]M\u001b6+X//E)\u0001\u0003\u0005\t\u0011+A9R\u0001\u0005\t\u0011!U=\n1#\u00193e-\u0016\u0014H/\u001a=%I\u00164\u0017-\u001e7uIM*\"!!$+\t\u0005u\u0011qR\u0016\u0003\u0003#\u0003B!a%\u0002\u001e6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0014\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002 \u0006U%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0019\u0012\r\u001a3WKJ$X\r\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u0015\u0016\u0005\u0003O\ty)A\nbI\u00124VM\u001d;fq\u0012\"WMZ1vYR$S'\u0006\u0002\u0002,*\u001a1+a$\u0002#\u0005$G-\u00123hK\u0012\"WMZ1vYR$C'A\tbI\u0012,EmZ3%I\u00164\u0017-\u001e7uIU\n\u0011#\u00193e\u000b\u0012<W\r\n3fM\u0006,H\u000e\u001e\u00137\u0003]\u0001\u0018M]:f\t\u0006$X\r^5nK\u0012\"WMZ1vYR$#'\u0006\u0002\u00028*\u001a\u0001,a$)\r\u0001a\u0018QBA^C\t\ti,\u0001F\t_)R\u0003\u0005\u001e:bSR\u0004cm\u001c:!GJ,\u0017\r^5oO\u0002\n\u0007e\u0012:ba\"\u0004#-\u001f\u0011bI\u0012Lgn\u001a\u0011b]\u0012\u0004C-\u001a7fi&tw\r\t<feRL7-Z:!C:$\u0007%\u001a3hKNt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I!oA%l\u0007\u000f\\3nK:$\u0018\r^5p]\u0002zg\r\t1He\u0006\u0004\bNQ;jY\u0012,'\u000f\u0019\u0011oK\u0016$7\u000f\t;pA=4XM\u001d:jI\u0016\u0004\u0003\r]1sg\u0016$V\u000f\u001d7fQQ,\b\u000f\\3;AQK\u0003\r\t;pA\u0011,g-\u001b8fAA\f'o]5oO\u0002zg\rI5oaV$\b\u0005Z1uC:R\u0001\u0005\t\u0016!)\",\u0007%\u001b8qkR\u0004C-\u0019;bA%\u001c\beZ3oKJ\fG/\u001a3!kNLgn\u001a\u0011bAm[6m\\7/e\u0006\u0004\b\u000e^8ss:\n\u0007/\u001b\u0018j]B,HOL*q_V$\be\u00159pkRlV\fI1oI\u0002\u0002\u0018m]:fI\u0002\"x\u000e\t;iK*\u0001\u0003E\u000b\u0011aa\u0006\u00148/\u001a+va2,\u0007\rI7fi\"|G\rI<iS\u000eD\u0007%[:!e\u0016\u001c\bo\u001c8tS\ndW\r\t4pe\u0002\"XO\u001d8j]\u001e\u0004C\u000f[3!e\u0006<\b\u0005Z1uC\u0002Jg\u000e^8!C\u0002b\u0017n\u001d;!_\u001a\u0004sM]1qQ\u0002*\b\u000fZ1uKNt\u0003%\u00138tS\u0012,\u0007\u0005\u001e5f\u0015\u0001\u0002#\u0006\t1qCJ\u001cX\rV;qY\u0016\u0004\u0007%[7qY\u0016lWM\u001c;bi&|g\u000e\f\u0011vg\u0016\u0004S.\u001a;i_\u0012\u001c\b\u0005Y1eIZ+'\u000f^3yA\u0002\ng\u000e\u001a\u0011aC\u0012$W\tZ4fA*\u0001\u0003E\u000b\u0011g_J\u0004\u0013\r\u001a3j]\u001e\u0004c/\u001a:uS\u000e,7\u000fI1oI\u0002*GmZ3t]\u0001\"\u0006.\u001a\u0011sKN,H\u000e^5oO\u0002:'/\u00199iAU\u0004H-\u0019;fg\u0002\n'/\u001a\u0011tK:$\u0007\u0005^8!i\",\u0007\u0005]1si&$\u0018n\u001c8tAI,7\u000f]8og&\u0014G.\u001a\u0011g_JT\u0001\u0005\t\u0016!Q\u0006tG\r\\5oO\u0002\"\b.\u001a\u0011wKJ$\u0018nY3tA\u0005tG\rI3eO\u0016\u001chF\u0003\u0011!U)\u0001\u0003E\u000b\u0011AKb\fW\u000e\u001d7f\u0015\u0001\u0002#\u0006I>|w*\u0001\u0003E\u000b\u0011dY\u0006\u001c8\u000f\t+xSR$XM]$sCBD')^5mI\u0016\u0014\b&\u000b\u0011fqR,g\u000eZ:!\u000fJ\f\u0007\u000f\u001b\"vS2$WM].TiJLgnZ/!w*\u0001\u0003E\u000b\u0011!A=4XM\u001d:jI\u0016\u0004C-\u001a4!a\u0006\u00148/\u001a+va2,\u0007FZ5mK2Kg.\u001a\u001e!'R\u0014\u0018N\\4*u\u0001*f.\u001b;!{\u0001Z(\u0002\t\u0011+A\u0001\u0002\u0003\u0005\t<bY\u0002\u001ax.\u001e:dK:{G-\u001a\u0011>A\u0019LG.\u001a'j]\u0016D\u0003'\u000b\u0006!A)\u0002\u0003\u0005\t\u0011!m\u0006d\u0007e\u001d:d\u0013\u0012\u0003\u0003\u0005\t\u0011!Au\u00023o\\;sG\u0016tu\u000eZ3/i>duN\\4\u000bA\u0001R\u0003\u0005\t\u0011!AY\fG\u000e\t;be\u001e,GOT8eK\u0002j\u0004EZ5mK2Kg.\u001a\u00152S)\u0001\u0003E\u000b\u0011!A\u0001\u0002c/\u00197!i\u0006\u0014\u0018\n\u0012\u0011!A\u0001\u0002\u0003%\u0010\u0011uCJ<W\r\u001e(pI\u0016tCo\u001c'p]\u001eT\u0001\u0005\t\u0016!A\u0001\u0002\u0003E^1mAQLW.Z*uC6\u0004\b\u0005I\u001f!M&dW\rT5oK\"\u0012\u0014F\f;p\u0019>twM\u0003\u0011!U)\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0013\r\u001a3WKJ$X\r\u001f\u0015uS6,7\u000b^1na2\u00023O]2J\t2\u0002\u0003K]8qKJ$\u0018.Z:)\u00136lW\u000f^1cY\u0016\u0004&o\u001c9feRL\bF\t8b[\u0016\u0014C\u0006I:pkJ\u001cWMT8eK&JC\u0006\t+za\u0016D#%V:fe\nJ\u0013F\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011bI\u00124VM\u001d;fq\"\"\u0018.\\3Ti\u0006l\u0007\u000f\f\u0011uCJLE\t\f\u0011Qe>\u0004XM\u001d;jKND\u0013*\\7vi\u0006\u0014G.\u001a)s_B,'\u000f^=)E9\fW.\u001a\u0012-AQ\f'oZ3u\u001d>$W-K\u0015-AQK\b/\u001a\u0015#+N,'OI\u0015*\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\nG\rZ#eO\u0016DC/[7f'R\fW\u000e\u001d\u0017!gJ\u001c\u0017\n\u0012\u0017!i\u0006\u0014\u0018\n\u0012\u0017!)f\u0004X\r\u000b\u0012G_2dwn^:#S%R\u0001\u0005\t\u0016!A\u0001j(\u0002\t\u0011+AuT\u0001\u0005\t\u0016!{vl(\u0002\t\u0011+A\u0001\u001bX-\u001a\u0011\\7B\u0013x\u000e]3si&,7/X/!7n\u001b\u0006o\\;u;vS\u0001\u0005\t\u00160\u0003\u00159%/\u00199i!\tA\bd\u0005\u0002\u0019M\u00051A(\u001b8jiz\"\"!!1\u0015\u0007M\u000bY\r\u0003\u0004\u0002hi\u0001\r\u0001\u0017\u0015\u00075q\fi!a\u001b")
public interface Graph {
    public int totalPartitions();

    public void handleGraphUpdate(GraphAlteration.GraphUpdate var1);

    public int sourceID();

    public long index();

    public String graphID();

    private Counter.Child vertexAddCounter() {
        return (Counter.Child)TelemetryReporter$.MODULE$.vertexAddCounter().labels(new String[]{String.valueOf(BoxesRunTime.boxToInteger((int)this.sourceID())), this.graphID()});
    }

    private Counter.Child edgeAddCounter() {
        return (Counter.Child)TelemetryReporter$.MODULE$.edgeAddCounter().labels(new String[]{String.valueOf(BoxesRunTime.boxToInteger((int)this.sourceID())), this.graphID()});
    }

    public static /* synthetic */ void addVertex$(Graph $this, long updateTime, long srcId, Type posTypeArg) {
        $this.addVertex(updateTime, srcId, posTypeArg);
    }

    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param posTypeArg specify a [[Type Type]] for the vertex\n    */")
    default public void addVertex(long updateTime, long srcId, Type posTypeArg) {
        long x$1 = updateTime;
        long x$2 = srcId;
        Type x$3 = posTypeArg;
        Properties x$4 = this.addVertex$default$3();
        long x$5 = this.addVertex$default$5();
        this.addVertex(x$1, x$2, x$4, x$3, x$5);
    }

    public static /* synthetic */ void addVertex$(Graph $this, long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        $this.addVertex(updateTime, srcId, properties, vertexType, secondaryIndex);
    }

    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param properties Optionally specify vertex properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param vertexType Optionally specify a [[Type Type]] for the vertex\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    default public void addVertex(long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        GraphAlteration.VertexAdd update = new GraphAlteration.VertexAdd(this.sourceID(), updateTime, secondaryIndex, srcId, properties, vertexType.toOption(), SchemaProviderInstances$.MODULE$.vertexAddSchemaProvider());
        this.handleGraphUpdate(update);
        this.vertexAddCounter().inc();
    }

    public static /* synthetic */ Properties addVertex$default$3$(Graph $this) {
        return $this.addVertex$default$3();
    }

    default public Properties addVertex$default$3() {
        return new Properties((Seq<Property>)Nil$.MODULE$);
    }

    public static /* synthetic */ MaybeType addVertex$default$4$(Graph $this) {
        return $this.addVertex$default$4();
    }

    default public MaybeType addVertex$default$4() {
        return NoType$.MODULE$;
    }

    public static /* synthetic */ long addVertex$default$5$(Graph $this) {
        return $this.addVertex$default$5();
    }

    default public long addVertex$default$5() {
        return this.index();
    }

    public static /* synthetic */ void addEdge$(Graph $this, long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        $this.addEdge(updateTime, srcId, dstId, properties, edgeType, secondaryIndex);
    }

    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param properties edge properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param edgeType   specify a [[Type Type]] for the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    default public void addEdge(long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        GraphAlteration.EdgeAdd update = new GraphAlteration.EdgeAdd(this.sourceID(), updateTime, secondaryIndex, srcId, dstId, properties, edgeType.toOption(), SchemaProviderInstances$.MODULE$.edgeAddSchemaProvider());
        this.handleGraphUpdate(update);
        this.edgeAddCounter().inc();
    }

    public static /* synthetic */ void addEdge$(Graph $this, long updateTime, long srcId, long dstId, Type posTypeArg) {
        $this.addEdge(updateTime, srcId, dstId, posTypeArg);
    }

    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param posTypeArg   specify a [[Type Type]] for the edge\n    */")
    default public void addEdge(long updateTime, long srcId, long dstId, Type posTypeArg) {
        long x$1 = updateTime;
        long x$2 = srcId;
        long x$3 = dstId;
        Type x$4 = posTypeArg;
        Properties x$5 = this.addEdge$default$4();
        long x$6 = this.addEdge$default$6();
        this.addEdge(x$1, x$2, x$3, x$5, x$4, x$6);
    }

    public static /* synthetic */ Properties addEdge$default$4$(Graph $this) {
        return $this.addEdge$default$4();
    }

    default public Properties addEdge$default$4() {
        return new Properties((Seq<Property>)Nil$.MODULE$);
    }

    public static /* synthetic */ MaybeType addEdge$default$5$(Graph $this) {
        return $this.addEdge$default$5();
    }

    default public MaybeType addEdge$default$5() {
        return NoType$.MODULE$;
    }

    public static /* synthetic */ long addEdge$default$6$(Graph $this) {
        return $this.addEdge$default$6();
    }

    default public long addEdge$default$6() {
        return this.index();
    }

    public static /* synthetic */ long assignID$(Graph $this, String uniqueChars) {
        return $this.assignID(uniqueChars);
    }

    @Scaladoc(value="/** Convenience method for generating unique IDs based on vertex names\n    *\n    * Use of this method is optional. A `GraphBuilder` is free to assign vertex IDs in different ways, provided\n    * that each vertex is assigned a unique ID of type `Long`.\n    *\n    * @param uniqueChars Vertex name\n    */")
    default public long assignID(String uniqueChars) {
        return Graph$.MODULE$.assignID(uniqueChars);
    }

    public static /* synthetic */ int getPartitionForId$(Graph $this, long id) {
        return $this.getPartitionForId(id);
    }

    default public int getPartitionForId(long id) {
        return (int)(RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(id)) % (long)this.totalPartitions());
    }

    public static /* synthetic */ long parseDatetime$(Graph $this, String dateTime, String format) {
        return $this.parseDatetime(dateTime, format);
    }

    @Scaladoc(value="/** Convenience method for converting dates into epochs to be used internally by Raphtory. This is the same function\n    * used by the `add vertex` and `add edge` functions, so can be called explicitly in a graph builder\n    * to reduce the number of conversions when performing multiple updates per tuple.\n    *\n    * @param dateTime The date string you wish to convert\n    * @param format The format of the date string. The default being \"yyyy-MM-dd[ HH:mm:ss[.SSS]].\"\n    * .\n    */")
    default public long parseDatetime(String dateTime, String format) {
        return DateTimeParser$.MODULE$.apply(format).parse(dateTime);
    }

    public static /* synthetic */ String parseDatetime$default$2$(Graph $this) {
        return $this.parseDatetime$default$2();
    }

    default public String parseDatetime$default$2() {
        return "yyyy-MM-dd[ HH:mm:ss[.SSS]]";
    }

    public static void $init$(Graph $this) {
    }
}

