/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.table;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.TableBase;
import com.raphtory.api.analysis.table.TableOutput$;
import com.raphtory.api.output.sink.Sink;
import com.raphtory.api.output.sink.SinkExecutor;
import com.raphtory.api.progresstracker.ProgressTracker;
import com.raphtory.api.progresstracker.WriteProgressTracker;
import com.raphtory.api.time.Perspective;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** Concrete Table with computed results for a perspective */")
@ScalaSignature(bytes="\u0006\u0005\t%c\u0001\u0002\u0013&\u0001BB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t)\u0002\u0011\t\u0012)A\u0005\u0019\"AQ\u000b\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003X\u0011!q\u0006A!f\u0001\n\u0003y\u0006\u0002\u00034\u0001\u0005#\u0005\u000b\u0011\u00021\t\u0011\u001d\u0004!Q1A\u0005\n!D\u0001\"\u001d\u0001\u0003\u0012\u0003\u0006I!\u001b\u0005\u0006e\u0002!Ia\u001d\u0005\u0006s\u0002!\tE\u001f\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\t9\u0004\u0001C!\u0003sAq!a\u000e\u0001\t\u0003\n\u0019\u0007C\u0004\u0002n\u0001!\t%a\u001c\t\u0013\u0005E\u0004!!A\u0005\u0002\u0005M\u0004\"CA?\u0001E\u0005I\u0011AA@\u0011%\t)\nAI\u0001\n\u0003\t9\nC\u0005\u0002\u001c\u0002\t\n\u0011\"\u0001\u0002\u001e\"I\u0011\u0011\u0015\u0001\u0012\u0002\u0013\u0005\u00111\u0015\u0005\t\u0003O\u00031\u0012!C\u0001Q\"I\u0011\u0011\u0016\u0001\u0002\u0002\u0013\u0005\u00131\u0016\u0005\n\u0003w\u0003\u0011\u0011!C\u0001\u0003{C\u0011\"!2\u0001\u0003\u0003%\t!a2\t\u0013\u0005M\u0007!!A\u0005B\u0005U\u0007\"CAr\u0001\u0005\u0005I\u0011AAs\u0011%\tI\u000fAA\u0001\n\u0003\nY\u000fC\u0005\u0002p\u0002\t\t\u0011\"\u0011\u0002r\"I\u00111\u001f\u0001\u0002\u0002\u0013\u0005\u0013Q_\u0004\n\u0003\u007f,\u0013\u0011!E\u0001\u0005\u00031\u0001\u0002J\u0013\u0002\u0002#\u0005!1\u0001\u0005\u0007ez!\tAa\u0007\t\u0013\u00055d$!A\u0005F\tu\u0001\"\u0003B\u0010=\u0005\u0005I\u0011\u0011B\u0011\u0011%\u0011YCHA\u0001\n\u0003\u0013i\u0003C\u0005\u0003@y\t\t\u0011\"\u0003\u0003B\tYA+\u00192mK>+H\u000f];u\u0015\t1s%A\u0003uC\ndWM\u0003\u0002)S\u0005A\u0011M\\1msNL7O\u0003\u0002+W\u0005\u0019\u0011\r]5\u000b\u00051j\u0013\u0001\u0003:ba\"$xN]=\u000b\u00039\n1aY8n\u0007\u0001\u0019R\u0001A\u00198wy\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0007C\u0001\u001d:\u001b\u0005)\u0013B\u0001\u001e&\u0005%!\u0016M\u00197f\u0005\u0006\u001cX\r\u0005\u00023y%\u0011Qh\r\u0002\b!J|G-^2u!\tytI\u0004\u0002A\u000b:\u0011\u0011\tR\u0007\u0002\u0005*\u00111iL\u0001\u0007yI|w\u000e\u001e \n\u0003QJ!AR\u001a\u0002\u000fA\f7m[1hK&\u0011\u0001*\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\rN\nQA[8c\u0013\u0012+\u0012\u0001\u0014\t\u0003\u001bFs!AT(\u0011\u0005\u0005\u001b\u0014B\u0001)4\u0003\u0019\u0001&/\u001a3fM&\u0011!k\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A\u001b\u0014A\u00026pE&#\u0005%A\u0006qKJ\u001c\b/Z2uSZ,W#A,\u0011\u0005a[V\"A-\u000b\u0005iK\u0013\u0001\u0002;j[\u0016L!\u0001X-\u0003\u0017A+'o\u001d9fGRLg/Z\u0001\ra\u0016\u00148\u000f]3di&4X\rI\u0001\u0005e><8/F\u0001a!\r\u0011\u0014mY\u0005\u0003EN\u0012Q!\u0011:sCf\u0004\"\u0001\u000f3\n\u0005\u0015,#a\u0001*po\u0006)!o\\<tA\u0005!1m\u001c8g+\u0005I\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003\u0019\u0019wN\u001c4jO*\u0011a.L\u0001\tif\u0004Xm]1gK&\u0011\u0001o\u001b\u0002\u0007\u0007>tg-[4\u0002\u000b\r|gN\u001a\u0011\u0002\rqJg.\u001b;?)\u0015!XO^<y!\tA\u0004\u0001C\u0003K\u0013\u0001\u0007A\nC\u0003V\u0013\u0001\u0007q\u000bC\u0003_\u0013\u0001\u0007\u0001\rC\u0003h\u0013\u0001\u0007\u0011.\u0001\u0004gS2$XM\u001d\u000b\u0003inDQ\u0001 \u0006A\u0002u\f\u0011A\u001a\t\u0006ey\u001c\u0017\u0011A\u0005\u0003\u007fN\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007I\n\u0019!C\u0002\u0002\u0006M\u0012qAQ8pY\u0016\fg\u000eK\u0004\u000b\u0003\u0013\ti\"a\b\u0011\t\u0005-\u0011\u0011D\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005A1oY1mC\u0012|7M\u0003\u0003\u0002\u0014\u0005U\u0011a\u0002;bW\u0016Tx.\u001a\u0006\u0004\u0003/i\u0013AB4ji\",(-\u0003\u0003\u0002\u001c\u00055!\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\u0005\u0005\u0012!a\f0U)\u0002\u0013\t\u001a3!C\u00022\u0017\u000e\u001c;fe\u0002z\u0007/\u001a:bi&|g\u000e\t;pAQ\f'\r\\3\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t4!MVt7\r^5p]\u0002\"\b.\u0019;!eVt7\u000fI8oG\u0016\u0004cm\u001c:!K\u0006\u001c\u0007\u000e\t:po\u0002BsN\u001c7zAI|wo\u001d\u0011g_J\u0004s\u000f[5dQ\u0002\u0002g\r\t1!e\u0016$XO\u001d8tA\u0001$(/^3aA\u0005\u0014X\rI6faRL#\u0002\t\u0011!A)z\u0013aB3ya2|G-\u001a\u000b\u0004i\u0006\u001d\u0002B\u0002?\f\u0001\u0004\tI\u0003E\u00033}\u000e\fY\u0003\u0005\u0003@\u0003[\u0019\u0017bAA\u0018\u0013\na\u0011\n^3sC\ndWm\u00148dK\":1\"!\u0003\u0002\u001e\u0005M\u0012EAA\u001b\u0003\u0005%xF\u000b\u0016!\u000bb\u0004Hn\u001c3fAQ\f'\r\\3!e><8O\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002C\u000b[5tA\r\u0014X-\u0019;fg\u0002\n\u0007E\\3xAQ\f'\r\\3!o\",'/\u001a\u0011fC\u000eD\u0007E]8xA%t\u0007\u0005\u001e5fA=dG\r\t;bE2,'\u0002\t\u0011!A)\u0002\u0013n\u001d\u0011nCB\u0004X\r\u001a\u0011u_\u0002jW\u000f\u001c;ja2,\u0007E]8xg\u0002Jg\u000e\t;iK\u0002rWm\u001e\u0011uC\ndWM\f\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005\u00119be\u0006l\u0007E\u001a\u0011gk:\u001cG/[8oAQD\u0017\r\u001e\u0011sk:\u001c\be\u001c8dK\u00022wN\u001d\u0011fC\u000eD\u0007E]8xA=4\u0007\u0005\u001e5fAQ\f'\r\\3!C:$\u0007%\\1qg\u0002JG\u000f\t;pA9,w\u000f\t:poNT\u0001\u0005\t\u0011!U=\nqa\u001e:ji\u0016$v\u000e\u0006\u0004\u0002<\u0005\u001d\u0013\u0011\f\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011I\u0015\u0002\u001fA\u0014xn\u001a:fgN$(/Y2lKJLA!!\u0012\u0002@\t!rK]5uKB\u0013xn\u001a:fgN$&/Y2lKJDq!!\u0013\r\u0001\u0004\tY%\u0001\u0003tS:\\\u0007\u0003BA'\u0003+j!!a\u0014\u000b\t\u0005%\u0013\u0011\u000b\u0006\u0004\u0003'J\u0013AB8viB,H/\u0003\u0003\u0002X\u0005=#\u0001B*j].Da!a\u0017\r\u0001\u0004a\u0015a\u00026pE:\u000bW.\u001a\u0015\b\u0019\u0005%\u0011QDA0C\t\t\t'\u0001B\u0011_)R\u0003e\u0016:ji\u0016\u0004s.\u001e;!I\u0006$\u0018\rI1oI*\u0001\u0003\u0005\t\u0011+AI,G/\u001e:oAm[6m\\7/e\u0006\u0004\b\u000e^8ss:\n\u0007/\u001b\u0018qe><'/Z:tiJ\f7m[3s]E+XM]=Qe><'/Z:t)J\f7m[3sAE+XM]=Qe><'/Z:t)J\f7m[3s;vS\u0001\u0005\t\u0011!U\u0001:\u0018\u000e\u001e5!GV\u001cHo\\7!U>\u0014\u0007E\\1nK*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!g&t7\u000e\t\u0011!Am[6m\\7/e\u0006\u0004\b\u000e^8ss:\n\u0007/\u001b\u0018pkR\u0004X\u000f\u001e\u0018tS:\\gfU5oW\u0002\u001a\u0016N\\6^;\u00022wN\u001d\u0011xe&$\u0018N\\4!e\u0016\u001cX\u000f\u001c;t\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!U>\u0014g*Y7fA9\u000bW.\u001a\u0011g_J\u0004#n\u001c2\u000bA\u0001\u0002\u0003EK\u0018\u0015\t\u0005m\u0012Q\r\u0005\b\u0003\u0013j\u0001\u0019AA&Q\u001di\u0011\u0011BA\u000f\u0003S\n#!a\u001b\u0002\u00033|#F\u000b\u0011Xe&$X\rI8vi\u0002\"\u0017\r^1!C:$'\u0002\t\u0011!A)\u0002#/\u001a;ve:\u00043lW2p[:\u0012\u0018\r\u001d5u_JLh&\u00199j]A\u0014xn\u001a:fgN$(/Y2lKJt\u0013+^3ssB\u0013xn\u001a:fgN$&/Y2lKJ\u0004\u0013+^3ssB\u0013xn\u001a:fgN$&/Y2lKJlVL\u0003\u0011!A\u0001R\u0003e^5uQ\u0002\"WMZ1vYR\u0004#n\u001c2!]\u0006lWM\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u00043/\u001b8lAm[6m\\7/e\u0006\u0004\b\u000e^8ss:\n\u0007/\u001b\u0018pkR\u0004X\u000f\u001e\u0018tS:\\gfU5oW\u0002\u001a\u0016N\\6^;\u00022wN\u001d\u0011xe&$\u0018N\\4!e\u0016\u001cX\u000f\u001c;t\u0015\u0001\u0002\u0003\u0005\t\u00160\u0003!!xn\u0015;sS:<G#\u0001'\u0002\t\r|\u0007/\u001f\u000b\ni\u0006U\u0014qOA=\u0003wBqAS\b\u0011\u0002\u0003\u0007A\nC\u0004V\u001fA\u0005\t\u0019A,\t\u000fy{\u0001\u0013!a\u0001A\"9qm\u0004I\u0001\u0002\u0004I\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0003S3\u0001TABW\t\t)\t\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\u0013Ut7\r[3dW\u0016$'bAAHg\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0015\u0011\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u00033S3aVAB\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a(+\u0007\u0001\f\u0019)\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u0015&fA5\u0002\u0004\u0006i1m\u001c8gI\u0005\u001c7-Z:tIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAW!\u0011\ty+!/\u000e\u0005\u0005E&\u0002BAZ\u0003k\u000bA\u0001\\1oO*\u0011\u0011qW\u0001\u0005U\u00064\u0018-C\u0002S\u0003c\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a0\u0011\u0007I\n\t-C\u0002\u0002DN\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!3\u0002PB\u0019!'a3\n\u0007\u000557GA\u0002B]fD\u0011\"!5\u0018\u0003\u0003\u0005\r!a0\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u000e\u0005\u0004\u0002Z\u0006}\u0017\u0011Z\u0007\u0003\u00037T1!!84\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\fYN\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0001\u0003OD\u0011\"!5\u001a\u0003\u0003\u0005\r!!3\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003[\u000bi\u000fC\u0005\u0002Rj\t\t\u00111\u0001\u0002@\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002@\u00061Q-];bYN$B!!\u0001\u0002x\"I\u0011\u0011\u001b\u000f\u0002\u0002\u0003\u0007\u0011\u0011\u001a\u0015\b\u0001\u0005%\u0011QDA~C\t\ti0A\u001f0U)\u00023i\u001c8de\u0016$X\r\t+bE2,\u0007e^5uQ\u0002\u001aw.\u001c9vi\u0016$\u0007E]3tk2$8\u000f\t4pe\u0002\n\u0007\u0005]3sgB,7\r^5wK\u0002Rs&A\u0006UC\ndWmT;uaV$\bC\u0001\u001d\u001f'\u0015q\"Q\u0001B\t!%\u00119A!\u0004M/\u0002LG/\u0004\u0002\u0003\n)\u0019!1B\u001a\u0002\u000fI,h\u000e^5nK&!!q\u0002B\u0005\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005'\u0011I\"\u0004\u0002\u0003\u0016)!!qCA[\u0003\tIw.C\u0002I\u0005+!\"A!\u0001\u0015\u0005\u00055\u0016!B1qa2LH#\u0003;\u0003$\t\u0015\"q\u0005B\u0015\u0011\u0015Q\u0015\u00051\u0001M\u0011\u0015)\u0016\u00051\u0001X\u0011\u0015q\u0016\u00051\u0001a\u0011\u00159\u0017\u00051\u0001j\u0003\u001d)h.\u00199qYf$BAa\f\u0003<A)!G!\r\u00036%\u0019!1G\u001a\u0003\r=\u0003H/[8o!\u001d\u0011$q\u0007'XA&L1A!\u000f4\u0005\u0019!V\u000f\u001d7fi!A!Q\b\u0012\u0002\u0002\u0003\u0007A/A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u0011\u0011\t\u0005=&QI\u0005\u0005\u0005\u000f\n\tL\u0001\u0004PE*,7\r\u001e")
public class TableOutput
implements TableBase,
Product,
Serializable {
    private final String jobID;
    private final Perspective perspective;
    private final Row[] rows;
    private final Config conf;

    public static Option<Tuple4<String, Perspective, Row[], Config>> unapply(TableOutput x$0) {
        return TableOutput$.MODULE$.unapply(x$0);
    }

    public static TableOutput apply(String jobID, Perspective perspective, Row[] rows, Config conf) {
        return TableOutput$.MODULE$.apply(jobID, perspective, rows, conf);
    }

    public static Function1<Tuple4<String, Perspective, Row[], Config>, TableOutput> tupled() {
        return TableOutput$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Perspective, Function1<Row[], Function1<Config, TableOutput>>>> curried() {
        return TableOutput$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    @Scaladoc(value="/** Write out data to files and\n    * return [[com.raphtory.api.progresstracker.QueryProgressTracker QueryProgressTracker]]\n    * with default job name\n    *\n    * @param name folder path for writing results\n    */")
    public ProgressTracker writeToFile(String name) {
        return TableBase.writeToFile$(this, name);
    }

    public Config conf$access$3() {
        return this.conf;
    }

    public String jobID() {
        return this.jobID;
    }

    public Perspective perspective() {
        return this.perspective;
    }

    public Row[] rows() {
        return this.rows;
    }

    private Config conf() {
        return this.conf;
    }

    @Override
    @Scaladoc(value="/** Add a filter operation to table\n    *\n    * @param f function that runs once for each row (only rows for which `f ` returns `true` are kept)\n    */")
    public TableOutput filter(Function1<Row, Object> f) {
        Row[] x$1 = (Row[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.rows()), f);
        String x$2 = this.copy$default$1();
        Perspective x$3 = this.copy$default$2();
        Config x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    @Scaladoc(value="/** Explode table rows\n    *\n    * This creates a new table where each row in the old table\n    * is mapped to multiple rows in the new table.\n    *\n    * @param f function that runs once for each row of the table and maps it to new rows\n    */")
    public TableOutput explode(Function1<Row, IterableOnce<Row>> f) {
        Row[] x$1 = (Row[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.rows()), f, ClassTag$.MODULE$.apply(Row.class));
        String x$2 = this.copy$default$1();
        Perspective x$3 = this.copy$default$2();
        Config x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    @Scaladoc(value="/** Write out data and\n    * return [[com.raphtory.api.progresstracker.QueryProgressTracker QueryProgressTracker]]\n    * with custom job name\n    *\n    * @param sink    [[com.raphtory.api.output.sink.Sink Sink]] for writing results\n    * @param jobName Name for job\n    */")
    public WriteProgressTracker writeTo(Sink sink, String jobName) {
        SinkExecutor executor = sink.executor(jobName, -1, this.conf());
        executor.setupPerspective(this.perspective());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.rows()), (Function1 & Serializable)row -> {
            executor.threadSafeWriteRow(row);
            return BoxedUnit.UNIT;
        });
        executor.closePerspective();
        executor.close();
        return new WriteProgressTracker(jobName, this.perspective());
    }

    @Override
    @Scaladoc(value="/** Write out data and\n    * return [[com.raphtory.api.progresstracker.QueryProgressTracker QueryProgressTracker]]\n    * with default job name\n    *\n    * @param sink [[com.raphtory.api.output.sink.Sink Sink]] for writing results\n    */")
    public WriteProgressTracker writeTo(Sink sink) {
        return this.writeTo(sink, this.jobID());
    }

    public String toString() {
        String printedRows = this.rows().length > 10 ? new StringBuilder(6).append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])this.rows()), 10)).mkString(", ")).append(", ... ").toString() : Predef$.MODULE$.wrapRefArray((Object[])this.rows()).mkString(", ");
        return new StringBuilder(19).append("TableOutput(").append(this.jobID()).append(", ").append(this.perspective()).append(", [").append(printedRows).append("])").toString();
    }

    public TableOutput copy(String jobID, Perspective perspective, Row[] rows, Config conf) {
        return new TableOutput(jobID, perspective, rows, conf);
    }

    public String copy$default$1() {
        return this.jobID();
    }

    public Perspective copy$default$2() {
        return this.perspective();
    }

    public Row[] copy$default$3() {
        return this.rows();
    }

    public Config copy$default$4() {
        return this.conf();
    }

    public String productPrefix() {
        return "TableOutput";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.jobID();
                break;
            }
            case 1: {
                object = this.perspective();
                break;
            }
            case 2: {
                object = this.rows();
                break;
            }
            case 3: {
                object = this.conf$access$3();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TableOutput;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "jobID";
                break;
            }
            case 1: {
                string = "perspective";
                break;
            }
            case 2: {
                string = "rows";
                break;
            }
            case 3: {
                string = "conf";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TableOutput)) return false;
        boolean bl = true;
        if (!bl) return false;
        TableOutput tableOutput = (TableOutput)x$1;
        String string = this.jobID();
        String string2 = tableOutput.jobID();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Perspective perspective = this.perspective();
        Perspective perspective2 = tableOutput.perspective();
        if (perspective == null) {
            if (perspective2 != null) {
                return false;
            }
        } else if (!perspective.equals(perspective2)) return false;
        if (this.rows() != tableOutput.rows()) return false;
        Config config = this.conf$access$3();
        Config config2 = tableOutput.conf$access$3();
        if (config == null) {
            if (config2 != null) {
                return false;
            }
        } else if (!config.equals(config2)) return false;
        if (!tableOutput.canEqual(this)) return false;
        return true;
    }

    public TableOutput(String jobID, Perspective perspective, Row[] rows, Config conf) {
        this.jobID = jobID;
        this.perspective = perspective;
        this.rows = rows;
        this.conf = conf;
        TableBase.$init$(this);
        Product.$init$((Product)this);
    }
}

