/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.graphstate;

import com.github.takezoe.scaladoc.Scaladoc;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@Scaladoc(value="/**\n  * Public interface for the Histograms API within [[GraphState]].\n  *\n  *  A Histogram maintains the distribution of a graph quantity in bins between the minimum and maximum value that\n  *  this quantity takes.\n  *\n  *  @tparam T Numeric value type of the histogram\n  *\n  * @see\n  * [[GraphState]],\n  * <a href=\"../../../../../_autodoc/com/raphtory/algorithms/generic/filters/EdgeQuantileFilter.html\"\n  *  class=\"extype\"\n  *  title=\"com.raphtory.algorithms.generic.filters.EdgeQuantileFilter\"\n  * >EdgeQuantileFilter</a>,\n  * <a href=\"../../../../../_autodoc/com/raphtory/algorithms/generic/filters/VertexQuantileFilter.html\"\n  *  class=\"extype\"\n  *  title=\"com.raphtory.algorithms.generic.filters.VertexQuantileFilter\"\n  * >VertexQuantileFilter</a>\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001da!B\u0007\u000f\u0003\u0003I\u0002\u0002C\u0011\u0001\u0005\u0007\u0005\u000b1\u0002\u0012\t\u000be\u0002A\u0011\u0001\u001e\t\u000b}\u0002a\u0011\u0001!\t\u000bI\u0003a\u0011A*\t\u000bi\u0003A\u0011A.\t\u000b\r\u0004A\u0011A.\t\u000b\u001d\u0004a\u0011\u00015\t\u000b5\u0004a\u0011A*\t\u000bE\u0004a\u0011\u0001:\t\u000b]\u0004a\u0011\u0001=\t\u000fu\u0004!\u0019!D\u0001}\"9q\u0010\u0001b\u0001\u000e\u0003q(!\u0003%jgR|wM]1n\u0015\ty\u0001#\u0001\u0006he\u0006\u0004\bn\u001d;bi\u0016T!!\u0005\n\u0002\u0011\u0005t\u0017\r\\=tSNT!a\u0005\u000b\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0016-\u0005A!/\u00199ii>\u0014\u0018PC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001+\tQ\u0002g\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\f!\"\u001a<jI\u0016t7-\u001a\u00132!\r\u00193F\f\b\u0003I%r!!\n\u0015\u000e\u0003\u0019R!a\n\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012B\u0001\u0016\u001e\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001L\u0017\u0003\u000f9+X.\u001a:jG*\u0011!&\b\t\u0003_Ab\u0001\u0001B\u00032\u0001\t\u0007!GA\u0001U#\t\u0019d\u0007\u0005\u0002\u001di%\u0011Q'\b\u0002\b\u001d>$\b.\u001b8h!\tar'\u0003\u00029;\t\u0019\u0011I\\=\u0002\rqJg.\u001b;?)\u0005YDC\u0001\u001f?!\ri\u0004AL\u0007\u0002\u001d!)\u0011E\u0001a\u0002E\u0005QAo\u001c;bY\u000e{WO\u001c;\u0016\u0003\u0005\u0003\"\u0001\b\"\n\u0005\rk\"aA%oi\"\"1!R(Q!\t1U*D\u0001H\u0015\tA\u0015*\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\tQ5*A\u0004uC.,'p\\3\u000b\u000513\u0012AB4ji\",(-\u0003\u0002O\u000f\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001R\u0003\u001dz#F\u000b\u0011SKR,(O\u001c\u0011uQ\u0016\u0004Co\u001c;bY\u0002\u0002x\u000e];mCRLwN\u001c\u0011tSj,\u0007EK\u0018\u0002\r\r,XnU;n+\u0005!\u0006c\u0001\u000fV\u0003&\u0011a+\b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u0005\t\u0015{\u0005,I\u0001Z\u0003u|#F\u000b\u0011D_6\u0004X\u000f^3!i\",\u0007eY;nk2\fG/\u001b<fA\u0011,gn]5us\u00022WO\\2uS>t\u0007e\u001c4!i\",\u0007\u0005\u001d:pa\u0016\u0014H/\u001f\u0011iSN$xn\u001a:b[\u0002*hN\\8s[\u0006d\u0017n]3eA!Jg\u000e\t:bo\u0002\u001aw.\u001e8ug\u0002\u001ax\u000eI1eIN\u0004Co\u001c\u0011ai>$\u0018\r\\\"pk:$\b-\u000b\u0011+_\u0005\u00191\r\u001a4\u0016\u0003q\u00032\u0001H+^!\tab,\u0003\u0002`;\t)a\t\\8bi\"\"Q!R(bC\u0005\u0011\u0017!L\u0018+U\u0001\u001aU/\\;mCRLg/\u001a\u0011eK:\u001c\u0018\u000e^=!MVt7\r^5p]\u0002rwN]7bY&\u001cX\r\u001a\u0011+_\u0005\u0019\u0001\u000f\u001a4)\t\u0019)u*Z\u0011\u0002M\u0006\u0019sF\u000b\u0016!!J|'-\u00192jY&$\u0018\u0010\t3f]NLG/\u001f\u0011gk:\u001cG/[8oA)z\u0013\u0001C9vC:$\u0018\u000e\\3\u0015\u0005uK\u0007\"B4\b\u0001\u0004i\u0006\u0006B\u0004F\u001f.\f\u0013\u0001\\\u0001\u0002>=R#\u0006I\"p[B,H/\u001a\u0011uQ\u0016\u0004c/\u00197vK\u0002\n7o]8dS\u0006$X\r\u001a\u0011xSRD\u0007%\u0019\u0011hSZ,g\u000eI9vC:$\u0018\u000e\\3\u000bA\u0001\u0002\u0003E\u000b\u0011!\u0001B\f'/Y7!cV\fg\u000e^5mK\u0002\u0002\u0013/^1oi&dW\r\t;pA\u0019Lg\u000e\u001a\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u00111]U\u0002so\\;mI\u0002\u001awN\u001d:fgB|g\u000e\u001a\u0011u_\u0002\"\b.\u001a\u0011nK\u0012L\u0017M\u001c\u0011wC2,XM\f\u0006!A\u0001\u0002#fL\u0001\bO\u0016$()\u001b8tQ\u0011AQiT8\"\u0003A\f!j\f\u0016+A\u001d+G\u000f^3sA\u0019,hn\u0019;j_:\u0004cm\u001c:!_\n$\u0018-\u001b8j]\u001e\u0004C\u000f[3!E&t7\u000fI2pk:$8\u000fI8gAQDW\r\t5jgR|wM]1n])\u0001\u0003\u0005\t\u0011+_\u00051q-\u001a;CS:$\"!Q:\t\u000b=K\u0001\u0019\u0001\u0018)\t%)u*^\u0011\u0002m\u0006qxF\u000b\u0016!\u000f\u0016$\b\u0005\u001e5fA\tLg\u000eI5oI\u0016D\b%Y:t_\u000eL\u0017\r^3eA]LG\u000f\u001b\u0011bA\u001dLg/\u001a8!m\u0006dW/\u001a\u0018\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t<bYV,\u0007%\u00138qkR\u0004c/\u00197vK*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001J,G/\u001e:oA\tKg\u000eI5oI\u0016D(\u0002\t\u0011!A)z\u0013aC4fi\nKgnQ8v]R$\"!Q=\t\u000b=S\u0001\u0019\u0001\u0018)\t))uj_\u0011\u0002y\u0006\tie\f\u0016+A\u0019Kg\u000e\u001a\u0011uQ\u0016\u0004\u0003o\u001c9vY\u0006$\u0018n\u001c8!_\u001a\u0004\u0013\r\t2j]\u0002\n7o]8dS\u0006$X\r\u001a\u0011xSRD\u0007%\u0019\u0011hSZ,g\u000e\t<bYV,gF\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004c/\u00197vK\u0002Je\u000e];uAY\fG.^3\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!sKR,(O\u001c\u0011D_VtG\u000fI8gA\u0015dW-\\3oiN\u0004\u0013N\u001c\u0011d_J\u0014Xm\u001d9p]\u0012Lgn\u001a\u0011cS:T\u0001\u0005\t\u0011!U=\n\u0001\"\\5o-\u0006dW/Z\u000b\u0002]\u0005AQ.\u0019=WC2,X\rK\u0003\u0001\u000b>\u000b\u0019!\t\u0002\u0002\u0006\u0005)yo\f\u0016+\u0015\u0001\u0002#\u0006\t)vE2L7\rI5oi\u0016\u0014h-Y2fA\u0019|'\u000f\t;iK\u0002B\u0015n\u001d;pOJ\fWn\u001d\u0011B!&\u0003s/\u001b;iS:\u00043lW$sCBD7\u000b^1uKvkfF\u0003\u0011!U)\u0001\u0003E\u000b\u0011!\u0003\u0002B\u0015n\u001d;pOJ\fW\u000eI7bS:$\u0018-\u001b8tAQDW\r\t3jgR\u0014\u0018NY;uS>t\u0007e\u001c4!C\u0002:'/\u00199iAE,\u0018M\u001c;jif\u0004\u0013N\u001c\u0011cS:\u001c\bEY3uo\u0016,g\u000e\t;iK\u0002j\u0017N\\5nk6\u0004\u0013M\u001c3![\u0006D\u0018.\\;nAY\fG.^3!i\"\fGO\u0003\u0011!U\u0001\u0002C\u000f[5tAE,\u0018M\u001c;jif\u0004C/Y6fg:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t!ua\u0006\u0014\u0018-\u001c\u0011UA9+X.\u001a:jG\u00022\u0018\r\\;fAQL\b/\u001a\u0011pM\u0002\"\b.\u001a\u0011iSN$xn\u001a:b[*\u0001\u0003E\u000b\u0006!A)\u0002\u0003i]3f\u0015\u0001\u0002#\u0006I.\\\u000fJ\f\u0007\u000f[*uCR,W,\u0018\u0017\u000bA\u0001R\u0003\u0005P1!QJ,g-\u0010\u0012/]=rcf\f\u0018/_9rsF\f\u00180?\u0006,Ho\u001c3pG>\u001aw.\\\u0018sCBDGo\u001c:z_\u0005dwm\u001c:ji\"l7oL4f]\u0016\u0014\u0018nY\u0018gS2$XM]:0\u000b\u0012<W-U;b]RLG.\u001a$jYR,'O\f5u[2\u0014#\u0002\t\u0011+A\u0001\u001aG.Y:t{\t*\u0007\u0010^=qK\nR\u0001\u0005\t\u0016!AQLG\u000f\\3>E\r|WN\f:ba\"$xN]=/C2<wN]5uQ6\u001chfZ3oKJL7M\f4jYR,'o\u001d\u0018FI\u001e,\u0017+^1oi&dWMR5mi\u0016\u0014(E\u0003\u0011!U\u0001rT\tZ4f#V\fg\u000e^5mK\u001aKG\u000e^3sy=\ng\b\f\u0006!A)\u0002C(\u0019\u0011ie\u00164WH\t\u0018/_9rsF\f\u00180]9zcFL\u0018`CV$x\u000eZ8d_\r|Wn\f:ba\"$xN]=0C2<wN]5uQ6\u001cxfZ3oKJL7m\f4jYR,'o]\u0018WKJ$X\r_)vC:$\u0018\u000e\\3GS2$XM\u001d\u0018ii6d'E\u0003\u0011!U\u0001\u00023\r\\1tgv\u0012S\r\u001f;za\u0016\u0014#\u0002\t\u0011+A\u0001\"\u0018\u000e\u001e7f{\t\u001aw.\u001c\u0018sCBDGo\u001c:z]\u0005dwm\u001c:ji\"l7OL4f]\u0016\u0014\u0018n\u0019\u0018gS2$XM]:/-\u0016\u0014H/\u001a=Rk\u0006tG/\u001b7f\r&dG/\u001a:#\u0015\u0001\u0002#\u0006\t WKJ$X\r_)vC:$\u0018\u000e\\3GS2$XM\u001d\u001f0CzR\u0001\u0005\t\u00160\u0001")
public abstract class Histogram<T> {
    public abstract T minValue();

    public abstract T maxValue();

    @Scaladoc(value="/** Return the total population size */")
    public abstract int totalCount();

    @Scaladoc(value="/** Compute the cumulative density function of the property histogram unnormalised (in raw counts so adds to `totalCount`) */")
    public abstract int[] cumSum();

    @Scaladoc(value="/** Cumulative density function normalised */")
    public float[] cdf() {
        return (float[])ArrayOps$.MODULE$.scanLeft$extension(Predef$.MODULE$.floatArrayOps(this.pdf()), (Object)BoxesRunTime.boxToFloat((float)0.0f), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToFloat((float)Histogram.$anonfun$cdf$1(BoxesRunTime.unboxToFloat((Object)x$1), BoxesRunTime.unboxToFloat((Object)x$2))), (ClassTag)ClassTag$.MODULE$.Float());
    }

    @Scaladoc(value="/** Probability density function */")
    public float[] pdf() {
        return (float[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(this.getBins()), (Function1)(JFunction1.mcFI.sp & Serializable)x$3 -> (float)x$3 / (float)this.totalCount(), (ClassTag)ClassTag$.MODULE$.Float());
    }

    @Scaladoc(value="/** Compute the value associated with a given quantile\n    *  @param quantile  quantile to find. For example, 0.5 would correspond to the median value.\n    */")
    public abstract float quantile(float var1);

    @Scaladoc(value="/** Getter function for obtaining the bins counts of the histogram.\n    */")
    public abstract int[] getBins();

    @Scaladoc(value="/** Get the bin index associated with a given value.\n    *\n    * @param value Input value\n    *\n    * @return Bin index\n    */")
    public abstract int getBin(T var1);

    @Scaladoc(value="/** Find the population of a bin associated with a given value.\n    *\n    * @param value Input value\n    *\n    * @return Count of elements in corresponding bin\n    */")
    public abstract int getBinCount(T var1);

    public static final /* synthetic */ float $anonfun$cdf$1(float x$1, float x$2) {
        return x$1 + x$2;
    }

    public Histogram(Numeric<T> evidence$1) {
    }
}

