/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.KCore$;
import com.raphtory.algorithms.temporal.motif.LocalThreeNodeMotifs$;
import com.raphtory.algorithms.temporal.motif.StarMotifCounter;
import com.raphtory.algorithms.temporal.motif.ThreeNodeMotifs$;
import com.raphtory.algorithms.temporal.motif.TriadMotifCounter;
import com.raphtory.algorithms.temporal.motif.TwoNodeMotifs;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.ReducedVertex;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@Scaladoc(value="/**\n  *  {s}`LocalThreeNodeMotifs(delta:Long, graphWide:Boolean=true, prettyPrint:Boolean=true)`\n  *    : Count occurrences of three-edge up-to-three-node temporal motifs each node participates in. For an efficient global count, use ThreeNodeMotifs\n  *\n  *  The algorithm is very based on that in \"Motifs in Temporal Networks\". An option is given to return results as a hashmap with labels or as an array which is easier for post-processing.\n  *\n  *  ## Motifs\n  *\n  *  ### Stars\n  *\n  *  There are three classes (in the order they are outputted) of star motif on three nodes based on the switching behaviour of the edges between the two leaf nodes.\n  *\n  *   - PRE: Stars of the form i<->j, i<->j, i<->k (ie two interactions with leaf j followed by one with leaf k)\n  *   - MID: Stars of the form i<->j, i<->k, i<->j (ie switching interactions from leaf j to leaf k, back to j again)\n  *   - POST: Stars of the form i<->j, i<->k, i<->k (ie one interaction with leaf j followed by two with leaf k)\n  *\n  *  Within each of these classes is 8 motifs depending on the direction of the first to the last edge -- incoming \"I\" or outgoing \"O\".\n  *  These are enumerated in the order III, IIO, IOI, IOO, OII, OIO, OOI, OOO (like binary with \"I\"-0 and \"O\"-1).\n  *\n  *  ### Two node motifs\n  *\n  *  Also included are two node motifs, of which there are 8 when counted from the perspective of each vertex. These are characterised by the direction of each edge, enumerated\n  *  in the above order. Note that for the global graph counts, each motif is counted in both directions (a single III motif for one vertex is an OOO motif for the other vertex).\n  *\n  *  ### Triangles\n  *\n  *  There are 8 triangle motifs, below is the order in which they appear in the returned array:\n  *\n  *   1. i --> j, k --> j, i --> k\n  *   2. i --> j, k --> i, j --> k\n  *   3. i --> j, j --> k, i --> k\n  *   4. i --> j, i --> k, j --> k\n  *   5. i --> j, k --> j, k --> i\n  *   6. i --> j, k --> i, k --> j\n  *   7. i --> j, j --> k, k --> i\n  *   8. i --> j, i --> k, k --> j\n  *\n  *   The motif counts are returned as a 40-d array where the first 24 elements are star counts,\n  *   the next 8 are two-node motif counts and the final 8 are triangle counts.\n  *\n  * ## States\n  *  {s}`starCounts: Array[Int]`\n  *    : Three-node star motif counts stored as an array (see indices above)\n  *  {s}`twoNodeCounts: Array[Int]`\n  *    : Two-node motif counts stored as an array (see indices above)\n  *  {s}`triCounts: Array[Int]`\n  *    : Triangle motif counts stored as an array (see indices above)\n  *\n  * ## Returns\n  *\n  *  | vertex name       | motifs                   |\n  *  | ----------------- | ------------------------ |\n  *  | {s}`name: String` | {s}`motifCounts: Array[Long]` |\n  *\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\n\u0014\u0001yA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\u0007\u0001B\u0001B\u0003%A\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0003@\u0001\u0011\u0005\u0003\tC\u0003O\u0001\u0011\u0005sjB\u0003i'!\u0005\u0011NB\u0003\u0013'!\u0005!\u000eC\u00039\u0011\u0011\u00051\u000fC\u0003@\u0011\u0011\u0005A\u000fC\u0004y\u0011E\u0005I\u0011A=\t\u0013\u0005%\u0001\"%A\u0005\u0002\u0005-\u0001\"CA\b\u0011E\u0005I\u0011AA\u0006\u0011!\t\t\u0002CI\u0001\n\u0003I\b\"CA\n\u0011E\u0005I\u0011AA\u0006\u0011%\t)\u0002CI\u0001\n\u0003\tY\u0001C\u0005\u0002\u0018!\t\t\u0011\"\u0003\u0002\u001a\t!Bj\\2bYRC'/Z3O_\u0012,Wj\u001c;jMNT!\u0001F\u000b\u0002\u000b5|G/\u001b4\u000b\u0005Y9\u0012\u0001\u0003;f[B|'/\u00197\u000b\u0005aI\u0012AC1mO>\u0014\u0018\u000e\u001e5ng*\u0011!dG\u0001\te\u0006\u0004\b\u000e^8ss*\tA$A\u0002d_6\u001c\u0001aE\u0002\u0001?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014.\u001b\u00059#B\u0001\u0015*\u0003%\tGnZ8sSRDWN\u0003\u0002+W\u0005A\u0011M\\1msNL7O\u0003\u0002-3\u0005\u0019\u0011\r]5\n\u00059:#\u0001E$f]\u0016\u0014\u0018n\u0019*fIV\u001cG/[8o\u0003\u0015!W\r\u001c;b!\t\u0001\u0013'\u0003\u00023C\t!Aj\u001c8h\u0003%9'/\u00199i/&$W\r\u0005\u0002!k%\u0011a'\t\u0002\b\u0005>|G.Z1o\u0003-\u0001(/\u001a;usB\u0013\u0018N\u001c;\u0002\rqJg.\u001b;?)\u0011QD(\u0010 \u0011\u0005m\u0002Q\"A\n\t\u000f=\"\u0001\u0013!a\u0001a!91\u0007\u0002I\u0001\u0002\u0004!\u0004bB\u001c\u0005!\u0003\u0005\r\u0001N\u0001\u0006CB\u0004H.\u001f\u000b\u0003\u0003\u0012\u0003\"A\u0011'\u000f\u0005\r#E\u0002\u0001\u0005\u0006\u000b\u0016\u0001\rAR\u0001\u0006OJ\f\u0007\u000f\u001b\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013&\n\u0011b\u001a:ba\"4\u0018.Z<\n\u0005-C%\u0001E$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f\u0013\ti%J\u0001\u0007SK\u0012,8-\u001a3He\u0006\u0004\b.\u0001\u0006uC\n,H.\u0019:jg\u0016$\"\u0001\u0015,\u0011\u0005E#V\"\u0001*\u000b\u0005MK\u0013!\u0002;bE2,\u0017BA+S\u0005\u0015!\u0016M\u00197f\u0011\u0015)e\u00011\u0001X!\t9\u0005,\u0003\u0002Z\u0011\n9\"+\u001a3vG\u0016$wI]1qQB+'o\u001d9fGRLg/\u001a\u0015\u0005\u0001m+g\r\u0005\u0002]G6\tQL\u0003\u0002_?\u0006A1oY1mC\u0012|7M\u0003\u0002aC\u00069A/Y6fu>,'B\u00012\u001c\u0003\u00199\u0017\u000e\u001e5vE&\u0011A-\u0018\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\nq-AKM_)R#\u0002\t\u0011+A\u0001Z8/ 1M_\u000e\fG\u000e\u00165sK\u0016tu\u000eZ3N_RLgm\u001d\u0015eK2$\u0018M\u000f'p]\u001ed\u0003e\u001a:ba\"<\u0016\u000eZ3;\u0005>|G.Z1o{Q\u0014X/\u001a\u0017!aJ,G\u000f^=Qe&tGO\u000f\"p_2,\u0017M\\\u001fueV,\u0017\u0006\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A\r{WO\u001c;!_\u000e\u001cWO\u001d:f]\u000e,7\u000fI8gAQD'/Z3.K\u0012<W\rI;q[Q|W\u0006\u001e5sK\u0016lcn\u001c3fAQ,W\u000e]8sC2\u0004Sn\u001c;jMN\u0004S-Y2iA9|G-\u001a\u0011qCJ$\u0018nY5qCR,7\u000fI5o]\u00012uN\u001d\u0011b]\u0002*gMZ5dS\u0016tG\u000fI4m_\n\fG\u000eI2pk:$H\u0006I;tK\u0002\"\u0006N]3f\u001d>$W-T8uS\u001a\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011UQ\u0016\u0004\u0013\r\\4pe&$\b.\u001c\u0011jg\u00022XM]=!E\u0006\u001cX\r\u001a\u0011p]\u0002\"\b.\u0019;!S:\u0004#%T8uS\u001a\u001c\b%\u001b8!)\u0016l\u0007o\u001c:bY\u0002rU\r^<pe.\u001c(E\f\u0011B]\u0002z\u0007\u000f^5p]\u0002J7\u000fI4jm\u0016t\u0007\u0005^8!e\u0016$XO\u001d8!e\u0016\u001cX\u000f\u001c;tA\u0005\u001c\b%\u0019\u0011iCNDW.\u00199!o&$\b\u000e\t7bE\u0016d7\u000fI8sA\u0005\u001c\b%\u00198!CJ\u0014\u0018-\u001f\u0011xQ&\u001c\u0007\u000eI5tA\u0015\f7/[3sA\u0019|'\u000f\t9pgRl\u0003O]8dKN\u001c\u0018N\\4/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023e\t\u0011N_RLgm\u001d\u0006!A)R\u0001\u0005\t\u0016!A\r\u001a3\u0005I*uCJ\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011UQ\u0016\u0014X\rI1sK\u0002\"\bN]3fA\rd\u0017m]:fg\u0002B\u0013N\u001c\u0011uQ\u0016\u0004sN\u001d3fe\u0002\"\b.Z=!CJ,\u0007e\\;uaV$H/\u001a3*A=4\u0007e\u001d;be\u0002jw\u000e^5gA=t\u0007\u0005\u001e5sK\u0016\u0004cn\u001c3fg\u0002\u0012\u0017m]3eA=t\u0007\u0005\u001e5fAM<\u0018\u000e^2iS:<\u0007EY3iCZLw.\u001e:!_\u001a\u0004C\u000f[3!K\u0012<Wm\u001d\u0011cKR<X-\u001a8!i\",\u0007\u0005^<pA1,\u0017M\u001a\u0011o_\u0012,7O\f\u0006!A)R\u0001\u0005\t\u0016!A\u0001j\u0003\u0005\u0015*Fu\u0001\u001aF/\u0019:tA=4\u0007\u0005\u001e5fA\u0019|'/\u001c\u0011jy5r$\u000e\f\u0011jy5r$\u000e\f\u0011jy5r4\u000e\t\u0015jK\u0002\"xo\u001c\u0011j]R,'/Y2uS>t7\u000fI<ji\"\u0004C.Z1gA)\u0004cm\u001c7m_^,G\r\t2zA=tW\rI<ji\"\u0004C.Z1gA-L#\u0002\t\u0011+A\u0001\u0002S\u0006I'J\tj\u00023\u000b^1sg\u0002zg\r\t;iK\u00022wN]7!SrjcH\u001b\u0017!Srjch\u001b\u0017!SrjcH\u001b\u0011)S\u0016\u00043o^5uG\"Lgn\u001a\u0011j]R,'/Y2uS>t7\u000f\t4s_6\u0004C.Z1gA)\u0004Co\u001c\u0011mK\u00064\u0007e\u001b\u0017!E\u0006\u001c7\u000e\t;pA)\u0004\u0013mZ1j]&R\u0001\u0005\t\u0016!A\u0001j\u0003\u0005U(T)j\u00023\u000b^1sg\u0002zg\r\t;iK\u00022wN]7!SrjcH\u001b\u0017!Srjch\u001b\u0017!Srjch\u001b\u0011)S\u0016\u0004sN\\3!S:$XM]1di&|g\u000eI<ji\"\u0004C.Z1gA)\u0004cm\u001c7m_^,G\r\t2zAQ<x\u000eI<ji\"\u0004C.Z1gA-L#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011XSRD\u0017N\u001c\u0011fC\u000eD\u0007e\u001c4!i\",7/\u001a\u0011dY\u0006\u001c8/Z:!SN\u0004\u0003\bI7pi&47\u000f\t3fa\u0016tG-\u001b8hA=t\u0007\u0005\u001e5fA\u0011L'/Z2uS>t\u0007e\u001c4!i\",\u0007EZ5sgR\u0004Co\u001c\u0011uQ\u0016\u0004C.Y:uA\u0015$w-\u001a\u0011.[\u0001JgnY8nS:<\u0007EI%#A=\u0014\be\\;uO>Lgn\u001a\u0011#\u001f\nr#\u0002\t\u0011+A\u0001\"\u0006.Z:fA\u0005\u0014X\rI3ok6,'/\u0019;fI\u0002Jg\u000e\t;iK\u0002z'\u000fZ3sA%K\u0015\n\f\u0011J\u0013>c\u0003%S(JY\u0001Juj\u0014\u0017!\u001f&KE\u0006I(J\u001f2\u0002sjT%-A={u\n\t\u0015mS.,\u0007EY5oCJL\be^5uQ\u0002\u0012\u0013JI\u00171A\u0005tG\r\t\u0012PE5\n\u0014F\f\u0006!A)R\u0001\u0005\t\u0016!A\r\u001a3\u0005\t+x_\u0002rw\u000eZ3![>$\u0018NZ:\u000bA\u0001R#\u0002\t\u0011+A\u0001\nEn]8!S:\u001cG.\u001e3fI\u0002\n'/\u001a\u0011uo>\u0004cn\u001c3fA5|G/\u001b4tY\u0001zg\rI<iS\u000eD\u0007\u0005\u001e5fe\u0016\u0004\u0013M]3!q\u0001:\b.\u001a8!G>,h\u000e^3eA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004\u0003/\u001a:ta\u0016\u001cG/\u001b<fA=4\u0007%Z1dQ\u00022XM\u001d;fq:\u0002C\u000b[3tK\u0002\n'/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe&\u001cX\r\u001a\u0011cs\u0002\"\b.\u001a\u0011eSJ,7\r^5p]\u0002zg\rI3bG\"\u0004S\rZ4fY\u0001*g.^7fe\u0006$X\r\u001a\u0006!A)\u0002\u0003%\u001b8!i\",\u0007%\u00192pm\u0016\u0004sN\u001d3fe:\u0002cj\u001c;fAQD\u0017\r\u001e\u0011g_J\u0004C\u000f[3!O2|'-\u00197!OJ\f\u0007\u000f\u001b\u0011d_VtGo\u001d\u0017!K\u0006\u001c\u0007\u000eI7pi&4\u0007%[:!G>,h\u000e^3eA%t\u0007EY8uQ\u0002\"\u0017N]3di&|gn\u001d\u0011)C\u0002\u001a\u0018N\\4mK\u0002J\u0015*\u0013\u0011n_RLg\r\t4pe\u0002zg.\u001a\u0011wKJ$X\r\u001f\u0011jg\u0002\ng\u000eI(P\u001f\u0002jw\u000e^5gA\u0019|'\u000f\t;iK\u0002zG\u000f[3sAY,'\u000f^3yS9R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I\u0012$G\u0001\"&/[1oO2,7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!)\",'/\u001a\u0011be\u0016\u0004\u0003\b\t;sS\u0006tw\r\\3![>$\u0018NZ:-A\t,Gn\\<!SN\u0004C\u000f[3!_J$WM\u001d\u0011j]\u0002:\b.[2iAQDW-\u001f\u0011baB,\u0017M\u001d\u0011j]\u0002\"\b.\u001a\u0011sKR,(O\\3eA\u0005\u0014(/Y=;\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003%\r\u0018!S\u0002jSF\u0010\u0011kY\u0001Z\u0007%L\u0017?A)d\u0003%\u001b\u0011.[y\u00023N\u0003\u0011!U\u0001\u0002\u0003E\r\u0018!S\u0002jSF\u0010\u0011kY\u0001Z\u0007%L\u0017?A%d\u0003E\u001b\u0011.[y\u00023N\u0003\u0011!U\u0001\u0002\u0003e\r\u0018!S\u0002jSF\u0010\u0011kY\u0001R\u0007%L\u0017?A-d\u0003%\u001b\u0011.[y\u00023N\u0003\u0011!U\u0001\u0002\u0003\u0005\u000e\u0018!S\u0002jSF\u0010\u0011kY\u0001J\u0007%L\u0017?A-d\u0003E\u001b\u0011.[y\u00023N\u0003\u0011!U\u0001\u0002\u0003%\u000e\u0018!S\u0002jSF\u0010\u0011kY\u0001Z\u0007%L\u0017?A)d\u0003e\u001b\u0011.[y\u0002\u0013N\u0003\u0011!U\u0001\u0002\u0003E\u000e\u0018!S\u0002jSF\u0010\u0011kY\u0001Z\u0007%L\u0017?A%d\u0003e\u001b\u0011.[y\u0002#N\u0003\u0011!U\u0001\u0002\u0003e\u000e\u0018!S\u0002jSF\u0010\u0011kY\u0001R\u0007%L\u0017?A-d\u0003e\u001b\u0011.[y\u0002\u0013N\u0003\u0011!U\u0001\u0002\u0003\u0005\u000f\u0018!S\u0002jSF\u0010\u0011kY\u0001J\u0007%L\u0017?A-d\u0003e\u001b\u0011.[y\u0002#N\u0003\u0011!U)\u0001\u0003E\u000b\u0011!AQCW\rI7pi&4\u0007eY8v]R\u001c\b%\u0019:fAI,G/\u001e:oK\u0012\u0004\u0013m\u001d\u0011bAQ\u0002T\u0006\u001a\u0011beJ\f\u0017\u0010I<iKJ,\u0007\u0005\u001e5fA\u0019L'o\u001d;!eQ\u0002S\r\\3nK:$8\u000fI1sK\u0002\u001aH/\u0019:!G>,h\u000e^:-\u0015\u0001\u0002#\u0006\t\u0011!i\",\u0007E\\3yi\u0002B\u0004%\u0019:fAQ<x.\f8pI\u0016\u0004Sn\u001c;jM\u0002\u001aw.\u001e8ug\u0002\ng\u000e\u001a\u0011uQ\u0016\u0004c-\u001b8bY\u0002B\u0004%\u0019:fAQ\u0014\u0018.\u00198hY\u0016\u00043m\\;oiNt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AM#\u0018\r^3t\u0015\u0001\u0002#\u0006\t\u0011|gv\u00047\u000f^1s\u0007>,h\u000e^:;A\u0005\u0013(/Y=\\\u0013:$X\f\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;AQC'/Z3.]>$W\rI:uCJ\u0004Sn\u001c;jM\u0002\u001aw.\u001e8ug\u0002\u001aHo\u001c:fI\u0002\n7\u000fI1oA\u0005\u0014(/Y=!QM,W\rI5oI&\u001cWm\u001d\u0011bE>4X-\u000b\u0006!A)\u0002\u0003e_:~AR<xNT8eK\u000e{WO\u001c;tu\u0001\n%O]1z7&sG/\u00181\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001\"vo\\\u0017o_\u0012,\u0007%\\8uS\u001a\u00043m\\;oiN\u00043\u000f^8sK\u0012\u0004\u0013m\u001d\u0011b]\u0002\n'O]1zA!\u001aX-\u001a\u0011j]\u0012L7-Z:!C\n|g/Z\u0015\u000bA\u0001R\u0003\u0005I>t{\u0002$(/[\"pk:$8O\u000f\u0011BeJ\f\u0017pW%oiv\u0003'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011Ue&\fgn\u001a7fA5|G/\u001b4!G>,h\u000e^:!gR|'/\u001a3!CN\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010\t\u0015tK\u0016\u0004\u0013N\u001c3jG\u0016\u001c\b%\u00192pm\u0016L#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AI+G/\u001e:og*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005 \u0011wKJ$X\r\u001f\u0011oC6,\u0007\u0005\t\u0011!A\u0001\u0002C\u0010I7pi&47\u000f\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001b(\u0002\t\u0011+A\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y*\u0001\u0003E\u000b\u0011!y\u0002Z8/ 1oC6,'\bI*ue&tw\r\u0019\u0011}Am\u001cX\u0010Y7pi&47i\\;oiNT\u0004%\u0011:sCf\\Fj\u001c8h;\u0002\u0004CP\u0003\u0011!U)\u0001\u0003EK\u0018\u0002)1{7-\u00197UQJ,WMT8eK6{G/\u001b4t!\tY\u0004bE\u0002\t?-\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\u0005%|'\"\u00019\u0002\t)\fg/Y\u0005\u0003e6\u0014AbU3sS\u0006d\u0017N_1cY\u0016$\u0012!\u001b\u000b\u0005uU4x\u000fC\u00040\u0015A\u0005\t\u0019\u0001\u0019\t\u000fMR\u0001\u0013!a\u0001i!9qG\u0003I\u0001\u0002\u0004!\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003iT#\u0001M>,\u0003q\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007\t\u0013AC1o]>$\u0018\r^5p]&\u0019\u0011q\u0001@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiA\u000b\u00025w\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\tc\\\u0001\u0005Y\u0006tw-\u0003\u0003\u0002&\u0005}!AB(cU\u0016\u001cG\u000f")
public class LocalThreeNodeMotifs
implements GenericReduction {
    private final long delta;
    private final boolean graphWide;
    private final boolean prettyPrint;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static boolean $lessinit$greater$default$3() {
        return LocalThreeNodeMotifs$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return LocalThreeNodeMotifs$.MODULE$.$lessinit$greater$default$2();
    }

    public static long $lessinit$greater$default$1() {
        return LocalThreeNodeMotifs$.MODULE$.$lessinit$greater$default$1();
    }

    public static boolean apply$default$3() {
        return LocalThreeNodeMotifs$.MODULE$.apply$default$3();
    }

    public static boolean apply$default$2() {
        return LocalThreeNodeMotifs$.MODULE$.apply$default$2();
    }

    public static long apply$default$1() {
        return LocalThreeNodeMotifs$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(Generic other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return (ConcreteReducedGraphPerspective)KCore$.MODULE$.apply(2, KCore$.MODULE$.apply$default$2()).apply(graph).clearMessages().reducedView().setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            LocalThreeNodeMotifs.$anonfun$apply$1(state);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            LocalThreeNodeMotifs.$anonfun$apply$11(v);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            LocalThreeNodeMotifs.$anonfun$apply$12(v);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            LocalThreeNodeMotifs.$anonfun$apply$14(v);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(v, state) -> {
            LocalThreeNodeMotifs.$anonfun$apply$20(this, v, state);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)v -> {
            LocalThreeNodeMotifs.$anonfun$apply$30(v);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(v, state) -> {
            LocalThreeNodeMotifs.$anonfun$apply$33(this, v, state);
            return BoxedUnit.UNIT;
        });
    }

    public Table tabularise(ReducedGraphPerspective graph) {
        return !this.graphWide ? (this.prettyPrint ? graph.select((Function1<Vertex, Row>)(Function1 & Serializable)vertex -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{vertex.name(), ThreeNodeMotifs$.MODULE$.getStarCountsPretty(((EntityVisitor)((Object)vertex)).getState("starCounts", ((EntityVisitor)((Object)vertex)).getState$default$2()), Numeric.LongIsIntegral$.MODULE$), ThreeNodeMotifs$.MODULE$.get2NodeCountsWithoutRepeats(((EntityVisitor)((Object)vertex)).getState("twoNodeCounts", ((EntityVisitor)((Object)vertex)).getState$default$2()), Numeric.LongIsIntegral$.MODULE$), ThreeNodeMotifs$.MODULE$.getTriCountsPretty(((EntityVisitor)((Object)vertex)).getState("triCounts", ((EntityVisitor)((Object)vertex)).getState$default$2()), Numeric.LongIsIntegral$.MODULE$)}))) : graph.select((Function1<Vertex, Row>)(Function1 & Serializable)vertex -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{vertex.name(), Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])((EntityVisitor)((Object)vertex)).getState("starCounts", ((EntityVisitor)((Object)vertex)).getState$default$2())), ((EntityVisitor)((Object)vertex)).getState("twoNodeCounts", ((EntityVisitor)((Object)vertex)).getState$default$2()), (ClassTag)ClassTag$.MODULE$.Long())), ((EntityVisitor)((Object)vertex)).getState("triCounts", ((EntityVisitor)((Object)vertex)).getState$default$2()), (ClassTag)ClassTag$.MODULE$.Long())).mkString("(", ";", ")")})))) : (this.prettyPrint ? graph.globalSelect((Function1<GraphState, Row>)(Function1 & Serializable)state -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ThreeNodeMotifs$.MODULE$.getStarCountsPretty(state.apply("starCounts").value(), Numeric.LongIsIntegral$.MODULE$), ThreeNodeMotifs$.MODULE$.get2NodeCountsWithoutRepeats(state.apply("twoNodeCounts").value(), Numeric.LongIsIntegral$.MODULE$), ThreeNodeMotifs$.MODULE$.getTriCountsPretty(state.apply("triCounts").value(), Numeric.LongIsIntegral$.MODULE$)}))) : graph.globalSelect((Function1<GraphState, Row>)(Function1 & Serializable)state -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])state.apply("starCounts").value()), state.apply("twoNodeCounts").value(), (ClassTag)ClassTag$.MODULE$.Long())), state.apply("triCounts").value(), (ClassTag)ClassTag$.MODULE$.Long())).mkString("(", ";", ")")}))));
    }

    public static final /* synthetic */ long $anonfun$apply$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ long $anonfun$apply$7(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ long $anonfun$apply$10(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ void $anonfun$apply$1(GraphState state) {
        state.newAccumulator("twoNodeCounts", Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), true, (Function2 & Serializable)(ar1, ar2) -> (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(ar1), (IterableOnce)Predef$.MODULE$.wrapLongArray(ar2))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToLong((long)LocalThreeNodeMotifs.$anonfun$apply$4(x0$1)), (ClassTag)ClassTag$.MODULE$.Long()));
        state.newAccumulator("triCounts", Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), true, (Function2 & Serializable)(ar1, ar2) -> (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(ar1), (IterableOnce)Predef$.MODULE$.wrapLongArray(ar2))), (Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)LocalThreeNodeMotifs.$anonfun$apply$7(x0$2)), (ClassTag)ClassTag$.MODULE$.Long()));
        state.newAccumulator("starCounts", Array$.MODULE$.fill(24, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), true, (Function2 & Serializable)(ar1, ar2) -> (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(ar1), (IterableOnce)Predef$.MODULE$.wrapLongArray(ar2))), (Function1 & Serializable)x0$3 -> BoxesRunTime.boxToLong((long)LocalThreeNodeMotifs.$anonfun$apply$10(x0$3)), (ClassTag)ClassTag$.MODULE$.Long()));
    }

    public static final /* synthetic */ void $anonfun$apply$11(ReducedVertex v) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            v.messageAllNeighbours(v.ID(), SchemaProviderInstances$.MODULE$.longSchemaProvider());
        }
    }

    public static final /* synthetic */ void $anonfun$apply$12(ReducedVertex v) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            scala.collection.immutable.Set neighbours = v.messageQueue().toSet();
            ((EntityVisitor)((Object)v)).setState("effNeighbours", neighbours);
            neighbours.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)nb -> v.messageVertex(BoxesRunTime.boxToLong((long)nb), new Tuple2(v.ID(), (Object)neighbours), SchemaProviderInstances$.MODULE$.genericSchemaProvider()));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$16(ReducedVertex v$2, scala.collection.immutable.Set neighbours$2, Tuple2 x0$4) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            long nb = tuple2._1$mcJ$sp();
            scala.collection.immutable.Set friendsOfFriend = (scala.collection.immutable.Set)tuple2._2();
            if (BoxesRunTime.unboxToLong((Object)v$2.ID()) > nb) {
                friendsOfFriend.intersect((Set)neighbours$2).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)w -> {
                    block0: {
                        if (nb <= w) break block0;
                        v$2.messageVertex(BoxesRunTime.boxToLong((long)w), ((List)v$2.explodedEdge(nb, v$2.explodedEdge$default$2(), v$2.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$apply$14(ReducedVertex v) {
        block0: {
            ((EntityVisitor)((Object)v)).setState("triCounts", Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()));
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            scala.collection.immutable.Set neighbours = (scala.collection.immutable.Set)((EntityVisitor)((Object)v)).getState("effNeighbours", ((EntityVisitor)((Object)v)).getState$default$2());
            ((EntityVisitor)((Object)v)).clearState("effNeighbours");
            Seq queue = v.messageQueue();
            queue.foreach((Function1 & Serializable)x0$4 -> {
                LocalThreeNodeMotifs.$anonfun$apply$16(v, neighbours, x0$4);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ long $anonfun$apply$28(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ void $anonfun$apply$21(LocalThreeNodeMotifs $this, ReducedVertex v$3, GraphState state$1, List edges) {
        Tuple3 tuple3 = (Tuple3)edges.head();
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        long u = BoxesRunTime.unboxToLong((Object)tuple3._1());
        long w = BoxesRunTime.unboxToLong((Object)tuple3._2());
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(u, w);
        Tuple2.mcJJ.sp sp3 = sp2;
        long u2 = sp3._1$mcJ$sp();
        long w2 = sp3._2$mcJ$sp();
        List inputEdges = (List)((SeqOps)((IterableOps)((List)v$3.explodedEdge(u2, v$3.explodedEdge$default$2(), v$3.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))).$plus$plus((IterableOnce)((List)v$3.explodedEdge(w2, v$3.explodedEdge$default$2(), v$3.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))))).$plus$plus((IterableOnce)edges)).sortBy((Function1 & Serializable)x -> new Tuple3(x._3(), x._1(), x._2()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$));
        List ids = (List)((SeqOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)v$3.ID()), u2, w2}))).sortWith((Function2)(JFunction2.mcZJJ.sp & Serializable)(x$2, x$3) -> x$2 < x$3);
        TriadMotifCounter mc = new TriadMotifCounter(BoxesRunTime.unboxToLong((Object)ids.apply(0)), BoxesRunTime.unboxToLong((Object)ids.apply(1)), (Iterable<Object>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{BoxesRunTime.unboxToLong((Object)ids.apply(2))}))));
        mc.execute((List<Tuple3<Object, Object, Object>>)inputEdges, $this.delta);
        long[] curVal = (long[])((EntityVisitor)((Object)v$3)).getState("triCounts", ((EntityVisitor)((Object)v$3)).getState$default$2());
        ((EntityVisitor)((Object)v$3)).setState("triCounts", ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(curVal), (IterableOnce)Predef$.MODULE$.wrapLongArray(mc.getCounts()))), (Function1 & Serializable)x0$5 -> BoxesRunTime.boxToLong((long)LocalThreeNodeMotifs.$anonfun$apply$28(x0$5)), (ClassTag)ClassTag$.MODULE$.Long()));
        v$3.messageVertex(BoxesRunTime.boxToLong((long)u2), mc.getCounts(), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        v$3.messageVertex(BoxesRunTime.boxToLong((long)w2), mc.getCounts(), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        state$1.apply("triCounts").$plus$eq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(mc.getCounts()), (Function1)(JFunction1.mcJJ.sp & Serializable)x$4 -> x$4, (ClassTag)ClassTag$.MODULE$.Long()));
    }

    public static final /* synthetic */ void $anonfun$apply$20(LocalThreeNodeMotifs $this, ReducedVertex v, GraphState state) {
        block0: {
            if (BoxesRunTime.unboxToInt(((EntityVisitor)((Object)v)).getState("effectiveDegree", ((EntityVisitor)((Object)v)).getState$default$2())) < 2) break block0;
            v.messageQueue().foreach((Function1 & Serializable)edges -> {
                LocalThreeNodeMotifs.$anonfun$apply$21($this, v, state, edges);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ long $anonfun$apply$32(Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ void $anonfun$apply$31(ReducedVertex v$4, long[] toAdd) {
        long[] curVal = (long[])((EntityVisitor)((Object)v$4)).getState("triCounts", ((EntityVisitor)((Object)v$4)).getState$default$2());
        ((EntityVisitor)((Object)v$4)).setState("triCounts", ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps(curVal), (IterableOnce)Predef$.MODULE$.wrapLongArray(toAdd))), (Function1 & Serializable)x0$6 -> BoxesRunTime.boxToLong((long)LocalThreeNodeMotifs.$anonfun$apply$32(x0$6)), (ClassTag)ClassTag$.MODULE$.Long()));
    }

    public static final /* synthetic */ void $anonfun$apply$30(ReducedVertex v) {
        v.messageQueue().foreach((Function1 & Serializable)toAdd -> {
            LocalThreeNodeMotifs.$anonfun$apply$31(v, toAdd);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$apply$43(Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long x = tuple2._1$mcJ$sp();
        long y = tuple2._2$mcJ$sp();
        long l = x + y;
        return l;
    }

    public static final /* synthetic */ void $anonfun$apply$33(LocalThreeNodeMotifs $this, ReducedVertex v, GraphState state) {
        StarMotifCounter mc = new StarMotifCounter(BoxesRunTime.unboxToLong((Object)v.ID()), (Iterable<Object>)((Iterable)v.neighbours().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$5 -> x$5 != BoxesRunTime.unboxToLong((Object)v.ID()))));
        mc.execute((List<Tuple3<Object, Object, Object>>)((List)v.explodeAllEdges(v.explodeAllEdges$default$1(), v.explodeAllEdges$default$2()).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))).sortBy((Function1 & Serializable)x -> new Tuple3(x._3(), x._1(), x._2()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))), $this.delta);
        long[] counts = mc.getCounts();
        ObjectRef twoNodeCounts = ObjectRef.create((Object)((long[])Array$.MODULE$.fill(8, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long())));
        v.neighbours().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)vid -> {
            TwoNodeMotifs mc2node = new TwoNodeMotifs(BoxesRunTime.unboxToLong((Object)v.ID()));
            mc2node.execute((Tuple3[])((IterableOnceOps)((List)v.explodedEdge(vid, v.explodedEdge$default$2(), v.explodedEdge$default$3()).getOrElse((Function0 & Serializable)() -> (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$))).map((Function1 & Serializable)e -> new Tuple3(e.src(), e.dst(), (Object)BoxesRunTime.boxToLong((long)e.timestamp()))).sortBy((Function1 & Serializable)x -> new Tuple3(x._3(), x._1(), x._2()), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))).toArray(ClassTag$.MODULE$.apply(Tuple3.class)), $this.delta);
            long[] twoNC = mc2node.getCounts();
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.longArrayOps(counts)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                counts$1[i] = counts[i] - twoNC[i % 8];
            });
            twoNodeCounts$1.elem = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.longArrayOps((long[])twoNodeCounts$1.elem), (IterableOnce)Predef$.MODULE$.wrapLongArray(twoNC))), (Function1 & Serializable)x0$7 -> BoxesRunTime.boxToLong((long)LocalThreeNodeMotifs.$anonfun$apply$43(x0$7)), (ClassTag)ClassTag$.MODULE$.Long());
        });
        ((EntityVisitor)((Object)v)).setState("twoNodeCounts", (long[])twoNodeCounts.elem);
        state.apply("twoNodeCounts").$plus$eq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps((long[])twoNodeCounts.elem), (Function1)(JFunction1.mcJJ.sp & Serializable)x$6 -> x$6, (ClassTag)ClassTag$.MODULE$.Long()));
        ((EntityVisitor)((Object)v)).setState("starCounts", counts);
        state.apply("starCounts").$plus$eq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(counts), (Function1)(JFunction1.mcJJ.sp & Serializable)x$7 -> x$7, (ClassTag)ClassTag$.MODULE$.Long()));
    }

    public LocalThreeNodeMotifs(long delta, boolean graphWide, boolean prettyPrint) {
        this.delta = delta;
        this.graphWide = graphWide;
        this.prettyPrint = prettyPrint;
        BaseAlgorithm.$init$(this);
        GenericReduction.$init$(this);
    }
}

