/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.motif.ThreeNodeMotifs$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.Vertex;
import com.typesafe.scalalogging.Logger;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  *  {s}`ThreeNodeMotifs()`\n  *    : Count occurrences of three-node motifs that a node participates in.\n  *\n  *  The algorithm works by first counting star motifs, including potential triangles.\n  *  Then, for each star we send a message to one of the neighbours to identify the potential third edge.\n  *  Based on the responses, we correct the star counts and count the triangles.\n  *\n  *  ```{note}\n  *  Stars are only counted once as they only appear in the counts for the central vertex. However, triangles\n  *  appear for each of the 3 vertices, so the count for triangles should be divided by 3 when aggregating results to get\n  *  motif counts for the whole graph.\n  *  ```\n  *\n  *  ## Motifs\n  *\n  *  ### Stars\n  *\n  *    - 0: l <- c -> r\n  *    - 1: l -> c <- r\n  *    - 2: l -> c -> r\n  *    - 3: l -> c <-> r\n  *    - 4: l <- c <-> r\n  *    - 5: l <-> c <-> r\n  *\n  *  ### Triangles\n  *\n  *  (Index of star + third edge)\n  *    - 6: 0 + l -> r\n  *    - 7: 2 + l <- r\n  *    - 8: 3 + l -> r\n  *    - 9: 4 + l -> r\n  *    - 10: 4 + l <- r\n  *    - 11: 5 + l -> r\n  *    - 12: 5 + l <-> r\n  *\n  * ## States\n  *  {s}`motifCounts: Array[Long]`\n  *    : Motif counts stored as an array (see indices above)\n  *\n  * ## Returns\n  *\n  *  | vertex name       | Motif 0                   | ... | Motif 12                   |\n  *  | ----------------- | ------------------------- | --- | -------------------------- |\n  *  | {s}`name: String` | {s}`motifCounts(0): Long` | ... | {s}`motifCounts(12): Long` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dr!B\n\u0015\u0011\u0003yb!B\u0011\u0015\u0011\u0003\u0011\u0003\"B\u001a\u0002\t\u0003!\u0004bB\u001b\u0002\u0005\u0004%\tA\u000e\u0005\u0007u\u0005\u0001\u000b\u0011B\u001c\t\u000fm\n!\u0019!C\u0001m!1A(\u0001Q\u0001\n]Bq!P\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004?\u0003\u0001\u0006Ia\u000e\u0005\b\u007f\u0005\u0011\r\u0011\"\u00017\u0011\u0019\u0001\u0015\u0001)A\u0005o!9\u0011)\u0001b\u0001\n\u0003\u0011\u0005B\u0002(\u0002A\u0003%1\tC\u0004P\u0003\t\u0007I\u0011\u0001\"\t\rA\u000b\u0001\u0015!\u0003D\u0011\u0015\t\u0016\u0001\"\u0001S\u0011\u0015\u0019\u0017\u0001\"\u0011e\u0011\u0015\t\u0018\u0001\"\u0011s\u0011\u001dQ\u0018!!A\u0005\nm\fq\u0002\u00165sK\u0016tu\u000eZ3N_RLgm\u001d\u0006\u0003+Y\tQ!\\8uS\u001aT!a\u0006\r\u0002\u000f\u001d,g.\u001a:jG*\u0011\u0011DG\u0001\u000bC2<wN]5uQ6\u001c(BA\u000e\u001d\u0003!\u0011\u0018\r\u001d5u_JL(\"A\u000f\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005\u0001\nQ\"\u0001\u000b\u0003\u001fQC'/Z3O_\u0012,Wj\u001c;jMN\u001c2!A\u0012*!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fMB\u0011!&M\u0007\u0002W)\u0011A&L\u0001\nC2<wN]5uQ6T!AL\u0018\u0002\u0011\u0005t\u0017\r\\=tSNT!\u0001\r\u000e\u0002\u0007\u0005\u0004\u0018.\u0003\u00023W\t9q)\u001a8fe&\u001c\u0017A\u0002\u001fj]&$h\bF\u0001 \u0003%Ign\\;u\u000b\u0012<W-F\u00018!\t!\u0003(\u0003\u0002:K\t\u0019\u0011J\u001c;\u0002\u0015%tw.\u001e;FI\u001e,\u0007%A\u0004pkR,EmZ3\u0002\u0011=,H/\u00123hK\u0002\na!\u001b8FI\u001e,\u0017aB5o\u000b\u0012<W\rI\u0001\u0007]>,EmZ3\u0002\u000f9|W\tZ4fA\u0005q1\u000f^1s\u001b>$\u0018NZ%oI\u0016DX#A\"\u0011\t\u0011K5jN\u0007\u0002\u000b*\u0011aiR\u0001\nS6lW\u000f^1cY\u0016T!\u0001S\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002K\u000b\n\u0019Q*\u00199\u0011\t\u0011bugN\u0005\u0003\u001b\u0016\u0012a\u0001V;qY\u0016\u0014\u0014aD:uCJlu\u000e^5g\u0013:$W\r\u001f\u0011\u0002%Q\u0014\u0018.\u00198hY\u0016lu\u000e^5g\u0013:$W\r_\u0001\u0014iJL\u0017M\\4mK6{G/\u001b4J]\u0012,\u0007\u0010I\u0001\r?\u001e,G/\u00123hKRK\b/\u001a\u000b\u0003'f\u0003B\u0001\n+Wo%\u0011Q+\n\u0002\n\rVt7\r^5p]F\u0002\"aV1\u000f\u0005aKF\u0002\u0001\u0005\u00065>\u0001\raW\u0001\u0007m\u0016\u0014H/\u001a=\u0011\u0005q{V\"A/\u000b\u0005yk\u0013a\u0002<jg&$xN]\u0005\u0003Av\u0013aAV3si\u0016D\u0018B\u00012`\u0005\u0019IE\tV=qK\u0006)\u0011\r\u001d9msR\u0011Qm\u001a\t\u0003M>t!\u0001W4\t\u000b!\u0004\u0002\u0019A5\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\u0005)lW\"A6\u000b\u00051l\u0013!C4sCBDg/[3x\u0013\tq7N\u0001\tHe\u0006\u0004\b\u000eU3sgB,7\r^5wK&\u0011\u0001/\u001c\u0002\u0006\u000fJ\f\u0007\u000f[\u0001\u000bi\u0006\u0014W\u000f\\1sSN,GCA:z!\t!x/D\u0001v\u0015\t1X&A\u0003uC\ndW-\u0003\u0002yk\n)A+\u00192mK\")\u0001.\u0005a\u0001S\u0006aqO]5uKJ+\u0007\u000f\\1dKR\tA\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001\u00027b]\u001eT!!a\u0001\u0002\t)\fg/Y\u0005\u0004\u0003\u000fq(AB(cU\u0016\u001cG\u000fK\u0004\u0002\u0003\u0017\ty\"!\t\u0011\t\u00055\u00111D\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005A1oY1mC\u0012|7M\u0003\u0003\u0002\u0016\u0005]\u0011a\u0002;bW\u0016Tx.\u001a\u0006\u0004\u00033a\u0012AB4ji\",(-\u0003\u0003\u0002\u001e\u0005=!\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\u0005\r\u0012ac50U)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u0019+ie\u0016,gj\u001c3f\u001b>$\u0018NZ:)S\u0001T\u0001\u0005\t\u0016!A\u0001\u0002#\bI\"pk:$\be\\2dkJ\u0014XM\\2fg\u0002zg\r\t;ie\u0016,WF\\8eK\u0002jw\u000e^5gg\u0002\"\b.\u0019;!C\u0002rw\u000eZ3!a\u0006\u0014H/[2ja\u0006$Xm\u001d\u0011j]:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t+iK\u0002\nGnZ8sSRDW\u000eI<pe.\u001c\bEY=!M&\u00148\u000f\u001e\u0011d_VtG/\u001b8hAM$\u0018M\u001d\u0011n_RLgm\u001d\u0017!S:\u001cG.\u001e3j]\u001e\u0004\u0003o\u001c;f]RL\u0017\r\u001c\u0011ue&\fgn\u001a7fg:R\u0001\u0005\t\u0016!AQCWM\u001c\u0017!M>\u0014\b%Z1dQ\u0002\u001aH/\u0019:!o\u0016\u00043/\u001a8eA\u0005\u0004S.Z:tC\u001e,\u0007\u0005^8!_:,\u0007e\u001c4!i\",\u0007E\\3jO\"\u0014w.\u001e:tAQ|\u0007%\u001b3f]RLg-\u001f\u0011uQ\u0016\u0004\u0003o\u001c;f]RL\u0017\r\u001c\u0011uQ&\u0014H\rI3eO\u0016t#\u0002\t\u0011+A\u0001\u0012\u0015m]3eA=t\u0007\u0005\u001e5fAI,7\u000f]8og\u0016\u001cH\u0006I<fA\r|'O]3di\u0002\"\b.\u001a\u0011ti\u0006\u0014\beY8v]R\u001c\b%\u00198eA\r|WO\u001c;!i\",\u0007\u0005\u001e:jC:<G.Z:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003\r\u00191|]>$X- \u0006!A)\u0002\u0003e\u0015;beN\u0004\u0013M]3!_:d\u0017\u0010I2pk:$X\r\u001a\u0011p]\u000e,\u0007%Y:!i\",\u0017\u0010I8oYf\u0004\u0013\r\u001d9fCJ\u0004\u0013N\u001c\u0011uQ\u0016\u00043m\\;oiN\u0004cm\u001c:!i\",\u0007eY3oiJ\fG\u000e\t<feR,\u0007P\f\u0011I_^,g/\u001a:-AQ\u0014\u0018.\u00198hY\u0016\u001c(\u0002\t\u0011+A\u0001\n\u0007\u000f]3be\u00022wN\u001d\u0011fC\u000eD\u0007e\u001c4!i\",\u0007e\r\u0011wKJ$\u0018nY3tY\u0001\u001ax\u000e\t;iK\u0002\u001aw.\u001e8uA\u0019|'\u000f\t;sS\u0006tw\r\\3tAMDw.\u001e7eA\t,\u0007\u0005Z5wS\u0012,G\r\t2zAM\u0002s\u000f[3oA\u0005<wM]3hCRLgn\u001a\u0011sKN,H\u000e^:!i>\u0004s-\u001a;\u000bA\u0001R\u0003\u0005I7pi&4\u0007eY8v]R\u001c\bEZ8sAQDW\rI<i_2,\u0007e\u001a:ba\"t#\u0002\t\u0011+A\u0001\u0002\u0007\r\u0019\u0006!A)R\u0001\u0005\t\u0016!A\r\u001a\u0003%T8uS\u001a\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011$G\r\u00023\u000b^1sg*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005\t\u0011.AAR\u0004\u0005\u001c\u0011=[\u0001\u001a\u0007%\f !e*\u0001\u0003E\u000b\u0011!A\u0001j\u0003%\r\u001e!Y\u0002jc\bI2!y5\u0002#O\u0003\u0011!U\u0001\u0002\u0003\u0005I\u0017!ei\u0002C\u000eI\u0017?A\r\u0004SF\u0010\u0011s\u0015\u0001\u0002#\u0006\t\u0011!A5\u00023G\u000f\u0011mA5r\u0004e\u0019\u0011=[y\u0002#O\u0003\u0011!U\u0001\u0002\u0003\u0005I\u0017!ii\u0002C\u000e\t\u001f.A\r\u0004C(\f !e*\u0001\u0003E\u000b\u0011!A\u0001j\u0003%\u000e\u001e!Y\u0002bTF\u0010\u0011dAqjc\b\t:\u000bA\u0001R#\u0002\t\u0011+A\u0001\u001a3e\t\u0011Ue&\fgn\u001a7fg*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005K%oI\u0016D\be\u001c4!gR\f'\u000fI\u0016!i\"L'\u000f\u001a\u0011fI\u001e,\u0017F\u0003\u0011!U\u0001\u0002\u0003\u0005I\u0017!mi\u0002\u0003\u0007I\u0016!Y\u0002jc\b\t:\u000bA\u0001R\u0003\u0005\t\u0011![\u0001:$\b\t\u001a!W\u0001b\u0007\u0005P\u0017!e*\u0001\u0003E\u000b\u0011!A\u0001j\u0003\u0005\u000f\u001e!g\u0001Z\u0003\u0005\u001c\u0011.}\u0001\u0012(\u0002\t\u0011+A\u0001\u0002\u0003%\f\u0011:u\u0001\"\u0004e\u000b\u0011mA5r\u0004E\u001d\u0006!A)\u0002\u0003\u0005\t\u0011.AE\u0002$\b\t\u001b!W\u0001b\u0007\u0005P\u0017!e*\u0001\u0003E\u000b\u0011!A\u0001j\u0003%M\u0019;AU\u00023\u0006\t7![y\u0002#O\u0003\u0011!U\u0001\u0002\u0003\u0005I\u0017!cIR\u0004%\u000e\u0011,A1\u0004C(\f !e*\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011Ti\u0006$Xm\u001d\u0006!A)\u0002\u0003e_:~A6|G/\u001b4D_VtGo\u001d\u001e!\u0003J\u0014\u0018-_.M_:<W\f\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A5{G/\u001b4!G>,h\u000e^:!gR|'/\u001a3!CN\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010\t\u0015tK\u0016\u0004\u0013N\u001c3jG\u0016\u001c\b%\u00192pm\u0016L#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AI+G/\u001e:og*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005 \u0011wKJ$X\r\u001f\u0011oC6,\u0007\u0005\t\u0011!A\u0001\u0002C\u0010I'pi&4\u0007\u0005\r\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u0010\t\u0018/]\u0001b\b%T8uS\u001a\u0004\u0013G\r\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002CP\u0003\u0011!U\u0001\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b\b%L\u0017.Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b(\u0002\t\u0011+A\u0001b\be_:~A:\fW.\u001a\u001e!'R\u0014\u0018N\\4aAq\u00043p]?a[>$\u0018NZ\"pk:$8\u000f\u000b\u0019*u\u0001buN\\4aAq\u0004cF\f\u0018!y\u0002Z8/ 1n_RLgmQ8v]R\u001c\b&\r\u001a*u\u0001buN\\4aAqT\u0001\u0005\t\u00160Q\u001d\u0001\u00111BA\u0010\u0003C\u0001")
public final class ThreeNodeMotifs {
    public static Table tabularise(GraphPerspective graph) {
        return ThreeNodeMotifs$.MODULE$.tabularise(graph);
    }

    public static ConcreteGraphPerspective apply(GraphPerspective graph) {
        return ThreeNodeMotifs$.MODULE$.apply(graph);
    }

    public static Function1<Object, Object> _getEdgeType(Vertex vertex) {
        return ThreeNodeMotifs$.MODULE$._getEdgeType(vertex);
    }

    public static Map<Tuple2<Object, Object>, Object> triangleMotifIndex() {
        return ThreeNodeMotifs$.MODULE$.triangleMotifIndex();
    }

    public static Map<Tuple2<Object, Object>, Object> starMotifIndex() {
        return ThreeNodeMotifs$.MODULE$.starMotifIndex();
    }

    public static int noEdge() {
        return ThreeNodeMotifs$.MODULE$.noEdge();
    }

    public static int inEdge() {
        return ThreeNodeMotifs$.MODULE$.inEdge();
    }

    public static int outEdge() {
        return ThreeNodeMotifs$.MODULE$.outEdge();
    }

    public static int inoutEdge() {
        return ThreeNodeMotifs$.MODULE$.inoutEdge();
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return ThreeNodeMotifs$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return ThreeNodeMotifs$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static Generic $minus$greater(Generic other) {
        return ThreeNodeMotifs$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return ThreeNodeMotifs$.MODULE$.name();
    }

    public static Logger logger() {
        return ThreeNodeMotifs$.MODULE$.logger();
    }
}

