/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.motif.GlobalTriangleCount$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.typesafe.scalalogging.Logger;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`GlobalTriangleCount()`\n  *  : Returns the total number of undirected triangles in the graph.\n  *\n  * ## States\n  *\n  *  {s}`triangleCount: Int`\n  *    : the number of triangles in the graph (treated as undirected and simple).\n  *\n  * ## Returns\n  *\n  *  | total triangles          |\n  *  | ------------------------ |\n  *  | {s}`triangleCount: Int`  |\n  *\n  * ```{note}\n  *  Edges here are treated as undirected, so if the underlying network is directed here,\n  * 'neighbours' refers to the union of in-neighbours and out-neighbours.\n  * ``\n  */")
@ScalaSignature(bytes="\u0006\u0005\u001d;Q!\u0002\u0004\t\u0002E1Qa\u0005\u0004\t\u0002QAQ!G\u0001\u0005\u0002iAQaG\u0001\u0005BqAqAL\u0001\u0002\u0002\u0013%q&A\nHY>\u0014\u0017\r\u001c+sS\u0006tw\r\\3D_VtGO\u0003\u0002\b\u0011\u0005)Qn\u001c;jM*\u0011\u0011BC\u0001\bO\u0016tWM]5d\u0015\tYA\"\u0001\u0006bY\u001e|'/\u001b;i[NT!!\u0004\b\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011aD\u0001\u0004G>l7\u0001\u0001\t\u0003%\u0005i\u0011A\u0002\u0002\u0014\u000f2|'-\u00197Ue&\fgn\u001a7f\u0007>,h\u000e^\n\u0003\u0003U\u0001\"AF\f\u000e\u0003!I!\u0001\u0007\u0005\u0003\u0015\u001d\u0013\u0018\r\u001d5Ti\u0006$X-\u0001\u0004=S:LGO\u0010\u000b\u0002#\u0005)\u0011\r\u001d9msR\u0011Q\u0004\t\t\u0003=1r!a\b\u0011\r\u0001!)\u0011e\u0001a\u0001E\u0005)qM]1qQB\u00111EK\u0007\u0002I)\u0011QEJ\u0001\nOJ\f\u0007\u000f\u001b<jK^T!a\n\u0015\u0002\u0011\u0005t\u0017\r\\=tSNT!!\u000b\u0007\u0002\u0007\u0005\u0004\u0018.\u0003\u0002,I\t\u0001rI]1qQB+'o\u001d9fGRLg/Z\u0005\u0003[)\u0012Qa\u0012:ba\"\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\u0012\u0001\r\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA\u0001\\1oO*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005\u0019y%M[3di\"\"\u0011!O\"E!\tQ\u0014)D\u0001<\u0015\taT(\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\tqt(A\u0004uC.,'p\\3\u000b\u0005\u0001s\u0011AB4ji\",(-\u0003\u0002Cw\tA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001F\u0003\u0011esF\u000b\u0016\u000bA\u0001R\u0003e_:~A\u001ecwNY1m)JL\u0017M\\4mK\u000e{WO\u001c;)S\u0001T\u0001\u0005\t\u0016!Ai\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAQ|G/\u00197!]Vl'-\u001a:!_\u001a\u0004SO\u001c3je\u0016\u001cG/\u001a3!iJL\u0017M\\4mKN\u0004\u0013N\u001c\u0011uQ\u0016\u0004sM]1qQ:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!'R\fG/Z:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1ue&\fgn\u001a7f\u0007>,h\u000e\u001e\u001e!\u0013:$\bM\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!iJL\u0017M\\4mKN\u0004\u0013N\u001c\u0011uQ\u0016\u0004sM]1qQ\u0002BCO]3bi\u0016$\u0007%Y:!k:$\u0017N]3di\u0016$\u0007%\u00198eAMLW\u000e\u001d7fS9R\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!%\u0016$XO\u001d8t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002C\u0010\t;pi\u0006d\u0007\u0005\u001e:jC:<G.Z:!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001b(\u0002\t\u0011+A\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.AqT\u0001\u0005\t\u0016!Aq\u00043p]?aiJL\u0017M\\4mK\u000e{WO\u001c;;A%sG\u000f\u0019\u0011!y*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\r\u00191|]>$X- \u0006!A)\u0002\u0003%\u00123hKN\u0004\u0003.\u001a:fA\u0005\u0014X\r\t;sK\u0006$X\r\u001a\u0011bg\u0002*h\u000eZ5sK\u000e$X\r\u001a\u0017!g>\u0004\u0013N\u001a\u0011uQ\u0016\u0004SO\u001c3fe2L\u0018N\\4!]\u0016$xo\u001c:lA%\u001c\b\u0005Z5sK\u000e$X\r\u001a\u0011iKJ,GF\u0003\u0011!U\u0001:c.Z5hQ\n|WO]:(AI,g-\u001a:tAQ|\u0007\u0005\u001e5fAUt\u0017n\u001c8!_\u001a\u0004\u0013N\\\u0017oK&<\u0007NY8veN\u0004\u0013M\u001c3!_V$XF\\3jO\"\u0014w.\u001e:t])\u0001\u0003E\u000b\u0011aA*\u0001\u0003EK\u0018)\t\u0001I4\t\u0012")
public final class GlobalTriangleCount {
    public static ConcreteGraphPerspective apply(GraphPerspective graph) {
        return GlobalTriangleCount$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return GlobalTriangleCount$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return GlobalTriangleCount$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static Generic $minus$greater(Generic other) {
        return GlobalTriangleCount$.MODULE$.$minus$greater(other);
    }

    public static Table tabularise(GraphPerspective graph) {
        return GlobalTriangleCount$.MODULE$.tabularise(graph);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return GlobalTriangleCount$.MODULE$.name();
    }

    public static Logger logger() {
        return GlobalTriangleCount$.MODULE$.logger();
    }
}

