/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.distance;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.distance.ShortestPathDistance$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.ConcreteEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.utils.Bounded;
import com.raphtory.utils.Bounded$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`ShortestPathDistance(src_name: String, tgt_name: String, it: Int = 1000)`\n  *  : compute the shortest path distance from vertex `src_name` to vertex `tgt_name`\n  *\n  * This algorithm returns the distance of the shortest path going from vertex `src_name` to vertex `tgt_name`\n  * after at most `it` interations of the shortest path updates - default is `it=1000`.\n  *\n  * ## Parameters\n  *\n  *  {s}`src_name: String`\n  *    : the source vertex, where the path must start from.\n  *\n  *  {s}`tgt_name: String`\n  *    : the target vertex, where the path must end to.\n  *\n  * ## States\n  *\n  *  {s}`DISTANCE: T`\n  *    : Distance to source vertex\n  *\n  * ## Returns\n  *\n  *  |     source vertex     |      target vertex    |      distance    |\n  *  | --------------------- | --------------------- | -----------------|\n  *  | {s}`src_name: String` | {s}`tgt_name: String` | {s}`DISTANCE: T` |\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.dynamic.RandomWalk)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001\u0002\t\u0012\u0001qA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tu\u0001\u0011\t\u0011)A\u0005_!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005@\u0001\t\r\t\u0015a\u0003A\u0011!\t\u0006AaA!\u0002\u0017\u0011\u0006\"B.\u0001\t\u0003a\u0006bB3\u0001\u0005\u0004%)A\u001a\u0005\u0007S\u0002\u0001\u000bQB4\t\u000b)\u0004A\u0011I6\t\u000ba\u0004A\u0011I=\b\u0013\u0005}\u0011#!A\t\u0002\u0005\u0005b\u0001\u0003\t\u0012\u0003\u0003E\t!a\t\t\rmcA\u0011AA\u001b\u0011%\t9\u0004DI\u0001\n\u0003\tI\u0004C\u0005\u0002T1\t\t\u0011\"\u0003\u0002V\t!2\u000b[8si\u0016\u001cH\u000fU1uQ\u0012K7\u000f^1oG\u0016T!AE\n\u0002\u0011\u0011L7\u000f^1oG\u0016T!\u0001F\u000b\u0002\u000f\u001d,g.\u001a:jG*\u0011acF\u0001\u000bC2<wN]5uQ6\u001c(B\u0001\r\u001a\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\u000e\u0002\u0007\r|Wn\u0001\u0001\u0016\u0005uA5c\u0001\u0001\u001fIA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\u0004\"!\n\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\u0013\u0005dwm\u001c:ji\"l'BA\u0015+\u0003!\tg.\u00197zg&\u001c(BA\u0016\u0018\u0003\r\t\u0007/[\u0005\u0003[\u0019\u0012qaR3oKJL7-\u0001\u0005te\u000e|f.Y7f!\t\u0001tG\u0004\u00022kA\u0011!\u0007I\u0007\u0002g)\u0011AgG\u0001\u0007yI|w\u000e\u001e \n\u0005Y\u0002\u0013A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!A\u000e\u0011\u0002\u0011Q<Go\u00188b[\u0016\f!!\u001b;\u0011\u0005}i\u0014B\u0001 !\u0005\rIe\u000e^\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA!E\r6\t!I\u0003\u0002D/\u0005)Q\u000f^5mg&\u0011QI\u0011\u0002\b\u0005>,h\u000eZ3e!\t9\u0005\n\u0004\u0001\u0005\u000b%\u0003!\u0019\u0001&\u0003\u0003Q\u000b\"a\u0013(\u0011\u0005}a\u0015BA'!\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aH(\n\u0005A\u0003#aA!os\u0006QQM^5eK:\u001cW\r\n\u001a\u0011\u0007MCfI\u0004\u0002U-:\u0011!'V\u0005\u0002C%\u0011q\u000bI\u0001\ba\u0006\u001c7.Y4f\u0013\tI&LA\u0004Ok6,'/[2\u000b\u0005]\u0003\u0013A\u0002\u001fj]&$h\b\u0006\u0003^E\u000e$Gc\u00010aCB\u0019q\f\u0001$\u000e\u0003EAQa\u0010\u0004A\u0004\u0001CQ!\u0015\u0004A\u0004ICQA\f\u0004A\u0002=BQA\u000f\u0004A\u0002=Bqa\u000f\u0004\u0011\u0002\u0003\u0007A(\u0001\u0005E\u0013N#\u0016IT\"F+\u00059w\"\u00015\"\u0003\u0015\f\u0011\u0002R%T)\u0006s5)\u0012\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00051t\u0007CA7w\u001d\t9e\u000eC\u0003p\u0013\u0001\u0007\u0001/A\u0003he\u0006\u0004\b\u000e\u0005\u0002ri6\t!O\u0003\u0002tQ\u0005IqM]1qQZLWm^\u0005\u0003kJ\u0014\u0001c\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3\n\u0005]$(!B$sCBD\u0017A\u0003;bEVd\u0017M]5tKR\u0019!0!\u0001\u0011\u0005mtX\"\u0001?\u000b\u0005uD\u0013!\u0002;bE2,\u0017BA@}\u0005\u0015!\u0016M\u00197f\u0011\u0015y'\u00021\u0001qQ\u001d\u0001\u0011QAA\r\u00037\u0001B!a\u0002\u0002\u00165\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\u0011\ty!!\u0005\u0002\u000fQ\f7.\u001a>pK*\u0019\u00111C\r\u0002\r\u001dLG\u000f[;c\u0013\u0011\t9\"!\u0003\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#!!\b\u0002\u000f\u007f{#F\u000b\u0006!A)\u00023p]?a'\"|'\u000f^3tiB\u000bG\u000f\u001b#jgR\fgnY3)gJ\u001cwL\\1nKj\u00023\u000b\u001e:j]\u001ed\u0003\u0005^4u?:\fW.\u001a\u001e!'R\u0014\u0018N\\4-A%$(\bI%oi\u0002j\u0004%\r\u00191a%\u0002'\u0002\t\u0011+A\u0001R\u0004eY8naV$X\r\t;iK\u0002\u001a\bn\u001c:uKN$\b\u0005]1uQ\u0002\"\u0017n\u001d;b]\u000e,\u0007E\u001a:p[\u00022XM\u001d;fq\u0002\u00027O]2`]\u0006lW\r\u0019\u0011u_\u00022XM\u001d;fq\u0002\u0002Go\u001a;`]\u0006lW\r\u0019\u0006!A)R\u0001\u0005\t\u0016!)\"L7\u000fI1mO>\u0014\u0018\u000e\u001e5nAI,G/\u001e:og\u0002\"\b.\u001a\u0011eSN$\u0018M\\2fA=4\u0007\u0005\u001e5fAMDwN\u001d;fgR\u0004\u0003/\u0019;iA\u001d|\u0017N\\4!MJ|W\u000e\t<feR,\u0007\u0010\t1te\u000e|f.Y7fA\u0002\"x\u000e\t<feR,\u0007\u0010\t1uOR|f.Y7fA*\u0001\u0003E\u000b\u0011bMR,'\u000fI1uA5|7\u000f\u001e\u0011aSR\u0004\u0007%\u001b8uKJ\fG/[8og\u0002zg\r\t;iK\u0002\u001a\bn\u001c:uKN$\b\u0005]1uQ\u0002*\b\u000fZ1uKN\u0004S\u0006\t3fM\u0006,H\u000e\u001e\u0011jg\u0002\u0002\u0017\u000e^\u001f2aA\u0002\u0004M\f\u0006!A)R\u0001\u0005\t\u0016!G\r\u0002\u0003+\u0019:b[\u0016$XM]:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1te\u000e|f.Y7fu\u0001\u001aFO]5oO\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t;iK\u0002\u001ax.\u001e:dK\u00022XM\u001d;fq2\u0002s\u000f[3sK\u0002\"\b.\u001a\u0011qCRD\u0007%\\;ti\u0002\u001aH/\u0019:uA\u0019\u0014x.\u001c\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1uOR|f.Y7fu\u0001\u001aFO]5oO\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t;iK\u0002\"\u0018M]4fi\u00022XM\u001d;fq2\u0002s\u000f[3sK\u0002\"\b.\u001a\u0011qCRD\u0007%\\;ti\u0002*g\u000e\u001a\u0011u_:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!'R\fG/Z:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1E\u0013N#\u0016IT\"Fu\u0001\"\u0006M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!\t&\u001cH/\u00198dK\u0002\"x\u000eI:pkJ\u001cW\r\t<feR,\u0007P\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t?!A\u0001\u0002\u0003e]8ve\u000e,\u0007E^3si\u0016D\b\u0005\t\u0011!Aq\u0004\u0003\u0005\t\u0011!AQ\f'oZ3uAY,'\u000f^3yA\u0001\u0002\u0003\u0005 \u0011!A\u0001\u0002\u0003\u0005Z5ti\u0006t7-\u001a\u0011!A\u0001b(\u0002\t\u0011+A\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?![5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017}\u0015\u0001\u0002#\u0006\t\u0011}Am\u001cX\u0010Y:sG~s\u0017-\\3;AM#(/\u001b8hA\u0002b\be_:~AR<Go\u00188b[\u0016T\u0004e\u0015;sS:<\u0007\r\t?!wNl\b\rR%T)\u0006s5)\u0012\u001e!)\u0002\u0004CP\u0003\u0011!U)\u0001\u0003E\u000b\u0011aA\u0002\\8/Z3bYN|WP\u0003\u0011!U\u0001ZV\fK2p[:\u0012\u0018\r\u001d5u_JLh&\u00197h_JLG\u000f[7t]\u001d,g.\u001a:jG:\"\u0017P\\1nS\u000et#+\u00198e_6<\u0016\r\\6*\u0015\u0001\u0002#\u0006\t1aA*\u0001\u0003EK\u0018\u0002)MCwN\u001d;fgR\u0004\u0016\r\u001e5ESN$\u0018M\\2f!\tyFb\u0005\u0003\r=\u0005\u0015\u0002\u0003BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\u0003S>T!!a\f\u0002\t)\fg/Y\u0005\u0005\u0003g\tIC\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002\"\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*B!a\u000f\u0002RU\u0011\u0011Q\b\u0016\u0004y\u0005}2FAA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\u0003%\u0001\u0006b]:|G/\u0019;j_:LA!a\u0014\u0002F\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b%s!\u0019\u0001&\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005]\u0003\u0003BA-\u0003?j!!a\u0017\u000b\t\u0005u\u0013QF\u0001\u0005Y\u0006tw-\u0003\u0003\u0002b\u0005m#AB(cU\u0016\u001cG\u000f")
public class ShortestPathDistance<T>
implements Generic {
    private final String src_name;
    private final String tgt_name;
    private final int it;
    private final Bounded<T> evidence$1;
    private final Numeric<T> evidence$2;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static <T> int $lessinit$greater$default$3() {
        return ShortestPathDistance$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    public final String DISTANCE() {
        return "DISTANCE";
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)graphState -> {
            graphState.newMin("minDistance", this.evidence$2, this.evidence$1);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, graphState) -> {
            ShortestPathDistance.$anonfun$apply$2(this, vertex, graphState);
            return BoxedUnit.UNIT;
        }).iterate((Function2 & Serializable)(vertex, graphState) -> {
            ShortestPathDistance.$anonfun$apply$4(this, vertex, graphState);
            return BoxedUnit.UNIT;
        }, this.it, true);
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.explodeSelect((Function1<Vertex, IterableOnce<Row>>)(Function1 & Serializable)vertex -> {
            String name;
            String string = name = vertex.name(vertex.name$default$1());
            String string2 = $this.tgt_name;
            return !(string != null ? !string.equals(string2) : string2 != null) ? (IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{$this.src_name, name, ((EntityVisitor)((Object)vertex)).getState("DISTANCE", ((EntityVisitor)((Object)vertex)).getState$default$2())}))})) : package$.MODULE$.List().empty();
        });
    }

    public static final /* synthetic */ void $anonfun$apply$2(ShortestPathDistance $this, Vertex vertex, GraphState graphState) {
        String string = vertex.name(vertex.name$default$1());
        String string2 = $this.src_name;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            ((EntityVisitor)((Object)vertex)).setState("DISTANCE", BoxesRunTime.boxToInteger((int)0));
            vertex.outEdges().foreach((Function1 & Serializable)edge -> {
                edge.send(edge.weight($this.evidence$2));
                return BoxedUnit.UNIT;
            });
        } else {
            ((EntityVisitor)((Object)vertex)).setState("DISTANCE", Bounded$.MODULE$.MAX($this.evidence$1));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$5(ShortestPathDistance $this, Object candidate_distance$1, GraphState graphState$1, ConcreteEdge edge) {
        block0: {
            Object dummy = Numeric.Implicits$.MODULE$.infixNumericOps(candidate_distance$1, $this.evidence$2).$plus(edge.weight($this.evidence$2));
            if (!Ordering.Implicits$.MODULE$.infixOrderingOps(dummy, $this.evidence$2).$less$eq(graphState$1.apply("minDistance").value())) break block0;
            edge.send(dummy);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$4(ShortestPathDistance $this, Vertex vertex, GraphState graphState) {
        Object candidate_distance = vertex.messageQueue().min($this.evidence$2);
        if (Ordering.Implicits$.MODULE$.infixOrderingOps(candidate_distance, $this.evidence$2).$less$eq(((EntityVisitor)((Object)vertex)).getState("DISTANCE", ((EntityVisitor)((Object)vertex)).getState$default$2()))) {
            ((EntityVisitor)((Object)vertex)).setState("DISTANCE", candidate_distance);
            String string = vertex.name(vertex.name$default$1());
            String string2 = $this.tgt_name;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                graphState.apply("minDistance").$plus$eq(candidate_distance);
            } else {
                vertex.outEdges().foreach((Function1 & Serializable)edge -> {
                    ShortestPathDistance.$anonfun$apply$5($this, candidate_distance, graphState, edge);
                    return BoxedUnit.UNIT;
                });
            }
        } else {
            vertex.voteToHalt();
        }
    }

    public ShortestPathDistance(String src_name, String tgt_name, int it, Bounded<T> evidence$1, Numeric<T> evidence$2) {
        this.src_name = src_name;
        this.tgt_name = tgt_name;
        this.it = it;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

