/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NeighbourNames$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.typesafe.scalalogging.Logger;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`NeighbourNames()`\n  *  : Get name of all neighbours and store the map from vertexID to name in state \"neighbourNames\".\n  *\n  *  This is mainly useful as part of algorithms or chains that return neighbourhood or edge information.\n  *\n  * ## States\n  *\n  *  {s}`neighbourNames: Map[Long, String]`\n  *    : map of vertex ID to name for all neighbours of vertex\n  *\n  * ## Returns\n  *\n  *  This algorithm does not return anything.\n  *\n  *  ```{seealso}\n  *  [](com.raphtory.algorithms.generic.EdgeList)\n  *  [](com.raphtory.algorithms.temporal.TemporalEdgeList)\n  *  ```\n  */")
@ScalaSignature(bytes="\u0006\u00055;Q!\u0002\u0004\t\u0002=1Q!\u0005\u0004\t\u0002IAQaI\u0001\u0005\u0002\u0011BQ!J\u0001\u0005B\u0019Bq\u0001N\u0001\u0002\u0002\u0013%Q'\u0001\bOK&<\u0007NY8ve:\u000bW.Z:\u000b\u0005\u001dA\u0011aB4f]\u0016\u0014\u0018n\u0019\u0006\u0003\u0013)\t!\"\u00197h_JLG\u000f[7t\u0015\tYA\"\u0001\u0005sCBDGo\u001c:z\u0015\u0005i\u0011aA2p[\u000e\u0001\u0001C\u0001\t\u0002\u001b\u00051!A\u0004(fS\u001eD'm\\;s\u001d\u0006lWm]\n\u0004\u0003MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001bC5\t1D\u0003\u0002\u001d;\u0005I\u0011\r\\4pe&$\b.\u001c\u0006\u0003=}\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003A)\t1!\u00199j\u0013\t\u00113DA\u0004HK:,'/[2\u0002\rqJg.\u001b;?)\u0005y\u0011!B1qa2LHCA\u0014+!\tA#G\u0004\u0002*U1\u0001\u0001\"B\u0016\u0004\u0001\u0004a\u0013!B4sCBD\u0007CA\u00171\u001b\u0005q#BA\u0018\u001e\u0003%9'/\u00199im&,w/\u0003\u00022]\t\u0001rI]1qQB+'o\u001d9fGRLg/Z\u0005\u0003gA\u0012Qa\u0012:ba\"\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\u0012A\u000e\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\nA\u0001\\1oO*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u0005\u0019y%M[3di\"\"\u0011aP%K!\t\u0001u)D\u0001B\u0015\t\u00115)\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\t!U)A\u0004uC.,'p\\3\u000b\u0005\u0019c\u0011AB4ji\",(-\u0003\u0002I\u0003\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001L\u0003\u0011=uF\u000b\u0016\u000bA\u0001R\u0003e_:~A:+\u0017n\u001a5c_V\u0014h*Y7fg\"J\u0003M\u0003\u0011!U\u0001\u0002#\bI$fi\u0002r\u0017-\\3!_\u001a\u0004\u0013\r\u001c7!]\u0016Lw\r\u001b2pkJ\u001c\b%\u00198eAM$xN]3!i\",\u0007%\\1qA\u0019\u0014x.\u001c\u0011wKJ$X\r_%EAQ|\u0007E\\1nK\u0002Jg\u000eI:uCR,\u0007E\t8fS\u001eD'm\\;s\u001d\u0006lWm\u001d\u0012/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002C\u000b[5tA%\u001c\b%\\1j]2L\b%^:fMVd\u0007%Y:!a\u0006\u0014H\u000fI8gA\u0005dwm\u001c:ji\"l7\u000fI8sA\rD\u0017-\u001b8tAQD\u0017\r\u001e\u0011sKR,(O\u001c\u0011oK&<\u0007NY8ve\"|w\u000e\u001a\u0011pe\u0002*GmZ3!S:4wN]7bi&|gN\f\u0006!A)R\u0001\u0005\t\u0016!G\r\u00023\u000b^1uKNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002tW-[4iE>,(OT1nKNT\u0004%T1q72{gn\u001a\u0017!'R\u0014\u0018N\\4^A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004%\\1qA=4\u0007E^3si\u0016D\b%\u0013#!i>\u0004c.Y7fA\u0019|'\u000fI1mY\u0002rW-[4iE>,(o\u001d\u0011pM\u00022XM\u001d;fq*\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011SKR,(O\\:\u000bA\u0001R#\u0002\t\u0011+A\u0001\"\u0006.[:!C2<wN]5uQ6\u0004Cm\\3tA9|G\u000f\t:fiV\u0014h\u000eI1osRD\u0017N\\4/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003\r\u00191|g\u0016,\u0017\r\\:p{*\u0001\u0003E\u000b\u0011!7vC3m\\7/e\u0006\u0004\b\u000e^8ss:\nGnZ8sSRDWn\u001d\u0018hK:,'/[2/\u000b\u0012<W\rT5ti&R\u0001\u0005\t\u0016!Amk\u0006fY8n]I\f\u0007\u000f\u001b;peft\u0013\r\\4pe&$\b.\\:/i\u0016l\u0007o\u001c:bY:\"V-\u001c9pe\u0006dW\tZ4f\u0019&\u001cH/\u000b\u0006!A)\u0002\u0003\u0005\u00191a\u0015\u0001\u0002#f\f\u0015\u0005\u0001}J%\n")
public final class NeighbourNames {
    public static ConcreteGraphPerspective apply(GraphPerspective graph) {
        return NeighbourNames$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return NeighbourNames$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return NeighbourNames$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static Generic $minus$greater(Generic other) {
        return NeighbourNames$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return NeighbourNames$.MODULE$.name();
    }

    @Scaladoc(value="/** Write out results to a table (this method is only called after `apply`)\n    *\n    * The default implementation returns an empty table\n    *\n    * @param graph Graph that results from the call to `apply`\n    */")
    public static Table tabularise(GraphPerspective graph) {
        return NeighbourNames$.MODULE$.tabularise(graph);
    }

    public static Logger logger() {
        return NeighbourNames$.MODULE$.logger();
    }
}

