/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.MaxFlow$;
import com.raphtory.algorithms.generic.MaxFlow$FlowAdded$;
import com.raphtory.algorithms.generic.MaxFlow$NewLabel$;
import com.raphtory.algorithms.generic.MaxFlow$Recheck$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.ConcreteEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.raphtory.utils.ExtendedNumeric$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@Scaladoc(value="/** {s}`MaxFlow[T](source: String, target: String, capacityLabel: String = \"weight\", maxIterations: Int = Int.MaxValue)`\n  *   : Finds the maximum flow (equivalently, the minimum cut) between a source and a target vertex\n  *\n  *   Implements the parallel push-relabel max-flow algorithm of Goldberg and Tarjan. [^ref]\n  *\n  * ## Parameters\n  *  {s}`T: Numeric`\n  *    : Type of edge weight attribute (needs to be specified as not possible to infer automatically)\n  *\n  *  {s}`source: String`\n  *    : name of source vertex\n  *\n  *  {s}`target: String`\n  *    : name of target vertex\n  *\n  *  {s}`capacityLabel: String = \"weight\"`\n  *    : Edge attribute key to use for computing capacities. Capacities are computed as the sum of weights over occurrences\n  *      of the edge. If the edge property does not exist, weight is computed as the edge count.\n  *\n  *   {s}`maxIterations: Int = Int.MaxValue`\n  *    : terminate the algorithm if it has not converged after {s}`maxIterations` pulses (note that the flow will be\n  *      incorrect if this happens)\n  *\n  *  ## States\n  *\n  *  {s}`flow: mutable.Map[Long, T]`\n  *    : Map of {s}`targetID -> flow`  for outflow at vertex (negative values are backflow used by the algorithm)\n  *\n  *  {s}`excess: T`\n  *    : excess flow at vertex (should be 0 except for source and target after algorithm converged)\n  *\n  *  {s}`distanceLabel: Int`\n  *    : vertex label used by the algorithm to decide where to push flow\n  *\n  *  {s}`neighbourLabels: mutable.Map[Long, Int]`\n  *    : Map of {s}`targetID -> label` containing the distance labels for the vertexes neighbours\n  *\n  *  ## Returns\n  *\n  *  | Maximum Flow |\n  *  | ------------ |\n  *  | {s}`flow: T` |\n  *\n  *  ```{note}\n  *  The algorithm returns a single line with the value of the maximum flow between the source and target.\n  *  ```\n  *\n  * [^ref]: [A new approach to the Maximum-Flow Problem](http://akira.ruc.dk/~keld/teaching/algoritmedesign_f03/Artikler/08/Goldberg88.pdf)\n  */")
@ScalaSignature(bytes="\u0006\u0005\r\u0005e\u0001B+W\u0001}C\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u001d\u0005\t{\u0002\u0011\t\u0011)A\u0005e\"Aa\u0010\u0001B\u0001B\u0003%!\u000fC\u0005\u0000\u0001\t\u0005\t\u0015!\u0003\u0002\u0002!Q\u0011q\u0001\u0001\u0003\u0002\u0003\u0006Y!!\u0003\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0003bBA1\u0001\u0011\u0005\u00131\r\u0004\n\u0003g\u0002\u0001\u0013aI\u0011\u0003k2a!a \u0001\u0001\u0006\u0005\u0005\"C9\u000b\u0005+\u0007I\u0011AAM\u0011)\tYJ\u0003B\tB\u0003%\u0011\u0011\u0012\u0005\u000b\u0003;S!Q3A\u0005\u0002\u0005}\u0005BCAQ\u0015\tE\t\u0015!\u0003\u0002\u001c!9\u0011\u0011\u0007\u0006\u0005\u0002\u0005\r\u0006\"CAV\u0015\u0005\u0005I\u0011AAW\u0011%\tYLCI\u0001\n\u0003\ti\fC\u0005\u0002X*\t\n\u0011\"\u0001\u0002Z\"I\u0011\u0011\u001d\u0006\u0002\u0002\u0013\u0005\u00131\u001d\u0005\n\u0003gT\u0011\u0011!C\u0001\u0003kD\u0011\"a>\u000b\u0003\u0003%\t!!?\t\u0013\u0005}(\"!A\u0005B\t\u0005\u0001\"\u0003B\b\u0015\u0005\u0005I\u0011\u0001B\t\u0011%\u0011YBCA\u0001\n\u0003\u0012i\u0002C\u0005\u0003\")\t\t\u0011\"\u0011\u0003$!I!Q\u0005\u0006\u0002\u0002\u0013\u0005#q\u0005\u0005\n\u0005SQ\u0011\u0011!C!\u0005W9\u0011B!)\u0001\u0003\u0003E\tAa)\u0007\u0013\u0005}\u0004!!A\t\u0002\t\u0015\u0006bBA\u0019;\u0011\u0005!\u0011\u0017\u0005\n\u0005Ki\u0012\u0011!C#\u0005OA\u0011\"!\u0012\u001e\u0003\u0003%\tIa-\t\u0013\t\u0005W$!A\u0005\u0002\n\rgA\u0002B\u0018\u0001\u0001\u0013\t\u0004C\u0005rE\tU\r\u0011\"\u0001\u0003<!Q\u00111\u0014\u0012\u0003\u0012\u0003\u0006IAa\u000e\t\u0015\tu\"E!f\u0001\n\u0003\t)\u0010\u0003\u0006\u0003@\t\u0012\t\u0012)A\u0005\u0003\u0003Aq!!\r#\t\u0003\u0011\t\u0005C\u0005\u0002,\n\n\t\u0011\"\u0001\u0003J!I\u00111\u0018\u0012\u0012\u0002\u0013\u0005!q\u000b\u0005\n\u0003/\u0014\u0013\u0013!C\u0001\u0005?B\u0011\"!9#\u0003\u0003%\t%a9\t\u0013\u0005M(%!A\u0005\u0002\u0005U\b\"CA|E\u0005\u0005I\u0011\u0001B4\u0011%\tyPIA\u0001\n\u0003\u0012\t\u0001C\u0005\u0003\u0010\t\n\t\u0011\"\u0001\u0003l!I!1\u0004\u0012\u0002\u0002\u0013\u0005#q\u000e\u0005\n\u0005C\u0011\u0013\u0011!C!\u0005GA\u0011B!\n#\u0003\u0003%\tEa\n\t\u0013\t%\"%!A\u0005B\tMt!\u0003Bo\u0001\u0005\u0005\t\u0012\u0001Bp\r%\u0011y\u0003AA\u0001\u0012\u0003\u0011\t\u000fC\u0004\u00022U\"\tAa9\t\u0013\t\u0015R'!A\u0005F\t\u001d\u0002\"CA#k\u0005\u0005I\u0011\u0011Bs\u0011%\u0011\t-NA\u0001\n\u0003\u0013\u0019P\u0002\u0004\u0003x\u0001\u0001%\u0011\u0010\u0005\b\u0003cQD\u0011\u0001BB\u0011%\tYKOA\u0001\n\u0003\u00119\tC\u0005\u0002bj\n\t\u0011\"\u0011\u0002d\"I\u00111\u001f\u001e\u0002\u0002\u0013\u0005\u0011Q\u001f\u0005\n\u0003oT\u0014\u0011!C\u0001\u0005#C\u0011\"a@;\u0003\u0003%\tE!\u0001\t\u0013\t=!(!A\u0005\u0002\tU\u0005\"\u0003B\u000eu\u0005\u0005I\u0011\tBM\u0011%\u0011\tCOA\u0001\n\u0003\u0012\u0019\u0003C\u0005\u0003&i\n\t\u0011\"\u0011\u0003(!I!\u0011\u0006\u001e\u0002\u0002\u0013\u0005#QT\u0004\n\u0007\u0007\u0001\u0011\u0011!E\u0001\u0007\u000b1\u0011Ba\u001e\u0001\u0003\u0003E\taa\u0002\t\u000f\u0005Er\t\"\u0001\u0004\n!I!QE$\u0002\u0002\u0013\u0015#q\u0005\u0005\n\u0003\u000b:\u0015\u0011!CA\u0007\u0017A\u0011B!1H\u0003\u0003%\ti!\u0006\b\u000f\rmb\u000b#\u0001\u0004>\u00191QK\u0016E\u0001\u0007\u007fAq!!\rN\t\u0003\u0019\t\u0005C\u0004\u0002F5#\taa\u0011\t\u0013\rmS*%A\u0005\u0002\ru\u0003\"CB3\u001bF\u0005I\u0011AB4\u0011%\u0019Y'TI\u0001\n\u0003\u0019i\u0007C\u0005\u0004r5\u000b\n\u0011\"\u0001\u0004t!I1qO'\u0002\u0002\u0013%1\u0011\u0010\u0002\b\u001b\u0006Dh\t\\8x\u0015\t9\u0006,A\u0004hK:,'/[2\u000b\u0005eS\u0016AC1mO>\u0014\u0018\u000e\u001e5ng*\u00111\fX\u0001\te\u0006\u0004\b\u000e^8ss*\tQ,A\u0002d_6\u001c\u0001!F\u0002a\u0003?\u00192\u0001A1h!\t\u0011W-D\u0001d\u0015\u0005!\u0017!B:dC2\f\u0017B\u00014d\u0005\u0019\te.\u001f*fMB\u0011\u0001n\\\u0007\u0002S*\u0011!n[\u0001\nC2<wN]5uQ6T!\u0001\\7\u0002\u0011\u0005t\u0017\r\\=tSNT!A\u001c.\u0002\u0007\u0005\u0004\u0018.\u0003\u0002qS\n9q)\u001a8fe&\u001c\u0017AB:pkJ\u001cW\r\u0005\u0002tu:\u0011A\u000f\u001f\t\u0003k\u000el\u0011A\u001e\u0006\u0003oz\u000ba\u0001\u0010:p_Rt\u0014BA=d\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\u001c\u0017A\u0002;be\u001e,G/A\u0007dCB\f7-\u001b;z\u0019\u0006\u0014W\r\\\u0001\u000e[\u0006D\u0018\n^3sCRLwN\\:\u0011\u0007\t\f\u0019!C\u0002\u0002\u0006\r\u00141!\u00138u\u0003\u001dqW/\\3sS\u000e\u0004b!a\u0003\u0002\u0016\u0005ma\u0002BA\u0007\u0003#q1!^A\b\u0013\u0005!\u0017bAA\nG\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\f\u00033\u0011qAT;nKJL7MC\u0002\u0002\u0014\r\u0004B!!\b\u0002 1\u0001AaBA\u0011\u0001\t\u0007\u00111\u0005\u0002\u0002)F!\u0011QEA\u0016!\r\u0011\u0017qE\u0005\u0004\u0003S\u0019'a\u0002(pi\"Lgn\u001a\t\u0004E\u00065\u0012bAA\u0018G\n\u0019\u0011I\\=\u0002\rqJg.\u001b;?))\t)$!\u0010\u0002@\u0005\u0005\u00131\t\u000b\u0005\u0003o\tY\u0004E\u0003\u0002:\u0001\tY\"D\u0001W\u0011\u001d\t9A\u0002a\u0002\u0003\u0013AQ!\u001d\u0004A\u0002IDQ! \u0004A\u0002IDqA \u0004\u0011\u0002\u0003\u0007!\u000f\u0003\u0005\u0000\rA\u0005\t\u0019AA\u0001\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\tI%!\u0014\u0011\t\u0005-\u0013Q\f\b\u0005\u0003;\ti\u0005C\u0004\u0002P\u001d\u0001\r!!\u0015\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\t\u0005M\u0013\u0011L\u0007\u0003\u0003+R1!a\u0016l\u0003%9'/\u00199im&,w/\u0003\u0003\u0002\\\u0005U#\u0001E$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f\u0013\u0011\ty&!\u0017\u0003\u000b\u001d\u0013\u0018\r\u001d5\u0002\u0015Q\f'-\u001e7be&\u001cX\r\u0006\u0003\u0002f\u0005E\u0004\u0003BA4\u0003[j!!!\u001b\u000b\u0007\u0005-4.A\u0003uC\ndW-\u0003\u0003\u0002p\u0005%$!\u0002+bE2,\u0007bBA(\u0011\u0001\u0007\u0011\u0011\u000b\u0002\b\u001b\u0016\u001c8/Y4f+\u0011\t9(!\u001f\u0014\u0005%\tGaBA>\u0013\t\u0007\u00111\u0005\u0002\t-\u0016\u0014H/\u001a=J\t&\"\u0011B\u0003\u0012;\u0005%1En\\<BI\u0012,G-\u0006\u0003\u0002\u0004\u0006-5\u0003\u0003\u0006b\u0003\u000b\u000bi)a%\u0011\u000b\u0005\u001d\u0015\"!#\u000e\u0003\u0001\u0001B!!\b\u0002\f\u00129\u00111\u0010\u0006C\u0002\u0005\r\u0002c\u00012\u0002\u0010&\u0019\u0011\u0011S2\u0003\u000fA\u0013x\u000eZ;diB!\u00111BAK\u0013\u0011\t9*!\u0007\u0003\u0019M+'/[1mSj\f'\r\\3\u0016\u0005\u0005%\u0015aB:pkJ\u001cW\rI\u0001\u0006m\u0006dW/Z\u000b\u0003\u00037\taA^1mk\u0016\u0004CCBAS\u0003O\u000bI\u000bE\u0003\u0002\b*\tI\t\u0003\u0004r\u001f\u0001\u0007\u0011\u0011\u0012\u0005\b\u0003;{\u0001\u0019AA\u000e\u0003\u0011\u0019w\u000e]=\u0016\t\u0005=\u0016Q\u0017\u000b\u0007\u0003c\u000b9,!/\u0011\u000b\u0005\u001d%\"a-\u0011\t\u0005u\u0011Q\u0017\u0003\b\u0003w\u0002\"\u0019AA\u0012\u0011!\t\b\u0003%AA\u0002\u0005M\u0006\"CAO!A\u0005\t\u0019AA\u000e\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*B!a0\u0002VV\u0011\u0011\u0011\u0019\u0016\u0005\u0003\u0013\u000b\u0019m\u000b\u0002\u0002FB!\u0011qYAi\u001b\t\tIM\u0003\u0003\u0002L\u00065\u0017!C;oG\",7m[3e\u0015\r\tymY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAj\u0003\u0013\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u001d\tY(\u0005b\u0001\u0003G\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0003\u0002\\\u0006}WCAAoU\u0011\tY\"a1\u0005\u000f\u0005m$C1\u0001\u0002$\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!:\u0011\t\u0005\u001d\u0018\u0011_\u0007\u0003\u0003STA!a;\u0002n\u0006!A.\u00198h\u0015\t\ty/\u0001\u0003kCZ\f\u0017bA>\u0002j\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011A\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY#a?\t\u0013\u0005uX#!AA\u0002\u0005\u0005\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0004A1!Q\u0001B\u0006\u0003Wi!Aa\u0002\u000b\u0007\t%1-\u0001\u0006d_2dWm\u0019;j_:LAA!\u0004\u0003\b\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\u0019B!\u0007\u0011\u0007\t\u0014)\"C\u0002\u0003\u0018\r\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002~^\t\t\u00111\u0001\u0002,\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t)Oa\b\t\u0013\u0005u\b$!AA\u0002\u0005\u0005\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u0005\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0003\u0014\t5\u0002\"CA\u007f7\u0005\u0005\t\u0019AA\u0016\u0005!qUm\u001e'bE\u0016dW\u0003\u0002B\u001a\u0005s\u0019\u0002BI1\u00036\u00055\u00151\u0013\t\u0006\u0003\u000fK!q\u0007\t\u0005\u0003;\u0011I\u0004B\u0004\u0002|\t\u0012\r!a\t\u0016\u0005\t]\u0012!\u00027bE\u0016d\u0017A\u00027bE\u0016d\u0007\u0005\u0006\u0004\u0003D\t\u0015#q\t\t\u0006\u0003\u000f\u0013#q\u0007\u0005\u0007c\u001e\u0002\rAa\u000e\t\u000f\tur\u00051\u0001\u0002\u0002U!!1\nB))\u0019\u0011iEa\u0015\u0003VA)\u0011q\u0011\u0012\u0003PA!\u0011Q\u0004B)\t\u001d\tY\b\u000bb\u0001\u0003GA\u0001\"\u001d\u0015\u0011\u0002\u0003\u0007!q\n\u0005\n\u0005{A\u0003\u0013!a\u0001\u0003\u0003)BA!\u0017\u0003^U\u0011!1\f\u0016\u0005\u0005o\t\u0019\rB\u0004\u0002|%\u0012\r!a\t\u0016\t\t\u0005$QM\u000b\u0003\u0005GRC!!\u0001\u0002D\u00129\u00111\u0010\u0016C\u0002\u0005\rB\u0003BA\u0016\u0005SB\u0011\"!@.\u0003\u0003\u0005\r!!\u0001\u0015\t\tM!Q\u000e\u0005\n\u0003{|\u0013\u0011!a\u0001\u0003W!B!!:\u0003r!I\u0011Q \u0019\u0002\u0002\u0003\u0007\u0011\u0011\u0001\u000b\u0005\u0005'\u0011)\bC\u0005\u0002~N\n\t\u00111\u0001\u0002,\t9!+Z2iK\u000e\\W\u0003\u0002B>\u0005\u0003\u001b\u0002BO1\u0003~\u00055\u00151\u0013\t\u0006\u0003\u000fK!q\u0010\t\u0005\u0003;\u0011\t\tB\u0004\u0002|i\u0012\r!a\t\u0015\u0005\t\u0015\u0005#BADu\t}T\u0003\u0002BE\u0005\u001f#\"Aa#\u0011\u000b\u0005\u001d%H!$\u0011\t\u0005u!q\u0012\u0003\b\u0003wb$\u0019AA\u0012)\u0011\tYCa%\t\u0013\u0005ux(!AA\u0002\u0005\u0005A\u0003\u0002B\n\u0005/C\u0011\"!@B\u0003\u0003\u0005\r!a\u000b\u0015\t\u0005\u0015(1\u0014\u0005\n\u0003{\u0014\u0015\u0011!a\u0001\u0003\u0003!BAa\u0005\u0003 \"I\u0011Q`#\u0002\u0002\u0003\u0007\u00111F\u0001\n\r2|w/\u00113eK\u0012\u00042!a\"\u001e'\u0011i\u0012Ma*\u0011\t\t%&qV\u0007\u0003\u0005WSAA!,\u0002n\u0006\u0011\u0011n\\\u0005\u0005\u0003/\u0013Y\u000b\u0006\u0002\u0003$V!!Q\u0017B^)\u0019\u00119L!0\u0003@B)\u0011q\u0011\u0006\u0003:B!\u0011Q\u0004B^\t\u001d\tY\b\tb\u0001\u0003GAa!\u001d\u0011A\u0002\te\u0006bBAOA\u0001\u0007\u00111D\u0001\bk:\f\u0007\u000f\u001d7z+\u0011\u0011)M!6\u0015\t\t\u001d'q\u001b\t\u0006E\n%'QZ\u0005\u0004\u0005\u0017\u001c'AB(qi&|g\u000eE\u0004c\u0005\u001f\u0014\u0019.a\u0007\n\u0007\tE7M\u0001\u0004UkBdWM\r\t\u0005\u0003;\u0011)\u000eB\u0004\u0002|\u0005\u0012\r!a\t\t\u0013\te\u0017%!AA\u0002\tm\u0017a\u0001=%aA)\u0011q\u0011\u0006\u0003T\u0006Aa*Z<MC\n,G\u000eE\u0002\u0002\bV\u001aB!N1\u0003(R\u0011!q\\\u000b\u0005\u0005O\u0014i\u000f\u0006\u0004\u0003j\n=(\u0011\u001f\t\u0006\u0003\u000f\u0013#1\u001e\t\u0005\u0003;\u0011i\u000fB\u0004\u0002|a\u0012\r!a\t\t\rED\u0004\u0019\u0001Bv\u0011\u001d\u0011i\u0004\u000fa\u0001\u0003\u0003)BA!>\u0003~R!!q\u001fB\u0000!\u0015\u0011'\u0011\u001aB}!\u001d\u0011'q\u001aB~\u0003\u0003\u0001B!!\b\u0003~\u00129\u00111P\u001dC\u0002\u0005\r\u0002\"\u0003Bms\u0005\u0005\t\u0019AB\u0001!\u0015\t9I\tB~\u0003\u001d\u0011Vm\u00195fG.\u00042!a\"H'\u00119\u0015Ma*\u0015\u0005\r\u0015Q\u0003BB\u0007\u0007'!\"aa\u0004\u0011\u000b\u0005\u001d%h!\u0005\u0011\t\u0005u11\u0003\u0003\b\u0003wR%\u0019AA\u0012+\u0011\u00199ba\b\u0015\t\tM1\u0011\u0004\u0005\n\u00053\\\u0015\u0011!a\u0001\u00077\u0001R!a\";\u0007;\u0001B!!\b\u0004 \u00119\u00111P&C\u0002\u0005\r\u0002f\u0002\u0001\u0004$\u0005u5q\u0007\t\u0005\u0007K\u0019\u0019$\u0004\u0002\u0004()!1\u0011FB\u0016\u0003!\u00198-\u00197bI>\u001c'\u0002BB\u0017\u0007_\tq\u0001^1lKj|WMC\u0002\u00042q\u000baaZ5uQV\u0014\u0017\u0002BB\u001b\u0007O\u0011\u0001bU2bY\u0006$wnY\u0011\u0003\u0007s\tqRP\u0018+U\u0001Z8/ 1NCb4En\\<\\)vC3o\\;sG\u0016T\u0004e\u0015;sS:<G\u0006\t;be\u001e,GO\u000f\u0011TiJLgn\u001a\u0017!G\u0006\u0004\u0018mY5us2\u000b'-\u001a7;AM#(/\u001b8hAu\u0002#e^3jO\"$(\u0005\f\u0011nCbLE/\u001a:bi&|gn\u001d\u001e!\u0013:$\b%\u0010\u0011J]RtS*\u0019=WC2,X-\u000b1\u000bA\u0001R\u0003\u0005\t\u0011;A\u0019Kg\u000eZ:!i\",\u0007%\\1yS6,X\u000e\t4m_^\u0004\u0003&Z9vSZ\fG.\u001a8uYfd\u0003\u0005\u001e5fA5Lg.[7v[\u0002\u001aW\u000f^\u0015!E\u0016$x/Z3oA\u0005\u00043o\\;sG\u0016\u0004\u0013M\u001c3!C\u0002\"\u0018M]4fi\u00022XM\u001d;fq*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005I%na2,W.\u001a8ug\u0002\"\b.\u001a\u0011qCJ\fG\u000e\\3mAA,8\u000f[\u0017sK2\f'-\u001a7![\u0006DXF\u001a7po\u0002\nGnZ8sSRDW\u000eI8gA\u001d{G\u000e\u001a2fe\u001e\u0004\u0013M\u001c3!)\u0006\u0014(.\u00198/Ams&/\u001a4^\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t)be\u0006lW\r^3sg*\u0001\u0003E\u000b\u0011!wNl\b\r\u0016\u001e!\u001dVlWM]5dA*\u0001\u0003E\u000b\u0011!A\u0001R\u0004\u0005V=qK\u0002zg\rI3eO\u0016\u0004s/Z5hQR\u0004\u0013\r\u001e;sS\n,H/\u001a\u0011)]\u0016,Gm\u001d\u0011u_\u0002\u0012W\rI:qK\u000eLg-[3eA\u0005\u001c\bE\\8uAA|7o]5cY\u0016\u0004Co\u001c\u0011j]\u001a,'\u000fI1vi>l\u0017\r^5dC2d\u00170\u000b\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y:pkJ\u001cWM\u000f\u0011TiJLgn\u001a1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001r\u0017-\\3!_\u001a\u00043o\\;sG\u0016\u0004c/\u001a:uKbT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002$\u0018M]4fij\u00023\u000b\u001e:j]\u001e\u0004'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011oC6,\u0007e\u001c4!i\u0006\u0014x-\u001a;!m\u0016\u0014H/\u001a=\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1dCB\f7-\u001b;z\u0019\u0006\u0014W\r\u001c\u001e!'R\u0014\u0018N\\4!{\u0001\u0012s/Z5hQR\u0014\u0003M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!\u000b\u0012<W\rI1uiJL'-\u001e;fA-,\u0017\u0010\t;pAU\u001cX\r\t4pe\u0002\u001aw.\u001c9vi&tw\rI2ba\u0006\u001c\u0017\u000e^5fg:\u00023)\u00199bG&$\u0018.Z:!CJ,\u0007eY8naV$X\r\u001a\u0011bg\u0002\"\b.\u001a\u0011tk6\u0004sN\u001a\u0011xK&<\u0007\u000e^:!_Z,'\u000fI8dGV\u0014(/\u001a8dKNT\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005I8gAQDW\rI3eO\u0016t\u0003%\u00134!i\",\u0007%\u001a3hK\u0002\u0002(o\u001c9feRL\b\u0005Z8fg\u0002rw\u000e\u001e\u0011fq&\u001cH\u000f\f\u0011xK&<\u0007\u000e\u001e\u0011jg\u0002\u001aw.\u001c9vi\u0016$\u0007%Y:!i\",\u0007%\u001a3hK\u0002\u001aw.\u001e8u])\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005I>t{\u0002l\u0017\r_%uKJ\fG/[8ogj\u0002\u0013J\u001c;!{\u0001Je\u000e\u001e\u0018NCb4\u0016\r\\;fA*\u0001\u0003E\u000b\u0011!A\u0001R\u0004\u0005^3s[&t\u0017\r^3!i\",\u0007%\u00197h_JLG\u000f[7!S\u001a\u0004\u0013\u000e\u001e\u0011iCN\u0004cn\u001c;!G>tg/\u001a:hK\u0012\u0004\u0013M\u001a;fe\u0002Z8/ 1nCbLE/\u001a:bi&|gn\u001d1!aVd7/Z:!Q9|G/\u001a\u0011uQ\u0006$\b\u0005\u001e5fA\u0019dwn\u001e\u0011xS2d\u0007EY3\u000bA\u0001R\u0003\u0005\t\u0011!A\u0001JgnY8se\u0016\u001cG\u000fI5gAQD\u0017n\u001d\u0011iCB\u0004XM\\:*\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023e\t\u0011Ti\u0006$Xm\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u00194m_^T\u0004%\\;uC\ndWML'bancuN\\4-AQk\u0006M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!\u001b\u0006\u0004\be\u001c4!wNl\b\r^1sO\u0016$\u0018\n\u0012\u0011.}\u00012Gn\\<aA\u00012wN\u001d\u0011pkR4Gn\\<!CR\u0004c/\u001a:uKb\u0004\u0003F\\3hCRLg/\u001a\u0011wC2,Xm\u001d\u0011be\u0016\u0004#-Y2lM2|w\u000fI;tK\u0012\u0004#-\u001f\u0011uQ\u0016\u0004\u0013\r\\4pe&$\b.\\\u0015\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1fq\u000e,7o\u001d\u001e!)\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\bI3yG\u0016\u001c8\u000f\t4m_^\u0004\u0013\r\u001e\u0011wKJ$X\r\u001f\u0011)g\"|W\u000f\u001c3!E\u0016\u0004\u0003\u0007I3yG\u0016\u0004H\u000f\t4pe\u0002\u001ax.\u001e:dK\u0002\ng\u000e\u001a\u0011uCJ<W\r\u001e\u0011bMR,'\u000fI1mO>\u0014\u0018\u000e\u001e5nA\r|gN^3sO\u0016$\u0017F\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b\rZ5ti\u0006t7-\u001a'bE\u0016d'\bI%oi\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t<feR,\u0007\u0010\t7bE\u0016d\u0007%^:fI\u0002\u0012\u0017\u0010\t;iK\u0002\nGnZ8sSRDW\u000e\t;pA\u0011,7-\u001b3fA]DWM]3!i>\u0004\u0003/^:iA\u0019dwn\u001e\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u00198fS\u001eD'm\\;s\u0019\u0006\u0014W\r\\:;A5,H/\u00192mK:j\u0015\r].M_:<G\u0006I%oiv\u0003'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011NCB\u0004sN\u001a\u0011|gv\u0004G/\u0019:hKRLE\tI\u0017?A1\f'-\u001a7aA\r|g\u000e^1j]&tw\r\t;iK\u0002\"\u0017n\u001d;b]\u000e,\u0007\u0005\\1cK2\u001c\bEZ8sAQDW\r\t<feR,\u00070Z:!]\u0016Lw\r\u001b2pkJ\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t?!\u001b\u0006D\u0018.\\;nA\u0019cwn\u001e\u0011}\u0015\u0001\u0002#\u0006\t\u0011}A5jS&L\u0017.[5jS&L\u0017!y*\u0001\u0003E\u000b\u0011!y\u0002Z8/ 1gY><(\b\t+aAqT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t1aAntw\u000e^3~\u0015\u0001\u0002#\u0006\t\u0011UQ\u0016\u0004\u0013\r\\4pe&$\b.\u001c\u0011sKR,(O\\:!C\u0002\u001a\u0018N\\4mK\u0002b\u0017N\\3!o&$\b\u000e\t;iK\u00022\u0018\r\\;fA=4\u0007\u0005\u001e5fA5\f\u00070[7v[\u00022Gn\\<!E\u0016$x/Z3oAQDW\rI:pkJ\u001cW\rI1oI\u0002\"\u0018M]4fi:R\u0001\u0005\t\u0016!A\u0001\u0004\u0007M\u0003\u0011!U)\u0001\u0003E\u000b\u0011\\=J,g-\u0018\u001e!7\u0006\u0003c.Z<!CB\u0004(o\\1dQ\u0002\"x\u000e\t;iK\u0002j\u0015\r_5nk6lc\t\\8xAA\u0013xN\u00197f[vC\u0003\u000e\u001e;qu=z\u0013m[5sC:\u0012Xo\u0019\u0018eW>r8.\u001a7e_Q,\u0017m\u00195j]\u001e|\u0013\r\\4pe&$X.\u001a3fg&<gn\u001841g=\n%\u000f^5lY\u0016\u0014x\u0006\r\u001d0\u000f>dGMY3sObBd\u0006\u001d3gS)\u0001\u0003EK\u0018\u0002\u000f5\u000b\u0007P\u00127poB\u0019\u0011\u0011H'\u0014\t5\u000b'q\u0015\u000b\u0003\u0007{)Ba!\u0012\u0004NQQ1qIB*\u0007+\u001a9f!\u0017\u0015\t\r%3q\n\t\u0006\u0003s\u000111\n\t\u0005\u0003;\u0019i\u0005B\u0004\u0002\"=\u0013\r!a\t\t\u000f\u0005\u001dq\nq\u0001\u0004RA1\u00111BA\u000b\u0007\u0017BQ!](A\u0002IDQ!`(A\u0002IDqA`(\u0011\u0002\u0003\u0007!\u000f\u0003\u0005\u0000\u001fB\u0005\t\u0019AA\u0001\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001aT\u0003BB0\u0007G*\"a!\u0019+\u0007I\f\u0019\rB\u0004\u0002\"A\u0013\r!a\t\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ*BA!\u0019\u0004j\u00119\u0011\u0011E)C\u0002\u0005\r\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0003\u0004`\r=DaBA\u0011%\n\u0007\u00111E\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\t\t\u00054Q\u000f\u0003\b\u0003C\u0019&\u0019AA\u0012\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019Y\b\u0005\u0003\u0002h\u000eu\u0014\u0002BB@\u0003S\u0014aa\u00142kK\u000e$\b")
public class MaxFlow<T>
implements Generic {
    private volatile MaxFlow$FlowAdded$ FlowAdded$module;
    private volatile MaxFlow$NewLabel$ NewLabel$module;
    private volatile MaxFlow$Recheck$ Recheck$module;
    private final String source;
    private final String target;
    private final String capacityLabel;
    private final int maxIterations;
    private final Numeric<T> numeric;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static <T> int $lessinit$greater$default$4() {
        return MaxFlow$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> String $lessinit$greater$default$3() {
        return MaxFlow$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> int apply$default$4() {
        return MaxFlow$.MODULE$.apply$default$4();
    }

    public static <T> String apply$default$3() {
        return MaxFlow$.MODULE$.apply$default$3();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    public MaxFlow$FlowAdded$ FlowAdded() {
        if (this.FlowAdded$module == null) {
            this.FlowAdded$lzycompute$1();
        }
        return this.FlowAdded$module;
    }

    public MaxFlow$NewLabel$ NewLabel() {
        if (this.NewLabel$module == null) {
            this.NewLabel$lzycompute$1();
        }
        return this.NewLabel$module;
    }

    public MaxFlow$Recheck$ Recheck() {
        if (this.Recheck$module == null) {
            this.Recheck$lzycompute$1();
        }
        return this.Recheck$module;
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function2<Vertex, GraphState, BoxedUnit>)(Function2 & Serializable)(vertex, graphState) -> {
            MaxFlow.$anonfun$apply$1(this, vertex, graphState);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            MaxFlow.$anonfun$apply$3(this, vertex);
            return BoxedUnit.UNIT;
        }, this.maxIterations, true);
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.explodeSelect((Function1<Vertex, IterableOnce<Row>>)(Function1 & Serializable)vertex -> {
            String string = vertex.name(vertex.name$default$1());
            String string2 = $this.source;
            return !(string != null ? !string.equals(string2) : string2 != null) ? (IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((MapOps)((EntityVisitor)((Object)vertex)).getState("flow", ((EntityVisitor)((Object)vertex)).getState$default$2())).values().sum($this.numeric)}))})) : package$.MODULE$.List().empty();
        });
    }

    private final void FlowAdded$lzycompute$1() {
        MaxFlow maxFlow = this;
        synchronized (maxFlow) {
            if (this.FlowAdded$module == null) {
                this.FlowAdded$module = new MaxFlow$FlowAdded$(this);
            }
        }
    }

    private final void NewLabel$lzycompute$1() {
        MaxFlow maxFlow = this;
        synchronized (maxFlow) {
            if (this.NewLabel$module == null) {
                this.NewLabel$module = new MaxFlow$NewLabel$(this);
            }
        }
    }

    private final void Recheck$lzycompute$1() {
        MaxFlow maxFlow = this;
        synchronized (maxFlow) {
            if (this.Recheck$module == null) {
                this.Recheck$module = new MaxFlow$Recheck$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$apply$2(MaxFlow $this, Map flow$1, Vertex vertex$1, ConcreteEdge edge) {
        Object c = edge.weight($this.capacityLabel, $this.numeric);
        flow$1.update(edge.dst(), c);
        vertex$1.messageVertex(edge.dst(), new FlowAdded<Object>($this, vertex$1.ID(), c), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
    }

    public static final /* synthetic */ void $anonfun$apply$1(MaxFlow $this, Vertex vertex, GraphState graphState) {
        int n = graphState.nodeCount();
        String string = vertex.name(vertex.name$default$1());
        String string2 = $this.source;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Map flow = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            ((EntityVisitor)((Object)vertex)).setState("distanceLabel", BoxesRunTime.boxToInteger((int)n));
            vertex.outEdges().foreach((Function1 & Serializable)edge -> {
                MaxFlow.$anonfun$apply$2($this, flow, vertex, edge);
                return BoxedUnit.UNIT;
            });
            ((EntityVisitor)((Object)vertex)).setState("flow", flow);
            vertex.messageAllNeighbours(new NewLabel<Object>($this, vertex.ID(), n), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        } else {
            ((EntityVisitor)((Object)vertex)).setState("distanceLabel", BoxesRunTime.boxToInteger((int)0));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$4(MaxFlow $this, Map flow$2, ObjectRef excess$1, Map labels$1, Message x0$1) {
        Message message = x0$1;
        if (message instanceof FlowAdded) {
            FlowAdded flowAdded = (FlowAdded)message;
            Object source = flowAdded.source();
            Object value = flowAdded.value();
            flow$2.update(source, Numeric.Implicits$.MODULE$.infixNumericOps(flow$2.getOrElse(source, (Function0 & Serializable)() -> ExtendedNumeric$.MODULE$.numericFromInt(0, $this.numeric)), $this.numeric).$minus(value));
            excess$1.elem = Numeric.Implicits$.MODULE$.infixNumericOps(excess$1.elem, $this.numeric).$plus(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (message instanceof NewLabel) {
            NewLabel newLabel = (NewLabel)message;
            Object source = newLabel.source();
            int label = newLabel.label();
            labels$1.update(source, (Object)BoxesRunTime.boxToInteger((int)label));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (message instanceof Recheck) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)message);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$6(MaxFlow $this, int label$1, Map labels$1, Map flow$2, ObjectRef excess$1, Vertex vertex$2, ConcreteEdge edge) {
        block0: {
            Object c;
            Object res;
            Object delta;
            Object dst = edge.dst();
            if (label$1 != BoxesRunTime.unboxToInt((Object)labels$1.getOrElse(dst, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1 || !Ordering.Implicits$.MODULE$.infixOrderingOps(delta = $this.numeric.min(excess$1.elem, res = Numeric.Implicits$.MODULE$.infixNumericOps(c = edge.weight($this.capacityLabel, $this.numeric), $this.numeric).$minus(flow$2.getOrElse(dst, (Function0 & Serializable)() -> ExtendedNumeric$.MODULE$.numericFromInt(0, $this.numeric)))), $this.numeric).$greater(ExtendedNumeric$.MODULE$.numericFromInt(0, $this.numeric))) break block0;
            vertex$2.messageVertex(dst, new FlowAdded<Object>($this, vertex$2.ID(), delta), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
            flow$2.update(dst, Numeric.Implicits$.MODULE$.infixNumericOps(flow$2.getOrElse(dst, (Function0 & Serializable)() -> ExtendedNumeric$.MODULE$.numericFromInt(0, $this.numeric)), $this.numeric).$plus(delta));
            excess$1.elem = Numeric.Implicits$.MODULE$.infixNumericOps(excess$1.elem, $this.numeric).$minus(delta);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$10(MaxFlow $this, int label$1, Map labels$1, ObjectRef excess$1, Vertex vertex$2, Map flow$2, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Object dst = tuple2._1();
            Object value = tuple2._2();
            if (Ordering.Implicits$.MODULE$.infixOrderingOps(value, $this.numeric).$less(ExtendedNumeric$.MODULE$.numericFromInt(0, $this.numeric)) && label$1 == BoxesRunTime.unboxToInt((Object)labels$1.getOrElse(dst, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1) {
                Object delta = $this.numeric.min(excess$1.elem, Numeric.Implicits$.MODULE$.infixNumericOps(value, $this.numeric).unary_$minus());
                if (Ordering.Implicits$.MODULE$.infixOrderingOps(delta, $this.numeric).$greater(ExtendedNumeric$.MODULE$.numericFromInt(0, $this.numeric))) {
                    vertex$2.messageVertex(dst, new FlowAdded<Object>($this, vertex$2.ID(), delta), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                    flow$2.update(dst, Numeric.Implicits$.MODULE$.infixNumericOps(flow$2.apply(dst), $this.numeric).$plus(delta));
                    excess$1.elem = Numeric.Implicits$.MODULE$.infixNumericOps(excess$1.elem, $this.numeric).$minus(delta);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$apply$12(MaxFlow $this, Map flow$2, Map labels$1, IntRef newLabel$1, ConcreteEdge edge) {
        block0: {
            Object c = edge.weight($this.capacityLabel, $this.numeric);
            Object dst = edge.dst();
            if (!Ordering.Implicits$.MODULE$.infixOrderingOps(Numeric.Implicits$.MODULE$.infixNumericOps(c, $this.numeric).$minus(flow$2.getOrElse(dst, (Function0 & Serializable)() -> ExtendedNumeric$.MODULE$.numericFromInt(0, $this.numeric))), $this.numeric).$greater(ExtendedNumeric$.MODULE$.numericFromInt(0, $this.numeric)) || BoxesRunTime.unboxToInt((Object)labels$1.getOrElse(dst, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1 >= newLabel$1.elem) break block0;
            newLabel$1.elem = BoxesRunTime.unboxToInt((Object)labels$1.getOrElse(dst, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1;
        }
    }

    public static final /* synthetic */ void $anonfun$apply$16(MaxFlow $this, Map labels$1, IntRef newLabel$1, Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Object dst = tuple2._1();
            Object value = tuple2._2();
            if (Ordering.Implicits$.MODULE$.infixOrderingOps(value, $this.numeric).$less(ExtendedNumeric$.MODULE$.numericFromInt(0, $this.numeric))) {
                if (BoxesRunTime.unboxToInt((Object)labels$1.getOrElse(dst, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1 < newLabel$1.elem) {
                    newLabel$1.elem = BoxesRunTime.unboxToInt((Object)labels$1.getOrElse(dst, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + 1;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$apply$3(MaxFlow $this, Vertex vertex) {
        ObjectRef excess;
        Map labels;
        Map flow;
        block6: {
            block5: {
                flow = (Map)((EntityVisitor)((Object)vertex)).getOrSetState("flow", Map$.MODULE$.empty(), ((EntityVisitor)((Object)vertex)).getOrSetState$default$3());
                labels = (Map)((EntityVisitor)((Object)vertex)).getOrSetState("neighbourLabels", Map$.MODULE$.empty(), ((EntityVisitor)((Object)vertex)).getOrSetState$default$3());
                excess = ObjectRef.create(((EntityVisitor)((Object)vertex)).getOrSetState("excess", ExtendedNumeric$.MODULE$.numericFromInt(0, $this.numeric), ((EntityVisitor)((Object)vertex)).getOrSetState$default$3()));
                vertex.messageQueue().foreach((Function1 & Serializable)x0$1 -> {
                    MaxFlow.$anonfun$apply$4($this, flow, excess, labels, x0$1);
                    return BoxedUnit.UNIT;
                });
                if (Ordering.Implicits$.MODULE$.infixOrderingOps(excess.elem, $this.numeric).equiv(ExtendedNumeric$.MODULE$.numericFromInt(0, $this.numeric))) break block5;
                String string = vertex.name(vertex.name$default$1());
                String string2 = $this.target;
                if (!(string == null ? string2 != null : !string.equals(string2))) break block5;
                String string3 = vertex.name(vertex.name$default$1());
                String string4 = $this.source;
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block6;
            }
            vertex.voteToHalt();
            return;
        }
        int label = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("distanceLabel", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        vertex.outEdges().foreach((Function1 & Serializable)edge -> {
            MaxFlow.$anonfun$apply$6($this, label, labels, flow, excess, vertex, edge);
            return BoxedUnit.UNIT;
        });
        flow.foreach((Function1 & Serializable)x0$2 -> {
            MaxFlow.$anonfun$apply$10($this, label, labels, excess, vertex, flow, x0$2);
            return BoxedUnit.UNIT;
        });
        if (Ordering.Implicits$.MODULE$.infixOrderingOps(excess.elem, $this.numeric).$greater(ExtendedNumeric$.MODULE$.numericFromInt(0, $this.numeric))) {
            IntRef newLabel = IntRef.create((int)Integer.MAX_VALUE);
            vertex.outEdges().foreach((Function1 & Serializable)edge -> {
                MaxFlow.$anonfun$apply$12($this, flow, labels, newLabel, edge);
                return BoxedUnit.UNIT;
            });
            flow.foreach((Function1 & Serializable)x0$3 -> {
                MaxFlow.$anonfun$apply$16($this, labels, newLabel, x0$3);
                return BoxedUnit.UNIT;
            });
            if (newLabel.elem > label) {
                ((EntityVisitor)((Object)vertex)).setState("distanceLabel", BoxesRunTime.boxToInteger((int)newLabel.elem));
                vertex.messageAllNeighbours(new NewLabel<Object>($this, vertex.ID(), newLabel.elem), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
                vertex.messageSelf($this.new Recheck(), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
            }
        }
        ((EntityVisitor)((Object)vertex)).setState("excess", excess.elem);
        ((EntityVisitor)((Object)vertex)).setState("flow", flow);
        ((EntityVisitor)((Object)vertex)).setState("neighbourLabels", labels);
    }

    public MaxFlow(String source, String target, String capacityLabel, int maxIterations, Numeric<T> numeric) {
        this.source = source;
        this.target = target;
        this.capacityLabel = capacityLabel;
        this.maxIterations = maxIterations;
        this.numeric = numeric;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }

    public class FlowAdded<VertexID>
    implements Message<VertexID>,
    Product,
    Serializable {
        private final VertexID source;
        private final T value;
        public final /* synthetic */ MaxFlow $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public VertexID source() {
            return this.source;
        }

        public T value() {
            return this.value;
        }

        public <VertexID> FlowAdded<VertexID> copy(VertexID source, T value) {
            return new FlowAdded<VertexID>(this.com$raphtory$algorithms$generic$MaxFlow$FlowAdded$$$outer(), source, value);
        }

        public <VertexID> VertexID copy$default$1() {
            return this.source();
        }

        public <VertexID> T copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "FlowAdded";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.source();
                    break;
                }
                case 1: {
                    object = this.value();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FlowAdded;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "source";
                    break;
                }
                case 1: {
                    string = "value";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FlowAdded)) return false;
            if (((FlowAdded)object).com$raphtory$algorithms$generic$MaxFlow$FlowAdded$$$outer() != this.com$raphtory$algorithms$generic$MaxFlow$FlowAdded$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FlowAdded flowAdded = (FlowAdded)x$1;
            if (!BoxesRunTime.equals(this.source(), flowAdded.source())) return false;
            if (!BoxesRunTime.equals(this.value(), flowAdded.value())) return false;
            if (!flowAdded.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MaxFlow com$raphtory$algorithms$generic$MaxFlow$FlowAdded$$$outer() {
            return this.$outer;
        }

        public FlowAdded(MaxFlow $outer, VertexID source, T value) {
            this.source = source;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public interface Message<VertexID> {
    }

    public class NewLabel<VertexID>
    implements Message<VertexID>,
    Product,
    Serializable {
        private final VertexID source;
        private final int label;
        public final /* synthetic */ MaxFlow $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public VertexID source() {
            return this.source;
        }

        public int label() {
            return this.label;
        }

        public <VertexID> NewLabel<VertexID> copy(VertexID source, int label) {
            return new NewLabel<VertexID>(this.com$raphtory$algorithms$generic$MaxFlow$NewLabel$$$outer(), source, label);
        }

        public <VertexID> VertexID copy$default$1() {
            return this.source();
        }

        public <VertexID> int copy$default$2() {
            return this.label();
        }

        public String productPrefix() {
            return "NewLabel";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.source();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.label());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NewLabel;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "source";
                    break;
                }
                case 1: {
                    string = "label";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.source()));
            n = Statics.mix((int)n, (int)this.label());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NewLabel)) return false;
            if (((NewLabel)object).com$raphtory$algorithms$generic$MaxFlow$NewLabel$$$outer() != this.com$raphtory$algorithms$generic$MaxFlow$NewLabel$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            NewLabel newLabel = (NewLabel)x$1;
            if (this.label() != newLabel.label()) return false;
            if (!BoxesRunTime.equals(this.source(), newLabel.source())) return false;
            if (!newLabel.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MaxFlow com$raphtory$algorithms$generic$MaxFlow$NewLabel$$$outer() {
            return this.$outer;
        }

        public NewLabel(MaxFlow $outer, VertexID source, int label) {
            this.source = source;
            this.label = label;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class Recheck<VertexID>
    implements Message<VertexID>,
    Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public <VertexID> Recheck<VertexID> copy() {
            return this.com$raphtory$algorithms$generic$MaxFlow$Recheck$$$outer().new Recheck<VertexID>();
        }

        public String productPrefix() {
            return "Recheck";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            Object object = Statics.ioobe((int)x$1);
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Recheck;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            String string = (String)Statics.ioobe((int)x$1);
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof Recheck && ((Recheck)object).com$raphtory$algorithms$generic$MaxFlow$Recheck$$$outer() == this.com$raphtory$algorithms$generic$MaxFlow$Recheck$$$outer();
            return bl && ((Recheck)x$1).canEqual(this);
        }

        public /* synthetic */ MaxFlow com$raphtory$algorithms$generic$MaxFlow$Recheck$$$outer() {
            return MaxFlow.this;
        }

        public Recheck() {
            if (MaxFlow.this == null) {
                throw null;
            }
            Product.$init$((Product)this);
        }
    }
}

