/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.GraphState$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.GraphStateOutput;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`GraphState(properties: Seq[String] = Seq.empty[String], defaults: Map[String, Any] = Map.empty[String, Any])`\n  * {s}`GraphState(properties: String*)`\n  * {s}`GraphState(defaults: Map[String, Any], properties: String*)`\n  * : Write out selected graph properties to table with optional default values.\n  *\n  * The different columns correspond to the selected properties.\n  *\n  * Property names are looked up on the graph state (either as general accumulators or graph constants.)\n  * This means that this algorithm can be used as the last step in an algorithm chain to include output\n  * of intermediate results or non-default state. It is also useful as the base class for custom algorithms that\n  * should return a table of graph properties as result.\n  *\n  * ## Parameters\n  *\n  * {s}`properties: Seq[String]`\n  * : Sequence of property names\n  *\n  * {s}`defaults: Map[String, Any]`\n  * : Map from property names to default values\n  * (if a property name is not found on in the graph state, it is first looked up in defaults,\n  * and if not found there, set to {s}`None`)\n  *\n  * ## Returns\n  *\n  * | Property1       | Property2       | ... |\n  * | --------------- | --------------- |     |\n  * | {s}`value: Any` | {s}`value: Any` | ... |\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.motif.GlobalTriangleCount)\n  * [](com.raphtory.algorithms.generic.LargestConnectedComponent)\n  * [](com.raphtory.algorithms.generic.NodeEdgeCount)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001B\b\u0011\u0001eA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!)a\t\u0001C\u0001\u000f\u001e)!\f\u0005E\u00017\u001a)q\u0002\u0005E\u00019\")a)\u0002C\u0001Q\")\u0011.\u0002C\u0001U\"9\u0001/BI\u0001\n\u0003\t\bb\u0002?\u0006#\u0003%\t! \u0005\u0006S\u0016!\ta \u0005\u0007S\u0016!\t!!\u0003\t\u0013\u0005=Q!%A\u0005\u0002\u0005E\u0001\u0002CA\u000b\u000bE\u0005I\u0011A?\t\u0013\u0005]Q!!A\u0005\n\u0005e!AC$sCBD7\u000b^1uK*\u0011\u0011CE\u0001\bO\u0016tWM]5d\u0015\t\u0019B#\u0001\u0006bY\u001e|'/\u001b;i[NT!!\u0006\f\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011aF\u0001\u0004G>l7\u0001A\n\u0004\u0001i!\u0003CA\u000e#\u001b\u0005a\"BA\u000f\u001f\u0003%\tGnZ8sSRDWN\u0003\u0002 A\u0005A\u0011M\\1msNL7O\u0003\u0002\")\u0005\u0019\u0011\r]5\n\u0005\rb\"\u0001E$sCBD7\u000b^1uK>+H\u000f];u!\tYR%\u0003\u0002'9\t9q)\u001a8fe&\u001c\u0017A\u00039s_B,'\u000f^5fgB\u0019\u0011f\r\u001c\u000f\u0005)\u0002dBA\u0016/\u001b\u0005a#BA\u0017\u0019\u0003\u0019a$o\\8u}%\tq&A\u0003tG\u0006d\u0017-\u0003\u00022e\u00059\u0001/Y2lC\u001e,'\"A\u0018\n\u0005Q*$aA*fc*\u0011\u0011G\r\t\u0003omr!\u0001O\u001d\u0011\u0005-\u0012\u0014B\u0001\u001e3\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i\u0012\u0014\u0001\u00033fM\u0006,H\u000e^:\u0011\t]\u0002eGQ\u0005\u0003\u0003v\u00121!T1q!\t\u0019E)D\u00013\u0013\t)%GA\u0002B]f\fa\u0001P5oSRtDc\u0001%K\u0017B\u0011\u0011\nA\u0007\u0002!!9qe\u0001I\u0001\u0002\u0004A\u0003b\u0002 \u0004!\u0003\u0005\ra\u0010\u0015\u0005\u00015;\u0006\f\u0005\u0002O+6\tqJ\u0003\u0002Q#\u0006A1oY1mC\u0012|7M\u0003\u0002S'\u00069A/Y6fu>,'B\u0001+\u0017\u0003\u00199\u0017\u000e\u001e5vE&\u0011ak\u0014\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\n\u0011,AFA_)R#\u0002\t\u0011+Am\u001cX\u0010Y$sCBD7\u000b^1uK\"\u0002(o\u001c9feRLWm\u001d\u001e!'\u0016\f8l\u0015;sS:<W\fI\u001f!'\u0016\fh&Z7qif\\6\u000b\u001e:j]\u001elF\u0006\t3fM\u0006,H\u000e^:;A5\u000b\u0007oW*ue&tw\r\f\u0011B]fl\u0006%\u0010\u0011NCBtS-\u001c9usn\u001bFO]5oO2\u0002\u0013I\\=^S\u0001T\u0001\u0005\t\u0016!wNl\bm\u0012:ba\"\u001cF/\u0019;fQA\u0014x\u000e]3si&,7O\u000f\u0011TiJLgn\u001a\u0016*A*\u0001\u0003E\u000b\u0011|gv\u0004wI]1qQN#\u0018\r^3)I\u00164\u0017-\u001e7ugj\u0002S*\u00199\\'R\u0014\u0018N\\4-A\u0005s\u00170\u0018\u0017!aJ|\u0007/\u001a:uS\u0016\u001c(\bI*ue&twMK\u0015a\u0015\u0001\u0002#\u0006\t\u001e!/JLG/\u001a\u0011pkR\u00043/\u001a7fGR,G\rI4sCBD\u0007\u0005\u001d:pa\u0016\u0014H/[3tAQ|\u0007\u0005^1cY\u0016\u0004s/\u001b;iA=\u0004H/[8oC2\u0004C-\u001a4bk2$\bE^1mk\u0016\u001chF\u0003\u0011!U)\u0001\u0003E\u000b\u0011UQ\u0016\u0004C-\u001b4gKJ,g\u000e\u001e\u0011d_2,XN\\:!G>\u0014(/Z:q_:$\u0007\u0005^8!i\",\u0007e]3mK\u000e$X\r\u001a\u0011qe>\u0004XM\u001d;jKNt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t)s_B,'\u000f^=!]\u0006lWm\u001d\u0011be\u0016\u0004Cn\\8lK\u0012\u0004S\u000f\u001d\u0011p]\u0002\"\b.\u001a\u0011he\u0006\u0004\b\u000eI:uCR,\u0007\u0005K3ji\",'\u000fI1tA\u001d,g.\u001a:bY\u0002\n7mY;nk2\fGo\u001c:tA=\u0014\be\u001a:ba\"\u00043m\u001c8ti\u0006tGo\u001d\u0018*\u0015\u0001\u0002#\u0006\t+iSN\u0004S.Z1og\u0002\"\b.\u0019;!i\"L7\u000fI1mO>\u0014\u0018\u000e\u001e5nA\r\fg\u000e\t2fAU\u001cX\r\u001a\u0011bg\u0002\"\b.\u001a\u0011mCN$\be\u001d;fa\u0002Jg\u000eI1oA\u0005dwm\u001c:ji\"l\u0007e\u00195bS:\u0004Co\u001c\u0011j]\u000edW\u000fZ3!_V$\b/\u001e;\u000bA\u0001R\u0003e\u001c4!S:$XM]7fI&\fG/\u001a\u0011sKN,H\u000e^:!_J\u0004cn\u001c8.I\u00164\u0017-\u001e7uAM$\u0018\r^3/A%#\b%[:!C2\u001cx\u000eI;tK\u001a,H\u000eI1tAQDW\r\t2bg\u0016\u00043\r\\1tg\u00022wN\u001d\u0011dkN$x.\u001c\u0011bY\u001e|'/\u001b;i[N\u0004C\u000f[1u\u0015\u0001\u0002#\u0006I:i_VdG\r\t:fiV\u0014h\u000eI1!i\u0006\u0014G.\u001a\u0011pM\u0002:'/\u00199iAA\u0014x\u000e]3si&,7\u000fI1tAI,7/\u001e7u])\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011QCJ\fW.\u001a;feNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003e_:~AB\u0014x\u000e]3si&,7O\u000f\u0011TKF\\6\u000b\u001e:j]\u001el\u0006M\u0003\u0011!U\u0001R\u0004eU3rk\u0016t7-\u001a\u0011pM\u0002\u0002(o\u001c9feRL\bE\\1nKNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003e_:~A\u0012,g-Y;miNT\u0004%T1q7N#(/\u001b8hY\u0001\ne._/a\u0015\u0001\u0002#\u0006\t\u001e!\u001b\u0006\u0004\bE\u001a:p[\u0002\u0002(o\u001c9feRL\bE\\1nKN\u0004Co\u001c\u0011eK\u001a\fW\u000f\u001c;!m\u0006dW/Z:\u000bA\u0001R\u0003\u0005K5gA\u0005\u0004\u0003O]8qKJ$\u0018\u0010\t8b[\u0016\u0004\u0013n\u001d\u0011o_R\u0004cm\\;oI\u0002zg\u000eI5oAQDW\rI4sCBD\u0007e\u001d;bi\u0016d\u0003%\u001b;!SN\u0004c-\u001b:ti\u0002bwn\\6fI\u0002*\b\u000fI5oA\u0011,g-Y;miNd#\u0002\t\u0011+A\u0005tG\rI5gA9|G\u000f\t4pk:$\u0007\u0005\u001e5fe\u0016d\u0003e]3uAQ|\u0007e_:~A:{g.\u001a1*\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t*fiV\u0014hn\u001d\u0006!A)R\u0001\u0005\t\u0016!y\u0002\u0002&o\u001c9feRL\u0018\u0007\t\u0011!A\u0001\u0002\u0003\u0005 \u0011Qe>\u0004XM\u001d;ze\u0001\u0002\u0003\u0005\t\u0011!Aq\u0004cF\f\u0018!y*\u0001\u0003E\u000b\u0011}A5jS&L\u0017.[5jS&L\u0017.[5\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002\u0002\u0003\u0005\t\u0011}\u0015\u0001\u0002#\u0006\t?!wNl\bM^1mk\u0016T\u0004%\u00118zA\u0002b\be_:~AZ\fG.^3;A\u0005s\u0017\u0010\u0019\u0011}A9rc\u0006\t?\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0004\u0007m_:fK\u0006d7o\\?\u000bA\u0001R\u0003eW/)G>lgF]1qQR|'/\u001f\u0018bY\u001e|'/\u001b;i[Nts-\u001a8fe&\u001cg&\\8uS\u001ats\t\\8cC2$&/[1oO2,7i\\;oi&R\u0001\u0005\t\u0016!7vC3m\\7/e\u0006\u0004\b\u000e^8ss:\nGnZ8sSRDWn\u001d\u0018hK:,'/[2/\u0019\u0006\u0014x-Z:u\u0007>tg.Z2uK\u0012\u001cu.\u001c9p]\u0016tG/\u000b\u0006!A)\u00023,\u0018\u0015d_6t#/\u00199ii>\u0014\u0018PL1mO>\u0014\u0018\u000e\u001e5ng::WM\\3sS\u000etcj\u001c3f\u000b\u0012<WmQ8v]RL#\u0002\t\u0011+A\u0001\u0004\u0007M\u0003\u0011!U=\n!b\u0012:ba\"\u001cF/\u0019;f!\tIUaE\u0002\u0006;\u0002\u0004\"a\u00110\n\u0005}\u0013$AB!osJ+g\r\u0005\u0002bM6\t!M\u0003\u0002dI\u0006\u0011\u0011n\u001c\u0006\u0002K\u0006!!.\u0019<b\u0013\t9'M\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001\\\u0003\u0015\t\u0007\u000f\u001d7z)\rA5n\u001c\u0005\bO\u001d\u0001\n\u00111\u0001m!\rISNN\u0005\u0003]V\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b}\u001d\u0001\n\u00111\u0001@\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\nT#\u0001:+\u00051\u001c8&\u0001;\u0011\u0005UTX\"\u0001<\u000b\u0005]D\u0018!C;oG\",7m[3e\u0015\tI('\u0001\u0006b]:|G/\u0019;j_:L!a\u001f<\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0005q(FA t)\rA\u0015\u0011\u0001\u0005\u0007O)\u0001\r!a\u0001\u0011\t\r\u000b)AN\u0005\u0004\u0003\u000f\u0011$A\u0003\u001fsKB,\u0017\r^3e}Q)\u0001*a\u0003\u0002\u000e!)ah\u0003a\u0001\u007f!1qe\u0003a\u0001\u0003\u0007\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTCAA\nU\tA3/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u00037\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C!\u0017\u0001\u00027b]\u001eLA!!\n\u0002 \t1qJ\u00196fGR\u0004")
public class GraphState
extends GraphStateOutput
implements Generic {
    public static Map<String, Object> $lessinit$greater$default$2() {
        return GraphState$.MODULE$.$lessinit$greater$default$2();
    }

    public static Seq<String> $lessinit$greater$default$1() {
        return GraphState$.MODULE$.$lessinit$greater$default$1();
    }

    public static Map<String, Object> apply$default$2() {
        return GraphState$.MODULE$.apply$default$2();
    }

    public static Iterable<String> apply$default$1() {
        return GraphState$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Main algorithm\n    *\n    * Default implementation returns the graph unchanged.\n    * This should be overridden by subclasses to define the actual\n    * algorithm steps unless the algorithm only outputs existing state or properties.\n    *\n    * @param graph graph to run function upon\n    */")
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return Generic.apply$(this, graph);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    public GraphState(Seq<String> properties, Map<String, Object> defaults) {
        super(properties, defaults);
        Generic.$init$(this);
    }
}

