/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.EdgeList$;
import com.raphtory.algorithms.generic.NeighbourNames$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.View;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  *  {s}`EdgeList(properties: String*)`\n  *  : Writes out edge list with selected properties to table with format srcName, dstName, edgeProperty1, ...\n  *\n  *  {s}`EdgeList(defaults: Map[String, Any], properties: String*)`\n  *  : Specify default values for missing properties\n  *\n  *  {s}`EdgeList(properties: Seq[String] = Seq.empty[String], defaults: Map[String, Any] = Map.empty[String, Any])`\n  *  : Specify sequence of property names\n  *\n  *  ## Parameters\n  *\n  *  {s}`properties: Seq[String]`\n  *  : Sequence of property names to extract (default: empty)\n  *\n  *  {s}`defaults: Map[String, Any]`\n  *  : Map of property names to default values (default value: None)\n  *\n  *  ## Returns\n  *\n  * edge list with selected properties\n  *\n  *  | source name          | destination name     | property 1      | ... |\n  *  | -------------------- | -------------------- | --------------- | --- |\n  *  | {s}`srcName: String` | {s}`dstName: String` | {s}`value: Any` | ... |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001\u0002\n\u0014\u0001qA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\")\u0011\n\u0001C\u0001\u0015\")q\n\u0001C!!\")a\f\u0001C!?\u001e)Qo\u0005E\u0001m\u001a)!c\u0005E\u0001o\"1\u0011j\u0002C\u0001\u0003\u0003AaaT\u0004\u0005\u0002\u0005\r\u0001BB(\b\t\u0003\t)\u0001C\u0005\u0002\f\u001d\t\n\u0011\"\u0001\u0002\u000e!I\u00111E\u0004\u0012\u0002\u0013\u0005\u0011Q\u0005\u0005\u0007\u001f\u001e!\t!!\u000b\t\r=;A\u0011AA\u001a\u0011%\tIdBI\u0001\n\u0003\ti\u0001C\u0005\u0002<\u001d\t\n\u0011\"\u0001\u0002&!I\u0011QH\u0004\u0002\u0002\u0013%\u0011q\b\u0002\t\u000b\u0012<W\rT5ti*\u0011A#F\u0001\bO\u0016tWM]5d\u0015\t1r#\u0001\u0006bY\u001e|'/\u001b;i[NT!\u0001G\r\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011AG\u0001\u0004G>l7\u0001A\n\u0004\u0001u\u0019\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%W5\tQE\u0003\u0002'O\u0005I\u0011\r\\4pe&$\b.\u001c\u0006\u0003Q%\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003U]\t1!\u00199j\u0013\taSEA\u0004HK:,'/[2\u0002\u0015A\u0014x\u000e]3si&,7\u000fE\u00020oir!\u0001M\u001b\u000f\u0005E\"T\"\u0001\u001a\u000b\u0005MZ\u0012A\u0002\u001fs_>$h(C\u0001!\u0013\t1t$A\u0004qC\u000e\\\u0017mZ3\n\u0005aJ$aA*fc*\u0011ag\b\t\u0003w}r!\u0001P\u001f\u0011\u0005Ez\u0012B\u0001  \u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005yz\u0012\u0001\u00033fM\u0006,H\u000e^:\u0011\tm\"%HR\u0005\u0003\u000b\u0006\u00131!T1q!\tqr)\u0003\u0002I?\t\u0019\u0011I\\=\u0002\rqJg.\u001b;?)\rYUJ\u0014\t\u0003\u0019\u0002i\u0011a\u0005\u0005\b[\r\u0001\n\u00111\u0001/\u0011\u001d\u00115\u0001%AA\u0002\r\u000bQ!\u00199qYf$\"!\u0015+\u0011\u0005IcfBA*U\u0019\u0001AQ!\u0016\u0003A\u0002Y\u000bQa\u001a:ba\"\u0004\"a\u0016.\u000e\u0003aS!!W\u0014\u0002\u0013\u001d\u0014\u0018\r\u001d5wS\u0016<\u0018BA.Y\u0005A9%/\u00199i!\u0016\u00148\u000f]3di&4X-\u0003\u0002^5\n)qI]1qQ\u0006QA/\u00192vY\u0006\u0014\u0018n]3\u0015\u0005\u00014\u0007CA1e\u001b\u0005\u0011'BA2(\u0003\u0015!\u0018M\u00197f\u0013\t)'MA\u0003UC\ndW\rC\u0003V\u000b\u0001\u0007a\u000b\u000b\u0003\u0001QJ\u001c\bCA5q\u001b\u0005Q'BA6m\u0003!\u00198-\u00197bI>\u001c'BA7o\u0003\u001d!\u0018m[3{_\u0016T!a\\\r\u0002\r\u001dLG\u000f[;c\u0013\t\t(N\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\u0005!\u0018a\"*0U)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y#eO\u0016d\u0015n\u001d;)aJ|\u0007/\u001a:uS\u0016\u001c(\bI*ue&twMK\u0015a\u0015\u0001\u0002#\u0006\t\u0011;A]\u0013\u0018\u000e^3tA=,H\u000fI3eO\u0016\u0004C.[:uA]LG\u000f\u001b\u0011tK2,7\r^3eAA\u0014x\u000e]3si&,7\u000f\t;pAQ\f'\r\\3!o&$\b\u000e\t4pe6\fG\u000fI:sG:\u000bW.\u001a\u0017!IN$h*Y7fY\u0001*GmZ3Qe>\u0004XM\u001d;zc1\u0002cF\f\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1FI\u001e,G*[:uQ\u0011,g-Y;miNT\u0004%T1q7N#(/\u001b8hY\u0001\ne._/-AA\u0014x\u000e]3si&,7O\u000f\u0011TiJLgn\u001a\u0016*A*\u0001\u0003E\u000b\u0011!u\u0001\u001a\u0006/Z2jMf\u0004C-\u001a4bk2$\bE^1mk\u0016\u001c\bEZ8sA5L7o]5oO\u0002\u0002(o\u001c9feRLWm\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y#eO\u0016d\u0015n\u001d;)aJ|\u0007/\u001a:uS\u0016\u001c(\bI*fcn\u001bFO]5oOv\u0003S\bI*fc:*W\u000e\u001d;z7N#(/\u001b8h;2\u0002C-\u001a4bk2$8O\u000f\u0011NCB\\6\u000b\u001e:j]\u001ed\u0003%\u00118z;\u0002j\u0004%T1q]\u0015l\u0007\u000f^=\\'R\u0014\u0018N\\4-A\u0005s\u00170X\u0015a\u0015\u0001\u0002#\u0006\t\u0011;AM\u0003XmY5gs\u0002\u001aX-];f]\u000e,\u0007e\u001c4!aJ|\u0007/\u001a:us\u0002r\u0017-\\3t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023e\t\u0011QCJ\fW.\u001a;feNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002\u0004(o\u001c9feRLWm\u001d\u001e!'\u0016\f8l\u0015;sS:<W\f\u0019\u0006!A)\u0002\u0003E\u000f\u0011TKF,XM\\2fA=4\u0007\u0005\u001d:pa\u0016\u0014H/\u001f\u0011oC6,7\u000f\t;pA\u0015DHO]1di\u0002BC-\u001a4bk2$(\bI3naRL\u0018F\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b\rZ3gCVdGo\u001d\u001e!\u001b\u0006\u00048l\u0015;sS:<G\u0006I!osv\u0003'\u0002\t\u0011+A\u0001R\u0004%T1qA=4\u0007\u0005\u001d:pa\u0016\u0014H/\u001f\u0011oC6,7\u000f\t;pA\u0011,g-Y;mi\u00022\u0018\r\\;fg\u0002BC-\u001a4bk2$\bE^1mk\u0016T\u0004ET8oK&R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I\u0012$AI+G/\u001e:og*\u0001\u0003E\u000b\u0006!A)\u0002S\rZ4fA1L7\u000f\u001e\u0011xSRD\u0007e]3mK\u000e$X\r\u001a\u0011qe>\u0004XM\u001d;jKNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t?!g>,(oY3!]\u0006lW\r\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!y\u0002\"Wm\u001d;j]\u0006$\u0018n\u001c8!]\u0006lW\r\t\u0011!A\u0001b\b\u0005\u001d:pa\u0016\u0014H/\u001f\u00112A\u0001\u0002\u0003\u0005\t\u0011}A9rc\u0006\t?\u000bA\u0001R\u0003\u0005\t?![5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&\f\u0011}A5jS\u0006\t?\u000bA\u0001R\u0003\u0005\t?!wNl\bm\u001d:d\u001d\u0006lWM\u000f\u0011TiJLgn\u001a1!y\u0002Z8/ 1egRt\u0015-\\3;AM#(/\u001b8hA\u0002b\be_:~AZ\fG.^3;A\u0005s\u0017\u0010\u0019\u0011}A9rc\u0006\t?\u000bA\u0001Rs&\u0001\u0005FI\u001e,G*[:u!\tauaE\u0002\b;a\u0004\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\u0005%|'\"A?\u0002\t)\fg/Y\u0005\u0003\u007fj\u0014AbU3sS\u0006d\u0017N_1cY\u0016$\u0012A\u001e\u000b\u0002\u0017R)1*a\u0002\u0002\n!9QF\u0003I\u0001\u0002\u0004q\u0003b\u0002\"\u000b!\u0003\u0005\raQ\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0002\u0016\u0004]\u0005E1FAA\n!\u0011\t)\"a\b\u000e\u0005\u0005]!\u0002BA\r\u00037\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005uq$\u0001\u0006b]:|G/\u0019;j_:LA!!\t\u0002\u0018\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII*\"!a\n+\u0007\r\u000b\t\u0002F\u0002L\u0003WAa!L\u0007A\u0002\u00055\u0002\u0003\u0002\u0010\u00020iJ1!!\r \u0005)a$/\u001a9fCR,GM\u0010\u000b\u0006\u0017\u0006U\u0012q\u0007\u0005\u0006\u0005:\u0001\ra\u0011\u0005\u0007[9\u0001\r!!\f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\t\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011q\t?\u0002\t1\fgnZ\u0005\u0005\u0003\u0017\n)E\u0001\u0004PE*,7\r\u001e")
public class EdgeList
implements Generic {
    private final Seq<String> properties;
    private final Map<String, Object> defaults;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static Map<String, Object> $lessinit$greater$default$2() {
        return EdgeList$.MODULE$.$lessinit$greater$default$2();
    }

    public static Seq<String> $lessinit$greater$default$1() {
        return EdgeList$.MODULE$.$lessinit$greater$default$1();
    }

    public static Map<String, Object> apply$default$2() {
        return EdgeList$.MODULE$.apply$default$2();
    }

    public static Seq<String> apply$default$1() {
        return EdgeList$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return NeighbourNames$.MODULE$.apply(graph);
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.explodeSelect((Function1<Vertex, IterableOnce<Row>>)(Function1 & Serializable)vertex -> {
            Map neighbourMap = (Map)((EntityVisitor)((Object)vertex)).getState("neighbourNames", ((EntityVisitor)((Object)vertex)).getState$default$2());
            String name = vertex.name(vertex.name$default$1());
            return (View)vertex.outEdges().map((Function1 & Serializable)edge -> {
                String string = name;
                String string2 = (String)neighbourMap.apply(edge.dst());
                Seq row = (Seq)((SeqOps)((SeqOps)$this.properties.map((Function1 & Serializable)key -> ((EntityVisitor)((Object)edge)).getPropertyOrElse((String)key, $this.defaults.getOrElse(key, (Function0 & Serializable)() -> None$.MODULE$)))).$plus$colon((Object)string2)).$plus$colon((Object)string);
                return Row$.MODULE$.apply((Seq<Object>)row);
            });
        });
    }

    public EdgeList(Seq<String> properties, Map<String, Object> defaults) {
        this.properties = properties;
        this.defaults = defaults;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

