/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`ConnectedComponents()`\n  * : Identify connected components\n  *\n  * A connected component of an undirected graph is a set of vertices all of which\n  * are connected by paths to each other. This algorithm identifies the connected component\n  * each vertex belongs to.\n  *\n  * ```{note}\n  * Edges here are treated as undirected, a future feature may be to calculate\n  * weakly/strongly connected components for directed networks.\n  * ```\n  *\n  * ## States\n  *\n  * {s}`cclabel: Long`\n  * : Label of connected component the vertex belongs to (minimum vertex ID in component)\n  *\n  * ## Returns\n  *\n  * | vertex name       | component label    |\n  * | ----------------- | ------------------ |\n  * | {s}`name: String` | {s}`cclabel: Long` |\n  *\n  * ## Implementation\n  *\n  * The algorithm is similar to that of GraphX and fairly straightforward:\n  *\n  *  1. Each node is numbered by its ID, and takes this as an initial connected components label.\n  *\n  *  2. Each node forwards its own label to each of its neighbours.\n  *\n  *  3. Having received a list of labels from neighbouring nodes, each node relabels itself with the smallest\n  *     label it has received (or stays the same if its starting label is smaller than any received).\n  *\n  *  4. The algorithm iterates over steps 2 and 3 until no nodes change their label within an iteration.\n  */")
public final class ConnectedComponents$
extends NodeList {
    public static final ConnectedComponents$ MODULE$ = new ConnectedComponents$();

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            ConnectedComponents$.$anonfun$apply$1(vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            ConnectedComponents$.$anonfun$apply$2(vertex);
            return BoxedUnit.UNIT;
        }, 100, true);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ConnectedComponents$.class);
    }

    public static final /* synthetic */ void $anonfun$apply$1(Vertex vertex) {
        ((EntityVisitor)((Object)vertex)).setState("cclabel", vertex.ID());
        vertex.messageAllNeighbours(vertex.ID(), vertex.provider());
    }

    public static final /* synthetic */ void $anonfun$apply$2(Vertex vertex) {
        Object label = vertex.messageQueue().min(vertex.IDOrdering());
        if (Ordering.Implicits$.MODULE$.infixOrderingOps(label, vertex.IDOrdering()).$less(((EntityVisitor)((Object)vertex)).getState("cclabel", ((EntityVisitor)((Object)vertex)).getState$default$2()))) {
            ((EntityVisitor)((Object)vertex)).setState("cclabel", label);
            vertex.messageAllNeighbours(label, vertex.provider());
            String string = vertex.name(vertex.name$default$1());
        } else {
            vertex.voteToHalt();
        }
    }

    private ConnectedComponents$() {
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cclabel"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

