/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowmessaging;

import com.raphtory.arrowmessaging.model.ArrowFlightDataset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.Criteria;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005mb!B\u0006\r\u00011\u0011\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u0011=\u0002!\u0011!Q\u0001\nABQa\r\u0001\u0005\u0002QBq!\u000f\u0001C\u0002\u0013%!\b\u0003\u0004P\u0001\u0001\u0006Ia\u000f\u0005\u0006!\u0002!\t%\u0015\u0005\u0006m\u0002!\te\u001e\u0005\b\u0003'\u0001A\u0011IA\u000b\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!a\u000e\u0001\t\u0003\nIDA\nBeJ|wO\u00127jO\"$\bK]8ek\u000e,'O\u0003\u0002\u000e\u001d\u0005q\u0011M\u001d:po6,7o]1hS:<'BA\b\u0011\u0003!\u0011\u0018\r\u001d5u_JL(\"A\t\u0002\u0007\r|WnE\u0002\u0001'}\u0001\"\u0001F\u000f\u000e\u0003UQ!AF\f\u0002\r\u0019d\u0017n\u001a5u\u0015\tA\u0012$A\u0003beJ|wO\u0003\u0002\u001b7\u00051\u0011\r]1dQ\u0016T\u0011\u0001H\u0001\u0004_J<\u0017B\u0001\u0010\u0016\u0005Iqun\u00149GY&<\u0007\u000e\u001e)s_\u0012,8-\u001a:\u0011\u0005\u0001*S\"A\u0011\u000b\u0005\t\u001a\u0013\u0001\u00027b]\u001eT\u0011\u0001J\u0001\u0005U\u00064\u0018-\u0003\u0002'C\ti\u0011)\u001e;p\u00072|7/Z1cY\u0016\f\u0011\"\u00197m_\u000e\fGo\u001c:\u0004\u0001A\u0011!&L\u0007\u0002W)\u0011AfF\u0001\u0007[\u0016lwN]=\n\u00059Z#a\u0004\"vM\u001a,'/\u00117m_\u000e\fGo\u001c:\u0002\u00111|7-\u0019;j_:\u0004\"\u0001F\u0019\n\u0005I*\"\u0001\u0003'pG\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\r)t\u0007\u000f\t\u0003m\u0001i\u0011\u0001\u0004\u0005\u0006O\r\u0001\r!\u000b\u0005\u0006_\r\u0001\r\u0001M\u0001\tI\u0006$\u0018m]3ugV\t1\b\u0005\u0003=\u0003\u000e3U\"A\u001f\u000b\u0005yz\u0014AC2p]\u000e,(O]3oi*\u0011\u0001iI\u0001\u0005kRLG.\u0003\u0002C{\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005Q!\u0015BA#\u0016\u0005A1E.[4ii\u0012+7o\u0019:jaR|'\u000fE\u0002=\u000f&K!\u0001S\u001f\u0003\u001b\tcwnY6j]\u001e\fV/Z;f!\tQU*D\u0001L\u0015\taE\"A\u0003n_\u0012,G.\u0003\u0002O\u0017\n\u0011\u0012I\u001d:po\u001ac\u0017n\u001a5u\t\u0006$\u0018m]3u\u0003%!\u0017\r^1tKR\u001c\b%A\u0005bG\u000e,\u0007\u000f\u001e)viR!!+V5o!\t\u00013+\u0003\u0002UC\tA!+\u001e8oC\ndW\rC\u0003W\r\u0001\u0007q+A\u0004d_:$X\r\u001f;\u0011\u0005a3gBA-e\u001d\tQ6M\u0004\u0002\\E:\u0011A,\u0019\b\u0003;\u0002l\u0011A\u0018\u0006\u0003?\"\na\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005iY\u0012B\u0001\r\u001a\u0013\t1r#\u0003\u0002f+\u0005qa\t\\5hQR\u0004&o\u001c3vG\u0016\u0014\u0018BA4i\u0005-\u0019\u0015\r\u001c7D_:$X\r\u001f;\u000b\u0005\u0015,\u0002\"\u00026\u0007\u0001\u0004Y\u0017\u0001\u00044mS\u001eDGo\u0015;sK\u0006l\u0007C\u0001\u000bm\u0013\tiWC\u0001\u0007GY&<\u0007\u000e^*ue\u0016\fW\u000eC\u0003p\r\u0001\u0007\u0001/A\u0005bG.\u001cFO]3b[B\u0019\u0001,]:\n\u0005ID'AD*ue\u0016\fW\u000eT5ti\u0016tWM\u001d\t\u0003)QL!!^\u000b\u0003\u0013A+HOU3tk2$\u0018!C4fiN#(/Z1n)\u0015Ahp`A\u0005!\tIH0D\u0001{\u0015\u0005Y\u0018!B:dC2\f\u0017BA?{\u0005\u0011)f.\u001b;\t\u000bY;\u0001\u0019A,\t\u000f\u0005\u0005q\u00011\u0001\u0002\u0004\u00051A/[2lKR\u00042\u0001FA\u0003\u0013\r\t9!\u0006\u0002\u0007)&\u001c7.\u001a;\t\u000f\u0005-q\u00011\u0001\u0002\u000e\u0005AA.[:uK:,'\u000fE\u0002Y\u0003\u001fI1!!\u0005i\u0005Q\u0019VM\u001d<feN#(/Z1n\u0019&\u001cH/\u001a8fe\u0006iq-\u001a;GY&<\u0007\u000e^%oM>$b!a\u0006\u0002\u001e\u0005}\u0001c\u0001\u000b\u0002\u001a%\u0019\u00111D\u000b\u0003\u0015\u0019c\u0017n\u001a5u\u0013:4w\u000eC\u0003W\u0011\u0001\u0007q\u000b\u0003\u0004\u0002\"!\u0001\raQ\u0001\u000bI\u0016\u001c8M]5qi>\u0014\u0018a\u00037jgR4E.[4iiN$r\u0001_A\u0014\u0003S\t\u0019\u0004C\u0003W\u0013\u0001\u0007q\u000bC\u0004\u0002,%\u0001\r!!\f\u0002\u0011\r\u0014\u0018\u000e^3sS\u0006\u00042\u0001FA\u0018\u0013\r\t\t$\u0006\u0002\t\u0007JLG/\u001a:jC\"9\u00111B\u0005A\u0002\u0005U\u0002\u0003\u0002-r\u0003/\tQa\u00197pg\u0016$\u0012\u0001\u001f")
public class ArrowFlightProducer
extends NoOpFlightProducer
implements AutoCloseable {
    private final BufferAllocator allocator;
    private final Location location;
    private final ConcurrentHashMap<FlightDescriptor, BlockingQueue<ArrowFlightDataset>> datasets;

    private ConcurrentHashMap<FlightDescriptor, BlockingQueue<ArrowFlightDataset>> datasets() {
        return this.datasets;
    }

    public Runnable acceptPut(FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        return () -> {
            while (flightStream.next()) {
                VectorSchemaRoot vectorSchemaRootSent = flightStream.getRoot();
                VectorUnloader unloader = new VectorUnloader(vectorSchemaRootSent);
                ArrowRecordBatch arrowRecordBatch = unloader.getRecordBatch();
                int rows = flightStream.getRoot().getRowCount();
                ArrowFlightDataset dataset = new ArrowFlightDataset(arrowRecordBatch, flightStream.getSchema(), rows);
                Object object = !this.datasets().containsKey(flightStream.getDescriptor()) ? this.datasets().put(flightStream.getDescriptor(), new ArrayBlockingQueue(1000)) : BoxedUnit.UNIT;
                this.datasets().get(flightStream.getDescriptor()).put(dataset);
            }
            ackStream.onCompleted();
        };
    }

    public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
        FlightDescriptor flightDescriptor = FlightDescriptor.path((String[])new String[]{new String(ticket.getBytes(), StandardCharsets.UTF_8)});
        BlockingQueue<ArrowFlightDataset> queue = this.datasets().get(flightDescriptor);
        ArrowFlightDataset dataset = queue.take();
        if (dataset == null) {
            throw CallStatus.NOT_FOUND.withDescription("Unknown descriptor").toRuntimeException();
        }
        try (VectorSchemaRoot vectorSchemaRoot = VectorSchemaRoot.create((Schema)dataset.schema(), (BufferAllocator)this.allocator);){
            VectorLoader loader = new VectorLoader(vectorSchemaRoot);
            listener.start(vectorSchemaRoot);
            ArrowRecordBatch arrowRecordBatch = dataset.arrowRecordBatch();
            loader.load(arrowRecordBatch.cloneWithTransfer(this.allocator));
            listener.putNext();
            listener.completed();
        }
    }

    public FlightInfo getFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
        FlightEndpoint flightEndpoint = new FlightEndpoint(new Ticket(((String)descriptor.getPath().get(0)).getBytes(StandardCharsets.UTF_8)), new Location[]{this.location});
        ArrowFlightDataset dataset = (ArrowFlightDataset)((Queue)this.datasets().get(descriptor)).peek();
        return new FlightInfo(dataset.schema(), descriptor, Collections.singletonList(flightEndpoint), -1L, dataset.rows());
    }

    public void listFlights(FlightProducer.CallContext context, Criteria criteria, FlightProducer.StreamListener<FlightInfo> listener) {
        this.datasets().entrySet().stream().filter(k -> ((Collection)k.getValue()).size() > 0).forEach(k -> listener.onNext((Object)this.getFlightInfo(null, (FlightDescriptor)k.getKey())));
        listener.onCompleted();
    }

    @Override
    public void close() {
        Collection<BlockingQueue<ArrowFlightDataset>> queues = this.datasets().values();
        queues.forEach(q -> AutoCloseables.close((Iterable)q));
    }

    public ArrowFlightProducer(BufferAllocator allocator, Location location) {
        this.allocator = allocator;
        this.location = location;
        this.datasets = new ConcurrentHashMap();
    }
}

