import { Test } from 'nodeunit';
declare const _default: {
    'unpartitioned JSON table'(test: Test): void;
    'partitioned JSON table'(test: Test): void;
    'compressed table'(test: Test): void;
    'encrypted table': {
        'SSE-S3'(test: Test): void;
        'SSE-KMS (implicitly created key)'(test: Test): void;
        'SSE-KMS (explicitly created key)'(test: Test): void;
        'SSE-KMS_MANAGED'(test: Test): void;
        'CSE-KMS (implicitly created key)'(test: Test): void;
        'CSE-KMS (explicitly created key)'(test: Test): void;
        'CSE-KMS (explicitly passed bucket and key)'(test: Test): void;
    };
    'explicit s3 bucket and prefix'(test: Test): void;
    'grants': {
        'read only'(test: Test): void;
        'write only'(test: Test): void;
        'read and write'(test: Test): void;
    };
    'validate': {
        'at least one column'(test: Test): void;
        'unique column names'(test: Test): void;
        'unique partition keys'(test: Test): void;
        'column names and partition keys are all unique'(test: Test): void;
        'can not specify an explicit bucket and encryption'(test: Test): void;
        'can explicitly pass bucket if Encryption undefined'(test: Test): void;
        'can explicitly pass bucket if Unencrypted'(test: Test): void;
        'can explicitly pass bucket if ClientSideKms'(test: Test): void;
    };
    'Table.fromTableArn'(test: Test): void;
};
export = _default;
