"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const glue = require("../lib");
module.exports = {
    'default database creates a bucket to store the datbase'(test) {
        const stack = new core_1.Stack();
        new glue.Database(stack, 'Database', {
            databaseName: 'test_database',
        });
        assert_1.expect(stack).toMatch({
            Resources: {
                DatabaseBucket318AF64F: {
                    Type: 'AWS::S3::Bucket',
                    DeletionPolicy: "Retain",
                    UpdateReplacePolicy: "Retain"
                },
                DatabaseB269D8BB: {
                    Type: 'AWS::Glue::Database',
                    Properties: {
                        CatalogId: {
                            Ref: "AWS::AccountId"
                        },
                        DatabaseInput: {
                            LocationUri: {
                                "Fn::Join": [
                                    "",
                                    [
                                        "s3://",
                                        {
                                            Ref: "DatabaseBucket318AF64F"
                                        },
                                        "/test_database"
                                    ]
                                ]
                            },
                            Name: "test_database"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'explicit locationURI'(test) {
        const stack = new core_1.Stack();
        new glue.Database(stack, 'Database', {
            databaseName: 'test_database',
            locationUri: 's3://my-uri/'
        });
        assert_1.expect(stack).toMatch({
            Resources: {
                DatabaseB269D8BB: {
                    Type: 'AWS::Glue::Database',
                    Properties: {
                        CatalogId: {
                            Ref: "AWS::AccountId"
                        },
                        DatabaseInput: {
                            LocationUri: 's3://my-uri/',
                            Name: "test_database"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'fromDatabase'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        const database = glue.Database.fromDatabaseArn(stack, 'import', 'arn:aws:glue:us-east-1:123456789012:database/db1');
        // THEN
        test.deepEqual(database.databaseArn, 'arn:aws:glue:us-east-1:123456789012:database/db1');
        test.deepEqual(database.databaseName, 'db1');
        test.deepEqual(stack.resolve(database.catalogArn), { 'Fn::Join': ['',
                ['arn:', { Ref: 'AWS::Partition' }, ':glue:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':catalog']] });
        test.deepEqual(stack.resolve(database.catalogId), { Ref: 'AWS::AccountId' });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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