#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const kms = require("@aws-cdk/aws-kms");
const cdk = require("@aws-cdk/core");
const glue = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-glue');
const database = new glue.Database(stack, 'MyDatabase', {
    databaseName: 'my_database',
});
const ordinaryTable = new glue.Table(stack, 'MyTable', {
    database,
    tableName: 'my_table',
    columns: [{
            name: 'col1',
            type: glue.Schema.STRING
        }, {
            name: 'col2',
            type: glue.Schema.STRING,
            comment: 'col2 comment'
        }, {
            name: 'col3',
            type: glue.Schema.array(glue.Schema.STRING)
        }, {
            name: 'col4',
            type: glue.Schema.map(glue.Schema.STRING, glue.Schema.STRING)
        }, {
            name: 'col5',
            type: glue.Schema.struct([{
                    name: 'col1',
                    type: glue.Schema.STRING
                }])
        }],
    partitionKeys: [{
            name: 'year',
            type: glue.Schema.SMALL_INT
        }],
    dataFormat: glue.DataFormat.Json
});
const encryptedTable = new glue.Table(stack, 'MyEncryptedTable', {
    database,
    tableName: 'my_encrypted_table',
    columns: [{
            name: 'col1',
            type: glue.Schema.STRING
        }, {
            name: 'col2',
            type: glue.Schema.STRING,
            comment: 'col2 comment'
        }, {
            name: 'col3',
            type: glue.Schema.array(glue.Schema.STRING)
        }, {
            name: 'col4',
            type: glue.Schema.map(glue.Schema.STRING, glue.Schema.STRING)
        }, {
            name: 'col5',
            type: glue.Schema.struct([{
                    name: 'col1',
                    type: glue.Schema.STRING
                }])
        }],
    partitionKeys: [{
            name: 'year',
            type: glue.Schema.SMALL_INT
        }],
    dataFormat: glue.DataFormat.Json,
    encryption: glue.TableEncryption.KMS,
    encryptionKey: new kms.Key(stack, 'MyKey')
});
const user = new iam.User(stack, 'MyUser');
ordinaryTable.grantReadWrite(user);
encryptedTable.grantReadWrite(user);
app.synth();
//# sourceMappingURL=data:application/json;base64,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