import { Construct, IResource, Resource } from '@aws-cdk/core';
export interface IDatabase extends IResource {
    /**
     * The ARN of the catalog.
     */
    readonly catalogArn: string;
    /**
     * The catalog id of the database (usually, the AWS account id)
     */
    readonly catalogId: string;
    /**
     * The ARN of the database.
     *
     * @attribute
     */
    readonly databaseArn: string;
    /**
     * The name of the database.
     *
     * @attribute
     */
    readonly databaseName: string;
}
export interface DatabaseProps {
    /**
     * The name of the database.
     */
    readonly databaseName: string;
    /**
     * The location of the database (for example, an HDFS path).
     *
     * @default a bucket is created and the database is stored under s3://<bucket-name>/<database-name>
     */
    readonly locationUri?: string;
}
/**
 * A Glue database.
 */
export declare class Database extends Resource implements IDatabase {
    static fromDatabaseArn(scope: Construct, id: string, databaseArn: string): IDatabase;
    /**
     * ARN of the Glue catalog in which this database is stored.
     */
    readonly catalogArn: string;
    /**
     * ID of the Glue catalog in which this database is stored.
     */
    readonly catalogId: string;
    /**
     * ARN of this database.
     */
    readonly databaseArn: string;
    /**
     * Name of this database.
     */
    readonly databaseName: string;
    /**
     * Location URI of this database.
     */
    readonly locationUri: string;
    constructor(scope: Construct, id: string, props: DatabaseProps);
}
