"""ext ctrl plns

Revision ID: 944a8fd5d5bc
Revises: 27724e407e2b
Create Date: 2025-09-10 16:18:19.742118

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '944a8fd5d5bc'
down_revision: Union[str, Sequence[str], None] = '27724e407e2b'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('k8s_ext_control_planes',
    sa.Column('stack_fqdn', sa.String(length=253), nullable=False),
    sa.Column('zone', sa.String(length=253), nullable=True),
    sa.Column('name', sa.String(length=253), nullable=True),
    sa.Column('proxy_stack_fqdn', sa.String(length=253), nullable=True),
    sa.PrimaryKeyConstraint('stack_fqdn')
    )
    op.drop_table('k8s_ext_control_plane')
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('k8s_ext_control_plane',
    sa.Column('stack_fqdn', sa.VARCHAR(length=253), autoincrement=False, nullable=False),
    sa.Column('zone', sa.VARCHAR(length=253), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=253), autoincrement=False, nullable=True),
    sa.Column('proxy_stack_fqdn', sa.VARCHAR(length=253), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('stack_fqdn', name=op.f('k8s_ext_control_plane_pkey'))
    )
    op.drop_table('k8s_ext_control_planes')
    # ### end Alembic commands ###
