"""migrate old

Revision ID: 7868bcd05006
Revises: 7dea8c4ee39f
Create Date: 2025-09-09 18:09:39.760976

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = '7868bcd05006'
down_revision: Union[str, Sequence[str], None] = '7dea8c4ee39f'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('acme_x509',
    sa.Column('stack_fqdn', sa.String(length=253), nullable=False),
    sa.Column('config', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('ec_csr', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('ec_crt', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('k8s', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.PrimaryKeyConstraint('stack_fqdn')
    )
    op.create_table('k8s_ingress_rules',
    sa.Column('zone', sa.String(length=253), nullable=False),
    sa.Column('name', sa.String(length=253), nullable=False),
    sa.Column('stack_fqdn', sa.String(length=253), nullable=False),
    sa.Column('proxy_stack_fqdn', sa.String(length=253), nullable=True),
    sa.Column('external', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('zone', 'name', 'stack_fqdn')
    )
    op.create_table('k8s_masters',
    sa.Column('ip', postgresql.INET(), nullable=False),
    sa.Column('hostname', sa.String(length=253), nullable=True),
    sa.Column('stack_fqdn', sa.String(length=253), nullable=True),
    sa.Column('proxy_stack_fqdn', sa.String(length=253), nullable=True),
    sa.PrimaryKeyConstraint('ip')
    )
    op.create_table('k8s_tcp_proxies',
    sa.Column('proxy_name', sa.String(length=253), nullable=True),
    sa.Column('haproxy_port', sa.SmallInteger(), nullable=False),
    sa.Column('node_port', sa.SmallInteger(), nullable=True),
    sa.Column('stack_fqdn', sa.String(length=253), nullable=True),
    sa.Column('proxy_snippet', sa.Text(), nullable=True),
    sa.Column('proxy_stack_fqdn', sa.String(length=253), nullable=False),
    sa.Column('external', sa.Boolean(), server_default='false', nullable=True),
    sa.PrimaryKeyConstraint('haproxy_port', 'proxy_stack_fqdn')
    )
    op.create_table('k8s_workers',
    sa.Column('ip', postgresql.INET(), nullable=False),
    sa.Column('hostname', sa.String(length=253), nullable=True),
    sa.Column('stack_fqdn', sa.String(length=253), nullable=True),
    sa.Column('proxy_stack_fqdn', sa.String(length=253), nullable=True),
    sa.PrimaryKeyConstraint('ip')
    )
    op.create_table('kea_reservations',
    sa.Column('mac', postgresql.MACADDR(), nullable=False),
    sa.Column('ip', postgresql.INET(), nullable=False),
    sa.Column('hostname', sa.String(length=253), nullable=True),
    sa.Column('stack_fqdn', sa.String(length=253), nullable=True),
    sa.PrimaryKeyConstraint('ip')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('kea_reservations')
    op.drop_table('k8s_workers')
    op.drop_table('k8s_tcp_proxies')
    op.drop_table('k8s_masters')
    op.drop_table('k8s_ingress_rules')
    op.drop_table('acme_x509')
    # ### end Alembic commands ###
