"""fix

Revision ID: 3c95509a5de9
Revises: d9b711555be8
Create Date: 2025-09-10 16:03:18.769927

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '3c95509a5de9'
down_revision: Union[str, Sequence[str], None] = 'd9b711555be8'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('k8s_ext_control_plane',
    sa.Column('stack_fqdn', sa.String(length=253), nullable=False),
    sa.Column('zone', sa.String(length=253), nullable=True),
    sa.Column('name', sa.String(length=253), nullable=True),
    sa.PrimaryKeyConstraint('stack_fqdn')
    )
    op.drop_table('k8s_ext_control_plan')
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('k8s_ext_control_plan',
    sa.Column('stack_fqdn', sa.VARCHAR(length=253), autoincrement=False, nullable=False),
    sa.Column('zone', sa.VARCHAR(length=253), autoincrement=False, nullable=True),
    sa.Column('name', sa.VARCHAR(length=253), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('stack_fqdn', name=op.f('k8s_ext_control_plan_pkey'))
    )
    op.drop_table('k8s_ext_control_plane')
    # ### end Alembic commands ###
