"""len rules + enforcements

Revision ID: 24a548bfce3e
Revises: 944a8fd5d5bc
Create Date: 2025-09-10 17:12:21.594162

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '24a548bfce3e'
down_revision: Union[str, Sequence[str], None] = '944a8fd5d5bc'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('k8s_ext_control_planes', 'zone',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    op.alter_column('k8s_ext_control_planes', 'name',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    op.alter_column('k8s_ext_control_planes', 'proxy_stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)

    # custom migration logic
    op.add_column('k8s_ingress_rules', sa.Column('rule_len', sa.Integer(), nullable=True))

    conn = op.get_bind()
    conn.execute(sa.text("""
        UPDATE k8s_ingress_rules
        SET rule_len = length(zone) + length(name)
    """))

    op.alter_column('k8s_ingress_rules', 'rule_len', nullable=False)

    op.alter_column('k8s_ingress_rules', 'proxy_stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    op.alter_column('k8s_masters', 'hostname',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    op.alter_column('k8s_masters', 'stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    op.alter_column('k8s_masters', 'proxy_stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    op.alter_column('k8s_tcp_proxies', 'proxy_name',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    op.alter_column('k8s_tcp_proxies', 'node_port',
               existing_type=sa.SMALLINT(),
               nullable=False)
    op.alter_column('k8s_tcp_proxies', 'stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    op.alter_column('k8s_workers', 'hostname',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    op.alter_column('k8s_workers', 'stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    op.alter_column('k8s_workers', 'proxy_stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    op.alter_column('kea_reservations', 'hostname',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    op.alter_column('kea_reservations', 'stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('kea_reservations', 'stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.alter_column('kea_reservations', 'hostname',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.alter_column('k8s_workers', 'proxy_stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.alter_column('k8s_workers', 'stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.alter_column('k8s_workers', 'hostname',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.alter_column('k8s_tcp_proxies', 'stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.alter_column('k8s_tcp_proxies', 'node_port',
               existing_type=sa.SMALLINT(),
               nullable=True)
    op.alter_column('k8s_tcp_proxies', 'proxy_name',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.alter_column('k8s_masters', 'proxy_stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.alter_column('k8s_masters', 'stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.alter_column('k8s_masters', 'hostname',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.alter_column('k8s_ingress_rules', 'proxy_stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.drop_column('k8s_ingress_rules', 'rule_len')
    op.alter_column('k8s_ext_control_planes', 'proxy_stack_fqdn',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.alter_column('k8s_ext_control_planes', 'name',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    op.alter_column('k8s_ext_control_planes', 'zone',
               existing_type=sa.VARCHAR(length=253),
               nullable=True)
    # ### end Alembic commands ###
