#  Copyright (c) 2020. Davi Pereira dos Santos
#  This file is part of the aiuna project.
#  Please respect the license - more about this in the section (*) below.
#
#  aiuna is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  aiuna is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with aiuna.  If not, see <http://www.gnu.org/licenses/>.
#
#  (*) Removing authorship by any means, e.g. by distribution of derived
#  works or verbatim, obfuscated, compiled or rewritten versions of any
#  part of this work is a crime and is unethical regarding the effort and
#  time spent here.
#  Relevant employers or funding agencies will be notified accordingly.
from functools import cached_property

import numpy as np
from pandas import Categorical
from sklearn import datasets

from aiuna.content.creation import new, translate_type
from aiuna.content.data import Data
from aiuna.content.root import Root
from aiuna.step.file import File
from akangatu.transf.dataindependentstep_ import DataIndependentStep_


class Dataset(DataIndependentStep_):
    def __init__(self, name="iris"):
        """
        TODO: fix broken datasets
        Fetches/loads datasets from sklearn (for now):
        boston
        breast_cancer
        diabetes
        load_digits
        iris
        linnerud
        wine
        abalone

        olivetti_faces
        20newsgroups
        20newsgroups_vectorized
        lfw_people
        lfw_pairs
        covtype
        rcv1
        kddcup99
        california_housing

        :param config:
        """
        super().__init__(name=name)
        if name == "abalone":
            aba = """
%%  1. Title of Database: Abalone data
%%  
%%  2. Sources:
%%  
%%     (a) Original owners of database:
%%  	Marine Resources Division
%%  	Marine Research Laboratories - Taroona
%%  	Department of Primary Industry and Fisheries, Tasmania
%%  	GPO Box 619F, Hobart, Tasmania 7001, Australia
%%  	(contact: Warwick Nash +61 02 277277, wnash@dpi.tas.gov.au)
%%  
%%     (b) Donor of database:
%%  	Sam Waugh (Sam.Waugh@cs.utas.edu.au)
%%  	Department of Computer Science, University of Tasmania
%%  	GPO Box 252C, Hobart, Tasmania 7001, Australia
%%  
%%     (c) Date received: December 1995
%%  
%%
%%  3. Past Usage:
%%  
%%     Sam Waugh (1995) "Extending and benchmarking Cascade-Correlation", PhD
%%     thesis, Computer Science Department, University of Tasmania.
%%  
%%     -- Test set performance (final 1044 examples, first 3133 used for training):
%%  	24.86% Cascade-Correlation (no hidden nodes)
%%  	26.25% Cascade-Correlation (5 hidden nodes)
%%  	21.5%  C4.5
%%  	 0.0%  Linear Discriminate Analysis
%%  	 3.57% k=5 Nearest Neighbour
%%        (Problem encoded as a classification task)
%%  
%%     -- Data set samples are highly overlapped.  Further information is required
%%  	to separate completely using affine combinations.  Other restrictions
%%  	to data set examined.
%%  
%%     David Clark, Zoltan Schreter, Anthony Adams "A Quantitative Comparison of
%%     Dystal and Backpropagation", submitted to the Australian Conference on
%%     Neural Networks (ACNN'96). Data set treated as a 3-category classification
%%     problem (grouping ring classes 1-8, 9 and 10, and 11 on).
%%  
%%     -- Test set performance (3133 training, 1044 testing as above):
%%  	64%    Backprop
%%  	55%    Dystal
%%     -- Previous work (Waugh, 1995) on same data set:
%%  	61.40% Cascade-Correlation (no hidden nodes)
%%  	65.61% Cascade-Correlation (5 hidden nodes)
%%  	59.2%  C4.5
%%  	32.57% Linear Discriminate Analysis
%%  	62.46% k=5 Nearest Neighbour
%%  
%%
%%  4. Relevant Information Paragraph:
%%  
%%     Predicting the age of abalone from physical measurements.  The age of
%%     abalone is determined by cutting the shell through the cone, staining it,
%%     and counting the number of rings through a microscope -- a boring and
%%     time-consuming task.  Other measurements, which are easier to obtain, are
%%     used to predict the age.  Further information, such as weather patterns
%%     and location (hence food availability) may be required to solve the problem.
%%  
%%     From the original data examples with missing values were removed (the
%%     majority having the predicted value missing), and the ranges of the
%%     continuous values have been scaled for use with an ANN (by dividing by 200).
%%  
%%     Data comes from an original (non-machine-learning) study:
%%  
%%  	Warwick J Nash, Tracy L Sellers, Simon R Talbot, Andrew J Cawthorn and
%%  	Wes B Ford (1994) "The Population Biology of Abalone (_Haliotis_
%%  	species) in Tasmania. I. Blacklip Abalone (_H. rubra_) from the North
%%  	Coast and Islands of Bass Strait", Sea Fisheries Division, Technical
%%  	Report No. 48 (ISSN 1034-3288)
%%  
%%
%%  5. Number of Instances: 4177
%%  
%%
%%  6. Number of Attributes: 8
%%  
%%
%%  7. Attribute information:
%%  
%%     Given is the attribute name, attribute type, the measurement unit and a
%%     brief description.  The number of rings is the value to predict: either
%%     as a continuous value or as a classification problem.
%%  
%%  	Name		Data Type	Meas.	Description
%%  	----		---------	-----	-----------
%%  	Sex		nominal			M, F, and I (infant)
%%  	Length		continuous	mm	Longest shell measurement
%%  	Diameter	continuous	mm	perpendicular to length
%%  	Height		continuous	mm	with meat in shell
%%  	Whole weight	continuous	grams	whole abalone
%%  	Shucked weight	continuous	grams	weight of meat
%%  	Viscera weight	continuous	grams	gut weight (after bleeding)
%%  	Shell weight	continuous	grams	after being dried
%%  	Rings		integer			+1.5 gives the age in years
%%  
%%     Statistics for numeric domains:
%%  
%%  		Length	Diam	Height	Whole	Shucked	Viscera	Shell	Rings
%%  	Min	0.075	0.055	0.000	0.002	0.001	0.001	0.002	    1
%%  	Max	0.815	0.650	1.130	2.826	1.488	0.760	1.005	   29
%%  	Mean	0.524	0.408	0.140	0.829	0.359	0.181	0.239	9.934
%%  	SD	0.120	0.099	0.042	0.490	0.222	0.110	0.139	3.224
%%  	Correl	0.557	0.575	0.557	0.540	0.421	0.504	0.628	  1.0
%%  
%%
%%  8. Missing Attribute Values: None
%%  
%%
%%  9. Class Distribution:
%%  
%%  	Class	Examples
%%  	-----	--------
%%  	1	1
%%  	2	1
%%  	3	15
%%  	4	57
%%  	5	115
%%  	6	259
%%  	7	391
%%  	8	568
%%  	9	689
%%  	10	634
%%  	11	487
%%  	12	267
%%  	13	203
%%  	14	126
%%  	15	103
%%  	16	67
%%  	17	58
%%  	18	42
%%  	19	32
%%  	20	26
%%  	21	14
%%  	22	6
%%  	23	9
%%  	24	2
%%  	25	1
%%  	26	1
%%  	27	2
%%  	29	1
%%  	-----	----
%%  	Total	4177s

@relation abalone-3class

@attribute V1 {F,I,M}
@attribute V2 numeric
@attribute V3 numeric
@attribute V4 numeric
@attribute V5 numeric
@attribute V6 numeric
@attribute V7 numeric
@attribute V8 numeric
@attribute class {1,2,3}

@data
M,0.455,0.365,0.095,0.514,0.2245,0.101,0.15,3
M,0.35,0.265,0.09,0.2255,0.0995,0.0485,0.07,1
F,0.53,0.42,0.135,0.677,0.2565,0.1415,0.21,2
M,0.44,0.365,0.125,0.516,0.2155,0.114,0.155,2
I,0.33,0.255,0.08,0.205,0.0895,0.0395,0.055,1
I,0.425,0.3,0.095,0.3515,0.141,0.0775,0.12,1
F,0.53,0.415,0.15,0.7775,0.237,0.1415,0.33,3
F,0.545,0.425,0.125,0.768,0.294,0.1495,0.26,3
M,0.475,0.37,0.125,0.5095,0.2165,0.1125,0.165,2
F,0.55,0.44,0.15,0.8945,0.3145,0.151,0.32,3
F,0.525,0.38,0.14,0.6065,0.194,0.1475,0.21,3
M,0.43,0.35,0.11,0.406,0.1675,0.081,0.135,2
M,0.49,0.38,0.135,0.5415,0.2175,0.095,0.19,3
F,0.535,0.405,0.145,0.6845,0.2725,0.171,0.205,2
F,0.47,0.355,0.1,0.4755,0.1675,0.0805,0.185,2
M,0.5,0.4,0.13,0.6645,0.258,0.133,0.24,3
I,0.355,0.28,0.085,0.2905,0.095,0.0395,0.115,1
F,0.44,0.34,0.1,0.451,0.188,0.087,0.13,2
M,0.365,0.295,0.08,0.2555,0.097,0.043,0.1,1
M,0.45,0.32,0.1,0.381,0.1705,0.075,0.115,2
M,0.355,0.28,0.095,0.2455,0.0955,0.062,0.075,3
I,0.38,0.275,0.1,0.2255,0.08,0.049,0.085,2
F,0.565,0.44,0.155,0.9395,0.4275,0.214,0.27,3
F,0.55,0.415,0.135,0.7635,0.318,0.21,0.2,2
F,0.615,0.48,0.165,1.1615,0.513,0.301,0.305,2
F,0.56,0.44,0.14,0.9285,0.3825,0.188,0.3,3
F,0.58,0.45,0.185,0.9955,0.3945,0.272,0.285,3
M,0.59,0.445,0.14,0.931,0.356,0.234,0.28,3
M,0.605,0.475,0.18,0.9365,0.394,0.219,0.295,3
M,0.575,0.425,0.14,0.8635,0.393,0.227,0.2,3
M,0.58,0.47,0.165,0.9975,0.3935,0.242,0.33,2
F,0.68,0.56,0.165,1.639,0.6055,0.2805,0.46,3
M,0.665,0.525,0.165,1.338,0.5515,0.3575,0.35,3
F,0.68,0.55,0.175,1.798,0.815,0.3925,0.455,3
F,0.705,0.55,0.2,1.7095,0.633,0.4115,0.49,3
M,0.465,0.355,0.105,0.4795,0.227,0.124,0.125,1
F,0.54,0.475,0.155,1.217,0.5305,0.3075,0.34,3
F,0.45,0.355,0.105,0.5225,0.237,0.1165,0.145,1
F,0.575,0.445,0.135,0.883,0.381,0.2035,0.26,3
M,0.355,0.29,0.09,0.3275,0.134,0.086,0.09,2
F,0.45,0.335,0.105,0.425,0.1865,0.091,0.115,2
F,0.55,0.425,0.135,0.8515,0.362,0.196,0.27,3
I,0.24,0.175,0.045,0.07,0.0315,0.0235,0.02,1
I,0.205,0.15,0.055,0.042,0.0255,0.015,0.012,1
I,0.21,0.15,0.05,0.042,0.0175,0.0125,0.015,1
I,0.39,0.295,0.095,0.203,0.0875,0.045,0.075,1
M,0.47,0.37,0.12,0.5795,0.293,0.227,0.14,2
F,0.46,0.375,0.12,0.4605,0.1775,0.11,0.15,1
I,0.325,0.245,0.07,0.161,0.0755,0.0255,0.045,1
F,0.525,0.425,0.16,0.8355,0.3545,0.2135,0.245,2
I,0.52,0.41,0.12,0.595,0.2385,0.111,0.19,1
M,0.4,0.32,0.095,0.303,0.1335,0.06,0.1,1
M,0.485,0.36,0.13,0.5415,0.2595,0.096,0.16,2
F,0.47,0.36,0.12,0.4775,0.2105,0.1055,0.15,2
M,0.405,0.31,0.1,0.385,0.173,0.0915,0.11,1
F,0.5,0.4,0.14,0.6615,0.2565,0.1755,0.22,1
M,0.445,0.35,0.12,0.4425,0.192,0.0955,0.135,1
M,0.47,0.385,0.135,0.5895,0.2765,0.12,0.17,1
I,0.245,0.19,0.06,0.086,0.042,0.014,0.025,1
F,0.505,0.4,0.125,0.583,0.246,0.13,0.175,1
M,0.45,0.345,0.105,0.4115,0.18,0.1125,0.135,1
M,0.505,0.405,0.11,0.625,0.305,0.16,0.175,2
F,0.53,0.41,0.13,0.6965,0.302,0.1935,0.2,2
M,0.425,0.325,0.095,0.3785,0.1705,0.08,0.1,1
M,0.52,0.4,0.12,0.58,0.234,0.1315,0.185,1
M,0.475,0.355,0.12,0.48,0.234,0.1015,0.135,1
F,0.565,0.44,0.16,0.915,0.354,0.1935,0.32,3
F,0.595,0.495,0.185,1.285,0.416,0.224,0.485,3
F,0.475,0.39,0.12,0.5305,0.2135,0.1155,0.17,2
I,0.31,0.235,0.07,0.151,0.063,0.0405,0.045,1
M,0.555,0.425,0.13,0.7665,0.264,0.168,0.275,3
F,0.4,0.32,0.11,0.353,0.1405,0.0985,0.1,1
F,0.595,0.475,0.17,1.247,0.48,0.225,0.425,3
M,0.57,0.48,0.175,1.185,0.474,0.261,0.38,3
F,0.605,0.45,0.195,1.098,0.481,0.2895,0.315,3
F,0.6,0.475,0.15,1.0075,0.4425,0.221,0.28,3
M,0.595,0.475,0.14,0.944,0.3625,0.189,0.315,2
F,0.6,0.47,0.15,0.922,0.363,0.194,0.305,2
F,0.555,0.425,0.14,0.788,0.282,0.1595,0.285,3
F,0.615,0.475,0.17,1.1025,0.4695,0.2355,0.345,3
F,0.575,0.445,0.14,0.941,0.3845,0.252,0.285,2
M,0.62,0.51,0.175,1.615,0.5105,0.192,0.675,3
F,0.52,0.425,0.165,0.9885,0.396,0.225,0.32,3
M,0.595,0.475,0.16,1.3175,0.408,0.234,0.58,3
M,0.58,0.45,0.14,1.013,0.38,0.216,0.36,3
F,0.57,0.465,0.18,1.295,0.339,0.2225,0.44,3
M,0.625,0.465,0.14,1.195,0.4825,0.205,0.4,3
M,0.56,0.44,0.16,0.8645,0.3305,0.2075,0.26,2
F,0.46,0.355,0.13,0.517,0.2205,0.114,0.165,2
F,0.575,0.45,0.16,0.9775,0.3135,0.231,0.33,3
M,0.565,0.425,0.135,0.8115,0.341,0.1675,0.255,3
M,0.555,0.44,0.15,0.755,0.307,0.1525,0.26,3
M,0.595,0.465,0.175,1.115,0.4015,0.254,0.39,3
F,0.625,0.495,0.165,1.262,0.507,0.318,0.39,2
M,0.695,0.56,0.19,1.494,0.588,0.3425,0.485,3
M,0.665,0.535,0.195,1.606,0.5755,0.388,0.48,3
M,0.535,0.435,0.15,0.725,0.269,0.1385,0.25,2
M,0.47,0.375,0.13,0.523,0.214,0.132,0.145,1
M,0.47,0.37,0.13,0.5225,0.201,0.133,0.165,1
F,0.475,0.375,0.125,0.5785,0.2775,0.085,0.155,2
I,0.36,0.265,0.095,0.2315,0.105,0.046,0.075,1
M,0.55,0.435,0.145,0.843,0.328,0.1915,0.255,3
M,0.53,0.435,0.16,0.883,0.316,0.164,0.335,3
M,0.53,0.415,0.14,0.724,0.3105,0.1675,0.205,2
M,0.605,0.47,0.16,1.1735,0.4975,0.2405,0.345,3
F,0.52,0.41,0.155,0.727,0.291,0.1835,0.235,3
F,0.545,0.43,0.165,0.802,0.2935,0.183,0.28,3
F,0.5,0.4,0.125,0.6675,0.261,0.1315,0.22,2
F,0.51,0.39,0.135,0.6335,0.231,0.179,0.2,2
F,0.435,0.395,0.105,0.3635,0.136,0.098,0.13,2
M,0.495,0.395,0.125,0.5415,0.2375,0.1345,0.155,2
M,0.465,0.36,0.105,0.431,0.172,0.107,0.175,2
I,0.435,0.32,0.08,0.3325,0.1485,0.0635,0.105,2
M,0.425,0.35,0.105,0.393,0.13,0.063,0.165,2
F,0.545,0.41,0.125,0.6935,0.2975,0.146,0.21,3
F,0.53,0.415,0.115,0.5915,0.233,0.1585,0.18,3
F,0.49,0.375,0.135,0.6125,0.2555,0.102,0.22,3
M,0.44,0.34,0.105,0.402,0.1305,0.0955,0.165,2
F,0.56,0.43,0.15,0.8825,0.3465,0.172,0.31,2
M,0.405,0.305,0.085,0.2605,0.1145,0.0595,0.085,1
F,0.47,0.365,0.105,0.4205,0.163,0.1035,0.14,2
I,0.385,0.295,0.085,0.2535,0.103,0.0575,0.085,1
F,0.515,0.425,0.14,0.766,0.304,0.1725,0.255,3
M,0.37,0.265,0.075,0.214,0.09,0.051,0.07,1
I,0.36,0.28,0.08,0.1755,0.081,0.0505,0.07,1
I,0.27,0.195,0.06,0.073,0.0285,0.0235,0.03,1
I,0.375,0.275,0.09,0.238,0.1075,0.0545,0.07,1
I,0.385,0.29,0.085,0.2505,0.112,0.061,0.08,1
M,0.7,0.535,0.16,1.7255,0.63,0.2635,0.54,3
M,0.71,0.54,0.165,1.959,0.7665,0.261,0.78,3
M,0.595,0.48,0.165,1.262,0.4835,0.283,0.41,3
F,0.44,0.35,0.125,0.4035,0.175,0.063,0.129,2
F,0.325,0.26,0.09,0.1915,0.085,0.036,0.062,1
I,0.35,0.26,0.095,0.211,0.086,0.056,0.068,1
I,0.265,0.2,0.065,0.0975,0.04,0.0205,0.028,1
F,0.425,0.33,0.115,0.406,0.1635,0.081,0.1355,1
F,0.305,0.23,0.08,0.156,0.0675,0.0345,0.048,1
M,0.345,0.255,0.09,0.2005,0.094,0.0295,0.063,2
F,0.405,0.325,0.11,0.3555,0.151,0.063,0.117,2
M,0.375,0.285,0.095,0.253,0.096,0.0575,0.0925,2
F,0.565,0.445,0.155,0.826,0.341,0.2055,0.2475,2
F,0.55,0.45,0.145,0.741,0.295,0.1435,0.2665,2
M,0.65,0.52,0.19,1.3445,0.519,0.306,0.4465,3
M,0.56,0.455,0.155,0.797,0.34,0.19,0.2425,3
M,0.475,0.375,0.13,0.5175,0.2075,0.1165,0.17,2
F,0.49,0.38,0.125,0.549,0.245,0.1075,0.174,2
M,0.46,0.35,0.12,0.515,0.224,0.108,0.1565,2
I,0.28,0.205,0.08,0.127,0.052,0.039,0.042,2
I,0.175,0.13,0.055,0.0315,0.0105,0.0065,0.0125,1
I,0.17,0.13,0.095,0.03,0.013,0.008,0.01,1
M,0.59,0.475,0.145,1.053,0.4415,0.262,0.325,3
F,0.605,0.5,0.185,1.1185,0.469,0.2585,0.335,2
F,0.635,0.515,0.19,1.3715,0.5065,0.305,0.45,2
F,0.605,0.485,0.16,1.0565,0.37,0.2355,0.355,2
F,0.565,0.45,0.135,0.9885,0.387,0.1495,0.31,3
M,0.515,0.405,0.13,0.722,0.32,0.131,0.21,2
F,0.575,0.46,0.19,0.994,0.392,0.2425,0.34,3
M,0.645,0.485,0.215,1.514,0.546,0.2615,0.635,3
F,0.58,0.455,0.17,0.9075,0.374,0.2135,0.285,3
F,0.575,0.46,0.165,1.124,0.2985,0.1785,0.44,3
M,0.605,0.465,0.165,1.056,0.4215,0.2475,0.34,3
F,0.605,0.485,0.16,1.222,0.53,0.2575,0.28,3
M,0.61,0.485,0.175,1.2445,0.544,0.297,0.345,3
F,0.725,0.56,0.21,2.141,0.65,0.398,1.005,3
F,0.65,0.545,0.23,1.752,0.5605,0.2895,0.815,3
M,0.725,0.57,0.19,2.55,1.0705,0.483,0.725,3
F,0.725,0.575,0.175,2.124,0.765,0.4515,0.85,3
F,0.68,0.57,0.205,1.842,0.625,0.408,0.65,3
M,0.705,0.56,0.22,1.981,0.8175,0.3085,0.76,3
F,0.68,0.515,0.175,1.6185,0.5125,0.409,0.62,3
M,0.695,0.55,0.215,1.9565,0.7125,0.541,0.59,3
F,0.53,0.395,0.145,0.775,0.308,0.169,0.255,1
M,0.525,0.435,0.155,1.065,0.486,0.233,0.285,1
F,0.52,0.405,0.115,0.776,0.32,0.1845,0.22,1
I,0.235,0.16,0.04,0.048,0.0185,0.018,0.015,1
I,0.36,0.26,0.09,0.1785,0.0645,0.037,0.075,1
I,0.315,0.21,0.06,0.125,0.06,0.0375,0.035,1
I,0.315,0.245,0.085,0.1435,0.053,0.0475,0.05,1
I,0.225,0.16,0.045,0.0465,0.025,0.015,0.015,1
M,0.58,0.475,0.15,0.97,0.385,0.2165,0.35,3
M,0.57,0.48,0.18,0.9395,0.399,0.2,0.295,3
M,0.64,0.51,0.175,1.368,0.515,0.266,0.57,3
F,0.56,0.45,0.16,1.0235,0.429,0.268,0.3,2
F,0.62,0.475,0.175,1.0165,0.4355,0.214,0.325,2
F,0.645,0.51,0.2,1.5675,0.621,0.367,0.46,3
M,0.62,0.49,0.19,1.218,0.5455,0.2965,0.355,3
F,0.63,0.48,0.15,1.0525,0.392,0.336,0.285,3
F,0.63,0.5,0.185,1.383,0.54,0.3315,0.38,2
F,0.63,0.48,0.16,1.199,0.5265,0.335,0.315,3
F,0.585,0.46,0.17,0.9325,0.365,0.271,0.29,2
M,0.615,0.48,0.18,1.1595,0.4845,0.2165,0.325,3
M,0.61,0.485,0.17,1.0225,0.419,0.2405,0.36,3
M,0.58,0.45,0.15,0.927,0.276,0.1815,0.36,3
I,0.355,0.275,0.085,0.22,0.092,0.06,0.15,1
F,0.51,0.4,0.14,0.8145,0.459,0.1965,0.195,2
M,0.5,0.405,0.155,0.772,0.346,0.1535,0.245,3
F,0.505,0.41,0.15,0.644,0.285,0.145,0.21,3
M,0.64,0.5,0.185,1.3035,0.4445,0.2635,0.465,3
M,0.56,0.45,0.16,0.922,0.432,0.178,0.26,3
M,0.585,0.46,0.185,0.922,0.3635,0.213,0.285,2
F,0.45,0.345,0.12,0.4165,0.1655,0.095,0.135,2
M,0.5,0.4,0.165,0.825,0.254,0.205,0.285,3
F,0.5,0.4,0.145,0.63,0.234,0.1465,0.23,3
F,0.53,0.435,0.17,0.8155,0.2985,0.155,0.275,3
M,0.42,0.335,0.115,0.369,0.171,0.071,0.12,1
F,0.44,0.34,0.14,0.482,0.186,0.1085,0.16,2
I,0.4,0.3,0.11,0.315,0.109,0.067,0.12,2
I,0.435,0.34,0.11,0.3795,0.1495,0.085,0.12,1
F,0.525,0.415,0.17,0.8325,0.2755,0.1685,0.31,3
I,0.37,0.28,0.095,0.2655,0.122,0.052,0.08,1
F,0.49,0.365,0.145,0.6345,0.1995,0.1625,0.22,2
M,0.335,0.25,0.09,0.181,0.0755,0.0415,0.06,1
F,0.415,0.325,0.105,0.38,0.1595,0.0785,0.12,3
M,0.5,0.405,0.14,0.6155,0.241,0.1355,0.205,2
F,0.485,0.395,0.16,0.66,0.2475,0.128,0.235,3
M,0.55,0.405,0.14,0.8025,0.244,0.1635,0.255,2
M,0.45,0.35,0.13,0.46,0.174,0.111,0.135,1
I,0.405,0.3,0.12,0.324,0.1265,0.07,0.11,1
M,0.47,0.36,0.135,0.501,0.1665,0.115,0.165,2
F,0.415,0.305,0.13,0.32,0.1305,0.0755,0.105,1
F,0.445,0.325,0.125,0.455,0.1785,0.1125,0.14,2
F,0.47,0.35,0.145,0.5175,0.187,0.1235,0.18,3
F,0.49,0.375,0.15,0.5755,0.22,0.144,0.19,2
F,0.445,0.355,0.15,0.485,0.181,0.125,0.155,3
I,0.425,0.38,0.105,0.3265,0.1285,0.0785,0.1,2
F,0.5,0.37,0.135,0.45,0.1715,0.1055,0.155,2
F,0.39,0.29,0.125,0.3055,0.121,0.082,0.09,1
I,0.365,0.27,0.085,0.205,0.078,0.0485,0.07,1
F,0.58,0.465,0.165,1.1015,0.404,0.2095,0.35,3
F,0.53,0.415,0.16,0.783,0.2935,0.158,0.245,3
M,0.555,0.445,0.135,0.836,0.336,0.1625,0.275,3
M,0.565,0.44,0.175,0.9025,0.31,0.193,0.325,3
M,0.625,0.505,0.215,1.4455,0.496,0.287,0.435,3
I,0.275,0.215,0.075,0.1155,0.0485,0.029,0.035,1
I,0.44,0.35,0.135,0.435,0.1815,0.083,0.125,3
I,0.295,0.225,0.08,0.124,0.0485,0.032,0.04,2
I,0.075,0.055,0.01,0.002,0.001,0.0005,0.0015,1
I,0.13,0.1,0.03,0.013,0.0045,0.003,0.004,1
I,0.11,0.09,0.03,0.008,0.0025,0.002,0.003,1
I,0.16,0.12,0.035,0.021,0.0075,0.0045,0.005,1
M,0.565,0.425,0.16,0.9425,0.3495,0.2185,0.275,3
I,0.27,0.2,0.07,0.1,0.034,0.0245,0.035,1
I,0.23,0.175,0.065,0.0645,0.026,0.0105,0.02,1
I,0.3,0.23,0.08,0.1275,0.0435,0.0265,0.04,1
I,0.33,0.255,0.085,0.1655,0.063,0.039,0.06,1
I,0.35,0.26,0.085,0.174,0.0705,0.0345,0.06,2
I,0.32,0.245,0.08,0.1585,0.0635,0.0325,0.05,3
I,0.36,0.275,0.085,0.1975,0.0745,0.0415,0.07,2
I,0.305,0.245,0.075,0.156,0.0675,0.038,0.045,1
I,0.345,0.27,0.11,0.2135,0.082,0.0545,0.07,1
I,0.33,0.25,0.105,0.1715,0.0655,0.035,0.06,1
M,0.59,0.47,0.18,1.1235,0.4205,0.2805,0.36,3
F,0.595,0.455,0.155,1.0605,0.5135,0.2165,0.3,3
F,0.575,0.46,0.185,1.094,0.4485,0.217,0.345,3
M,0.6,0.495,0.165,1.2415,0.485,0.2775,0.34,3
M,0.56,0.45,0.175,1.011,0.3835,0.2065,0.37,3
M,0.56,0.45,0.185,1.07,0.3805,0.175,0.41,3
M,0.545,0.46,0.16,0.8975,0.341,0.1655,0.345,2
F,0.635,0.505,0.17,1.415,0.605,0.297,0.365,3
F,0.59,0.475,0.16,1.1015,0.4775,0.2555,0.295,3
F,0.54,0.475,0.155,0.928,0.394,0.194,0.26,3
F,0.57,0.44,0.125,0.865,0.3675,0.1725,0.27,3
M,0.53,0.42,0.165,0.8945,0.319,0.239,0.245,3
I,0.245,0.195,0.06,0.095,0.0445,0.0245,0.026,1
M,0.27,0.2,0.08,0.1205,0.0465,0.028,0.04,1
F,0.46,0.38,0.13,0.639,0.3,0.1525,0.16,3
M,0.52,0.45,0.15,0.895,0.3615,0.186,0.235,3
M,0.35,0.275,0.11,0.2925,0.1225,0.0635,0.0905,1
M,0.47,0.39,0.15,0.6355,0.2185,0.0885,0.255,2
F,0.45,0.36,0.125,0.4995,0.2035,0.1,0.17,3
F,0.64,0.525,0.215,1.779,0.4535,0.2855,0.55,3
M,0.59,0.5,0.2,1.187,0.412,0.2705,0.37,3
M,0.62,0.485,0.205,1.219,0.3875,0.2505,0.385,3
M,0.63,0.505,0.225,1.525,0.56,0.3335,0.45,3
M,0.63,0.515,0.155,1.259,0.4105,0.197,0.41,3
M,0.655,0.54,0.215,1.844,0.7425,0.327,0.585,3
F,0.66,0.53,0.185,1.3485,0.493,0.245,0.49,3
M,0.61,0.5,0.24,1.642,0.532,0.3345,0.69,3
M,0.635,0.525,0.205,1.484,0.55,0.3115,0.43,3
F,0.515,0.425,0.135,0.712,0.2665,0.1605,0.25,3
F,0.535,0.415,0.185,0.8415,0.314,0.1585,0.3,3
I,0.36,0.285,0.105,0.2415,0.0915,0.057,0.075,1
F,0.455,0.355,0.12,0.4495,0.177,0.104,0.15,2
M,0.485,0.395,0.14,0.6295,0.2285,0.127,0.225,3
M,0.515,0.38,0.175,0.9565,0.325,0.158,0.31,3
F,0.535,0.415,0.17,0.879,0.295,0.1965,0.285,2
M,0.53,0.435,0.155,0.699,0.288,0.1595,0.205,2
F,0.495,0.4,0.155,0.6445,0.242,0.1325,0.205,3
M,0.44,0.355,0.125,0.4775,0.132,0.0815,0.19,2
F,0.535,0.435,0.16,0.8105,0.3155,0.1795,0.24,2
M,0.54,0.435,0.18,0.996,0.3835,0.226,0.325,3
F,0.565,0.505,0.21,1.2765,0.501,0.279,0.355,3
M,0.61,0.475,0.165,1.116,0.428,0.2205,0.315,3
F,0.565,0.455,0.175,1.013,0.342,0.207,0.35,3
M,0.6,0.495,0.195,1.0575,0.384,0.19,0.375,3
I,0.295,0.215,0.085,0.128,0.049,0.034,0.04,1
I,0.275,0.205,0.075,0.1105,0.045,0.0285,0.035,1
I,0.28,0.21,0.085,0.1065,0.039,0.0295,0.03,1
M,0.49,0.395,0.14,0.549,0.2215,0.1275,0.15,3
M,0.37,0.28,0.105,0.234,0.0905,0.0585,0.075,2
F,0.405,0.305,0.095,0.3485,0.1455,0.0895,0.1,2
F,0.54,0.435,0.175,0.892,0.322,0.174,0.335,3
M,0.37,0.28,0.1,0.252,0.1065,0.0595,0.074,1
M,0.36,0.27,0.1,0.217,0.0885,0.0495,0.0715,1
F,0.47,0.36,0.13,0.472,0.182,0.114,0.15,2
I,0.2,0.145,0.06,0.037,0.0125,0.0095,0.011,1
I,0.165,0.12,0.03,0.0215,0.007,0.005,0.005,1
M,0.645,0.515,0.24,1.5415,0.471,0.369,0.535,3
M,0.55,0.41,0.125,0.7605,0.2505,0.1635,0.195,3
M,0.57,0.435,0.145,0.9055,0.3925,0.2355,0.275,2
F,0.63,0.485,0.19,1.2435,0.4635,0.3055,0.39,3
M,0.56,0.44,0.14,0.971,0.443,0.2045,0.265,3
M,0.595,0.455,0.195,1.3305,0.4595,0.3235,0.345,3
F,0.62,0.47,0.2,1.2255,0.381,0.27,0.435,3
M,0.63,0.485,0.175,1.3,0.4335,0.2945,0.46,3
I,0.45,0.355,0.11,0.4585,0.194,0.067,0.14,1
F,0.635,0.535,0.19,1.242,0.576,0.2475,0.39,3
M,0.45,0.35,0.1,0.3675,0.1465,0.1015,0.12,2
F,0.58,0.455,0.155,0.8365,0.315,0.1385,0.32,3
I,0.33,0.255,0.095,0.172,0.066,0.0255,0.06,1
I,0.265,0.21,0.06,0.0965,0.0425,0.022,0.03,1
I,0.19,0.145,0.04,0.038,0.0165,0.0065,0.015,1
M,0.385,0.31,0.1,0.2845,0.1065,0.075,0.1,3
I,0.265,0.205,0.07,0.1055,0.039,0.041,0.035,1
M,0.335,0.265,0.105,0.222,0.0935,0.056,0.075,1
I,0.355,0.275,0.09,0.251,0.097,0.053,0.08,1
I,0.32,0.255,0.1,0.1755,0.073,0.0415,0.065,1
M,0.51,0.4,0.13,0.6435,0.27,0.1665,0.205,3
M,0.36,0.295,0.105,0.241,0.0865,0.053,0.095,1
I,0.36,0.28,0.09,0.2255,0.0885,0.04,0.09,1
M,0.5,0.38,0.155,0.5955,0.2135,0.161,0.2,3
F,0.4,0.325,0.12,0.3185,0.134,0.0565,0.095,1
I,0.3,0.22,0.08,0.121,0.0475,0.042,0.035,1
I,0.235,0.175,0.04,0.0705,0.0335,0.015,0.02,1
F,0.74,0.6,0.195,1.974,0.598,0.4085,0.71,3
M,0.62,0.465,0.19,1.3415,0.5705,0.3175,0.355,3
M,0.6,0.475,0.19,1.0875,0.403,0.2655,0.325,3
M,0.59,0.45,0.185,1.283,0.473,0.276,0.425,3
M,0.62,0.475,0.185,1.325,0.6045,0.325,0.33,3
F,0.565,0.45,0.195,1.0035,0.406,0.2505,0.285,3
M,0.575,0.455,0.145,1.165,0.581,0.2275,0.3,3
F,0.62,0.51,0.205,1.3475,0.4775,0.2565,0.48,3
M,0.62,0.465,0.185,1.274,0.579,0.3065,0.32,3
F,0.505,0.375,0.18,0.568,0.2325,0.1495,0.17,3
F,0.46,0.425,0.155,0.746,0.3005,0.152,0.24,1
M,0.49,0.39,0.14,0.707,0.2795,0.2185,0.18,3
F,0.525,0.42,0.16,0.756,0.2745,0.173,0.275,2
I,0.34,0.26,0.08,0.2,0.08,0.0555,0.055,1
I,0.375,0.305,0.115,0.2715,0.092,0.074,0.09,1
M,0.61,0.48,0.15,1.2,0.56,0.2455,0.28,3
F,0.61,0.495,0.185,1.153,0.536,0.2905,0.245,1
F,0.585,0.45,0.17,0.8685,0.3325,0.1635,0.27,3
M,0.57,0.46,0.14,0.9535,0.4465,0.2065,0.245,3
M,0.58,0.455,0.17,0.93,0.408,0.259,0.22,2
M,0.635,0.515,0.17,1.275,0.509,0.286,0.34,3
M,0.7,0.58,0.205,2.13,0.7415,0.49,0.58,3
M,0.675,0.525,0.185,1.587,0.6935,0.336,0.395,3
F,0.645,0.525,0.19,1.8085,0.7035,0.3885,0.395,3
M,0.745,0.585,0.215,2.499,0.9265,0.472,0.7,3
F,0.685,0.545,0.18,1.768,0.7495,0.392,0.485,3
M,0.605,0.49,0.18,1.227,0.48,0.287,0.35,3
F,0.59,0.465,0.15,0.997,0.392,0.246,0.34,3
F,0.65,0.525,0.175,1.4225,0.61,0.2995,0.445,3
F,0.6,0.48,0.15,1.029,0.4085,0.2705,0.295,3
F,0.62,0.5,0.175,1.186,0.4985,0.3015,0.35,3
M,0.63,0.515,0.16,1.016,0.4215,0.244,0.355,3
M,0.58,0.465,0.145,0.887,0.4405,0.1655,0.265,3
F,0.58,0.455,0.12,1.0735,0.479,0.2735,0.265,2
M,0.63,0.49,0.18,1.13,0.458,0.2765,0.315,3
F,0.69,0.56,0.215,1.719,0.68,0.299,0.47,3
F,0.65,0.545,0.165,1.566,0.6645,0.3455,0.415,3
F,0.66,0.565,0.195,1.7605,0.692,0.3265,0.5,3
F,0.68,0.58,0.2,1.787,0.585,0.453,0.6,3
F,0.7,0.575,0.17,1.31,0.5095,0.314,0.42,3
M,0.685,0.52,0.15,1.343,0.4635,0.292,0.4,3
F,0.675,0.545,0.195,1.7345,0.6845,0.3695,0.605,3
M,0.63,0.49,0.19,1.1775,0.4935,0.3365,0.285,3
F,0.585,0.45,0.16,1.077,0.4995,0.2875,0.25,2
M,0.565,0.465,0.175,0.995,0.3895,0.183,0.37,3
F,0.61,0.495,0.185,1.1085,0.3705,0.3135,0.33,3
M,0.605,0.47,0.18,1.1405,0.3755,0.2805,0.385,3
M,0.535,0.42,0.145,0.791,0.33,0.189,0.25,2
M,0.485,0.4,0.135,0.663,0.313,0.137,0.2,2
M,0.47,0.375,0.12,0.5565,0.226,0.122,0.195,3
M,0.545,0.425,0.135,0.8445,0.373,0.21,0.235,2
F,0.455,0.37,0.105,0.4925,0.216,0.1245,0.135,2
M,0.54,0.42,0.155,0.7385,0.3515,0.152,0.215,3
M,0.46,0.38,0.135,0.482,0.207,0.1225,0.145,2
M,0.49,0.42,0.125,0.609,0.239,0.1435,0.22,3
I,0.465,0.375,0.12,0.471,0.222,0.119,0.14,2
I,0.415,0.325,0.1,0.3215,0.1535,0.0595,0.105,2
M,0.475,0.375,0.125,0.593,0.277,0.115,0.18,2
F,0.47,0.375,0.125,0.5615,0.252,0.137,0.18,2
I,0.365,0.295,0.095,0.25,0.1075,0.0545,0.08,2
I,0.345,0.275,0.095,0.1995,0.0755,0.0535,0.07,1
I,0.39,0.31,0.1,0.302,0.116,0.064,0.115,3
F,0.5,0.395,0.14,0.7155,0.3165,0.176,0.24,2
M,0.47,0.38,0.145,0.5865,0.2385,0.144,0.185,1
M,0.535,0.44,0.15,0.6765,0.256,0.139,0.26,3
M,0.585,0.455,0.15,0.987,0.4355,0.2075,0.31,3
F,0.485,0.365,0.12,0.5885,0.27,0.131,0.175,2
M,0.515,0.455,0.135,0.7225,0.295,0.1625,0.235,2
F,0.435,0.325,0.11,0.4335,0.178,0.0985,0.155,1
F,0.515,0.415,0.14,0.6935,0.3115,0.152,0.2,2
I,0.44,0.345,0.12,0.365,0.1655,0.083,0.11,1
F,0.525,0.44,0.15,0.8425,0.3685,0.1985,0.24,3
M,0.45,0.355,0.115,0.479,0.2125,0.1045,0.15,1
M,0.59,0.485,0.12,0.911,0.39,0.182,0.29,3
M,0.555,0.45,0.145,0.915,0.4,0.246,0.285,3
M,0.57,0.44,0.095,0.827,0.3395,0.2215,0.235,1
M,0.59,0.5,0.165,1.1045,0.4565,0.2425,0.34,3
M,0.585,0.475,0.12,0.945,0.41,0.2115,0.28,3
F,0.58,0.46,0.12,0.9935,0.4625,0.2385,0.28,3
M,0.545,0.44,0.12,0.8565,0.3475,0.1715,0.24,3
F,0.605,0.495,0.17,1.2385,0.528,0.2465,0.39,3
F,0.62,0.47,0.14,1.0325,0.3605,0.224,0.36,3
F,0.63,0.5,0.17,1.3135,0.5595,0.267,0.4,3
M,0.63,0.515,0.165,1.352,0.488,0.349,0.45,3
F,0.63,0.5,0.155,1.005,0.367,0.199,0.36,3
M,0.545,0.41,0.14,0.625,0.223,0.16,0.235,3
F,0.67,0.54,0.165,1.5015,0.518,0.358,0.505,3
I,0.49,0.38,0.12,0.529,0.2165,0.139,0.155,3
F,0.49,0.39,0.135,0.5785,0.2465,0.123,0.2,3
I,0.29,0.225,0.07,0.101,0.036,0.0235,0.035,1
I,0.26,0.2,0.07,0.092,0.037,0.02,0.03,1
M,0.58,0.45,0.175,1.068,0.425,0.203,0.32,3
F,0.61,0.485,0.165,1.0915,0.3935,0.2435,0.33,3
M,0.6,0.5,0.16,1.015,0.3995,0.1735,0.33,3
F,0.56,0.455,0.125,0.943,0.344,0.129,0.375,3
F,0.575,0.45,0.17,1.0475,0.3775,0.1705,0.385,3
F,0.57,0.45,0.175,0.9555,0.38,0.1665,0.295,3
M,0.6,0.47,0.155,1.036,0.4375,0.196,0.325,3
M,0.565,0.455,0.17,0.9065,0.342,0.156,0.32,3
M,0.545,0.42,0.14,0.7505,0.2475,0.13,0.255,3
I,0.44,0.345,0.1,0.366,0.122,0.0905,0.12,3
M,0.5,0.41,0.15,0.662,0.2815,0.137,0.22,3
I,0.36,0.275,0.095,0.217,0.084,0.0435,0.09,1
I,0.385,0.305,0.095,0.252,0.0915,0.055,0.09,3
M,0.39,0.3,0.09,0.3055,0.143,0.0645,0.085,2
M,0.5,0.415,0.165,0.6885,0.249,0.138,0.25,3
I,0.36,0.275,0.11,0.2335,0.095,0.0525,0.085,2
I,0.335,0.26,0.1,0.192,0.0785,0.0585,0.07,1
F,0.505,0.425,0.14,0.85,0.275,0.1625,0.285,3
I,0.395,0.295,0.1,0.2715,0.134,0.0325,0.085,2
F,0.41,0.325,0.105,0.3635,0.159,0.077,0.12,2
F,0.56,0.455,0.19,0.714,0.283,0.129,0.275,2
M,0.565,0.435,0.185,0.9815,0.329,0.136,0.39,3
M,0.565,0.455,0.185,0.9265,0.354,0.1575,0.375,3
M,0.605,0.5,0.175,1.098,0.4765,0.232,0.375,3
F,0.565,0.455,0.15,0.8205,0.365,0.159,0.26,3
M,0.725,0.565,0.215,1.891,0.6975,0.4725,0.58,3
F,0.675,0.535,0.16,1.41,0.592,0.3175,0.42,3
F,0.665,0.555,0.195,1.4385,0.581,0.354,0.36,3
F,0.565,0.49,0.155,0.9245,0.405,0.2195,0.255,3
F,0.645,0.55,0.175,1.2915,0.57,0.3045,0.33,3
M,0.575,0.47,0.14,0.8375,0.3485,0.1735,0.24,3
F,0.64,0.54,0.175,1.221,0.51,0.259,0.39,3
I,0.36,0.28,0.105,0.199,0.0695,0.045,0.08,2
I,0.415,0.31,0.11,0.2965,0.123,0.057,0.0995,2
F,0.525,0.41,0.135,0.7085,0.293,0.1525,0.235,3
M,0.38,0.285,0.1,0.2665,0.115,0.061,0.075,3
F,0.585,0.465,0.17,0.9915,0.3865,0.224,0.265,3
I,0.24,0.185,0.07,0.0715,0.026,0.018,0.025,1
I,0.22,0.165,0.055,0.0545,0.0215,0.012,0.02,1
I,0.255,0.195,0.07,0.0735,0.0255,0.02,0.025,1
I,0.175,0.125,0.05,0.0235,0.008,0.0035,0.008,1
F,0.67,0.55,0.19,1.3905,0.5425,0.3035,0.4,3
M,0.655,0.53,0.195,1.388,0.567,0.2735,0.41,3
F,0.68,0.55,0.21,1.7445,0.5975,0.305,0.625,3
M,0.675,0.555,0.2,1.4385,0.545,0.2665,0.465,3
F,0.53,0.44,0.135,0.7835,0.313,0.1715,0.2185,2
F,0.515,0.405,0.12,0.646,0.2895,0.1405,0.177,2
I,0.43,0.34,0.12,0.3575,0.151,0.0645,0.1045,2
F,0.52,0.405,0.12,0.627,0.2645,0.1415,0.181,3
F,0.545,0.415,0.16,0.7715,0.272,0.1455,0.2765,2
M,0.53,0.415,0.175,0.7395,0.261,0.1395,0.2645,3
F,0.465,0.35,0.115,0.421,0.1565,0.091,0.1345,2
M,0.665,0.54,0.175,1.347,0.4955,0.254,0.415,3
M,0.735,0.59,0.225,1.756,0.637,0.3405,0.58,3
M,0.66,0.545,0.185,1.32,0.5305,0.2635,0.455,3
F,0.7,0.585,0.185,1.8075,0.7055,0.3215,0.475,3
M,0.575,0.4,0.155,0.9325,0.3605,0.2445,0.3,3
M,0.57,0.465,0.125,0.849,0.3785,0.1765,0.24,3
F,0.58,0.46,0.15,0.9955,0.429,0.212,0.26,3
M,0.63,0.48,0.145,1.0115,0.4235,0.237,0.305,3
F,0.585,0.465,0.14,0.908,0.381,0.1615,0.315,3
M,0.55,0.45,0.13,0.92,0.378,0.2385,0.29,3
F,0.625,0.515,0.15,1.2415,0.5235,0.3065,0.36,3
M,0.54,0.42,0.135,0.8075,0.3485,0.1795,0.235,3
F,0.57,0.455,0.165,1.0595,0.44,0.2195,0.285,3
M,0.59,0.455,0.145,1.073,0.475,0.19,0.285,3
M,0.58,0.46,0.13,0.921,0.357,0.181,0.29,3
F,0.655,0.51,0.155,1.2895,0.5345,0.2855,0.41,3
M,0.655,0.53,0.175,1.2635,0.486,0.2635,0.415,3
M,0.625,0.5,0.195,1.369,0.5875,0.2185,0.37,3
F,0.625,0.5,0.15,0.953,0.3445,0.2235,0.305,3
F,0.64,0.52,0.175,1.248,0.4245,0.2595,0.48,3
F,0.605,0.485,0.165,1.0105,0.435,0.209,0.3,3
F,0.615,0.525,0.155,1.0385,0.427,0.2315,0.345,3
M,0.555,0.45,0.175,0.874,0.3275,0.202,0.305,2
F,0.58,0.44,0.18,0.854,0.3665,0.1635,0.245,3
F,0.62,0.52,0.225,1.1835,0.378,0.27,0.395,3
F,0.62,0.47,0.225,1.115,0.378,0.2145,0.36,3
F,0.6,0.505,0.19,1.129,0.4385,0.256,0.36,3
F,0.625,0.485,0.19,1.1745,0.4385,0.2305,0.42,3
M,0.6,0.47,0.175,1.105,0.4865,0.247,0.315,3
M,0.56,0.46,0.235,0.8395,0.3325,0.157,0.305,3
M,0.585,0.455,0.225,1.055,0.3815,0.221,0.365,3
M,0.56,0.435,0.18,0.889,0.36,0.204,0.25,3
I,0.56,0.445,0.155,0.8735,0.3005,0.209,0.275,3
I,0.68,0.53,0.185,1.1095,0.439,0.245,0.34,2
F,0.455,0.35,0.14,0.5185,0.221,0.1265,0.135,2
F,0.49,0.38,0.145,0.6725,0.249,0.181,0.21,2
M,0.31,0.22,0.085,0.146,0.061,0.0365,0.045,1
F,0.275,0.195,0.07,0.08,0.031,0.0215,0.025,1
M,0.27,0.195,0.08,0.1,0.0385,0.0195,0.03,1
M,0.4,0.29,0.115,0.2795,0.1115,0.0575,0.075,2
M,0.28,0.2,0.08,0.0915,0.033,0.0215,0.03,1
M,0.325,0.23,0.09,0.147,0.06,0.034,0.045,1
F,0.345,0.25,0.09,0.203,0.078,0.059,0.055,1
M,0.21,0.15,0.05,0.0385,0.0155,0.0085,0.01,1
F,0.36,0.27,0.09,0.1885,0.0845,0.0385,0.055,1
I,0.365,0.26,0.115,0.218,0.0935,0.0445,0.07,2
M,0.2,0.14,0.055,0.035,0.0145,0.008,0.01,1
M,0.235,0.16,0.06,0.0545,0.0265,0.0095,0.015,1
M,0.175,0.125,0.04,0.024,0.0095,0.006,0.005,1
M,0.155,0.11,0.04,0.0155,0.0065,0.003,0.005,1
F,0.57,0.445,0.155,0.733,0.282,0.159,0.235,3
F,0.57,0.45,0.16,0.9715,0.3965,0.255,0.26,3
M,0.385,0.3,0.095,0.24,0.0885,0.059,0.085,2
I,0.53,0.42,0.185,0.752,0.299,0.156,0.205,3
F,0.46,0.355,0.13,0.458,0.192,0.1055,0.13,3
I,0.47,0.37,0.12,0.4705,0.1845,0.1055,0.155,3
F,0.435,0.335,0.11,0.38,0.1695,0.086,0.11,2
I,0.47,0.37,0.14,0.4985,0.2095,0.1225,0.145,2
I,0.465,0.38,0.13,0.454,0.1895,0.08,0.155,3
I,0.52,0.405,0.14,0.5775,0.2,0.145,0.179,3
M,0.29,0.23,0.075,0.1165,0.043,0.0255,0.04,1
M,0.275,0.205,0.07,0.094,0.0335,0.02,0.0325,1
F,0.375,0.29,0.115,0.2705,0.093,0.066,0.0885,2
F,0.5,0.375,0.14,0.604,0.242,0.1415,0.179,3
F,0.44,0.355,0.115,0.415,0.1585,0.0925,0.131,3
M,0.42,0.325,0.115,0.2885,0.1,0.057,0.1135,3
M,0.445,0.35,0.115,0.3615,0.1565,0.0695,0.117,1
F,0.38,0.29,0.105,0.257,0.099,0.051,0.085,2
M,0.32,0.245,0.075,0.1555,0.0585,0.038,0.049,3
M,0.255,0.195,0.065,0.08,0.0315,0.018,0.027,1
M,0.205,0.155,0.045,0.0425,0.017,0.0055,0.0155,1
F,0.565,0.45,0.16,0.795,0.3605,0.1555,0.23,3
I,0.555,0.425,0.18,0.875,0.3695,0.2005,0.255,3
I,0.65,0.515,0.16,1.1625,0.495,0.203,0.33,3
I,0.615,0.49,0.155,0.9885,0.4145,0.195,0.345,3
I,0.56,0.44,0.165,0.8,0.335,0.1735,0.25,3
I,0.48,0.37,0.12,0.514,0.2075,0.131,0.155,3
I,0.485,0.39,0.125,0.591,0.287,0.141,0.12,2
I,0.5,0.385,0.15,0.6265,0.2605,0.1665,0.16,2
I,0.525,0.405,0.15,0.795,0.3075,0.205,0.255,3
F,0.66,0.5,0.165,1.1905,0.4585,0.298,0.37,3
F,0.66,0.53,0.17,1.326,0.519,0.2625,0.44,3
I,0.52,0.4,0.145,0.66,0.267,0.1055,0.22,3
F,0.44,0.34,0.105,0.364,0.148,0.0805,0.1175,1
I,0.515,0.4,0.12,0.659,0.2705,0.179,0.17,3
F,0.475,0.35,0.115,0.452,0.1715,0.092,0.155,3
F,0.545,0.415,0.15,0.7335,0.2795,0.163,0.2185,3
F,0.47,0.355,0.13,0.5465,0.2005,0.126,0.185,3
M,0.35,0.255,0.065,0.179,0.0705,0.0385,0.06,2
I,0.485,0.355,0.13,0.581,0.245,0.132,0.168,3
I,0.435,0.33,0.125,0.406,0.1685,0.1055,0.096,3
M,0.28,0.21,0.08,0.1085,0.041,0.0265,0.0345,1
F,0.41,0.32,0.115,0.387,0.165,0.1005,0.0985,3
I,0.45,0.35,0.14,0.474,0.21,0.109,0.1275,3
I,0.45,0.345,0.135,0.443,0.1975,0.0875,0.1175,3
F,0.59,0.455,0.155,1.066,0.382,0.2275,0.415,3
F,0.57,0.44,0.14,0.9535,0.3785,0.201,0.305,3
I,0.61,0.475,0.15,0.9665,0.4145,0.2,0.345,2
F,0.61,0.475,0.14,1.133,0.5275,0.2355,0.35,3
I,0.56,0.425,0.14,0.9175,0.4005,0.1975,0.26,2
F,0.585,0.435,0.175,0.982,0.4055,0.2495,0.27,2
I,0.58,0.445,0.15,0.8865,0.383,0.209,0.255,3
F,0.63,0.48,0.175,1.3675,0.5015,0.3035,0.515,3
F,0.625,0.49,0.175,1.233,0.5565,0.247,0.365,3
I,0.55,0.425,0.15,0.806,0.376,0.171,0.245,3
F,0.645,0.525,0.19,1.4635,0.6615,0.3435,0.435,3
I,0.46,0.355,0.14,0.4935,0.216,0.133,0.115,3
F,0.41,0.305,0.1,0.363,0.1735,0.065,0.11,3
I,0.495,0.39,0.125,0.6655,0.284,0.162,0.2,3
I,0.52,0.425,0.17,0.6805,0.28,0.174,0.195,2
F,0.55,0.41,0.145,0.8285,0.3095,0.1905,0.25,3
M,0.45,0.335,0.14,0.4625,0.164,0.076,0.15,3
F,0.405,0.31,0.12,0.3095,0.138,0.058,0.095,3
I,0.51,0.4,0.15,0.745,0.2865,0.1675,0.235,3
F,0.37,0.29,0.115,0.25,0.111,0.057,0.075,2
I,0.525,0.41,0.175,0.874,0.3585,0.207,0.205,3
F,0.66,0.52,0.18,1.514,0.526,0.2975,0.42,3
M,0.535,0.42,0.15,0.6995,0.2575,0.153,0.24,3
I,0.575,0.455,0.18,0.8525,0.3015,0.1825,0.3,3
F,0.55,0.43,0.14,0.7135,0.2565,0.186,0.225,2
I,0.605,0.47,0.14,0.939,0.3385,0.201,0.32,3
I,0.605,0.495,0.145,1.054,0.369,0.2255,0.36,3
F,0.56,0.445,0.195,0.981,0.305,0.2245,0.335,3
I,0.535,0.42,0.145,0.926,0.398,0.1965,0.25,3
F,0.385,0.315,0.11,0.286,0.1225,0.0635,0.0835,2
F,0.39,0.3,0.1,0.265,0.1075,0.06,0.0865,3
I,0.47,0.345,0.115,0.4885,0.2005,0.108,0.166,3
I,0.515,0.39,0.14,0.5555,0.2,0.1135,0.2235,3
I,0.425,0.345,0.125,0.425,0.16,0.0795,0.154,3
M,0.345,0.27,0.09,0.195,0.078,0.0455,0.059,2
I,0.485,0.37,0.13,0.458,0.181,0.113,0.136,2
M,0.37,0.285,0.1,0.228,0.0675,0.0675,0.081,2
M,0.35,0.265,0.09,0.1775,0.0575,0.042,0.068,3
F,0.44,0.345,0.17,0.4085,0.15,0.0825,0.1515,3
M,0.195,0.145,0.05,0.032,0.01,0.008,0.012,1
M,0.325,0.24,0.075,0.155,0.0475,0.0355,0.06,2
I,0.495,0.37,0.125,0.4775,0.185,0.0705,0.169,3
I,0.45,0.35,0.145,0.525,0.2085,0.1,0.1655,3
M,0.415,0.345,0.135,0.3865,0.128,0.07,0.148,3
F,0.47,0.355,0.14,0.433,0.1525,0.095,0.152,3
M,0.32,0.24,0.085,0.17,0.0655,0.047,0.049,1
M,0.31,0.225,0.075,0.1295,0.0455,0.0335,0.044,2
M,0.235,0.17,0.055,0.0515,0.018,0.0105,0.0195,1
M,0.345,0.255,0.08,0.169,0.06,0.0425,0.054,2
I,0.485,0.38,0.14,0.673,0.2175,0.13,0.195,3
F,0.5,0.385,0.115,0.6785,0.2945,0.138,0.195,3
F,0.5,0.385,0.105,0.498,0.1795,0.1095,0.17,3
I,0.465,0.36,0.105,0.498,0.214,0.116,0.14,3
F,0.525,0.405,0.16,0.658,0.2655,0.1125,0.225,3
F,0.425,0.335,0.095,0.322,0.1205,0.061,0.125,2
F,0.38,0.305,0.095,0.2815,0.1255,0.0525,0.09,1
I,0.53,0.415,0.145,0.944,0.3845,0.185,0.265,3
M,0.34,0.265,0.085,0.1835,0.077,0.046,0.065,2
I,0.475,0.365,0.115,0.49,0.223,0.1235,0.1335,2
F,0.43,0.34,0.12,0.391,0.1555,0.095,0.1405,1
M,0.46,0.365,0.125,0.467,0.1895,0.0945,0.158,2
I,0.47,0.36,0.13,0.5225,0.198,0.1065,0.165,2
M,0.36,0.295,0.1,0.2105,0.066,0.0525,0.075,2
M,0.355,0.265,0.09,0.168,0.05,0.041,0.063,1
M,0.38,0.235,0.1,0.258,0.1055,0.054,0.08,1
M,0.355,0.26,0.085,0.1905,0.081,0.0485,0.055,1
I,0.44,0.345,0.12,0.487,0.1965,0.108,0.16,3
F,0.51,0.4,0.13,0.5735,0.219,0.1365,0.195,3
M,0.325,0.24,0.085,0.173,0.0795,0.038,0.05,1
I,0.62,0.485,0.18,1.1785,0.4675,0.2655,0.39,3
F,0.59,0.45,0.16,0.9,0.358,0.156,0.315,3
M,0.33,0.255,0.095,0.1875,0.0735,0.045,0.06,1
M,0.45,0.34,0.13,0.3715,0.1605,0.0795,0.105,2
I,0.445,0.33,0.12,0.347,0.12,0.084,0.105,3
M,0.33,0.215,0.075,0.1145,0.045,0.0265,0.035,1
M,0.48,0.375,0.145,0.777,0.216,0.13,0.17,2
I,0.46,0.35,0.12,0.4885,0.193,0.105,0.155,3
F,0.475,0.36,0.125,0.447,0.1695,0.081,0.14,2
M,0.255,0.18,0.065,0.079,0.034,0.014,0.025,1
I,0.335,0.245,0.09,0.1665,0.0595,0.04,0.06,1
I,0.47,0.35,0.13,0.466,0.1845,0.099,0.145,3
M,0.31,0.225,0.08,0.1345,0.054,0.024,0.05,1
F,0.37,0.28,0.11,0.2305,0.0945,0.0465,0.075,2
M,0.295,0.215,0.075,0.129,0.05,0.0295,0.04,1
F,0.555,0.435,0.165,0.97,0.336,0.2315,0.295,3
F,0.615,0.515,0.17,1.14,0.4305,0.2245,0.42,3
I,0.58,0.49,0.195,1.3165,0.5305,0.254,0.41,3
F,0.585,0.475,0.185,0.9585,0.4145,0.1615,0.33,3
I,0.65,0.525,0.18,1.626,0.597,0.3445,0.53,3
I,0.535,0.45,0.17,0.781,0.3055,0.1555,0.295,3
F,0.415,0.34,0.13,0.3675,0.146,0.0885,0.12,2
F,0.38,0.305,0.105,0.281,0.1045,0.0615,0.09,3
I,0.45,0.355,0.12,0.412,0.1145,0.0665,0.16,3
F,0.395,0.295,0.095,0.2245,0.078,0.054,0.08,2
M,0.455,0.35,0.12,0.4835,0.1815,0.144,0.16,3
F,0.485,0.38,0.15,0.605,0.2155,0.14,0.18,3
M,0.55,0.425,0.155,0.9175,0.2775,0.243,0.335,3
F,0.45,0.35,0.145,0.5425,0.1765,0.123,0.175,3
M,0.475,0.385,0.145,0.6175,0.235,0.108,0.215,3
F,0.5,0.38,0.155,0.655,0.2405,0.143,0.205,3
F,0.53,0.41,0.165,0.8115,0.24,0.169,0.24,3
M,0.49,0.39,0.15,0.573,0.225,0.124,0.17,3
F,0.49,0.385,0.15,0.7865,0.241,0.14,0.24,3
F,0.52,0.395,0.18,0.64,0.158,0.11,0.245,3
M,0.54,0.415,0.145,0.74,0.2635,0.168,0.245,3
F,0.5,0.375,0.115,0.5945,0.185,0.148,0.19,3
F,0.45,0.38,0.165,0.8165,0.25,0.1915,0.265,3
F,0.37,0.275,0.1,0.2225,0.093,0.026,0.08,1
I,0.37,0.275,0.1,0.2295,0.0885,0.0465,0.07,1
M,0.485,0.37,0.14,0.5725,0.204,0.1415,0.175,2
F,0.435,0.325,0.115,0.3915,0.154,0.094,0.12,1
M,0.535,0.405,0.185,0.8345,0.3175,0.1725,0.29,3
M,0.51,0.4,0.14,0.6515,0.2455,0.1665,0.185,2
M,0.565,0.44,0.185,0.909,0.344,0.2325,0.255,3
F,0.535,0.4,0.15,0.8045,0.3345,0.2125,0.21,3
F,0.535,0.405,0.125,0.927,0.26,0.1425,0.345,3
M,0.525,0.4,0.17,0.7305,0.279,0.2055,0.195,3
M,0.59,0.44,0.15,0.9555,0.366,0.2425,0.295,3
M,0.5,0.375,0.15,0.636,0.2535,0.145,0.19,2
I,0.255,0.19,0.075,0.0865,0.0345,0.0205,0.025,1
F,0.43,0.325,0.115,0.3865,0.1475,0.1065,0.11,3
M,0.38,0.29,0.12,0.283,0.1175,0.0655,0.085,2
I,0.165,0.11,0.02,0.019,0.0065,0.0025,0.005,1
I,0.315,0.23,0.09,0.1285,0.043,0.04,0.04,1
I,0.155,0.105,0.05,0.0175,0.005,0.0035,0.005,1
M,0.28,0.205,0.1,0.1165,0.0545,0.0285,0.03,1
F,0.43,0.335,0.12,0.444,0.155,0.1145,0.14,3
F,0.395,0.315,0.105,0.3515,0.1185,0.091,0.1195,3
M,0.385,0.285,0.105,0.2905,0.1215,0.0685,0.0875,3
F,0.48,0.385,0.135,0.536,0.1895,0.142,0.173,3
F,0.445,0.33,0.105,0.4525,0.18,0.103,0.123,2
M,0.395,0.295,0.115,0.316,0.1205,0.0595,0.1105,3
M,0.4,0.3,0.125,0.417,0.191,0.09,0.1175,2
M,0.415,0.325,0.14,0.417,0.1535,0.1015,0.144,2
M,0.315,0.25,0.09,0.203,0.0615,0.037,0.0795,3
F,0.345,0.26,0.09,0.207,0.0775,0.0435,0.0765,2
M,0.36,0.295,0.13,0.2765,0.0895,0.057,0.1005,2
I,0.295,0.225,0.09,0.1105,0.0405,0.0245,0.032,1
I,0.325,0.25,0.08,0.176,0.0595,0.0355,0.063,1
M,0.375,0.3,0.1,0.2465,0.104,0.0475,0.083,3
I,0.28,0.205,0.055,0.1135,0.045,0.0275,0.0335,1
M,0.355,0.265,0.085,0.201,0.069,0.053,0.0695,1
M,0.35,0.255,0.08,0.1915,0.08,0.0385,0.063,2
I,0.275,0.2,0.065,0.1035,0.0475,0.0205,0.03,1
I,0.29,0.205,0.07,0.0975,0.036,0.019,0.035,1
I,0.25,0.19,0.06,0.0765,0.036,0.0115,0.0245,1
I,0.18,0.125,0.035,0.0265,0.0095,0.0055,0.0085,1
I,0.15,0.1,0.025,0.015,0.0045,0.004,0.005,1
I,0.16,0.11,0.025,0.018,0.0065,0.0055,0.005,1
M,0.555,0.455,0.16,1.0575,0.3925,0.228,0.293,3
M,0.555,0.44,0.15,1.092,0.416,0.212,0.4405,3
M,0.525,0.41,0.13,0.99,0.3865,0.243,0.295,3
M,0.465,0.36,0.08,0.488,0.191,0.125,0.155,3
F,0.49,0.36,0.11,0.5005,0.161,0.107,0.195,3
M,0.4,0.305,0.085,0.297,0.108,0.0705,0.1,2
F,0.48,0.375,0.105,0.525,0.2185,0.1195,0.155,3
M,0.505,0.4,0.125,0.77,0.2735,0.159,0.255,3
F,0.52,0.4,0.12,0.6515,0.261,0.2015,0.165,3
M,0.525,0.4,0.13,0.8295,0.2405,0.1825,0.275,3
M,0.545,0.42,0.13,0.879,0.374,0.1695,0.23,3
M,0.52,0.4,0.12,0.823,0.298,0.1805,0.265,3
M,0.505,0.38,0.13,0.656,0.227,0.1785,0.22,3
M,0.525,0.425,0.12,0.8665,0.2825,0.176,0.29,3
M,0.51,0.39,0.125,0.6565,0.262,0.1835,0.175,2
M,0.52,0.385,0.115,0.669,0.2385,0.172,0.205,3
F,0.52,0.405,0.125,0.6435,0.2415,0.1735,0.21,3
M,0.535,0.41,0.135,0.862,0.2855,0.1525,0.32,3
M,0.445,0.345,0.09,0.3795,0.143,0.074,0.125,2
M,0.53,0.44,0.205,0.835,0.32,0.2175,0.245,3
F,0.36,0.265,0.09,0.2065,0.078,0.057,0.06,1
F,0.535,0.42,0.15,0.7365,0.2785,0.186,0.215,3
F,0.52,0.405,0.14,0.8175,0.2795,0.183,0.26,3
M,0.53,0.415,0.13,0.8425,0.275,0.1945,0.265,3
F,0.53,0.42,0.13,1.001,0.34,0.226,0.265,3
F,0.66,0.52,0.2,1.676,0.673,0.4805,0.45,3
M,0.52,0.385,0.14,0.6595,0.2485,0.2035,0.16,2
M,0.535,0.42,0.13,0.8055,0.301,0.181,0.28,3
M,0.695,0.515,0.175,1.5165,0.578,0.4105,0.39,3
F,0.51,0.39,0.105,0.612,0.187,0.15,0.195,3
M,0.485,0.355,0.12,0.547,0.215,0.1615,0.14,2
F,0.605,0.46,0.17,1.122,0.347,0.3045,0.315,3
F,0.58,0.455,0.165,1.1365,0.369,0.3005,0.275,3
M,0.65,0.515,0.175,1.4805,0.5295,0.272,0.525,3
M,0.62,0.505,0.185,1.5275,0.69,0.368,0.35,3
M,0.615,0.525,0.155,1.1375,0.367,0.236,0.37,3
F,0.605,0.495,0.19,1.437,0.469,0.2655,0.41,3
M,0.57,0.44,0.155,1.116,0.4775,0.2315,0.27,3
M,0.57,0.43,0.12,1.0615,0.348,0.167,0.31,3
M,0.585,0.405,0.15,1.2565,0.435,0.202,0.325,3
F,0.55,0.44,0.155,0.946,0.313,0.1825,0.335,3
F,0.54,0.44,0.135,0.959,0.2385,0.221,0.3,3
M,0.64,0.51,0.19,1.613,0.6215,0.361,0.47,3
F,0.61,0.47,0.145,1.153,0.403,0.296,0.32,3
M,0.545,0.45,0.15,0.978,0.3365,0.1905,0.3,3
F,0.59,0.445,0.13,1.1325,0.3825,0.234,0.32,3
M,0.345,0.27,0.095,0.197,0.0665,0.05,0.07,2
F,0.55,0.43,0.155,0.785,0.289,0.227,0.233,3
F,0.53,0.425,0.17,0.949,0.3485,0.2395,0.278,3
F,0.53,0.455,0.165,0.9805,0.3155,0.2815,0.2965,3
I,0.485,0.375,0.14,0.521,0.2,0.123,0.17,1
M,0.385,0.275,0.115,0.2685,0.0975,0.0825,0.085,1
M,0.455,0.34,0.135,0.462,0.1675,0.158,0.12,2
M,0.49,0.38,0.14,0.7605,0.245,0.167,0.185,2
M,0.53,0.41,0.165,0.732,0.189,0.17,0.31,3
M,0.505,0.385,0.145,0.6775,0.236,0.179,0.2,3
M,0.49,0.38,0.14,0.6385,0.2305,0.142,0.195,3
M,0.465,0.35,0.14,0.5755,0.2015,0.1505,0.19,3
F,0.47,0.36,0.145,0.537,0.1725,0.1375,0.195,3
M,0.56,0.41,0.165,0.93,0.3505,0.237,0.3,3
M,0.505,0.385,0.15,0.6415,0.246,0.152,0.215,3
M,0.515,0.435,0.145,0.8815,0.292,0.206,0.255,2
I,0.385,0.28,0.125,0.244,0.102,0.038,0.085,1
I,0.215,0.155,0.06,0.0525,0.021,0.0165,0.015,1
M,0.55,0.415,0.175,1.042,0.3295,0.2325,0.2905,3
F,0.515,0.39,0.13,0.5755,0.1975,0.13,0.1845,2
M,0.495,0.385,0.135,0.709,0.211,0.1375,0.262,3
F,0.505,0.39,0.16,0.644,0.2475,0.2025,0.1635,2
F,0.6,0.465,0.165,0.8875,0.309,0.246,0.262,3
F,0.57,0.465,0.16,0.8935,0.3145,0.2575,0.263,2
F,0.485,0.375,0.135,0.556,0.1925,0.1315,0.1685,2
M,0.47,0.37,0.18,0.51,0.1915,0.1285,0.1625,2
M,0.575,0.45,0.165,0.9215,0.3275,0.225,0.256,3
M,0.58,0.465,0.16,1.0345,0.315,0.26,0.3635,3
M,0.515,0.405,0.145,0.695,0.215,0.1635,0.234,3
M,0.53,0.41,0.155,0.7155,0.2805,0.1685,0.214,3
M,0.44,0.335,0.11,0.394,0.157,0.096,0.122,2
M,0.52,0.42,0.16,0.745,0.255,0.157,0.2885,3
F,0.425,0.345,0.11,0.3665,0.125,0.081,0.117,3
M,0.46,0.34,0.135,0.495,0.1655,0.117,0.185,2
M,0.45,0.335,0.125,0.349,0.119,0.1055,0.115,2
M,0.425,0.33,0.13,0.4405,0.152,0.0935,0.155,2
I,0.37,0.275,0.1,0.22,0.094,0.045,0.065,1
M,0.515,0.38,0.135,0.6615,0.2875,0.2095,0.155,2
M,0.405,0.305,0.12,0.3185,0.1235,0.0905,0.095,1
I,0.28,0.205,0.07,0.1015,0.041,0.03,0.03,1
F,0.48,0.4,0.125,0.759,0.2125,0.179,0.24,3
F,0.44,0.34,0.13,0.4195,0.153,0.1155,0.13,2
F,0.52,0.41,0.115,0.807,0.2855,0.179,0.235,3
M,0.505,0.405,0.14,0.875,0.2665,0.174,0.285,3
F,0.49,0.365,0.13,0.6835,0.165,0.1315,0.205,3
I,0.235,0.175,0.055,0.067,0.027,0.0125,0.018,1
I,0.255,0.185,0.06,0.088,0.0365,0.021,0.023,1
I,0.315,0.24,0.085,0.1715,0.071,0.0345,0.0535,1
I,0.325,0.25,0.08,0.1735,0.0765,0.0345,0.049,1
I,0.335,0.25,0.08,0.183,0.0735,0.04,0.0575,1
I,0.35,0.27,0.09,0.2055,0.075,0.0575,0.062,1
I,0.35,0.25,0.07,0.18,0.0655,0.048,0.054,1
I,0.36,0.3,0.085,0.27,0.1185,0.064,0.0745,1
I,0.365,0.275,0.135,0.24,0.108,0.0445,0.0735,1
I,0.37,0.275,0.14,0.2215,0.097,0.0455,0.0615,1
I,0.38,0.275,0.095,0.1375,0.086,0.0585,0.0605,1
I,0.385,0.29,0.095,0.312,0.143,0.0635,0.086,1
I,0.385,0.3,0.1,0.2895,0.1215,0.063,0.09,1
I,0.395,0.29,0.095,0.319,0.138,0.08,0.082,1
I,0.395,0.29,0.095,0.304,0.127,0.084,0.077,1
I,0.4,0.31,0.1,0.306,0.13,0.06,0.094,1
I,0.41,0.325,0.1,0.394,0.208,0.0655,0.106,1
I,0.415,0.32,0.11,0.3735,0.175,0.0755,0.109,1
M,0.415,0.305,0.1,0.325,0.156,0.0505,0.091,1
I,0.425,0.325,0.1,0.398,0.1185,0.0645,0.0945,1
I,0.44,0.365,0.115,0.501,0.2435,0.084,0.1465,2
I,0.445,0.335,0.1,0.4895,0.2745,0.086,0.1105,1
I,0.445,0.325,0.1,0.378,0.1795,0.1,0.089,1
I,0.45,0.35,0.13,0.547,0.245,0.1405,0.1405,1
M,0.47,0.375,0.12,0.5805,0.266,0.0935,0.169,1
I,0.475,0.365,0.125,0.5465,0.229,0.1185,0.172,2
F,0.48,0.365,0.135,0.6395,0.2945,0.113,0.175,1
I,0.485,0.355,0.105,0.498,0.2175,0.096,0.1525,2
M,0.49,0.385,0.125,0.609,0.3065,0.096,0.1775,1
F,0.495,0.41,0.125,0.7555,0.3355,0.129,0.214,2
M,0.5,0.4,0.125,0.5975,0.27,0.1275,0.166,2
M,0.505,0.44,0.14,0.8275,0.3415,0.1855,0.239,1
M,0.525,0.395,0.13,0.7635,0.3375,0.1425,0.225,1
M,0.54,0.405,0.125,0.891,0.4815,0.1915,0.202,2
F,0.54,0.42,0.14,0.805,0.369,0.1725,0.21,3
F,0.545,0.44,0.135,0.9185,0.429,0.2015,0.2375,2
F,0.55,0.43,0.125,0.923,0.4035,0.175,0.283,1
M,0.55,0.45,0.15,1.0145,0.407,0.2015,0.2875,2
F,0.55,0.45,0.15,0.875,0.362,0.1755,0.2765,2
M,0.555,0.435,0.145,0.9685,0.4985,0.168,0.2385,2
M,0.565,0.45,0.155,1.0595,0.4735,0.24,0.265,2
M,0.57,0.455,0.15,0.952,0.3895,0.2155,0.2745,2
M,0.57,0.435,0.13,0.7535,0.349,0.1755,0.194,2
F,0.575,0.465,0.14,0.958,0.442,0.1815,0.2705,2
M,0.59,0.475,0.165,1.077,0.4545,0.244,0.3095,2
M,0.59,0.46,0.13,1.102,0.455,0.2055,0.33,3
F,0.595,0.48,0.15,1.11,0.498,0.228,0.33,2
F,0.595,0.48,0.16,1.2095,0.5225,0.296,0.32,1
F,0.595,0.475,0.16,1.1405,0.547,0.231,0.271,1
F,0.595,0.465,0.14,1.113,0.5175,0.244,0.305,3
M,0.6,0.475,0.175,1.3445,0.549,0.2875,0.36,3
F,0.6,0.475,0.155,1.21,0.653,0.1695,0.3205,2
M,0.6,0.495,0.175,1.29,0.606,0.276,0.3445,3
F,0.605,0.475,0.175,1.382,0.609,0.2325,0.3985,2
M,0.605,0.455,0.16,1.1035,0.421,0.3015,0.325,2
F,0.615,0.5,0.175,1.377,0.5585,0.33,0.292,3
F,0.615,0.52,0.15,1.3435,0.629,0.2605,0.345,2
M,0.615,0.51,0.15,1.296,0.545,0.3315,0.32,2
M,0.615,0.505,0.165,1.34,0.5315,0.2815,0.41,3
F,0.62,0.505,0.16,1.3725,0.6285,0.275,0.3685,3
M,0.62,0.5,0.165,1.307,0.6355,0.2545,0.315,2
F,0.625,0.49,0.155,1.2085,0.465,0.162,0.411,3
F,0.625,0.49,0.2,1.3825,0.5895,0.285,0.381,3
M,0.63,0.505,0.165,1.26,0.4525,0.2755,0.406,3
M,0.635,0.51,0.17,1.3555,0.619,0.305,0.39,2
F,0.635,0.5,0.15,1.376,0.6495,0.361,0.31,2
F,0.635,0.485,0.165,1.2945,0.668,0.2605,0.2715,2
F,0.64,0.51,0.165,1.486,0.7595,0.332,0.321,1
M,0.65,0.525,0.175,1.4715,0.675,0.315,0.399,3
M,0.655,0.52,0.165,1.4095,0.586,0.291,0.405,2
M,0.655,0.58,0.205,2.0805,0.959,0.3415,0.601,3
M,0.66,0.53,0.17,1.3905,0.5905,0.212,0.453,3
M,0.66,0.52,0.19,1.558,0.755,0.298,0.4,2
F,0.67,0.585,0.16,1.309,0.5445,0.2945,0.413,2
F,0.675,0.525,0.17,1.8095,0.784,0.391,0.455,3
F,0.675,0.525,0.155,1.4785,0.628,0.3405,0.42,2
F,0.68,0.56,0.195,1.7775,0.861,0.322,0.415,3
F,0.685,0.54,0.16,1.6675,0.833,0.3775,0.475,3
F,0.695,0.56,0.22,1.834,0.8455,0.422,0.455,3
M,0.73,0.595,0.23,2.8255,1.1465,0.419,0.897,3
I,0.205,0.14,0.05,0.046,0.0165,0.012,0.0135,1
I,0.24,0.175,0.055,0.0705,0.025,0.014,0.021,1
I,0.24,0.175,0.065,0.0665,0.031,0.0135,0.017,1
I,0.255,0.19,0.05,0.083,0.0295,0.0215,0.027,1
I,0.255,0.18,0.055,0.083,0.031,0.0215,0.02,1
I,0.265,0.195,0.06,0.092,0.0345,0.025,0.0245,1
I,0.28,0.12,0.075,0.117,0.0455,0.029,0.0345,1
I,0.295,0.23,0.08,0.1625,0.065,0.05,0.0385,1
I,0.3,0.235,0.08,0.131,0.05,0.0265,0.043,1
I,0.3,0.23,0.095,0.1385,0.056,0.0365,0.037,1
I,0.305,0.22,0.07,0.141,0.062,0.031,0.037,1
I,0.315,0.235,0.075,0.1485,0.0585,0.0375,0.0425,1
I,0.315,0.23,0.07,0.144,0.053,0.0305,0.04,1
I,0.32,0.24,0.09,0.1575,0.07,0.0265,0.0425,1
I,0.325,0.24,0.075,0.187,0.0825,0.0445,0.05,1
I,0.33,0.265,0.085,0.196,0.0775,0.0305,0.0445,1
I,0.335,0.25,0.075,0.1825,0.0705,0.044,0.055,1
I,0.335,0.25,0.075,0.186,0.0945,0.038,0.0445,1
I,0.34,0.25,0.075,0.1785,0.0665,0.0455,0.045,1
I,0.34,0.25,0.07,0.2225,0.104,0.0425,0.055,1
I,0.345,0.265,0.1,0.2455,0.111,0.0535,0.065,1
I,0.37,0.29,0.095,0.249,0.1045,0.058,0.067,1
I,0.37,0.28,0.095,0.2865,0.1505,0.069,0.0795,1
I,0.375,0.28,0.09,0.215,0.084,0.06,0.055,1
I,0.385,0.265,0.08,0.251,0.124,0.037,0.07,1
I,0.41,0.31,0.09,0.339,0.155,0.0695,0.09,1
I,0.41,0.305,0.09,0.3535,0.157,0.0745,0.1,1
I,0.41,0.31,0.09,0.3335,0.1635,0.061,0.091,1
I,0.415,0.33,0.09,0.3595,0.17,0.081,0.09,1
I,0.42,0.32,0.115,0.376,0.169,0.092,0.1,1
I,0.42,0.315,0.1,0.3435,0.157,0.0795,0.09,1
I,0.425,0.34,0.1,0.382,0.164,0.096,0.1,1
I,0.425,0.315,0.1,0.377,0.1645,0.072,0.105,1
I,0.43,0.325,0.1,0.3645,0.1575,0.0825,0.105,1
I,0.43,0.325,0.09,0.425,0.217,0.087,0.095,1
I,0.435,0.325,0.12,0.3995,0.1815,0.061,0.1125,1
I,0.435,0.34,0.115,0.3925,0.1825,0.078,0.1145,1
I,0.44,0.345,0.13,0.4495,0.209,0.0835,0.134,1
I,0.44,0.325,0.09,0.35,0.148,0.067,0.105,1
F,0.445,0.335,0.11,0.4355,0.2025,0.1095,0.1195,1
I,0.445,0.35,0.13,0.4195,0.1695,0.0945,0.1195,1
I,0.45,0.36,0.13,0.478,0.191,0.127,0.137,1
I,0.45,0.355,0.105,0.4445,0.197,0.093,0.1335,1
I,0.45,0.345,0.11,0.47,0.2355,0.0855,0.1135,1
I,0.45,0.335,0.105,0.447,0.2335,0.153,0.119,1
I,0.455,0.355,0.125,0.5325,0.225,0.126,0.1465,1
I,0.455,0.375,0.12,0.497,0.2355,0.1055,0.1295,1
I,0.46,0.36,0.1,0.4635,0.2325,0.093,0.115,1
I,0.46,0.345,0.105,0.449,0.196,0.0945,0.1265,1
I,0.465,0.365,0.115,0.467,0.2315,0.0925,0.113,1
I,0.465,0.37,0.115,0.534,0.261,0.098,0.143,1
I,0.465,0.345,0.11,0.4415,0.1755,0.0905,0.12,1
F,0.465,0.35,0.125,0.482,0.23,0.106,0.1095,1
M,0.47,0.365,0.12,0.612,0.327,0.15,0.14,1
F,0.47,0.365,0.12,0.582,0.29,0.092,0.146,1
M,0.475,0.37,0.125,0.537,0.222,0.1215,0.15,2
F,0.475,0.36,0.12,0.5915,0.3245,0.11,0.127,1
M,0.48,0.375,0.115,0.6765,0.3205,0.1065,0.17,1
M,0.48,0.385,0.145,0.64,0.2925,0.1405,0.1575,1
M,0.48,0.36,0.1,0.439,0.194,0.099,0.115,1
M,0.48,0.365,0.12,0.6015,0.312,0.117,0.14,1
F,0.485,0.37,0.115,0.4785,0.1995,0.0955,0.129,1
M,0.49,0.385,0.125,0.649,0.32,0.124,0.1695,1
M,0.495,0.395,0.135,0.6335,0.3035,0.1295,0.1495,1
M,0.495,0.4,0.135,0.61,0.272,0.1435,0.144,1
M,0.5,0.39,0.135,0.6595,0.3145,0.1535,0.1565,1
I,0.5,0.385,0.12,0.56,0.2835,0.103,0.135,1
M,0.5,0.385,0.135,0.6425,0.3195,0.129,0.1535,1
M,0.5,0.4,0.125,0.6725,0.336,0.12,0.1825,1
F,0.505,0.39,0.13,0.674,0.3165,0.141,0.1785,2
I,0.505,0.39,0.15,0.685,0.362,0.131,0.156,1
M,0.505,0.41,0.125,0.642,0.289,0.133,0.155,2
I,0.505,0.355,0.125,0.601,0.25,0.1205,0.185,1
M,0.51,0.39,0.135,0.769,0.3935,0.1455,0.19,1
I,0.51,0.375,0.1,0.5785,0.238,0.1225,0.175,1
I,0.51,0.405,0.135,0.769,0.3655,0.1585,0.18,1
M,0.51,0.405,0.15,0.7035,0.347,0.134,0.1885,1
M,0.51,0.41,0.145,0.796,0.3865,0.1815,0.1955,1
F,0.515,0.43,0.14,0.834,0.367,0.2,0.23,1
M,0.515,0.39,0.155,0.7125,0.3695,0.137,0.155,1
F,0.525,0.415,0.14,0.724,0.3475,0.173,0.175,1
M,0.525,0.4,0.14,0.7325,0.334,0.1575,0.17,3
F,0.53,0.425,0.13,0.7585,0.325,0.197,0.205,1
F,0.53,0.425,0.15,0.8495,0.328,0.232,0.202,1
M,0.53,0.405,0.125,0.6515,0.2715,0.1605,0.186,1
F,0.535,0.4,0.135,0.8215,0.3935,0.196,0.205,1
M,0.535,0.43,0.14,0.7165,0.2855,0.1595,0.2155,1
M,0.535,0.435,0.14,0.874,0.3735,0.229,0.2195,1
F,0.55,0.445,0.155,0.9905,0.544,0.178,0.218,2
F,0.55,0.43,0.14,0.8105,0.368,0.161,0.275,2
F,0.56,0.455,0.16,0.967,0.4525,0.207,0.274,2
F,0.565,0.4,0.13,0.6975,0.3075,0.1665,0.18,1
M,0.57,0.45,0.155,1.195,0.5625,0.2565,0.295,2
M,0.57,0.45,0.155,1.1935,0.513,0.21,0.343,2
F,0.57,0.455,0.15,1.107,0.54,0.255,0.27,1
M,0.57,0.445,0.14,1.0635,0.5265,0.2195,0.24,1
M,0.57,0.46,0.17,0.9035,0.4075,0.1935,0.214,1
M,0.575,0.475,0.16,1.114,0.4955,0.2745,0.29,2
F,0.575,0.46,0.16,1.103,0.538,0.221,0.249,2
F,0.58,0.46,0.15,1.1155,0.5575,0.2255,0.29,1
F,0.58,0.46,0.18,1.0515,0.4095,0.2595,0.276,1
M,0.58,0.455,0.15,1.012,0.4985,0.2115,0.2835,2
F,0.58,0.45,0.145,1.137,0.5585,0.22,0.29,1
M,0.58,0.49,0.13,1.1335,0.586,0.2565,0.237,2
M,0.59,0.465,0.155,1.136,0.5245,0.2615,0.275,3
M,0.59,0.47,0.16,1.206,0.479,0.2425,0.309,1
F,0.59,0.455,0.145,1.063,0.5155,0.2445,0.25,1
F,0.595,0.47,0.155,1.121,0.4515,0.178,0.155,3
F,0.595,0.45,0.15,1.114,0.5865,0.2205,0.25,3
M,0.595,0.475,0.165,1.213,0.621,0.2435,0.274,2
F,0.595,0.46,0.14,1.0045,0.4655,0.2095,0.2515,2
M,0.595,0.455,0.15,1.044,0.518,0.2205,0.27,2
F,0.605,0.49,0.15,1.1345,0.5265,0.2645,0.295,2
M,0.605,0.475,0.155,1.161,0.572,0.2455,0.275,2
M,0.605,0.47,0.165,1.2315,0.6025,0.262,0.2925,3
M,0.61,0.47,0.15,1.1625,0.565,0.258,0.3085,3
M,0.61,0.475,0.155,1.168,0.554,0.239,0.3295,2
F,0.615,0.48,0.16,1.2525,0.585,0.2595,0.33,1
F,0.62,0.51,0.18,1.3315,0.594,0.276,0.388,3
F,0.625,0.48,0.17,1.3525,0.6235,0.278,0.365,2
M,0.625,0.49,0.175,1.3325,0.5705,0.271,0.405,2
F,0.625,0.475,0.175,1.1435,0.4755,0.2475,0.349,2
F,0.625,0.5,0.165,1.288,0.573,0.3035,0.315,2
F,0.625,0.485,0.2,1.38,0.5845,0.302,0.401,2
M,0.63,0.485,0.155,1.278,0.637,0.275,0.31,1
F,0.63,0.495,0.165,1.3075,0.599,0.284,0.315,3
M,0.63,0.48,0.15,1.1785,0.5185,0.248,0.3235,1
M,0.635,0.49,0.175,1.375,0.623,0.2705,0.395,3
M,0.635,0.525,0.185,1.4065,0.684,0.3,0.3745,2
M,0.64,0.505,0.155,1.4025,0.705,0.2655,0.335,2
F,0.64,0.5,0.17,1.5175,0.693,0.326,0.409,3
F,0.64,0.5,0.175,1.394,0.4935,0.291,0.4,2
F,0.645,0.5,0.155,1.2205,0.6145,0.236,0.3185,2
M,0.645,0.52,0.175,1.636,0.779,0.342,0.432,3
M,0.645,0.52,0.175,1.561,0.709,0.3555,0.4,1
F,0.645,0.505,0.165,1.4325,0.684,0.308,0.336,1
M,0.645,0.5,0.175,1.3385,0.633,0.299,0.349,3
F,0.645,0.5,0.16,1.2465,0.5475,0.327,0.3,2
F,0.645,0.515,0.15,1.212,0.515,0.2055,0.385,2
M,0.65,0.495,0.16,1.304,0.57,0.312,0.3725,2
M,0.65,0.52,0.21,1.6785,0.6665,0.308,0.46,3
M,0.65,0.525,0.185,1.622,0.6645,0.3225,0.477,2
F,0.655,0.46,0.16,1.494,0.6895,0.331,0.1825,2
F,0.655,0.51,0.175,1.6525,0.8515,0.3365,0.403,2
F,0.66,0.505,0.185,1.528,0.69,0.3025,0.441,3
M,0.66,0.535,0.19,1.5905,0.6425,0.297,0.5175,2
M,0.66,0.495,0.195,1.6275,0.594,0.3595,0.485,2
F,0.66,0.475,0.18,1.3695,0.641,0.294,0.335,1
M,0.67,0.525,0.165,1.6085,0.682,0.3145,0.4005,3
F,0.675,0.57,0.225,1.587,0.739,0.2995,0.435,2
F,0.675,0.565,0.195,1.8375,0.7645,0.3615,0.553,3
M,0.68,0.535,0.185,1.607,0.7245,0.3215,0.498,3
M,0.69,0.525,0.175,1.7005,0.8255,0.362,0.405,1
M,0.69,0.505,0.2,1.872,0.893,0.4015,0.48,2
F,0.695,0.535,0.175,1.8385,0.8035,0.396,0.503,2
F,0.705,0.535,0.18,1.685,0.693,0.42,0.4045,3
M,0.71,0.565,0.205,2.198,1.012,0.5225,0.5475,3
M,0.715,0.565,0.175,1.9525,0.7645,0.4185,0.4135,2
F,0.715,0.525,0.185,1.56,0.6655,0.383,0.405,3
F,0.735,0.6,0.22,2.555,1.1335,0.44,0.6,3
M,0.765,0.6,0.22,2.302,1.007,0.509,0.6205,3
I,0.185,0.13,0.045,0.029,0.012,0.0075,0.0095,1
I,0.195,0.15,0.045,0.0375,0.018,0.006,0.011,1
I,0.195,0.135,0.04,0.0325,0.0135,0.005,0.0095,1
I,0.2,0.155,0.04,0.0435,0.0155,0.009,0.007,1
I,0.225,0.165,0.055,0.059,0.027,0.0125,0.015,1
I,0.245,0.18,0.065,0.071,0.03,0.013,0.0215,1
I,0.25,0.18,0.065,0.0685,0.0245,0.0155,0.0225,1
I,0.265,0.195,0.055,0.084,0.0365,0.0175,0.025,1
I,0.275,0.195,0.065,0.106,0.054,0.02,0.028,1
I,0.28,0.21,0.085,0.1075,0.0415,0.024,0.034,1
I,0.285,0.22,0.065,0.096,0.0405,0.0205,0.03,1
I,0.3,0.22,0.08,0.1255,0.055,0.0265,0.039,1
I,0.315,0.235,0.055,0.151,0.065,0.027,0.039,1
I,0.32,0.225,0.085,0.1415,0.0675,0.0295,0.0405,1
I,0.34,0.265,0.08,0.2015,0.09,0.0475,0.055,1
I,0.37,0.28,0.1,0.221,0.1165,0.0265,0.0635,1
I,0.375,0.28,0.08,0.2345,0.1125,0.0455,0.067,1
I,0.375,0.275,0.1,0.2325,0.1165,0.042,0.065,1
I,0.385,0.29,0.08,0.2485,0.122,0.0495,0.065,1
I,0.4,0.32,0.095,0.348,0.194,0.053,0.087,1
I,0.405,0.3,0.11,0.32,0.172,0.044,0.093,1
I,0.41,0.3,0.1,0.282,0.1255,0.057,0.0875,1
I,0.41,0.325,0.1,0.3245,0.132,0.072,0.106,1
I,0.42,0.3,0.105,0.316,0.1255,0.07,0.1035,1
I,0.42,0.32,0.11,0.3625,0.174,0.0635,0.105,1
I,0.42,0.31,0.095,0.279,0.1255,0.051,0.088,1
I,0.425,0.325,0.115,0.3685,0.162,0.0865,0.1045,1
M,0.43,0.335,0.12,0.397,0.1985,0.0865,0.1035,1
I,0.435,0.33,0.11,0.413,0.2055,0.096,0.096,1
I,0.435,0.345,0.115,0.418,0.222,0.0735,0.106,1
I,0.44,0.33,0.11,0.3705,0.1545,0.084,0.12,1
I,0.445,0.345,0.105,0.409,0.1675,0.1015,0.117,1
I,0.445,0.34,0.145,0.434,0.1945,0.0905,0.13,1
I,0.445,0.335,0.11,0.411,0.1985,0.0935,0.109,1
I,0.45,0.365,0.125,0.462,0.2135,0.0985,0.1315,1
I,0.45,0.34,0.12,0.4925,0.241,0.1075,0.12,1
I,0.45,0.33,0.105,0.3715,0.1865,0.0785,0.0975,1
I,0.45,0.33,0.1,0.411,0.1945,0.1,0.098,1
I,0.45,0.33,0.11,0.3685,0.16,0.0885,0.102,1
I,0.46,0.35,0.115,0.4155,0.18,0.098,0.1175,1
M,0.47,0.36,0.105,0.544,0.27,0.1395,0.129,1
I,0.47,0.38,0.125,0.4845,0.211,0.1075,0.142,1
I,0.475,0.35,0.11,0.4565,0.206,0.099,0.13,1
I,0.475,0.35,0.1,0.4545,0.2165,0.111,0.115,1
I,0.48,0.38,0.125,0.6245,0.3395,0.1085,0.1665,1
M,0.49,0.465,0.125,0.5225,0.235,0.13,0.141,1
I,0.5,0.375,0.14,0.5495,0.248,0.112,0.1585,1
I,0.5,0.375,0.12,0.542,0.215,0.116,0.17,2
I,0.5,0.38,0.125,0.519,0.2485,0.1135,0.134,1
M,0.5,0.39,0.125,0.5215,0.2485,0.117,0.131,1
F,0.505,0.39,0.125,0.5445,0.246,0.15,0.1405,1
I,0.51,0.405,0.125,0.6795,0.3465,0.1395,0.182,1
F,0.51,0.4,0.125,0.545,0.261,0.115,0.1385,1
I,0.51,0.4,0.125,0.5575,0.2615,0.1195,0.1525,2
I,0.51,0.38,0.115,0.5155,0.215,0.1135,0.166,1
I,0.515,0.385,0.125,0.6115,0.3175,0.1265,0.15,1
M,0.52,0.4,0.145,0.7765,0.3525,0.1845,0.185,2
I,0.52,0.38,0.135,0.5395,0.2295,0.133,0.157,1
I,0.52,0.38,0.125,0.5545,0.288,0.1295,0.167,1
F,0.52,0.46,0.15,1.019,0.523,0.1985,0.254,1
I,0.525,0.4,0.13,0.6455,0.325,0.1245,0.17,1
I,0.525,0.4,0.14,0.601,0.2625,0.1285,0.1835,2
M,0.525,0.405,0.12,0.7555,0.3755,0.1555,0.201,2
I,0.525,0.395,0.12,0.608,0.297,0.1395,0.1405,1
I,0.53,0.4,0.125,0.617,0.279,0.127,0.19,1
I,0.535,0.39,0.125,0.599,0.2595,0.149,0.169,2
I,0.54,0.42,0.14,0.6665,0.3125,0.138,0.1895,2
M,0.545,0.39,0.135,0.7835,0.4225,0.1815,0.156,1
M,0.545,0.41,0.12,0.793,0.434,0.1405,0.19,2
M,0.545,0.415,0.14,0.82,0.4615,0.127,0.218,2
F,0.55,0.415,0.135,0.8145,0.427,0.1855,0.175,1
F,0.55,0.43,0.15,0.84,0.395,0.195,0.223,1
M,0.55,0.425,0.15,0.8315,0.411,0.1765,0.2165,2
M,0.56,0.43,0.145,0.8995,0.464,0.1775,0.234,2
M,0.56,0.445,0.16,0.8965,0.42,0.2175,0.2215,1
F,0.56,0.44,0.155,0.6405,0.336,0.1765,0.245,1
M,0.56,0.415,0.145,0.852,0.43,0.1885,0.205,1
M,0.565,0.455,0.15,0.9595,0.4565,0.2395,0.23,2
M,0.565,0.435,0.15,0.99,0.5795,0.1825,0.206,1
F,0.565,0.45,0.175,1.0095,0.447,0.2375,0.2645,2
M,0.57,0.46,0.15,1.0375,0.5415,0.2035,0.25,2
F,0.57,0.445,0.145,0.8775,0.412,0.217,0.22,1
I,0.57,0.44,0.15,0.755,0.3425,0.16,0.224,1
F,0.575,0.46,0.145,0.9945,0.466,0.229,0.265,1
F,0.575,0.45,0.16,1.068,0.556,0.214,0.2575,2
M,0.575,0.435,0.14,0.8455,0.401,0.191,0.222,2
F,0.575,0.47,0.165,0.869,0.435,0.197,0.238,2
M,0.575,0.455,0.135,0.907,0.4245,0.197,0.26,2
I,0.575,0.435,0.13,0.805,0.3155,0.2155,0.245,2
M,0.575,0.445,0.17,1.0225,0.549,0.2175,0.228,2
M,0.575,0.445,0.145,0.847,0.415,0.1945,0.22,2
M,0.58,0.455,0.15,1.114,0.4765,0.2155,0.265,1
M,0.58,0.455,0.195,1.859,0.945,0.426,0.441,2
M,0.58,0.445,0.135,0.814,0.3775,0.1915,0.22,2
M,0.58,0.45,0.14,0.9615,0.486,0.1815,0.253,2
M,0.58,0.45,0.145,1.0025,0.547,0.1975,0.2295,1
F,0.58,0.45,0.155,0.93,0.385,0.246,0.265,2
M,0.585,0.46,0.145,0.9335,0.478,0.1825,0.235,2
M,0.585,0.465,0.16,0.9555,0.4595,0.236,0.265,1
M,0.59,0.47,0.15,0.9955,0.481,0.232,0.24,1
F,0.6,0.475,0.16,1.0265,0.485,0.2495,0.2565,2
M,0.6,0.455,0.17,1.1915,0.696,0.2395,0.24,1
F,0.6,0.465,0.15,1.1025,0.5455,0.262,0.25,1
M,0.6,0.465,0.155,1.0165,0.512,0.2465,0.225,2
F,0.605,0.47,0.165,1.1775,0.611,0.2275,0.292,2
M,0.605,0.475,0.14,1.1175,0.555,0.257,0.274,2
M,0.605,0.48,0.17,1.1835,0.582,0.2365,0.317,2
F,0.605,0.475,0.165,1.056,0.433,0.2195,0.357,2
M,0.61,0.485,0.16,1.0145,0.5315,0.212,0.2415,1
M,0.61,0.485,0.145,1.3305,0.783,0.2255,0.2865,2
M,0.61,0.47,0.165,1.052,0.498,0.242,0.267,2
M,0.615,0.46,0.17,1.0565,0.4815,0.272,0.27,2
F,0.615,0.465,0.15,0.923,0.4615,0.1825,0.2415,2
F,0.615,0.475,0.155,1.027,0.447,0.25,0.285,2
M,0.62,0.47,0.135,1.0195,0.5315,0.2005,0.2475,1
M,0.62,0.45,0.2,0.858,0.4285,0.1525,0.2405,1
F,0.62,0.48,0.16,1.1125,0.5635,0.2445,0.281,1
F,0.625,0.485,0.175,1.3745,0.7335,0.2715,0.332,2
M,0.625,0.48,0.185,1.2065,0.587,0.29,0.286,1
M,0.63,0.47,0.155,1.1325,0.589,0.211,0.287,1
M,0.63,0.5,0.175,1.2645,0.5635,0.3065,0.3425,2
F,0.635,0.495,0.015,1.1565,0.5115,0.308,0.2885,2
M,0.64,0.515,0.165,1.369,0.632,0.3415,0.358,2
M,0.645,0.53,0.195,1.39,0.6465,0.2945,0.3735,2
F,0.645,0.48,0.17,1.1345,0.528,0.254,0.305,2
F,0.65,0.5,0.19,1.464,0.6415,0.339,0.4245,2
M,0.65,0.5,0.155,1.202,0.565,0.3135,0.294,3
M,0.655,0.515,0.16,1.31,0.553,0.369,0.345,3
F,0.655,0.51,0.175,1.415,0.5885,0.3725,0.364,2
F,0.66,0.53,0.185,1.346,0.546,0.2705,0.476,3
M,0.665,0.525,0.16,1.363,0.629,0.279,0.34,1
I,0.665,0.5,0.17,1.2975,0.6035,0.291,0.3595,2
F,0.67,0.505,0.205,1.3645,0.6075,0.3025,0.353,2
F,0.685,0.54,0.215,1.7025,0.664,0.3655,0.4735,3
M,0.685,0.52,0.165,1.519,0.699,0.3685,0.4,2
F,0.69,0.54,0.155,1.454,0.624,0.3105,0.39,2
M,0.69,0.53,0.21,1.583,0.7355,0.405,0.3865,3
F,0.69,0.53,0.17,1.5535,0.7945,0.3485,0.3695,2
M,0.695,0.56,0.185,1.74,0.885,0.3715,0.4375,2
M,0.7,0.565,0.18,1.751,0.895,0.3355,0.446,2
M,0.7,0.575,0.19,2.273,1.095,0.418,0.638,3
F,0.7,0.525,0.19,1.6465,0.8545,0.307,0.3995,2
F,0.705,0.55,0.17,1.219,0.6395,0.236,0.301,2
F,0.71,0.56,0.18,1.652,0.735,0.381,0.4525,3
M,0.715,0.55,0.19,2.0045,1.0465,0.407,0.5075,3
M,0.715,0.535,0.19,1.6755,0.889,0.313,0.42,2
F,0.72,0.58,0.195,2.103,1.0265,0.48,0.5375,2
F,0.72,0.55,0.2,1.9965,0.9035,0.469,0.5215,2
M,0.72,0.565,0.145,1.187,0.691,0.1945,0.2685,1
M,0.725,0.505,0.185,1.978,1.026,0.4255,0.4505,3
F,0.73,0.575,0.185,1.8795,0.931,0.38,0.4825,3
M,0.735,0.585,0.185,2.124,0.952,0.55,0.5,3
M,0.745,0.565,0.215,1.931,0.896,0.4585,0.5,3
F,0.75,0.57,0.21,2.236,1.109,0.5195,0.545,3
F,0.755,0.625,0.21,2.505,1.1965,0.513,0.6785,3
M,0.755,0.58,0.205,2.0065,0.8295,0.4015,0.595,2
F,0.78,0.63,0.215,2.657,1.488,0.4985,0.586,3
I,0.185,0.375,0.12,0.4645,0.196,0.1045,0.15,1
I,0.245,0.205,0.06,0.0765,0.034,0.014,0.0215,1
I,0.25,0.185,0.065,0.0685,0.0295,0.014,0.0225,1
I,0.25,0.19,0.065,0.0835,0.039,0.015,0.025,1
I,0.275,0.195,0.09,0.1125,0.0545,0.0295,0.0355,1
I,0.305,0.215,0.065,0.1075,0.044,0.0205,0.038,1
I,0.31,0.225,0.07,0.1055,0.435,0.015,0.04,1
I,0.315,0.23,0.08,0.1375,0.0545,0.031,0.0445,1
I,0.315,0.23,0.07,0.1145,0.046,0.0235,0.0385,1
I,0.325,0.225,0.075,0.139,0.0565,0.032,0.09,1
I,0.33,0.25,0.095,0.2085,0.102,0.0395,0.052,1
I,0.33,0.205,0.095,0.1595,0.077,0.032,0.0435,1
I,0.335,0.245,0.09,0.2015,0.096,0.0405,0.048,1
I,0.34,0.25,0.09,0.179,0.0775,0.033,0.055,1
I,0.345,0.255,0.095,0.1945,0.0925,0.037,0.055,1
I,0.345,0.255,0.085,0.2005,0.105,0.037,0.05,1
I,0.35,0.27,0.075,0.215,0.1,0.036,0.065,1
I,0.35,0.255,0.09,0.1785,0.0855,0.0305,0.0525,1
I,0.36,0.27,0.085,0.196,0.0875,0.035,0.064,1
I,0.365,0.27,0.085,0.1875,0.081,0.042,0.058,1
I,0.365,0.27,0.085,0.196,0.0825,0.0375,0.06,1
I,0.365,0.265,0.085,0.213,0.0945,0.049,0.06,1
I,0.37,0.29,0.09,0.2445,0.089,0.0655,0.075,1
I,0.37,0.28,0.085,0.217,0.1095,0.035,0.062,1
I,0.375,0.29,0.095,0.213,0.096,0.041,0.061,1
I,0.375,0.29,0.085,0.2385,0.118,0.045,0.0695,1
I,0.375,0.275,0.09,0.218,0.093,0.0405,0.0755,1
I,0.375,0.275,0.095,0.2465,0.11,0.0415,0.0775,1
I,0.375,0.28,0.08,0.2025,0.0825,0.048,0.065,1
I,0.375,0.27,0.085,0.218,0.0945,0.039,0.07,1
I,0.38,0.275,0.11,0.256,0.11,0.0535,0.0755,1
I,0.38,0.27,0.08,0.2105,0.0865,0.042,0.07,1
I,0.385,0.29,0.09,0.2615,0.111,0.0595,0.0745,2
I,0.385,0.28,0.085,0.2175,0.097,0.038,0.067,1
I,0.385,0.3,0.095,0.302,0.152,0.0615,0.0735,1
I,0.385,0.28,0.09,0.228,0.1025,0.042,0.0655,1
I,0.39,0.3,0.095,0.3265,0.1665,0.0575,0.089,1
I,0.395,0.305,0.105,0.284,0.1135,0.0595,0.0945,1
I,0.395,0.295,0.095,0.2725,0.115,0.0625,0.085,1
I,0.395,0.27,0.1,0.2985,0.1445,0.061,0.082,1
I,0.4,0.29,0.1,0.2675,0.1205,0.0605,0.0765,1
I,0.405,0.285,0.09,0.2645,0.1265,0.0505,0.075,1
I,0.41,0.335,0.11,0.33,0.157,0.0705,0.17,1
I,0.42,0.305,0.09,0.328,0.168,0.0615,0.082,1
I,0.425,0.325,0.11,0.3335,0.173,0.045,0.1,1
I,0.425,0.32,0.1,0.3055,0.126,0.06,0.106,1
I,0.425,0.31,0.09,0.301,0.1385,0.065,0.08,1
I,0.43,0.34,0,0.428,0.2065,0.086,0.115,1
I,0.43,0.315,0.095,0.378,0.175,0.08,0.1045,1
I,0.435,0.315,0.11,0.3685,0.1615,0.0715,0.12,1
I,0.44,0.34,0.12,0.438,0.2115,0.083,0.12,2
I,0.45,0.33,0.105,0.448,0.208,0.089,0.12,2
I,0.455,0.345,0.105,0.4005,0.164,0.0755,0.126,1
F,0.455,0.365,0.115,0.4305,0.184,0.108,0.1245,1
I,0.455,0.33,0.1,0.372,0.358,0.0775,0.11,1
I,0.46,0.36,0.105,0.466,0.2225,0.099,0.11,1
I,0.46,0.35,0.105,0.3705,0.1575,0.077,0.114,2
F,0.46,0.365,0.125,0.4785,0.206,0.1045,0.141,1
I,0.465,0.34,0.11,0.346,0.1425,0.073,0.113,3
I,0.47,0.365,0.1,0.411,0.175,0.0855,0.135,1
I,0.47,0.355,0.18,0.48,0.2055,0.105,0.1505,1
I,0.47,0.355,0.12,0.393,0.167,0.0885,0.115,1
I,0.475,0.355,0.1,0.5035,0.2535,0.091,0.14,1
I,0.475,0.38,0.12,0.441,0.1785,0.0885,0.1505,1
I,0.475,0.36,0.11,0.492,0.211,0.11,0.15,1
I,0.48,0.37,0.125,0.5435,0.244,0.101,0.165,2
I,0.48,0.355,0.115,0.4725,0.2065,0.112,0.132,1
I,0.48,0.365,0.1,0.461,0.2205,0.0835,0.135,1
I,0.495,0.355,0.12,0.4965,0.214,0.1045,0.1495,1
I,0.495,0.38,0.13,0.5125,0.2185,0.116,0.16,1
M,0.495,0.395,0.12,0.553,0.224,0.1375,0.167,1
I,0.5,0.38,0.135,0.594,0.2945,0.104,0.1565,2
M,0.5,0.42,0.135,0.6765,0.302,0.1415,0.2065,2
I,0.5,0.375,0.145,0.5795,0.239,0.1375,0.185,2
I,0.5,0.41,0.14,0.6615,0.2585,0.1625,0.196,2
I,0.5,0.375,0.125,0.5695,0.259,0.124,0.157,1
I,0.5,0.395,0.14,0.6215,0.2925,0.1205,0.195,2
I,0.505,0.405,0.13,0.6015,0.3015,0.11,0.18,1
I,0.505,0.38,0.12,0.594,0.2595,0.1435,0.18,1
I,0.505,0.395,0.105,0.551,0.248,0.103,0.171,1
I,0.515,0.38,0.12,0.625,0.3265,0.1295,0.16,1
I,0.515,0.42,0.135,0.711,0.337,0.144,0.205,3
I,0.515,0.4,0.135,0.6965,0.32,0.1255,0.175,2
I,0.52,0.4,0.13,0.5825,0.233,0.1365,0.18,2
I,0.52,0.395,0.125,0.663,0.3005,0.131,0.1905,2
I,0.525,0.4,0.125,0.6965,0.369,0.1385,0.164,2
M,0.525,0.42,0.155,0.842,0.428,0.1415,0.2045,2
I,0.53,0.415,0.13,0.694,0.3905,0.111,0.167,2
I,0.53,0.42,0.155,0.81,0.4725,0.111,0.192,2
I,0.53,0.415,0.11,0.5745,0.2525,0.1235,0.189,2
I,0.53,0.425,0.13,0.7675,0.419,0.1205,0.21,2
I,0.535,0.4,0.135,0.6025,0.2895,0.121,0.154,2
I,0.535,0.415,0.15,0.5765,0.3595,0.135,0.225,1
F,0.535,0.41,0.13,0.7145,0.335,0.144,0.2075,2
M,0.535,0.435,0.15,0.717,0.3475,0.1445,0.194,2
F,0.54,0.42,0.145,0.8655,0.4315,0.163,0.2175,2
I,0.54,0.42,0.14,0.7265,0.3205,0.1445,0.229,2
I,0.545,0.435,0.135,0.7715,0.372,0.148,0.227,1
F,0.545,0.445,0.15,0.8,0.3535,0.163,0.207,2
I,0.545,0.43,0.15,0.7285,0.302,0.1315,0.2545,2
I,0.545,0.405,0.135,0.5945,0.27,0.1185,0.185,1
I,0.55,0.43,0.145,0.7895,0.3745,0.171,0.223,3
F,0.55,0.405,0.125,0.651,0.2965,0.137,0.2,2
M,0.55,0.43,0.15,0.8745,0.413,0.1905,0.248,2
I,0.55,0.435,0.14,0.7535,0.3285,0.1555,0.2325,2
I,0.55,0.425,0.135,0.7305,0.3325,0.1545,0.215,2
M,0.555,0.44,0.14,0.8705,0.407,0.156,0.255,2
I,0.555,0.43,0.155,0.7395,0.3135,0.1435,0.28,2
I,0.555,0.43,0.14,0.7665,0.341,0.165,0.23,2
I,0.555,0.425,0.145,0.7905,0.3485,0.1765,0.225,2
I,0.56,0.425,0.135,0.8205,0.3715,0.185,0.236,2
I,0.56,0.425,0.145,0.688,0.3095,0.1305,0.2165,2
F,0.56,0.445,0.155,1.224,0.5565,0.3225,0.2695,2
I,0.56,0.455,0.145,0.974,0.547,0.1615,0.235,2
I,0.565,0.44,0.175,0.8735,0.414,0.21,0.21,3
F,0.565,0.45,0.145,0.8495,0.4215,0.1685,0.225,1
M,0.565,0.445,0.15,0.796,0.3635,0.184,0.219,1
M,0.565,0.39,0.125,0.744,0.352,0.13,0.1685,3
I,0.57,0.45,0.145,0.751,0.2825,0.2195,0.2215,2
I,0.57,0.45,0.135,0.794,0.3815,0.1415,0.245,1
F,0.57,0.46,0.135,0.9795,0.397,0.2525,0.2655,2
M,0.57,0.435,0.17,0.873,0.382,0.183,0.2705,2
I,0.57,0.44,0.13,0.7665,0.347,0.1785,0.202,2
M,0.57,0.435,0.125,0.8965,0.383,0.1835,0.275,2
F,0.575,0.42,0.135,0.857,0.461,0.147,0.2125,2
F,0.575,0.48,0.165,1.078,0.511,0.2095,0.306,2
M,0.575,0.46,0.155,0.892,0.4415,0.176,0.22,2
M,0.58,0.46,0.155,1.4395,0.6715,0.273,0.2955,2
M,0.58,0.455,0.135,0.7955,0.405,0.167,0.204,2
F,0.58,0.445,0.15,0.858,0.4,0.156,0.253,1
M,0.585,0.465,0.155,0.9145,0.4555,0.1965,0.235,2
M,0.585,0.49,0.185,1.171,0.522,0.2535,0.335,2
I,0.585,0.475,0.16,1.0505,0.48,0.234,0.285,2
M,0.585,0.46,0.165,1.1135,0.5825,0.2345,0.274,2
M,0.585,0.47,0.165,1.409,0.8,0.229,0.295,2
M,0.585,0.475,0.15,1.065,0.5315,0.199,0.2885,2
M,0.585,0.45,0.18,0.7995,0.336,0.1855,0.237,1
I,0.59,0.445,0.135,0.7715,0.328,0.1745,0.23,2
M,0.59,0.47,0.18,1.187,0.5985,0.227,0.31,2
M,0.59,0.455,0.155,0.8855,0.388,0.188,0.275,2
F,0.595,0.465,0.15,0.98,0.4115,0.196,0.2255,2
F,0.595,0.465,0.155,1.026,0.4645,0.112,0.305,3
M,0.6,0.475,0.17,1.1315,0.508,0.272,0.309,2
M,0.6,0.48,0.155,1.014,0.451,0.1885,0.325,3
I,0.6,0.475,0.15,1.12,0.565,0.2465,0.27,2
F,0.6,0.465,0.155,1.04,0.4755,0.25,0.28,3
F,0.6,0.455,0.145,0.8895,0.419,0.1715,0.269,2
M,0.6,0.46,0.155,0.9595,0.4455,0.189,0.295,3
I,0.605,0.485,0.15,1.238,0.6315,0.226,0.33,3
M,0.605,0.49,0.14,0.9755,0.419,0.206,0.315,2
I,0.605,0.435,0.13,0.9025,0.432,0.174,0.26,3
F,0.605,0.475,0.175,1.076,0.463,0.2195,0.335,2
F,0.605,0.47,0.16,1.0835,0.5405,0.2215,0.275,3
M,0.61,0.45,0.15,0.871,0.407,0.1835,0.25,2
M,0.61,0.48,0.165,1.244,0.6345,0.257,0.305,3
M,0.61,0.475,0.17,1.0265,0.435,0.2335,0.3035,2
I,0.61,0.465,0.15,0.9605,0.4495,0.1725,0.286,2
M,0.61,0.48,0.17,1.137,0.4565,0.29,0.347,2
M,0.61,0.46,0.16,1,0.494,0.197,0.275,2
F,0.615,0.475,0.155,1.004,0.4475,0.193,0.2895,2
M,0.615,0.47,0.165,1.128,0.4465,0.2195,0.34,2
M,0.615,0.5,0.17,1.054,0.4845,0.228,0.295,2
F,0.615,0.475,0.165,1.023,0.4905,0.1955,0.3035,3
M,0.615,0.475,0.17,1.129,0.4795,0.302,0.3,2
M,0.615,0.48,0.175,1.118,0.446,0.3195,0.3,2
F,0.615,0.475,0.155,1.115,0.484,0.2115,0.355,2
M,0.62,0.51,0.175,1.2815,0.5715,0.2385,0.39,2
M,0.62,0.495,0.18,1.2555,0.5765,0.254,0.355,3
F,0.62,0.5,0.15,1.293,0.596,0.3135,0.354,2
F,0.62,0.475,0.16,1.1295,0.463,0.2685,0.33,2
M,0.625,0.455,0.17,1.082,0.4955,0.2345,0.315,2
F,0.625,0.505,0.175,1.15,0.5475,0.256,0.3045,3
F,0.625,0.515,0.16,1.264,0.5715,0.326,0.321,2
F,0.625,0.48,0.155,1.2035,0.5865,0.239,0.3185,3
F,0.63,0.485,0.17,1.3205,0.5945,0.345,0.345,2
I,0.63,0.505,0.18,1.272,0.6025,0.295,0.315,3
M,0.63,0.485,0.145,1.062,0.5065,0.1785,0.3365,3
I,0.63,0.475,0.145,1.0605,0.5165,0.2195,0.28,2
M,0.63,0.495,0.16,1.093,0.497,0.221,0.315,3
M,0.635,0.49,0.16,1.101,0.534,0.1865,0.3455,2
F,0.635,0.5,0.165,1.4595,0.705,0.2645,0.39,2
F,0.635,0.495,0.175,1.211,0.707,0.2725,0.323,2
M,0.635,0.475,0.17,1.1935,0.5205,0.2695,0.3665,2
M,0.635,0.51,0.155,0.986,0.405,0.2255,0.31,2
M,0.64,0.565,0.23,1.521,0.644,0.372,0.406,3
M,0.64,0.525,0.18,1.3135,0.4865,0.2995,0.4075,2
M,0.645,0.51,0.16,1.1835,0.556,0.2385,0.345,3
M,0.645,0.5,0.195,1.401,0.6165,0.3515,0.3725,2
M,0.645,0.525,0.16,1.5075,0.7455,0.245,0.4325,3
F,0.65,0.505,0.165,1.16,0.4785,0.274,0.349,3
F,0.65,0.59,0.22,1.662,0.77,0.378,0.435,3
M,0.65,0.525,0.175,1.5365,0.6865,0.3585,0.405,3
M,0.65,0.51,0.19,1.542,0.7155,0.3735,0.375,2
F,0.65,0.51,0.17,1.567,0.7245,0.349,0.391,2
F,0.655,0.525,0.19,1.3595,0.564,0.3215,0.3985,2
M,0.655,0.535,0.205,1.6445,0.7305,0.3595,0.46,3
F,0.655,0.52,0.19,1.4545,0.6,0.3865,0.383,2
M,0.655,0.49,0.175,1.3585,0.6395,0.294,0.365,2
F,0.66,0.495,0.21,1.548,0.724,0.3525,0.3925,2
F,0.66,0.515,0.17,1.337,0.615,0.3125,0.3575,2
F,0.665,0.53,0.18,1.491,0.6345,0.342,0.435,2
F,0.67,0.53,0.225,1.5615,0.63,0.487,0.3725,3
F,0.67,0.505,0.175,1.0145,0.4375,0.271,0.3745,2
M,0.675,0.545,0.185,1.7375,0.876,0.3135,0.469,3
M,0.685,0.545,0.205,1.7925,0.8145,0.416,0.461,2
F,0.695,0.565,0.19,1.7635,0.7465,0.399,0.4975,3
F,0.7,0.545,0.13,1.556,0.6725,0.374,0.195,3
M,0.705,0.565,0.515,2.21,1.1075,0.4865,0.512,2
M,0.705,0.555,0.215,2.141,1.0465,0.383,0.528,3
F,0.705,0.57,0.18,1.5345,0.96,0.4195,0.43,3
F,0.71,0.55,0.17,1.614,0.743,0.345,0.45,3
F,0.72,0.575,0.17,1.9335,0.913,0.389,0.51,3
M,0.72,0.575,0.215,2.173,0.9515,0.564,0.5365,3
F,0.725,0.6,0.2,1.737,0.697,0.3585,0.595,3
F,0.73,0.58,0.19,1.7375,0.6785,0.4345,0.52,3
F,0.735,0.565,0.205,2.1275,0.949,0.46,0.565,3
F,0.745,0.57,0.215,2.25,1.1565,0.446,0.558,2
F,0.75,0.61,0.235,2.5085,1.232,0.519,0.612,3
F,0.815,0.65,0.25,2.255,0.8905,0.42,0.7975,3
I,0.14,0.105,0.035,0.014,0.0055,0.0025,0.004,1
I,0.23,0.165,0.06,0.0515,0.019,0.0145,0.036,1
I,0.365,0.265,0.135,0.2215,0.105,0.047,0.0605,1
I,0.365,0.255,0.08,0.1985,0.0785,0.0345,0.053,1
I,0.37,0.27,0.095,0.232,0.1325,0.041,0.0615,1
I,0.375,0.28,0.085,0.3155,0.187,0.046,0.067,1
I,0.385,0.3,0.09,0.247,0.1225,0.044,0.0675,1
I,0.395,0.295,0.09,0.3025,0.143,0.0665,0.0765,1
I,0.4,0.29,0.11,0.329,0.188,0.0455,0.0825,1
I,0.4,0.3,0.09,0.2815,0.1185,0.061,0.08,1
I,0.405,0.31,0.095,0.3425,0.1785,0.064,0.0855,1
I,0.405,0.29,0.09,0.2825,0.112,0.075,0.0815,1
I,0.405,0.3,0.105,0.304,0.1455,0.061,0.0805,1
I,0.41,0.32,0.095,0.2905,0.141,0.063,0.073,1
M,0.415,0.315,0.115,0.3895,0.2015,0.065,0.103,2
I,0.425,0.34,0.105,0.389,0.2015,0.0905,0.088,1
I,0.43,0.34,0.105,0.4405,0.2385,0.0745,0.1075,1
I,0.44,0.34,0.105,0.369,0.164,0.08,0.1015,1
M,0.44,0.32,0.12,0.4565,0.2435,0.092,0.1025,1
I,0.44,0.365,0.11,0.4465,0.213,0.089,0.1135,2
M,0.45,0.335,0.125,0.4475,0.2165,0.126,0.11,1
I,0.455,0.335,0.135,0.501,0.274,0.0995,0.1065,1
I,0.46,0.355,0.11,0.436,0.1975,0.096,0.125,1
I,0.47,0.345,0.14,0.4615,0.229,0.1105,0.116,2
I,0.47,0.35,0.125,0.4315,0.19,0.1165,0.1175,1
I,0.47,0.355,0.12,0.3685,0.126,0.0835,0.1365,1
M,0.475,0.37,0.125,0.649,0.347,0.136,0.142,1
I,0.475,0.365,0.115,0.459,0.2175,0.093,0.1165,1
F,0.475,0.365,0.115,0.566,0.281,0.117,0.1335,1
I,0.48,0.36,0.125,0.542,0.2795,0.1025,0.147,1
I,0.485,0.38,0.12,0.4725,0.2075,0.1075,0.147,1
M,0.485,0.39,0.085,0.6435,0.2945,0.103,0.198,1
M,0.485,0.37,0.13,0.526,0.2485,0.105,0.1555,1
F,0.495,0.38,0.12,0.573,0.2655,0.1285,0.144,1
M,0.505,0.385,0.105,0.5525,0.239,0.1245,0.1555,2
F,0.505,0.38,0.135,0.6855,0.361,0.1565,0.161,2
I,0.515,0.395,0.125,0.556,0.2695,0.096,0.17,1
M,0.515,0.425,0.145,0.9365,0.497,0.181,0.2185,1
I,0.515,0.4,0.125,0.5625,0.25,0.1245,0.17,1
M,0.52,0.4,0.125,0.559,0.254,0.139,0.149,1
M,0.525,0.4,0.14,0.7205,0.3685,0.145,0.1735,1
I,0.53,0.43,0.13,0.7045,0.346,0.1415,0.189,2
M,0.53,0.4,0.125,0.7575,0.398,0.151,0.175,1
F,0.545,0.41,0.14,0.7405,0.3565,0.1775,0.203,2
F,0.55,0.43,0.14,0.84,0.375,0.218,0.1945,1
M,0.55,0.425,0.16,0.793,0.343,0.2035,0.215,2
F,0.56,0.43,0.15,0.8745,0.453,0.161,0.22,1
F,0.56,0.435,0.15,0.8715,0.4755,0.1835,0.1835,2
M,0.57,0.445,0.15,0.9875,0.504,0.207,0.249,1
M,0.575,0.465,0.15,1.08,0.595,0.2065,0.238,2
M,0.575,0.46,0.165,0.9155,0.4005,0.2465,0.2385,1
F,0.58,0.46,0.175,1.165,0.65,0.2205,0.3055,2
F,0.58,0.435,0.14,0.953,0.475,0.2165,0.2095,2
M,0.585,0.455,0.15,0.906,0.4095,0.23,0.2335,1
M,0.59,0.44,0.15,0.8725,0.387,0.215,0.245,1
F,0.59,0.465,0.15,1.151,0.613,0.239,0.2515,2
F,0.59,0.46,0.145,0.9905,0.453,0.2205,0.275,1
F,0.595,0.455,0.16,1.04,0.452,0.2655,0.288,2
M,0.6,0.455,0.155,0.945,0.4365,0.2085,0.25,1
M,0.6,0.465,0.2,1.259,0.6405,0.1985,0.357,2
F,0.605,0.485,0.165,0.9515,0.4535,0.193,0.2765,3
F,0.605,0.485,0.16,1.201,0.417,0.2875,0.38,2
F,0.605,0.515,0.17,1.289,0.6,0.2945,0.3315,2
F,0.61,0.485,0.17,1.1005,0.5125,0.229,0.305,3
I,0.615,0.475,0.13,0.8425,0.353,0.1915,0.251,1
M,0.62,0.485,0.155,1.049,0.462,0.231,0.25,2
F,0.62,0.435,0.155,1.012,0.477,0.236,0.275,1
M,0.62,0.48,0.165,1.0725,0.4815,0.235,0.312,2
M,0.625,0.52,0.175,1.4105,0.691,0.322,0.3465,2
M,0.625,0.47,0.18,1.136,0.451,0.3245,0.305,3
M,0.63,0.47,0.145,1.1005,0.52,0.26,0.276,2
F,0.63,0.5,0.175,1.1105,0.467,0.268,0.329,2
M,0.63,0.455,0.15,1.1315,0.481,0.2745,0.305,2
M,0.63,0.48,0.15,1.271,0.6605,0.2425,0.31,3
F,0.63,0.49,0.225,1.336,0.6805,0.259,0.3245,2
F,0.635,0.505,0.145,1.1345,0.505,0.2655,0.315,2
M,0.635,0.51,0.185,1.308,0.544,0.318,0.377,1
F,0.64,0.515,0.205,1.5335,0.6635,0.3345,0.4025,2
F,0.645,0.515,0.175,1.546,0.7035,0.365,0.415,2
M,0.645,0.51,0.155,1.539,0.6405,0.3585,0.43,3
F,0.645,0.505,0.165,1.318,0.55,0.3015,0.335,3
F,0.65,0.545,0.175,1.5245,0.59,0.326,0.495,2
M,0.65,0.515,0.175,1.466,0.677,0.3045,0.4,2
F,0.65,0.5,0.16,1.3825,0.702,0.304,0.3195,2
M,0.65,0.485,0.14,1.175,0.475,0.2435,0.215,1
F,0.655,0.54,0.215,1.5555,0.695,0.296,0.444,3
M,0.655,0.51,0.215,1.7835,0.8885,0.4095,0.4195,3
M,0.66,0.505,0.165,1.374,0.589,0.351,0.345,2
F,0.665,0.515,0.18,1.389,0.5945,0.324,0.395,2
M,0.67,0.545,0.2,1.7025,0.833,0.374,0.41,3
M,0.67,0.51,0.175,1.5265,0.651,0.4475,0.345,2
M,0.67,0.5,0.19,1.519,0.616,0.388,0.415,2
F,0.68,0.5,0.185,1.741,0.7665,0.3255,0.4685,3
M,0.68,0.515,0.17,1.6115,0.8415,0.306,0.395,3
M,0.69,0.525,0.2,1.7825,0.9165,0.3325,0.461,3
F,0.7,0.55,0.17,1.684,0.7535,0.3265,0.32,3
M,0.7,0.555,0.2,1.858,0.73,0.3665,0.595,3
M,0.705,0.56,0.165,1.675,0.797,0.4095,0.388,2
M,0.72,0.565,0.2,2.1055,1.017,0.363,0.494,3
M,0.725,0.575,0.24,2.21,1.351,0.413,0.5015,3
M,0.74,0.57,0.18,1.8725,0.9115,0.427,0.446,2
M,0.75,0.55,0.18,1.893,0.942,0.397,0.445,3
I,0.21,0.17,0.045,0.0475,0.019,0.011,0.013,1
I,0.285,0.21,0.055,0.101,0.0415,0.017,0.0335,1
I,0.295,0.215,0.07,0.121,0.047,0.0155,0.0405,1
I,0.3,0.23,0.085,0.117,0.05,0.0175,0.0415,1
I,0.305,0.225,0.09,0.1465,0.063,0.034,0.0415,1
I,0.335,0.255,0.08,0.168,0.079,0.0355,0.05,1
I,0.35,0.26,0.075,0.18,0.09,0.0245,0.055,1
I,0.355,0.27,0.075,0.1775,0.079,0.0315,0.054,1
I,0.355,0.26,0.09,0.1985,0.0715,0.0495,0.058,1
I,0.36,0.27,0.095,0.2,0.073,0.056,0.061,1
I,0.36,0.275,0.075,0.2205,0.0985,0.044,0.066,1
I,0.36,0.265,0.075,0.1845,0.083,0.0365,0.055,1
I,0.365,0.27,0.085,0.2225,0.0935,0.0525,0.066,1
I,0.37,0.27,0.095,0.2175,0.097,0.046,0.065,1
I,0.375,0.28,0.08,0.2165,0.0935,0.0925,0.07,1
I,0.38,0.285,0.095,0.243,0.0895,0.0665,0.075,1
I,0.38,0.29,0.1,0.237,0.108,0.0395,0.082,1
I,0.385,0.29,0.09,0.2365,0.1,0.0505,0.076,1
I,0.385,0.28,0.095,0.257,0.119,0.059,0.07,1
I,0.385,0.3,0.09,0.308,0.1525,0.056,0.0835,1
I,0.39,0.3,0.09,0.252,0.1065,0.053,0.08,1
I,0.39,0.285,0.1,0.281,0.1275,0.062,0.077,1
I,0.39,0.29,0.1,0.2225,0.095,0.0465,0.073,1
I,0.41,0.3,0.09,0.304,0.129,0.071,0.0955,1
I,0.41,0.3,0.09,0.28,0.141,0.0575,0.075,1
I,0.415,0.325,0.1,0.313,0.139,0.0625,0.0965,1
I,0.425,0.325,0.11,0.317,0.135,0.048,0.09,1
I,0.425,0.315,0.08,0.303,0.131,0.0585,0.095,1
I,0.435,0.335,0.1,0.3295,0.129,0.07,0.11,1
I,0.435,0.325,0.11,0.367,0.1595,0.08,0.105,1
I,0.45,0.34,0.095,0.3245,0.1385,0.064,0.105,1
I,0.45,0.335,0.11,0.4195,0.181,0.085,0.1345,1
I,0.455,0.36,0.115,0.457,0.2085,0.0855,0.147,2
I,0.46,0.35,0.11,0.4,0.176,0.083,0.1205,1
I,0.46,0.355,0.11,0.4255,0.2015,0.081,0.13,1
I,0.465,0.37,0.12,0.4365,0.188,0.0815,0.147,2
I,0.465,0.345,0.11,0.393,0.1825,0.0735,0.12,1
I,0.47,0.355,0.125,0.499,0.21,0.0985,0.155,1
I,0.475,0.36,0.145,0.6325,0.2825,0.137,0.19,1
M,0.475,0.36,0.1,0.4285,0.1965,0.099,0.112,1
I,0.475,0.36,0.125,0.4905,0.205,0.1305,0.125,1
I,0.48,0.37,0.125,0.474,0.179,0.1035,0.175,2
I,0.48,0.37,0.12,0.536,0.251,0.114,0.15,1
M,0.48,0.355,0.16,0.464,0.221,0.106,0.239,1
I,0.485,0.375,0.13,0.6025,0.2935,0.1285,0.16,1
I,0.49,0.375,0.115,0.4615,0.204,0.0945,0.143,1
I,0.49,0.4,0.135,0.624,0.3035,0.1285,0.169,1
I,0.495,0.37,0.125,0.4715,0.2075,0.091,0.15,1
I,0.495,0.4,0.105,0.602,0.2505,0.1265,0.19,1
I,0.5,0.4,0.12,0.616,0.261,0.143,0.1935,1
I,0.5,0.39,0.12,0.5955,0.2455,0.147,0.173,1
I,0.5,0.375,0.14,0.559,0.2375,0.135,0.169,2
I,0.51,0.395,0.13,0.6025,0.281,0.143,0.162,1
F,0.515,0.375,0.11,0.6065,0.3005,0.131,0.15,1
I,0.515,0.36,0.125,0.4725,0.1815,0.125,0.138,2
I,0.515,0.35,0.105,0.4745,0.213,0.123,0.1275,2
I,0.515,0.395,0.125,0.6635,0.32,0.14,0.17,1
I,0.515,0.39,0.125,0.5705,0.238,0.1265,0.185,1
I,0.52,0.41,0.145,0.646,0.2965,0.1595,0.165,2
I,0.52,0.39,0.13,0.5545,0.2355,0.1095,0.1895,1
M,0.525,0.415,0.145,0.845,0.3525,0.1635,0.2875,1
I,0.525,0.39,0.12,0.664,0.3115,0.147,0.178,2
I,0.525,0.38,0.135,0.615,0.261,0.159,0.175,1
I,0.525,0.4,0.14,0.654,0.305,0.16,0.169,1
M,0.525,0.4,0.155,0.707,0.282,0.1605,0.225,2
I,0.53,0.42,0.12,0.5965,0.2555,0.141,0.177,1
I,0.53,0.43,0.135,0.6255,0.245,0.1455,0.2135,2
I,0.53,0.4,0.145,0.555,0.1935,0.1305,0.195,2
I,0.53,0.42,0.13,0.8365,0.3745,0.167,0.249,3
I,0.535,0.4,0.13,0.657,0.2835,0.162,0.175,1
I,0.54,0.43,0.17,0.836,0.3725,0.1815,0.24,2
I,0.54,0.425,0.14,0.742,0.32,0.1395,0.25,2
I,0.54,0.43,0.14,0.8195,0.3935,0.1725,0.2295,2
M,0.54,0.455,0.14,0.972,0.419,0.255,0.269,2
I,0.54,0.42,0.14,0.6275,0.2505,0.1175,0.235,2
I,0.54,0.425,0.13,0.7205,0.2955,0.169,0.225,2
I,0.54,0.425,0.135,0.686,0.3475,0.1545,0.213,1
I,0.545,0.4,0.13,0.686,0.3285,0.1455,0.18,2
I,0.545,0.375,0.12,0.543,0.2375,0.1155,0.1725,1
I,0.545,0.42,0.125,0.717,0.358,0.112,0.22,1
M,0.55,0.435,0.14,0.7625,0.327,0.1685,0.259,2
I,0.55,0.425,0.15,0.639,0.269,0.1345,0.217,2
I,0.55,0.42,0.135,0.816,0.3995,0.1485,0.23,3
I,0.55,0.415,0.145,0.7815,0.373,0.16,0.2215,1
I,0.55,0.425,0.15,0.7665,0.339,0.176,0.21,1
I,0.555,0.395,0.13,0.5585,0.222,0.1245,0.17,2
I,0.555,0.435,0.14,0.765,0.3945,0.15,0.206,1
I,0.555,0.46,0.145,0.9005,0.3845,0.158,0.2765,3
I,0.56,0.445,0.15,0.8225,0.3685,0.187,0.236,2
I,0.56,0.44,0.13,0.7235,0.349,0.149,0.2,1
M,0.56,0.425,0.135,0.849,0.3265,0.221,0.2645,2
I,0.565,0.42,0.155,0.743,0.31,0.186,0.231,2
F,0.565,0.44,0.15,0.863,0.435,0.149,0.27,2
M,0.565,0.44,0.125,0.802,0.3595,0.1825,0.215,2
M,0.565,0.43,0.15,0.831,0.4245,0.1735,0.219,2
F,0.57,0.45,0.135,0.7805,0.3345,0.185,0.21,1
M,0.57,0.45,0.14,0.795,0.3385,0.148,0.245,2
I,0.57,0.435,0.17,0.848,0.4,0.166,0.25,2
I,0.57,0.43,0.145,0.833,0.354,0.144,0.2815,2
I,0.57,0.445,0.155,0.867,0.3705,0.1705,0.28,2
I,0.57,0.445,0.145,0.7405,0.306,0.172,0.1825,3
M,0.575,0.455,0.165,0.867,0.3765,0.1805,0.268,1
I,0.575,0.425,0.135,0.7965,0.364,0.196,0.239,2
F,0.575,0.47,0.155,1.116,0.509,0.238,0.34,2
I,0.575,0.45,0.125,0.78,0.3275,0.188,0.235,2
M,0.575,0.47,0.185,0.985,0.3745,0.2175,0.355,2
F,0.575,0.465,0.195,0.9965,0.417,0.247,0.47,1
I,0.575,0.445,0.17,0.8015,0.3475,0.1465,0.25,2
I,0.575,0.45,0.135,0.807,0.3615,0.176,0.254,2
F,0.575,0.435,0.15,1.0305,0.4605,0.218,0.36,1
M,0.575,0.445,0.16,0.839,0.4005,0.198,0.239,2
M,0.575,0.44,0.16,0.9615,0.483,0.166,0.275,3
F,0.58,0.435,0.15,0.834,0.428,0.1515,0.23,1
M,0.58,0.46,0.155,1.0335,0.469,0.2225,0.295,2
M,0.58,0.43,0.13,0.798,0.365,0.173,0.2285,2
I,0.58,0.445,0.125,0.7095,0.303,0.1405,0.235,2
F,0.585,0.445,0.14,0.913,0.4305,0.2205,0.253,2
M,0.59,0.49,0.165,1.207,0.559,0.235,0.309,2
I,0.59,0.45,0.145,1.022,0.428,0.268,0.265,2
I,0.59,0.46,0.145,0.9015,0.419,0.1785,0.26,3
F,0.595,0.435,0.15,0.9,0.4175,0.17,0.265,1
M,0.595,0.45,0.14,0.838,0.3965,0.194,0.217,2
M,0.595,0.45,0.145,0.959,0.463,0.2065,0.2535,2
I,0.595,0.46,0.15,0.8335,0.377,0.1925,0.235,1
F,0.6,0.46,0.155,0.9735,0.427,0.2045,0.3,1
F,0.6,0.475,0.15,1.13,0.575,0.196,0.305,2
M,0.6,0.48,0.165,0.9165,0.4135,0.1965,0.2725,2
I,0.6,0.48,0.17,0.9175,0.38,0.2225,0.29,1
F,0.6,0.48,0.18,1.0645,0.4495,0.2455,0.325,2
M,0.6,0.47,0.165,1.059,0.504,0.241,0.275,2
M,0.6,0.47,0.16,1.194,0.5625,0.3045,0.2635,2
F,0.605,0.455,0.145,0.9775,0.468,0.1775,0.275,2
M,0.605,0.475,0.145,0.884,0.3835,0.1905,0.27,1
I,0.605,0.47,0.145,0.8025,0.379,0.2265,0.22,2
F,0.605,0.48,0.14,0.991,0.4735,0.2345,0.24,1
F,0.605,0.47,0.155,0.974,0.393,0.224,0.3345,2
F,0.605,0.505,0.18,1.434,0.7285,0.264,0.431,3
M,0.61,0.475,0.155,0.983,0.4565,0.228,0.266,2
F,0.61,0.465,0.16,1.0725,0.4835,0.2515,0.28,2
F,0.61,0.485,0.15,1.2405,0.6025,0.2915,0.3085,3
M,0.61,0.47,0.16,1.022,0.449,0.2345,0.2945,2
F,0.61,0.475,0.16,1.1155,0.3835,0.223,0.379,2
I,0.61,0.465,0.125,0.9225,0.436,0.19,0.26,2
M,0.61,0.47,0.17,1.1185,0.5225,0.2405,0.31,2
F,0.61,0.485,0.18,1.2795,0.5735,0.2855,0.355,1
M,0.615,0.47,0.16,1.0175,0.473,0.2395,0.28,2
M,0.615,0.475,0.175,1.224,0.6035,0.261,0.311,2
I,0.62,0.485,0.18,1.154,0.4935,0.256,0.315,3
F,0.62,0.515,0.155,1.3255,0.6685,0.2605,0.335,3
M,0.62,0.515,0.175,1.221,0.535,0.241,0.395,3
F,0.62,0.54,0.165,1.139,0.4995,0.2435,0.357,3
I,0.62,0.49,0.16,1.066,0.446,0.246,0.305,3
F,0.62,0.48,0.18,1.2215,0.582,0.2695,0.313,3
I,0.62,0.47,0.14,0.8565,0.3595,0.16,0.295,2
I,0.62,0.45,0.135,0.924,0.358,0.2265,0.2965,2
M,0.62,0.48,0.15,1.266,0.6285,0.2575,0.309,3
F,0.62,0.48,0.175,1.0405,0.464,0.2225,0.3,2
M,0.625,0.49,0.165,1.1165,0.4895,0.2615,0.3325,3
M,0.625,0.475,0.16,1.0845,0.5005,0.2355,0.3105,2
M,0.625,0.5,0.17,1.0985,0.4645,0.22,0.354,2
I,0.625,0.47,0.155,1.1955,0.643,0.2055,0.3145,3
F,0.625,0.485,0.175,1.362,0.6765,0.2615,0.3705,2
I,0.625,0.485,0.15,1.044,0.438,0.2865,0.278,2
M,0.63,0.505,0.17,1.0915,0.4615,0.266,0.3,2
F,0.63,0.5,0.18,1.1965,0.514,0.2325,0.3995,1
M,0.63,0.49,0.17,1.1745,0.5255,0.273,0.339,3
M,0.63,0.485,0.165,1.233,0.6565,0.2315,0.3035,2
M,0.63,0.495,0.175,1.2695,0.605,0.271,0.328,3
I,0.635,0.5,0.165,1.489,0.715,0.3445,0.3615,3
M,0.635,0.5,0.17,1.4345,0.611,0.309,0.418,3
F,0.635,0.49,0.175,1.2435,0.5805,0.313,0.305,2
F,0.635,0.49,0.17,1.2615,0.5385,0.2665,0.38,2
F,0.64,0.505,0.165,1.2235,0.5215,0.2695,0.36,2
M,0.64,0.515,0.18,1.247,0.5475,0.2925,0.3685,2
M,0.64,0.525,0.185,1.707,0.763,0.4205,0.4435,3
M,0.645,0.505,0.15,1.1605,0.519,0.2615,0.335,2
M,0.645,0.5,0.175,1.286,0.5645,0.288,0.386,3
M,0.645,0.5,0.19,1.5595,0.741,0.3715,0.3845,3
M,0.645,0.51,0.19,1.4745,0.605,0.345,0.48,2
M,0.645,0.51,0.195,1.226,0.5885,0.2215,0.3745,2
M,0.645,0.51,0.16,1.33,0.6665,0.309,0.317,2
F,0.645,0.51,0.16,1.2415,0.5815,0.276,0.315,2
M,0.645,0.5,0.175,1.3375,0.554,0.308,0.415,2
F,0.645,0.51,0.19,1.363,0.573,0.362,0.36,2
M,0.645,0.485,0.15,1.2215,0.5695,0.2735,0.33,2
F,0.645,0.48,0.19,1.371,0.6925,0.2905,0.35,3
F,0.65,0.495,0.155,1.337,0.615,0.3195,0.335,2
M,0.65,0.505,0.19,1.274,0.59,0.23,0.391,3
M,0.65,0.525,0.185,1.488,0.665,0.337,0.378,3
M,0.65,0.51,0.16,1.3835,0.6385,0.2905,0.3665,2
M,0.655,0.55,0.18,1.274,0.586,0.281,0.365,2
F,0.655,0.51,0.15,1.043,0.4795,0.223,0.305,2
F,0.655,0.505,0.19,1.3485,0.5935,0.2745,0.425,3
F,0.655,0.505,0.195,1.4405,0.688,0.3805,0.363,3
M,0.66,0.5,0.165,1.3195,0.667,0.269,0.341,2
F,0.66,0.535,0.175,1.5175,0.711,0.3125,0.415,3
M,0.66,0.53,0.195,1.5505,0.6505,0.3295,0.495,2
M,0.66,0.51,0.165,1.6375,0.7685,0.3545,0.3925,3
M,0.665,0.525,0.175,1.443,0.6635,0.3845,0.353,3
M,0.665,0.505,0.16,1.289,0.6145,0.253,0.3665,3
F,0.665,0.505,0.16,1.2915,0.631,0.2925,0.32,3
M,0.665,0.52,0.175,1.3725,0.606,0.32,0.395,3
M,0.665,0.5,0.175,1.2975,0.6075,0.314,0.315,2
M,0.67,0.505,0.16,1.2585,0.6255,0.311,0.308,3
M,0.67,0.52,0.165,1.39,0.711,0.2865,0.3,3
F,0.67,0.52,0.19,1.32,0.5235,0.3095,0.4275,3
F,0.67,0.55,0.155,1.566,0.858,0.339,0.354,2
F,0.67,0.54,0.195,1.619,0.74,0.3305,0.465,3
M,0.675,0.525,0.16,1.2835,0.572,0.2755,0.3545,3
F,0.675,0.51,0.195,1.382,0.6045,0.3175,0.3965,2
M,0.68,0.52,0.195,1.4535,0.592,0.391,0.4125,2
F,0.68,0.51,0.2,1.6075,0.714,0.339,0.4705,3
M,0.685,0.52,0.15,1.3735,0.7185,0.293,0.32,3
F,0.685,0.565,0.175,1.638,0.7775,0.375,0.438,3
F,0.69,0.55,0.2,1.569,0.687,0.3675,0.46,3
M,0.7,0.565,0.175,1.8565,0.8445,0.3935,0.54,2
F,0.7,0.535,0.175,1.773,0.6805,0.48,0.512,3
F,0.705,0.545,0.17,1.58,0.6435,0.4565,0.265,3
M,0.71,0.575,0.215,2.009,0.9895,0.4475,0.502,3
F,0.71,0.57,0.195,1.9805,0.9925,0.4925,0.48,3
F,0.71,0.54,0.205,1.5805,0.802,0.287,0.435,2
M,0.71,0.56,0.22,2.015,0.9215,0.454,0.566,3
M,0.72,0.57,0.2,1.8275,0.919,0.366,0.485,2
M,0.72,0.55,0.205,2.125,1.1455,0.4425,0.511,3
F,0.72,0.525,0.18,1.445,0.631,0.3215,0.435,1
F,0.725,0.565,0.21,2.1425,1.03,0.487,0.503,3
F,0.73,0.56,0.19,1.9425,0.799,0.5195,0.5655,3
M,0.735,0.59,0.215,1.747,0.7275,0.403,0.557,3
F,0.74,0.565,0.205,2.119,0.9655,0.5185,0.482,3
F,0.75,0.565,0.215,1.938,0.7735,0.4825,0.575,3
M,0.75,0.595,0.205,2.2205,1.083,0.421,0.63,3
M,0.77,0.62,0.195,2.5155,1.1155,0.6415,0.642,3
M,0.775,0.63,0.25,2.7795,1.3485,0.76,0.578,3
I,0.275,0.175,0.09,0.2315,0.096,0.057,0.0705,1
I,0.375,0.245,0.1,0.394,0.166,0.091,0.1125,1
F,0.375,0.27,0.135,0.597,0.272,0.131,0.1675,1
M,0.39,0.28,0.125,0.564,0.3035,0.0955,0.143,1
I,0.435,0.3,0.12,0.5965,0.259,0.139,0.1645,1
M,0.445,0.32,0.12,0.414,0.199,0.09,0.117,1
I,0.455,0.335,0.105,0.422,0.229,0.0865,0.1,1
I,0.455,0.325,0.135,0.82,0.4005,0.1715,0.211,1
I,0.455,0.345,0.11,0.434,0.207,0.0855,0.1215,1
I,0.465,0.325,0.14,0.7615,0.362,0.1535,0.209,2
M,0.465,0.36,0.115,0.5795,0.295,0.1395,0.12,1
I,0.485,0.365,0.105,0.5205,0.195,0.123,0.182,1
M,0.485,0.37,0.155,0.968,0.419,0.2455,0.2365,2
I,0.485,0.345,0.16,0.869,0.3085,0.185,0.319,2
F,0.49,0.355,0.16,0.8795,0.3485,0.215,0.2825,1
M,0.5,0.37,0.15,1.0615,0.494,0.223,0.296,2
M,0.515,0.35,0.155,0.9225,0.4185,0.198,0.273,2
M,0.515,0.395,0.135,1.007,0.472,0.2495,0.252,1
M,0.525,0.365,0.17,0.9605,0.438,0.2225,0.276,2
M,0.525,0.38,0.125,0.65,0.303,0.155,0.159,1
M,0.53,0.41,0.14,0.7545,0.3495,0.1715,0.2105,1
F,0.535,0.425,0.135,0.771,0.3765,0.1815,0.1795,1
I,0.535,0.385,0.18,1.0835,0.4955,0.2295,0.304,1
I,0.545,0.42,0.165,0.8935,0.4235,0.2195,0.228,1
F,0.545,0.415,0.2,1.358,0.567,0.318,0.403,2
F,0.545,0.385,0.15,1.1185,0.5425,0.2445,0.2845,2
F,0.55,0.38,0.165,1.205,0.543,0.294,0.3345,2
M,0.55,0.42,0.16,1.3405,0.6325,0.311,0.344,2
M,0.57,0.455,0.175,1.02,0.4805,0.2145,0.29,2
M,0.575,0.44,0.185,1.025,0.5075,0.2245,0.2485,2
I,0.575,0.45,0.13,0.8145,0.403,0.1715,0.213,2
F,0.58,0.43,0.17,1.48,0.6535,0.324,0.4155,2
M,0.585,0.455,0.145,0.953,0.3945,0.2685,0.258,2
I,0.585,0.45,0.15,0.8915,0.3975,0.2035,0.253,1
M,0.6,0.495,0.175,1.3005,0.6195,0.284,0.3285,3
M,0.6,0.465,0.165,1.038,0.4975,0.2205,0.251,2
M,0.605,0.475,0.175,1.2525,0.5575,0.3055,0.343,2
M,0.605,0.475,0.15,1.15,0.575,0.232,0.297,2
F,0.61,0.475,0.15,1.1135,0.5195,0.2575,0.3005,3
F,0.615,0.455,0.145,1.1155,0.5045,0.238,0.315,2
M,0.62,0.47,0.145,1.0865,0.511,0.2715,0.2565,2
M,0.625,0.495,0.175,1.254,0.5815,0.286,0.3185,2
M,0.625,0.49,0.185,1.169,0.5275,0.2535,0.344,3
M,0.635,0.495,0.195,1.172,0.445,0.3115,0.3475,3
F,0.635,0.475,0.15,1.1845,0.533,0.307,0.291,2
F,0.64,0.475,0.14,1.0725,0.4895,0.2295,0.31,1
M,0.645,0.5,0.16,1.3815,0.672,0.326,0.315,2
M,0.65,0.525,0.19,1.6125,0.777,0.3685,0.3965,3
M,0.65,0.485,0.16,1.7395,0.5715,0.2785,0.3075,2
F,0.655,0.52,0.2,1.5475,0.713,0.314,0.466,2
M,0.655,0.545,0.19,1.4245,0.6325,0.333,0.378,2
F,0.665,0.515,0.185,1.3405,0.5595,0.293,0.4375,3
F,0.675,0.53,0.175,1.4465,0.6775,0.33,0.389,2
F,0.685,0.535,0.175,1.5845,0.7175,0.3775,0.4215,2
F,0.695,0.55,0.185,1.679,0.805,0.4015,0.3965,2
M,0.695,0.53,0.19,1.726,0.7625,0.436,0.455,3
F,0.705,0.545,0.18,1.5395,0.6075,0.3675,0.4645,3
F,0.72,0.55,0.195,2.073,1.0715,0.4265,0.5015,2
M,0.72,0.56,0.18,1.5865,0.691,0.375,0.4425,3
M,0.73,0.575,0.21,2.069,0.9285,0.409,0.643,3
I,0.185,0.135,0.04,0.027,0.0105,0.0055,0.009,1
I,0.24,0.18,0.055,0.0555,0.0235,0.013,0.018,1
I,0.31,0.215,0.075,0.1275,0.0565,0.0275,0.036,1
I,0.34,0.26,0.085,0.1885,0.0815,0.0335,0.06,1
I,0.35,0.265,0.08,0.2,0.09,0.042,0.06,1
I,0.365,0.27,0.085,0.197,0.0815,0.0325,0.065,1
I,0.365,0.275,0.085,0.223,0.098,0.0375,0.075,1
I,0.365,0.27,0.075,0.2215,0.095,0.0445,0.07,1
I,0.39,0.31,0.105,0.2665,0.1185,0.0525,0.081,1
I,0.405,0.3,0.09,0.269,0.103,0.067,0.11,1
I,0.41,0.315,0.095,0.2805,0.114,0.0345,0.11,1
I,0.41,0.335,0.105,0.3305,0.1405,0.064,0.105,1
I,0.415,0.31,0.09,0.2815,0.1245,0.0615,0.085,1
I,0.415,0.31,0.1,0.2805,0.114,0.0565,0.0975,1
I,0.415,0.31,0.095,0.311,0.1125,0.0625,0.115,1
I,0.42,0.325,0.1,0.368,0.1675,0.0625,0.1135,3
I,0.43,0.34,0.1,0.3405,0.1395,0.0665,0.12,1
I,0.435,0.335,0.1,0.3245,0.135,0.0785,0.098,1
I,0.435,0.33,0.11,0.38,0.1515,0.0945,0.11,1
I,0.435,0.33,0.105,0.335,0.156,0.0555,0.105,1
I,0.435,0.345,0.12,0.3215,0.13,0.056,0.1185,1
I,0.445,0.33,0.11,0.358,0.1525,0.067,0.1185,1
I,0.465,0.37,0.11,0.445,0.1635,0.096,0.166,1
I,0.47,0.375,0.12,0.487,0.196,0.099,0.135,1
I,0.475,0.34,0.105,0.4535,0.203,0.08,0.1465,2
I,0.485,0.385,0.13,0.568,0.2505,0.178,0.154,1
I,0.485,0.36,0.12,0.5155,0.2465,0.1025,0.147,1
I,0.485,0.37,0.115,0.457,0.1885,0.0965,0.15,2
I,0.495,0.38,0.135,0.5095,0.2065,0.1165,0.165,1
I,0.495,0.38,0.145,0.5,0.205,0.148,0.1505,1
I,0.495,0.375,0.14,0.494,0.181,0.0975,0.191,1
I,0.5,0.38,0.11,0.5605,0.28,0.106,0.15,2
I,0.505,0.405,0.13,0.599,0.2245,0.1175,0.225,3
I,0.505,0.4,0.145,0.7045,0.334,0.1425,0.207,1
F,0.51,0.4,0.12,0.7005,0.347,0.1105,0.195,2
I,0.515,0.415,0.135,0.7125,0.285,0.152,0.245,2
I,0.515,0.42,0.15,0.6725,0.2555,0.1335,0.235,2
M,0.515,0.385,0.11,0.5785,0.253,0.16,0.14,1
I,0.52,0.41,0.11,0.5185,0.2165,0.0915,0.184,1
I,0.52,0.415,0.14,0.6375,0.308,0.1335,0.168,2
I,0.52,0.395,0.125,0.5805,0.2445,0.146,0.165,2
I,0.52,0.38,0.115,0.6645,0.3285,0.17,0.1425,1
I,0.52,0.385,0.115,0.581,0.2555,0.156,0.143,2
I,0.525,0.415,0.12,0.596,0.2805,0.12,0.1695,2
I,0.525,0.405,0.145,0.6965,0.3045,0.1535,0.21,1
I,0.525,0.4,0.145,0.6095,0.248,0.159,0.175,2
I,0.53,0.43,0.14,0.677,0.298,0.0965,0.23,1
I,0.53,0.43,0.16,0.7245,0.321,0.1275,0.24,2
I,0.53,0.395,0.13,0.575,0.247,0.115,0.183,2
I,0.53,0.405,0.12,0.632,0.2715,0.148,0.1875,2
I,0.535,0.455,0.14,1.0015,0.53,0.1765,0.244,2
F,0.54,0.425,0.16,0.9455,0.3675,0.2005,0.295,2
I,0.54,0.395,0.135,0.6555,0.2705,0.155,0.192,2
I,0.54,0.39,0.125,0.6255,0.2525,0.158,0.19,1
I,0.545,0.425,0.14,0.8145,0.305,0.231,0.244,2
I,0.545,0.43,0.14,0.687,0.2615,0.1405,0.25,2
I,0.55,0.435,0.14,0.7995,0.295,0.1905,0.238,2
I,0.55,0.45,0.13,0.804,0.3375,0.1405,0.23,1
M,0.555,0.435,0.14,0.7495,0.341,0.1645,0.214,1
M,0.555,0.41,0.125,0.599,0.2345,0.1465,0.194,1
M,0.555,0.4,0.13,0.7075,0.332,0.1585,0.18,1
I,0.555,0.45,0.175,0.738,0.304,0.1755,0.22,2
M,0.555,0.455,0.135,0.837,0.382,0.171,0.235,2
I,0.56,0.445,0.165,0.832,0.3455,0.179,0.279,2
F,0.565,0.445,0.125,0.8305,0.3135,0.1785,0.23,3
M,0.565,0.415,0.125,0.667,0.302,0.1545,0.185,1
M,0.565,0.455,0.155,0.9355,0.421,0.183,0.26,3
I,0.565,0.435,0.145,0.8445,0.3975,0.158,0.255,2
M,0.565,0.45,0.16,0.895,0.415,0.195,0.246,2
I,0.565,0.46,0.155,0.8715,0.3755,0.215,0.25,2
M,0.57,0.46,0.155,1.0005,0.454,0.205,0.265,3
M,0.57,0.455,0.155,0.832,0.3585,0.174,0.277,3
M,0.57,0.44,0.175,0.9415,0.3805,0.2285,0.283,2
M,0.57,0.415,0.13,0.88,0.4275,0.1955,0.238,3
F,0.57,0.44,0.12,0.803,0.382,0.1525,0.234,2
M,0.575,0.45,0.13,0.785,0.318,0.193,0.2265,2
M,0.575,0.45,0.155,0.9765,0.495,0.2145,0.235,2
M,0.575,0.435,0.135,0.992,0.432,0.2225,0.239,2
M,0.575,0.455,0.155,1.013,0.4685,0.2085,0.295,3
M,0.575,0.445,0.145,0.876,0.3795,0.1615,0.27,2
F,0.575,0.465,0.175,1.099,0.4735,0.202,0.35,2
I,0.575,0.45,0.135,0.8715,0.45,0.162,0.225,2
I,0.575,0.45,0.135,0.8245,0.3375,0.2115,0.239,3
F,0.575,0.43,0.155,0.7955,0.3485,0.1925,0.22,2
M,0.575,0.475,0.145,0.857,0.3665,0.173,0.269,2
F,0.58,0.45,0.195,0.8265,0.4035,0.173,0.225,2
F,0.58,0.5,0.165,0.925,0.37,0.185,0.3005,2
M,0.58,0.44,0.15,1.0465,0.518,0.2185,0.2795,2
I,0.58,0.44,0.145,0.7905,0.3525,0.1645,0.242,2
M,0.58,0.44,0.16,0.8295,0.3365,0.2005,0.2485,2
M,0.595,0.455,0.15,0.886,0.4315,0.201,0.223,2
F,0.6,0.47,0.135,0.97,0.4655,0.1955,0.264,3
M,0.6,0.46,0.17,1.1805,0.456,0.337,0.329,3
M,0.6,0.475,0.15,0.99,0.386,0.2195,0.3105,2
F,0.6,0.465,0.16,1.133,0.466,0.2885,0.298,3
I,0.605,0.49,0.165,1.071,0.482,0.1935,0.352,2
F,0.605,0.455,0.145,0.862,0.334,0.1985,0.3,2
M,0.605,0.47,0.18,1.1155,0.479,0.2565,0.321,2
M,0.61,0.48,0.14,1.031,0.4375,0.2615,0.27,1
F,0.61,0.46,0.145,1.1185,0.478,0.2945,0.2985,2
F,0.61,0.46,0.155,0.957,0.4255,0.1975,0.265,1
F,0.61,0.47,0.165,1.1785,0.566,0.2785,0.294,3
M,0.615,0.47,0.145,1.0285,0.4435,0.2825,0.285,3
M,0.615,0.47,0.15,1.0875,0.4975,0.283,0.2685,2
F,0.615,0.495,0.16,1.255,0.5815,0.3195,0.3225,3
M,0.615,0.495,0.2,1.219,0.564,0.227,0.3885,2
M,0.62,0.49,0.16,1.035,0.44,0.2525,0.285,3
M,0.62,0.49,0.15,1.195,0.4605,0.302,0.355,2
F,0.62,0.495,0.17,1.062,0.372,0.213,0.34,3
M,0.62,0.495,0.195,1.5145,0.579,0.346,0.5195,3
M,0.62,0.47,0.15,1.309,0.587,0.4405,0.325,2
M,0.62,0.485,0.155,1.0295,0.425,0.2315,0.335,3
M,0.625,0.495,0.155,1.0485,0.487,0.212,0.3215,3
M,0.625,0.515,0.17,1.331,0.5725,0.3005,0.361,2
M,0.625,0.505,0.185,1.1565,0.52,0.2405,0.3535,2
F,0.625,0.445,0.16,1.09,0.46,0.2965,0.304,3
F,0.625,0.52,0.18,1.354,0.4845,0.351,0.375,3
F,0.625,0.47,0.145,0.984,0.475,0.2,0.265,3
M,0.63,0.49,0.155,1.2525,0.63,0.246,0.289,2
F,0.635,0.485,0.165,1.2695,0.5635,0.3065,0.3395,3
F,0.635,0.52,0.165,1.3405,0.5065,0.296,0.412,3
F,0.635,0.505,0.155,1.2895,0.594,0.314,0.345,3
M,0.635,0.525,0.16,1.195,0.5435,0.246,0.335,3
M,0.635,0.5,0.165,1.273,0.6535,0.213,0.365,3
M,0.635,0.515,0.165,1.229,0.5055,0.2975,0.3535,2
M,0.64,0.53,0.165,1.1895,0.4765,0.3,0.35,3
F,0.64,0.48,0.145,1.1145,0.508,0.24,0.34,2
F,0.64,0.515,0.165,1.3115,0.4945,0.2555,0.41,2
I,0.64,0.49,0.135,1.1,0.488,0.2505,0.2925,2
M,0.64,0.49,0.155,1.1285,0.477,0.269,0.34,2
F,0.64,0.485,0.185,1.4195,0.6735,0.3465,0.3255,3
F,0.645,0.51,0.18,1.6195,0.7815,0.322,0.4675,3
M,0.645,0.49,0.175,1.32,0.6525,0.2375,0.3385,3
F,0.645,0.52,0.21,1.5535,0.616,0.3655,0.474,3
I,0.65,0.52,0.15,1.238,0.5495,0.296,0.3305,2
F,0.65,0.51,0.155,1.189,0.483,0.278,0.3645,3
F,0.65,0.51,0.185,1.375,0.531,0.384,0.3985,2
F,0.655,0.515,0.18,1.412,0.6195,0.2485,0.497,3
F,0.655,0.525,0.175,1.348,0.5855,0.2605,0.394,2
M,0.655,0.52,0.17,1.1445,0.53,0.223,0.348,2
F,0.66,0.535,0.205,1.4415,0.5925,0.2775,0.49,2
M,0.66,0.51,0.175,1.218,0.5055,0.303,0.37,3
F,0.665,0.5,0.15,1.2475,0.4625,0.2955,0.3595,2
M,0.665,0.515,0.2,1.2695,0.5115,0.2675,0.436,3
M,0.665,0.525,0.18,1.429,0.6715,0.29,0.4,3
F,0.67,0.53,0.205,1.4015,0.643,0.2465,0.416,3
M,0.675,0.515,0.15,1.312,0.556,0.2845,0.4115,3
F,0.675,0.51,0.185,1.473,0.6295,0.3025,0.4245,3
M,0.68,0.54,0.19,1.623,0.7165,0.354,0.4715,3
M,0.68,0.54,0.155,1.534,0.671,0.379,0.384,2
M,0.685,0.535,0.155,1.3845,0.6615,0.2145,0.4075,2
M,0.69,0.55,0.18,1.6915,0.6655,0.402,0.5,3
M,0.695,0.545,0.185,1.5715,0.6645,0.3835,0.4505,3
F,0.7,0.575,0.205,1.773,0.605,0.447,0.538,3
M,0.7,0.55,0.175,1.4405,0.6565,0.2985,0.375,3
M,0.7,0.55,0.195,1.6245,0.675,0.347,0.535,3
F,0.705,0.535,0.22,1.866,0.929,0.3835,0.4395,2
F,0.72,0.575,0.18,1.6705,0.732,0.3605,0.501,3
M,0.72,0.565,0.19,2.081,1.0815,0.4305,0.503,3
F,0.725,0.57,0.205,1.6195,0.744,0.315,0.488,3
F,0.75,0.55,0.195,1.8325,0.83,0.366,0.44,3
M,0.76,0.605,0.215,2.173,0.801,0.4915,0.646,3
I,0.135,0.13,0.04,0.029,0.0125,0.0065,0.008,1
I,0.16,0.11,0.025,0.0195,0.0075,0.005,0.006,1
I,0.21,0.15,0.055,0.0465,0.017,0.012,0.015,1
I,0.28,0.21,0.075,0.1195,0.053,0.0265,0.03,1
I,0.28,0.2,0.065,0.0895,0.036,0.0185,0.03,1
I,0.285,0.215,0.06,0.0935,0.031,0.023,0.03,1
I,0.29,0.21,0.07,0.1115,0.048,0.0205,0.03,1
I,0.29,0.21,0.06,0.1195,0.056,0.0235,0.03,1
I,0.29,0.21,0.065,0.097,0.0375,0.022,0.03,1
I,0.32,0.24,0.07,0.133,0.0585,0.0255,0.041,1
I,0.325,0.25,0.07,0.1745,0.0875,0.0355,0.04,1
I,0.335,0.25,0.08,0.1695,0.0695,0.044,0.0495,1
I,0.35,0.235,0.08,0.17,0.0725,0.0465,0.0495,1
I,0.35,0.25,0.07,0.1605,0.0715,0.0335,0.046,1
I,0.355,0.27,0.105,0.271,0.1425,0.0525,0.0735,2
I,0.36,0.27,0.085,0.2185,0.1065,0.038,0.062,1
I,0.36,0.27,0.085,0.196,0.0905,0.034,0.053,1
I,0.375,0.28,0.08,0.226,0.105,0.047,0.065,1
I,0.375,0.275,0.085,0.22,0.109,0.05,0.0605,1
I,0.395,0.29,0.095,0.3,0.158,0.068,0.078,1
I,0.405,0.25,0.09,0.2875,0.128,0.063,0.0805,1
I,0.415,0.325,0.11,0.316,0.1385,0.0795,0.0925,1
I,0.425,0.315,0.095,0.3675,0.1865,0.0675,0.0985,1
I,0.43,0.32,0.11,0.3675,0.1675,0.102,0.105,1
I,0.435,0.325,0.12,0.346,0.159,0.084,0.095,1
M,0.45,0.33,0.105,0.4955,0.2575,0.082,0.129,1
I,0.46,0.35,0.11,0.4675,0.2125,0.099,0.1375,1
M,0.47,0.365,0.135,0.522,0.2395,0.1525,0.145,2
I,0.47,0.375,0.105,0.441,0.167,0.0865,0.145,2
I,0.475,0.365,0.12,0.5185,0.268,0.1095,0.1365,1
M,0.505,0.39,0.12,0.653,0.3315,0.1385,0.167,2
M,0.505,0.395,0.135,0.5915,0.288,0.1315,0.185,3
M,0.505,0.385,0.115,0.4825,0.21,0.1035,0.1535,2
I,0.51,0.455,0.135,0.6855,0.2875,0.154,0.2035,2
M,0.515,0.4,0.14,0.6335,0.288,0.145,0.168,2
M,0.525,0.41,0.13,0.6875,0.3435,0.1495,0.1765,2
F,0.53,0.43,0.15,0.741,0.325,0.1855,0.196,2
F,0.53,0.405,0.13,0.6355,0.2635,0.1565,0.185,2
M,0.545,0.44,0.14,0.8395,0.356,0.1905,0.2385,3
F,0.55,0.47,0.15,0.9205,0.381,0.2435,0.2675,2
F,0.56,0.41,0.16,0.8215,0.342,0.184,0.253,2
M,0.565,0.445,0.145,0.9255,0.4345,0.212,0.2475,2
F,0.57,0.435,0.15,0.8295,0.3875,0.156,0.245,2
M,0.58,0.46,0.16,1.063,0.513,0.2705,0.2625,2
M,0.59,0.465,0.165,1.115,0.5165,0.273,0.275,2
F,0.6,0.45,0.14,0.837,0.37,0.177,0.2425,2
M,0.605,0.445,0.14,0.982,0.4295,0.2085,0.295,3
M,0.61,0.49,0.16,1.112,0.465,0.228,0.341,2
F,0.625,0.515,0.18,1.3485,0.5255,0.252,0.3925,3
M,0.66,0.515,0.195,1.5655,0.7345,0.353,0.386,2
I,0.255,0.19,0.06,0.086,0.04,0.0185,0.025,1
I,0.27,0.195,0.065,0.1065,0.0475,0.0225,0.0285,1
I,0.28,0.215,0.08,0.132,0.072,0.022,0.033,1
I,0.285,0.215,0.07,0.1075,0.051,0.0225,0.027,1
I,0.32,0.255,0.085,0.1745,0.072,0.033,0.057,1
I,0.325,0.24,0.07,0.152,0.0565,0.0305,0.054,1
I,0.385,0.28,0.1,0.2755,0.1305,0.061,0.0725,1
I,0.395,0.295,0.1,0.293,0.14,0.062,0.082,1
F,0.4,0.305,0.16,0.368,0.173,0.0705,0.105,1
I,0.405,0.31,0.09,0.312,0.138,0.06,0.087,1
I,0.415,0.305,0.12,0.336,0.165,0.076,0.0805,1
I,0.42,0.315,0.115,0.355,0.1895,0.065,0.087,1
I,0.44,0.305,0.115,0.379,0.162,0.091,0.11,2
I,0.445,0.32,0.12,0.378,0.152,0.0825,0.12,1
M,0.45,0.35,0.13,0.4655,0.2075,0.1045,0.135,1
F,0.455,0.355,1.13,0.594,0.332,0.116,0.1335,1
M,0.46,0.345,0.12,0.4935,0.2435,0.1175,0.132,1
M,0.46,0.345,0.11,0.4595,0.235,0.0885,0.116,1
M,0.465,0.36,0.11,0.4955,0.2665,0.085,0.121,1
I,0.465,0.355,0.09,0.4325,0.2005,0.074,0.1275,2
F,0.475,0.38,0.14,0.689,0.3165,0.1315,0.1955,1
I,0.48,0.35,0.135,0.5465,0.2735,0.0995,0.158,1
M,0.485,0.39,0.135,0.617,0.25,0.1345,0.1635,1
I,0.49,0.37,0.11,0.538,0.271,0.1035,0.139,1
M,0.5,0.39,0.135,0.7815,0.361,0.1575,0.2385,2
F,0.5,0.38,0.14,0.6355,0.277,0.143,0.1785,1
M,0.505,0.385,0.13,0.6435,0.3135,0.149,0.1515,1
M,0.525,0.385,0.1,0.5115,0.246,0.1005,0.1455,1
M,0.535,0.42,0.125,0.738,0.355,0.1895,0.1795,1
F,0.535,0.42,0.13,0.699,0.3125,0.1565,0.2035,1
F,0.54,0.385,0.14,0.7655,0.3265,0.116,0.2365,2
F,0.54,0.42,0.13,0.7505,0.368,0.1675,0.1845,2
F,0.545,0.43,0.16,0.844,0.3945,0.1855,0.231,2
M,0.55,0.41,0.13,0.8705,0.4455,0.2115,0.213,2
I,0.55,0.42,0.115,0.668,0.2925,0.137,0.209,3
F,0.565,0.44,0.135,0.83,0.393,0.1735,0.238,2
M,0.58,0.45,0.12,0.8685,0.418,0.1475,0.2605,1
F,0.58,0.435,0.15,0.839,0.3485,0.207,0.192,1
F,0.585,0.485,0.15,1.079,0.4145,0.2115,0.356,3
M,0.595,0.465,0.15,0.919,0.4335,0.1765,0.262,2
F,0.6,0.47,0.19,1.1345,0.492,0.2595,0.3375,2
F,0.61,0.43,0.14,0.909,0.438,0.2,0.22,1
M,0.61,0.48,0.165,1.2435,0.5575,0.2675,0.372,1
F,0.62,0.49,0.16,1.056,0.493,0.244,0.2725,2
M,0.645,0.495,0.15,1.2095,0.603,0.2225,0.339,2
M,0.65,0.5,0.14,1.238,0.6165,0.2355,0.32,1
F,0.665,0.525,0.21,1.644,0.818,0.3395,0.4275,2
M,0.685,0.55,0.2,1.7725,0.813,0.387,0.49,3
F,0.69,0.54,0.195,1.2525,0.73,0.3975,0.462,3
F,0.705,0.57,0.185,1.761,0.747,0.3725,0.488,2
F,0.71,0.5,0.15,1.3165,0.6835,0.2815,0.28,2
M,0.72,0.585,0.22,1.914,0.9155,0.448,0.479,3
F,0.72,0.575,0.215,2.1,0.8565,0.4825,0.602,3
F,0.73,0.555,0.18,1.6895,0.6555,0.1965,0.4935,2
M,0.775,0.57,0.22,2.032,0.735,0.4755,0.6585,3
F,0.505,0.39,0.115,0.66,0.3045,0.1555,0.175,1
M,0.53,0.425,0.13,0.7455,0.2995,0.1355,0.245,2
F,0.505,0.385,0.115,0.616,0.243,0.1075,0.21,3
I,0.405,0.305,0.09,0.2825,0.114,0.0575,0.095,1
M,0.415,0.3,0.1,0.3355,0.1545,0.0685,0.095,1
M,0.5,0.39,0.145,0.651,0.273,0.132,0.22,3
M,0.425,0.33,0.08,0.361,0.134,0.0825,0.125,1
M,0.47,0.35,0.1,0.4775,0.1885,0.0885,0.175,1
F,0.4,0.31,0.115,0.3465,0.1475,0.0695,0.115,2
I,0.37,0.29,0.1,0.25,0.1025,0.0505,0.085,2
M,0.5,0.38,0.155,0.66,0.2655,0.1365,0.215,3
I,0.41,0.31,0.11,0.315,0.124,0.082,0.095,2
M,0.375,0.29,0.1,0.276,0.1175,0.0565,0.085,2
F,0.49,0.385,0.125,0.5395,0.2175,0.128,0.165,3
M,0.585,0.48,0.185,1.04,0.434,0.265,0.285,2
M,0.595,0.455,0.155,1.041,0.416,0.2105,0.365,3
F,0.675,0.55,0.18,1.6885,0.562,0.3705,0.6,3
M,0.665,0.535,0.225,2.1835,0.7535,0.391,0.885,3
M,0.62,0.49,0.17,1.2105,0.5185,0.2555,0.335,3
I,0.325,0.25,0.055,0.166,0.076,0.051,0.045,1
I,0.455,0.355,0.08,0.452,0.2165,0.0995,0.125,2
M,0.525,0.405,0.13,0.7185,0.3265,0.1975,0.175,1
I,0.385,0.29,0.09,0.232,0.0855,0.0495,0.08,1
I,0.13,0.095,0.035,0.0105,0.005,0.0065,0.0035,1
I,0.18,0.13,0.045,0.0275,0.0125,0.01,0.009,1
I,0.31,0.225,0.05,0.1445,0.0675,0.0385,0.045,1
F,0.375,0.29,0.08,0.282,0.1405,0.0725,0.08,1
F,0.48,0.38,0.12,0.608,0.2705,0.1405,0.185,1
I,0.455,0.37,0.125,0.433,0.201,0.1265,0.145,2
M,0.425,0.325,0.1,0.3295,0.1365,0.0725,0.11,1
I,0.475,0.36,0.11,0.4555,0.177,0.0965,0.145,2
F,0.435,0.35,0.12,0.4585,0.192,0.1,0.13,3
F,0.29,0.21,0.075,0.275,0.113,0.0675,0.035,1
M,0.385,0.295,0.095,0.335,0.147,0.094,0.09,1
M,0.47,0.375,0.115,0.4265,0.1685,0.0755,0.15,1
F,0.5,0.4,0.125,0.5765,0.2395,0.126,0.185,2
I,0.4,0.31,0.1,0.127,0.106,0.071,0.085,1
M,0.62,0.51,0.175,1.1505,0.4375,0.2265,0.4,3
M,0.595,0.47,0.15,0.8915,0.359,0.2105,0.245,3
M,0.585,0.455,0.14,0.97,0.462,0.185,0.295,2
M,0.32,0.24,0.08,0.18,0.08,0.0385,0.055,1
F,0.52,0.41,0.125,0.6985,0.2945,0.1625,0.215,2
M,0.44,0.35,0.11,0.4585,0.2,0.0885,0.13,2
F,0.44,0.33,0.115,0.4005,0.143,0.113,0.12,1
M,0.565,0.425,0.1,0.7145,0.3055,0.166,0.18,3
F,0.56,0.425,0.125,0.932,0.361,0.213,0.335,2
F,0.59,0.455,0.175,0.966,0.391,0.2455,0.31,2
F,0.57,0.465,0.18,0.9995,0.405,0.277,0.295,3
M,0.68,0.53,0.205,1.496,0.5825,0.337,0.465,3
F,0.45,0.36,0.125,0.5065,0.222,0.105,0.16,2
I,0.32,0.24,0.075,0.1735,0.076,0.0355,0.05,1
I,0.46,0.35,0.11,0.3945,0.1685,0.0865,0.125,2
M,0.47,0.37,0.105,0.4665,0.2025,0.1015,0.155,2
M,0.455,0.35,0.105,0.401,0.1575,0.083,0.135,2
F,0.415,0.325,0.115,0.3455,0.1405,0.0765,0.11,2
M,0.465,0.35,0.12,0.5205,0.2015,0.1625,0.185,3
M,0.46,0.375,0.135,0.4935,0.186,0.0845,0.17,3
M,0.415,0.31,0.09,0.3245,0.1305,0.0735,0.115,1
M,0.27,0.195,0.07,0.106,0.0465,0.018,0.036,1
M,0.445,0.355,0.11,0.4415,0.1805,0.1035,0.1505,2
F,0.745,0.585,0.19,1.966,0.8435,0.437,0.5855,3
F,0.4,0.3,0.115,0.3025,0.1335,0.0465,0.0935,1
I,0.28,0.2,0.075,0.1225,0.0545,0.0115,0.035,1
M,0.55,0.44,0.135,0.879,0.368,0.2095,0.265,2
M,0.58,0.46,0.165,1.2275,0.473,0.1965,0.435,3
M,0.61,0.5,0.165,1.2715,0.4915,0.185,0.49,3
M,0.62,0.495,0.175,1.806,0.643,0.3285,0.725,3
M,0.56,0.42,0.195,0.8085,0.3025,0.1795,0.285,3
F,0.64,0.51,0.2,1.3905,0.61,0.3315,0.41,3
M,0.69,0.55,0.2,1.8465,0.732,0.472,0.57,3
F,0.715,0.565,0.24,2.1995,0.7245,0.465,0.885,3
F,0.71,0.565,0.195,1.817,0.785,0.492,0.49,3
F,0.55,0.47,0.15,0.897,0.377,0.184,0.29,2
M,0.375,0.305,0.09,0.3245,0.1395,0.0565,0.095,1
F,0.61,0.45,0.16,1.136,0.414,0.311,0.3,2
I,0.38,0.28,0.085,0.2735,0.115,0.061,0.085,1
F,0.37,0.275,0.085,0.2405,0.104,0.0535,0.07,1
M,0.335,0.235,0.085,0.1545,0.066,0.0345,0.045,1
I,0.165,0.115,0.015,0.0145,0.0055,0.003,0.005,1
M,0.285,0.21,0.075,0.1185,0.055,0.0285,0.04,1
I,0.19,0.13,0.03,0.0295,0.0155,0.015,0.01,1
I,0.215,0.15,0.03,0.0385,0.0115,0.005,0.01,1
M,0.595,0.465,0.125,0.799,0.3245,0.2,0.23,2
F,0.645,0.5,0.17,1.1845,0.4805,0.274,0.355,3
M,0.575,0.45,0.185,0.925,0.342,0.197,0.35,3
F,0.57,0.45,0.17,1.098,0.414,0.187,0.405,3
F,0.58,0.45,0.235,1.071,0.3,0.206,0.395,3
F,0.595,0.48,0.2,0.975,0.358,0.2035,0.34,3
F,0.595,0.47,0.25,1.283,0.462,0.2475,0.445,3
F,0.625,0.42,0.165,1.0595,0.358,0.165,0.445,3
M,0.535,0.42,0.165,0.9195,0.3355,0.1985,0.26,3
M,0.55,0.43,0.16,0.9295,0.317,0.1735,0.355,3
M,0.495,0.4,0.155,0.8085,0.2345,0.1155,0.35,1
I,0.32,0.235,0.08,0.1485,0.064,0.031,0.045,1
M,0.445,0.34,0.12,0.4475,0.193,0.1035,0.13,2
F,0.52,0.4,0.125,0.6865,0.295,0.1715,0.185,2
M,0.495,0.385,0.135,0.6335,0.2,0.1225,0.26,3
M,0.47,0.37,0.135,0.547,0.222,0.1325,0.17,3
F,0.49,0.37,0.14,0.585,0.243,0.115,0.195,2
M,0.58,0.47,0.165,0.927,0.3215,0.1985,0.315,3
M,0.645,0.495,0.185,1.4935,0.5265,0.2785,0.455,3
F,0.575,0.485,0.165,1.0405,0.419,0.264,0.3,3
I,0.215,0.17,0.055,0.0605,0.0205,0.014,0.02,1
I,0.43,0.325,0.11,0.3675,0.1355,0.0935,0.12,3
I,0.26,0.215,0.08,0.099,0.037,0.0255,0.045,1
I,0.37,0.28,0.09,0.233,0.0905,0.0545,0.07,3
I,0.405,0.305,0.105,0.3625,0.1565,0.0705,0.125,2
I,0.27,0.19,0.08,0.081,0.0265,0.0195,0.03,1
F,0.68,0.55,0.2,1.596,0.525,0.4075,0.585,3
F,0.65,0.515,0.195,1.4005,0.5195,0.36,0.44,3
F,0.645,0.49,0.215,1.406,0.4265,0.2285,0.51,3
M,0.57,0.405,0.16,0.9245,0.3445,0.2185,0.295,3
M,0.615,0.48,0.19,1.36,0.5305,0.2375,0.47,3
M,0.42,0.345,0.105,0.43,0.175,0.096,0.13,1
I,0.275,0.22,0.08,0.1365,0.0565,0.0285,0.042,1
F,0.29,0.225,0.075,0.14,0.0515,0.0235,0.04,1
M,0.42,0.34,0.115,0.4215,0.175,0.093,0.135,1
F,0.625,0.525,0.215,1.5765,0.5115,0.2595,0.665,3
F,0.55,0.465,0.18,1.2125,0.3245,0.205,0.525,3
M,0.66,0.505,0.2,1.6305,0.4865,0.297,0.61,3
M,0.565,0.47,0.195,1.142,0.387,0.258,0.35,3
F,0.595,0.495,0.235,1.366,0.5065,0.219,0.52,3
M,0.63,0.51,0.23,1.539,0.5635,0.2815,0.57,3
F,0.43,0.325,0.12,0.445,0.165,0.0995,0.155,1
F,0.455,0.35,0.14,0.5725,0.1965,0.1325,0.175,2
I,0.33,0.26,0.08,0.19,0.0765,0.0385,0.065,1
F,0.515,0.415,0.13,0.764,0.276,0.196,0.25,3
M,0.495,0.39,0.15,0.853,0.3285,0.189,0.27,3
F,0.485,0.375,0.145,0.5885,0.2385,0.1155,0.19,3
F,0.535,0.46,0.145,0.7875,0.3395,0.2005,0.2,1
M,0.58,0.465,0.175,1.035,0.401,0.1865,0.385,3
F,0.625,0.525,0.195,1.352,0.4505,0.2445,0.53,3
F,0.555,0.455,0.18,0.958,0.296,0.195,0.39,3
F,0.55,0.425,0.145,0.797,0.297,0.15,0.265,2
M,0.59,0.475,0.155,0.857,0.356,0.174,0.28,3
I,0.355,0.28,0.11,0.2235,0.0815,0.0525,0.08,1
I,0.275,0.2,0.075,0.086,0.0305,0.019,0.03,1
F,0.505,0.39,0.175,0.692,0.267,0.15,0.215,3
M,0.37,0.28,0.095,0.2225,0.0805,0.051,0.075,1
M,0.555,0.43,0.165,0.7575,0.2735,0.1635,0.275,3
F,0.505,0.4,0.165,0.729,0.2675,0.155,0.25,2
F,0.56,0.445,0.18,0.903,0.3575,0.2045,0.295,2
M,0.595,0.475,0.17,1.0965,0.419,0.229,0.35,3
F,0.57,0.45,0.165,0.903,0.3305,0.1845,0.295,3
M,0.6,0.48,0.175,1.229,0.4125,0.2735,0.415,3
F,0.56,0.435,0.185,1.106,0.422,0.2435,0.33,3
M,0.585,0.465,0.19,1.171,0.3905,0.2355,0.4,3
I,0.46,0.335,0.11,0.444,0.225,0.0745,0.11,1
F,0.46,0.36,0.115,0.4755,0.2105,0.105,0.16,1
M,0.415,0.315,0.125,0.388,0.068,0.09,0.125,3
F,0.435,0.32,0.12,0.3785,0.152,0.0915,0.125,3
F,0.475,0.38,0.135,0.486,0.1735,0.07,0.185,1
M,0.465,0.36,0.13,0.5265,0.2105,0.1185,0.165,2
I,0.355,0.28,0.1,0.2275,0.0935,0.0455,0.085,3
M,0.46,0.375,0.14,0.5105,0.192,0.1045,0.205,2
F,0.38,0.325,0.11,0.3105,0.12,0.074,0.105,2
F,0.47,0.365,0.12,0.543,0.2295,0.1495,0.15,2
M,0.36,0.27,0.09,0.2225,0.083,0.053,0.075,1
F,0.585,0.455,0.165,0.998,0.345,0.2495,0.315,3
M,0.655,0.59,0.2,1.5455,0.654,0.3765,0.415,3
M,0.6,0.485,0.175,1.2675,0.4995,0.2815,0.38,3
F,0.57,0.46,0.17,1.1,0.4125,0.2205,0.38,3
F,0.645,0.5,0.2,1.4285,0.639,0.305,0.36,3
M,0.65,0.495,0.18,1.793,0.8005,0.339,0.53,3
M,0.51,0.395,0.145,0.6185,0.216,0.1385,0.24,3
M,0.52,0.38,0.135,0.5825,0.2505,0.1565,0.175,1
M,0.495,0.415,0.165,0.7485,0.264,0.134,0.285,3
M,0.43,0.335,0.115,0.406,0.166,0.0935,0.135,1
F,0.59,0.465,0.16,1.1005,0.506,0.2525,0.295,3
M,0.55,0.46,0.175,0.869,0.3155,0.1825,0.32,2
M,0.585,0.43,0.16,0.955,0.3625,0.176,0.27,3
F,0.58,0.455,0.16,0.9215,0.312,0.196,0.3,3
F,0.62,0.51,0.15,1.456,0.581,0.2875,0.32,3
I,0.59,0.45,0.16,0.893,0.2745,0.2185,0.345,3
F,0.72,0.575,0.215,2.226,0.8955,0.405,0.62,3
F,0.635,0.51,0.175,1.2125,0.5735,0.261,0.36,3
F,0.61,0.48,0.175,1.0675,0.391,0.216,0.42,3
F,0.545,0.445,0.175,0.8525,0.3465,0.189,0.295,3
M,0.57,0.45,0.16,0.8615,0.3725,0.2175,0.255,3
F,0.6,0.475,0.18,1.162,0.511,0.2675,0.32,3
F,0.52,0.41,0.17,0.8705,0.3735,0.219,0.25,3
M,0.635,0.51,0.21,1.598,0.6535,0.2835,0.58,3
F,0.67,0.52,0.15,1.406,0.519,0.348,0.37,3
M,0.695,0.57,0.2,2.033,0.751,0.4255,0.685,3
M,0.655,0.525,0.185,1.259,0.487,0.2215,0.445,3
F,0.62,0.48,0.23,1.0935,0.403,0.245,0.355,3
F,0.6,0.475,0.18,1.1805,0.4345,0.2475,0.425,3
M,0.51,0.405,0.13,0.7175,0.3725,0.158,0.17,2
M,0.525,0.405,0.135,0.7575,0.3305,0.216,0.195,2
M,0.44,0.375,0.13,0.487,0.226,0.0965,0.155,2
I,0.485,0.415,0.14,0.5705,0.25,0.134,0.185,1
F,0.495,0.385,0.13,0.6905,0.3125,0.179,0.175,2
I,0.435,0.345,0.12,0.4475,0.221,0.112,0.125,1
I,0.405,0.315,0.105,0.347,0.1605,0.0785,0.1,2
I,0.42,0.33,0.1,0.352,0.1635,0.089,0.1,2
F,0.5,0.395,0.15,0.7145,0.3235,0.173,0.195,2
F,0.385,0.305,0.105,0.3315,0.1365,0.0745,0.1,1
I,0.33,0.265,0.09,0.18,0.068,0.036,0.06,1
F,0.58,0.475,0.155,0.974,0.4305,0.23,0.285,2
I,0.325,0.27,0.1,0.185,0.08,0.0435,0.065,1
M,0.475,0.375,0.12,0.563,0.2525,0.1205,0.185,2
F,0.38,0.3,0.09,0.3215,0.1545,0.075,0.095,2
I,0.34,0.26,0.09,0.179,0.076,0.0525,0.055,1
M,0.525,0.425,0.12,0.702,0.3335,0.1465,0.22,3
F,0.52,0.415,0.145,0.8045,0.3325,0.1725,0.285,2
F,0.535,0.45,0.135,0.8075,0.322,0.181,0.25,3
M,0.475,0.36,0.12,0.578,0.2825,0.12,0.17,1
I,0.415,0.325,0.1,0.385,0.167,0.08,0.125,1
I,0.495,0.385,0.125,0.585,0.2755,0.1235,0.165,1
F,0.48,0.405,0.13,0.6375,0.277,0.1445,0.21,2
F,0.52,0.425,0.15,0.813,0.385,0.2015,0.23,2
M,0.46,0.375,0.13,0.5735,0.2505,0.119,0.195,2
F,0.58,0.455,0.12,0.94,0.399,0.257,0.265,3
M,0.59,0.49,0.135,1.008,0.422,0.2245,0.285,3
F,0.55,0.415,0.135,0.775,0.302,0.179,0.26,3
F,0.65,0.5,0.165,1.1445,0.485,0.218,0.365,3
F,0.465,0.375,0.135,0.6,0.2225,0.129,0.23,3
M,0.455,0.355,0.13,0.515,0.2,0.1275,0.175,3
M,0.47,0.375,0.13,0.5795,0.2145,0.164,0.195,3
F,0.435,0.35,0.11,0.384,0.143,0.1005,0.125,3
M,0.35,0.265,0.11,0.2965,0.1365,0.063,0.085,1
I,0.315,0.24,0.07,0.137,0.0545,0.0315,0.04,1
M,0.595,0.47,0.145,0.991,0.4035,0.1505,0.34,3
F,0.58,0.475,0.135,0.925,0.391,0.165,0.275,3
M,0.575,0.435,0.15,0.805,0.293,0.1625,0.27,3
M,0.535,0.435,0.155,0.8915,0.3415,0.177,0.25,3
M,0.515,0.42,0.14,0.769,0.2505,0.154,0.29,3
F,0.505,0.385,0.135,0.6185,0.251,0.1175,0.2,3
F,0.505,0.395,0.145,0.6515,0.2695,0.153,0.205,3
I,0.4,0.31,0.1,0.2875,0.1145,0.0635,0.095,2
M,0.49,0.395,0.135,0.5545,0.213,0.0925,0.215,3
M,0.53,0.435,0.135,0.7365,0.3275,0.1315,0.22,3
I,0.395,0.325,0.105,0.306,0.111,0.0735,0.095,1
F,0.665,0.535,0.19,1.496,0.5775,0.2815,0.475,3
F,0.415,0.305,0.105,0.3605,0.12,0.082,0.1,2
M,0.43,0.345,0.115,0.3045,0.0925,0.055,0.12,3
M,0.475,0.395,0.135,0.592,0.2465,0.1645,0.2,3
F,0.525,0.425,0.145,0.7995,0.3345,0.209,0.24,3
I,0.48,0.39,0.145,0.5825,0.2315,0.121,0.255,3
I,0.42,0.345,0.115,0.3435,0.1515,0.0795,0.115,2
M,0.59,0.46,0.155,0.906,0.327,0.1485,0.335,3
F,0.515,0.42,0.135,0.6295,0.2815,0.127,0.215,2
M,0.695,0.55,0.22,1.5515,0.566,0.3835,0.445,3
F,0.8,0.63,0.195,2.526,0.933,0.59,0.62,3
M,0.61,0.49,0.15,1.103,0.425,0.2025,0.36,3
F,0.565,0.48,0.175,0.957,0.3885,0.215,0.275,3
M,0.56,0.455,0.165,0.86,0.4015,0.1695,0.245,3
M,0.655,0.485,0.195,1.62,0.6275,0.358,0.485,3
M,0.64,0.52,0.2,1.407,0.566,0.304,0.455,3
F,0.59,0.47,0.17,0.9,0.355,0.1905,0.25,3
I,0.31,0.24,0.09,0.1455,0.0605,0.0315,0.045,1
I,0.255,0.185,0.07,0.075,0.028,0.018,0.025,1
I,0.17,0.125,0.055,0.0235,0.009,0.0055,0.008,1
M,0.67,0.55,0.17,1.247,0.472,0.2455,0.4,3
F,0.71,0.565,0.195,1.7265,0.638,0.3365,0.565,3
F,0.56,0.43,0.125,0.8025,0.313,0.1715,0.263,3
M,0.505,0.4,0.13,0.764,0.3035,0.189,0.2175,3
M,0.525,0.43,0.165,0.8645,0.376,0.1945,0.2515,3
F,0.45,0.36,0.105,0.4715,0.2035,0.0935,0.149,2
F,0.515,0.435,0.17,0.631,0.2765,0.111,0.216,3
M,0.59,0.475,0.16,0.9455,0.3815,0.184,0.27,3
M,0.7,0.53,0.19,1.3185,0.548,0.233,0.42,3
F,0.72,0.56,0.175,1.7265,0.637,0.3415,0.525,3
M,0.635,0.495,0.15,1.081,0.4825,0.242,0.31,3
M,0.555,0.44,0.135,0.9025,0.3805,0.2105,0.28,3
M,0.575,0.47,0.15,1.1415,0.4515,0.204,0.4,3
M,0.585,0.455,0.125,1.027,0.391,0.212,0.25,3
F,0.61,0.485,0.21,1.3445,0.535,0.2205,0.515,3
F,0.645,0.525,0.2,1.449,0.601,0.2565,0.505,3
F,0.545,0.44,0.175,0.7745,0.2985,0.1875,0.265,3
M,0.55,0.45,0.155,0.7895,0.343,0.159,0.25,3
F,0.66,0.525,0.205,1.3665,0.5005,0.291,0.41,3
M,0.57,0.475,0.195,1.0295,0.4635,0.1905,0.305,3
F,0.6,0.47,0.2,1.031,0.392,0.2035,0.29,3
F,0.63,0.505,0.165,1.065,0.4595,0.216,0.315,3
M,0.695,0.57,0.23,1.885,0.8665,0.435,0.5,3
M,0.65,0.545,0.16,1.2425,0.487,0.296,0.48,3
F,0.72,0.595,0.225,1.969,0.8045,0.423,0.66,3
I,0.56,0.44,0.17,0.9445,0.3545,0.2175,0.3,3
I,0.42,0.325,0.115,0.354,0.1625,0.064,0.105,1
M,0.18,0.125,0.05,0.023,0.0085,0.0055,0.01,1
F,0.405,0.325,0.11,0.3575,0.145,0.0725,0.11,3
F,0.5,0.405,0.15,0.5965,0.253,0.126,0.185,3
I,0.435,0.335,0.11,0.383,0.1555,0.0675,0.135,3
M,0.34,0.275,0.09,0.2065,0.0725,0.043,0.07,2
F,0.43,0.34,0.11,0.382,0.154,0.0955,0.109,1
I,0.535,0.41,0.155,0.6315,0.2745,0.1415,0.1815,3
I,0.415,0.325,0.115,0.3285,0.1405,0.051,0.106,3
F,0.36,0.265,0.09,0.2165,0.096,0.037,0.0735,2
M,0.175,0.135,0.04,0.0305,0.011,0.0075,0.01,1
M,0.155,0.115,0.025,0.024,0.009,0.005,0.0075,1
I,0.525,0.43,0.15,0.7365,0.3225,0.161,0.215,3
F,0.525,0.39,0.135,0.6005,0.2265,0.131,0.21,3
F,0.44,0.345,0.105,0.4285,0.165,0.083,0.132,3
F,0.45,0.345,0.115,0.496,0.1905,0.117,0.14,3
F,0.485,0.365,0.14,0.6195,0.2595,0.1445,0.177,3
I,0.47,0.35,0.135,0.567,0.2315,0.1465,0.1525,3
I,0.515,0.375,0.14,0.6505,0.2495,0.141,0.2215,2
M,0.42,0.34,0.125,0.4495,0.165,0.1125,0.144,3
F,0.455,0.35,0.125,0.4485,0.1585,0.102,0.1335,3
M,0.37,0.29,0.09,0.241,0.11,0.045,0.069,2
M,0.33,0.25,0.09,0.197,0.085,0.041,0.0605,2
I,0.3,0.22,0.09,0.1425,0.057,0.0335,0.043,1
I,0.625,0.46,0.16,1.2395,0.55,0.273,0.38,3
I,0.61,0.475,0.17,1.0385,0.4435,0.241,0.32,3
I,0.625,0.465,0.155,0.972,0.404,0.1845,0.35,3
I,0.635,0.505,0.19,1.3315,0.5805,0.252,0.435,3
I,0.5,0.385,0.155,0.762,0.3795,0.161,0.19,3
F,0.53,0.43,0.17,0.775,0.35,0.152,0.235,3
I,0.445,0.33,0.1,0.437,0.163,0.0755,0.17,3
F,0.585,0.415,0.155,0.6985,0.3,0.146,0.195,3
I,0.44,0.355,0.165,0.435,0.159,0.105,0.14,3
M,0.29,0.225,0.08,0.1295,0.0535,0.026,0.045,2
I,0.555,0.455,0.17,0.8435,0.309,0.1905,0.3,3
I,0.655,0.515,0.145,1.25,0.5265,0.283,0.315,3
F,0.58,0.46,0.185,1.017,0.3515,0.2,0.32,2
I,0.625,0.43,0.175,1.411,0.572,0.297,0.395,3
I,0.62,0.485,0.17,1.208,0.4805,0.3045,0.33,3
F,0.64,0.5,0.15,1.0705,0.371,0.2705,0.36,1
F,0.505,0.375,0.115,0.5895,0.2635,0.12,0.167,2
I,0.5,0.395,0.12,0.537,0.2165,0.1085,0.1785,2
M,0.31,0.245,0.095,0.15,0.0525,0.034,0.048,1
F,0.505,0.38,0.145,0.651,0.2935,0.19,0.17,3
I,0.42,0.305,0.11,0.28,0.094,0.0785,0.0955,2
M,0.4,0.315,0.105,0.287,0.1135,0.037,0.113,2
M,0.425,0.315,0.125,0.3525,0.1135,0.0565,0.13,3
M,0.31,0.235,0.06,0.12,0.0415,0.033,0.04,3
F,0.465,0.35,0.13,0.494,0.1945,0.103,0.155,3
F,0.465,0.36,0.12,0.4765,0.192,0.1125,0.16,2
M,0.35,0.255,0.085,0.2145,0.1,0.0465,0.06,3
I,0.52,0.415,0.16,0.595,0.2105,0.142,0.26,3
F,0.475,0.365,0.13,0.4805,0.1905,0.114,0.1475,3
F,0.41,0.315,0.11,0.321,0.1255,0.0655,0.095,2
M,0.26,0.2,0.065,0.096,0.044,0.027,0.03,1
I,0.575,0.45,0.17,0.9315,0.358,0.2145,0.26,3
I,0.565,0.435,0.155,0.782,0.2715,0.168,0.285,3
M,0.26,0.19,0.075,0.0945,0.0445,0.02,0.03,1
F,0.53,0.385,0.125,0.6695,0.289,0.151,0.18,2
M,0.34,0.255,0.095,0.213,0.081,0.034,0.07,2
I,0.52,0.38,0.14,0.525,0.1775,0.115,0.185,3
F,0.635,0.5,0.18,1.312,0.529,0.2485,0.485,3
F,0.61,0.485,0.165,1.087,0.4255,0.232,0.38,3
F,0.66,0.515,0.18,1.523,0.54,0.3365,0.555,3
I,0.635,0.5,0.18,1.319,0.5485,0.292,0.49,3
F,0.465,0.38,0.135,0.579,0.208,0.1095,0.22,3
M,0.515,0.4,0.16,0.8175,0.2515,0.156,0.3,3
I,0.335,0.24,0.095,0.17,0.062,0.039,0.055,2
F,0.515,0.4,0.17,0.796,0.258,0.1755,0.28,3
F,0.345,0.255,0.1,0.197,0.071,0.051,0.06,2
M,0.465,0.355,0.125,0.5255,0.2025,0.135,0.145,3
M,0.54,0.415,0.17,0.879,0.339,0.208,0.255,2
M,0.475,0.355,0.125,0.4625,0.186,0.107,0.145,2
F,0.445,0.335,0.14,0.4565,0.1785,0.114,0.14,3
M,0.5,0.355,0.14,0.528,0.2125,0.149,0.14,2
M,0.5,0.38,0.135,0.5835,0.2295,0.1265,0.18,3
F,0.55,0.435,0.17,0.884,0.2875,0.1645,0.28,3
I,0.275,0.205,0.08,0.096,0.036,0.0185,0.03,1
F,0.35,0.265,0.09,0.1855,0.0745,0.0415,0.06,1
F,0.37,0.285,0.105,0.27,0.1125,0.0585,0.0835,2
F,0.42,0.33,0.125,0.463,0.186,0.11,0.145,2
M,0.35,0.26,0.09,0.198,0.0725,0.056,0.06,2
M,0.395,0.305,0.105,0.282,0.0975,0.065,0.096,2
I,0.325,0.2,0.08,0.0995,0.0395,0.0225,0.032,1
I,0.275,0.2,0.065,0.092,0.0385,0.0235,0.027,1
I,0.235,0.17,0.065,0.0625,0.023,0.014,0.022,1
I,0.25,0.18,0.06,0.073,0.028,0.017,0.0225,1
I,0.25,0.185,0.065,0.071,0.027,0.0185,0.0225,1
I,0.2,0.145,0.05,0.036,0.0125,0.008,0.011,1
F,0.585,0.47,0.17,1.099,0.3975,0.2325,0.358,3
M,0.445,0.35,0.14,0.5905,0.2025,0.158,0.19,3
F,0.5,0.385,0.13,0.768,0.2625,0.095,0.27,3
M,0.44,0.325,0.08,0.413,0.144,0.1015,0.13,1
M,0.515,0.405,0.14,0.8505,0.312,0.146,0.315,3
F,0.52,0.405,0.14,0.6915,0.276,0.137,0.215,3
M,0.5,0.39,0.13,0.709,0.275,0.168,0.18,3
M,0.425,0.325,0.12,0.3755,0.142,0.1065,0.105,2
M,0.51,0.415,0.14,0.8185,0.3025,0.2155,0.235,3
F,0.37,0.275,0.08,0.227,0.093,0.0625,0.07,1
M,0.54,0.415,0.13,0.8245,0.272,0.226,0.24,3
M,0.615,0.475,0.17,1.1825,0.474,0.2895,0.24,3
M,0.565,0.44,0.175,1.122,0.393,0.2,0.375,3
M,0.645,0.515,0.175,1.6115,0.6745,0.384,0.385,3
F,0.615,0.47,0.175,1.2985,0.5135,0.343,0.32,3
M,0.605,0.49,0.145,1.3,0.517,0.3285,0.31,3
F,0.59,0.455,0.165,1.161,0.38,0.2455,0.28,3
M,0.645,0.485,0.155,1.489,0.5915,0.312,0.38,3
M,0.57,0.42,0.155,1.008,0.377,0.193,0.34,3
F,0.47,0.355,0.18,0.441,0.1525,0.1165,0.135,1
F,0.5,0.44,0.155,0.742,0.2025,0.2005,0.2115,3
F,0.52,0.425,0.145,0.7,0.207,0.1905,0.24,3
M,0.39,0.285,0.095,0.271,0.11,0.06,0.08,1
M,0.52,0.4,0.165,0.8565,0.2745,0.201,0.21,3
F,0.54,0.415,0.175,0.8975,0.275,0.241,0.275,3
M,0.46,0.36,0.135,0.6105,0.1955,0.107,0.235,3
I,0.355,0.26,0.09,0.1925,0.077,0.038,0.065,1
F,0.49,0.4,0.145,0.6635,0.21,0.1295,0.2515,3
F,0.63,0.51,0.185,1.235,0.5115,0.349,0.3065,3
M,0.5,0.385,0.145,0.7615,0.246,0.195,0.204,3
M,0.49,0.39,0.135,0.592,0.242,0.096,0.1835,3
M,0.44,0.325,0.115,0.39,0.163,0.087,0.113,1
F,0.515,0.395,0.165,0.7565,0.1905,0.17,0.3205,2
F,0.475,0.38,0.145,0.57,0.167,0.118,0.187,3
I,0.42,0.31,0.1,0.2865,0.115,0.0735,0.085,1
M,0.4,0.305,0.13,0.2935,0.096,0.0675,0.105,2
M,0.45,0.36,0.16,0.567,0.174,0.1245,0.225,3
F,0.52,0.4,0.13,0.6245,0.215,0.2065,0.17,3
M,0.505,0.4,0.155,0.8415,0.2715,0.1775,0.285,3
M,0.495,0.4,0.14,0.7775,0.2015,0.18,0.25,3
M,0.54,0.41,0.145,0.989,0.2815,0.213,0.355,3
F,0.48,0.39,0.125,0.6905,0.219,0.155,0.2,3
F,0.33,0.26,0.08,0.2,0.0625,0.05,0.07,2
I,0.285,0.21,0.07,0.109,0.044,0.0265,0.033,1
I,0.3,0.23,0.075,0.127,0.052,0.03,0.0345,1
I,0.31,0.24,0.105,0.2885,0.118,0.065,0.083,1
I,0.34,0.255,0.075,0.18,0.0745,0.04,0.0525,1
I,0.375,0.3,0.075,0.144,0.059,0.03,0.044,1
I,0.415,0.325,0.1,0.4665,0.2285,0.1065,0.114,1
I,0.415,0.315,0.105,0.33,0.1405,0.0705,0.095,1
I,0.415,0.315,0.09,0.3625,0.175,0.0835,0.093,1
I,0.42,0.32,0.1,0.34,0.1745,0.05,0.0945,1
I,0.425,0.31,0.105,0.365,0.159,0.0825,0.105,1
M,0.465,0.375,0.11,0.5,0.21,0.113,0.1505,1
F,0.465,0.35,0.135,0.6265,0.259,0.1445,0.175,1
I,0.47,0.37,0.11,0.5555,0.25,0.115,0.163,1
F,0.47,0.375,0.12,0.6015,0.2765,0.1455,0.135,1
I,0.475,0.365,0.12,0.53,0.2505,0.0975,0.1625,2
M,0.48,0.37,0.135,0.6315,0.3445,0.1015,0.161,1
M,0.5,0.4,0.13,0.7715,0.37,0.16,0.211,1
I,0.505,0.39,0.185,0.6125,0.267,0.142,0.172,1
M,0.525,0.425,0.19,0.872,0.4625,0.1725,0.199,2
M,0.54,0.42,0.12,0.8115,0.392,0.1455,0.2235,2
M,0.545,0.45,0.15,0.8795,0.387,0.15,0.2625,3
F,0.565,0.44,0.15,0.983,0.4475,0.2355,0.2485,2
M,0.58,0.46,0.18,1.145,0.48,0.277,0.325,3
M,0.59,0.455,0.16,1.09,0.5,0.2215,0.292,2
M,0.59,0.48,0.16,1.262,0.5685,0.2725,0.335,2
M,0.595,0.49,0.185,1.185,0.482,0.2015,0.361,2
F,0.6,0.475,0.135,1.4405,0.5885,0.191,0.3175,2
F,0.6,0.5,0.155,1.332,0.6235,0.2835,0.35,1
F,0.6,0.485,0.165,1.1405,0.587,0.2175,0.288,2
M,0.605,0.475,0.175,1.201,0.5395,0.275,0.309,2
F,0.625,0.49,0.155,1.33,0.6675,0.259,0.33,2
M,0.63,0.5,0.185,1.362,0.5785,0.3125,0.384,2
M,0.64,0.585,0.195,1.647,0.7225,0.331,0.471,3
F,0.64,0.5,0.18,1.4995,0.593,0.314,0.431,3
F,0.655,0.545,0.165,1.6225,0.6555,0.299,0.513,3
I,0.66,0.525,0.215,1.786,0.6725,0.3615,0.4065,3
M,0.66,0.535,0.2,1.791,0.733,0.318,0.54,3
F,0.675,0.555,0.205,1.925,0.713,0.358,0.4535,3
F,0.675,0.55,0.175,1.689,0.694,0.371,0.474,3
F,0.69,0.55,0.18,1.659,0.8715,0.2655,0.4395,2
F,0.695,0.53,0.2,2.0475,0.75,0.4195,0.6095,3
F,0.7,0.525,0.19,1.6015,0.707,0.365,0.43,2
F,0.73,0.57,0.165,2.0165,1.0685,0.418,0.435,2
I,0.205,0.15,0.065,0.04,0.02,0.011,0.013,1
I,0.225,0.17,0.07,0.0565,0.024,0.013,0.016,1
I,0.23,0.18,0.05,0.064,0.0215,0.0135,0.02,1
I,0.275,0.195,0.07,0.0875,0.0345,0.022,0.0255,1
I,0.28,0.21,0.055,0.106,0.0415,0.0265,0.031,1
I,0.28,0.22,0.08,0.1315,0.066,0.024,0.03,1
I,0.295,0.22,0.07,0.126,0.0515,0.0275,0.035,1
I,0.31,0.225,0.075,0.155,0.065,0.037,0.0365,1
I,0.315,0.235,0.07,0.149,0.058,0.0325,0.047,1
I,0.34,0.265,0.07,0.185,0.0625,0.0395,0.07,1
I,0.37,0.29,0.08,0.2545,0.108,0.0565,0.07,1
I,0.38,0.285,0.085,0.237,0.115,0.0405,0.07,1
I,0.39,0.295,0.1,0.279,0.1155,0.059,0.08,1
I,0.405,0.31,0.065,0.3205,0.1575,0.066,0.088,1
I,0.415,0.325,0.1,0.3335,0.1445,0.0715,0.095,1
I,0.44,0.335,0.11,0.3885,0.175,0.0835,0.111,1
I,0.44,0.345,0.115,0.545,0.269,0.111,0.1305,1
I,0.44,0.325,0.1,0.4165,0.185,0.0865,0.11,1
I,0.44,0.355,0.12,0.495,0.231,0.11,0.125,1
I,0.45,0.35,0.125,0.4775,0.2235,0.089,0.118,1
I,0.45,0.35,0.12,0.468,0.2005,0.1065,0.1325,1
F,0.455,0.35,0.12,0.4555,0.1945,0.1045,0.1375,1
F,0.46,0.35,0.115,0.46,0.2025,0.1115,0.1165,1
I,0.46,0.345,0.12,0.4155,0.198,0.0885,0.107,1
I,0.46,0.345,0.115,0.4215,0.1895,0.102,0.111,1
I,0.465,0.355,0.11,0.474,0.23,0.1005,0.12,1
M,0.465,0.34,0.105,0.486,0.231,0.1035,0.1225,2
I,0.475,0.385,0.11,0.5735,0.311,0.1025,0.136,1
I,0.475,0.355,0.105,0.468,0.201,0.1115,0.12,1
M,0.48,0.37,0.1,0.5135,0.243,0.1015,0.135,1
M,0.5,0.375,0.145,0.6215,0.274,0.166,0.1485,1
I,0.5,0.38,0.11,0.494,0.218,0.09,0.1325,1
I,0.505,0.385,0.12,0.6005,0.239,0.142,0.185,1
M,0.515,0.395,0.12,0.646,0.285,0.1365,0.172,2
M,0.525,0.415,0.135,0.7945,0.394,0.189,0.202,1
M,0.525,0.425,0.125,0.812,0.4035,0.1705,0.195,1
F,0.53,0.42,0.17,0.828,0.41,0.208,0.1505,1
M,0.53,0.41,0.14,0.681,0.3095,0.1415,0.1835,1
F,0.53,0.405,0.15,0.889,0.4055,0.2275,0.215,1
M,0.54,0.435,0.14,0.7345,0.33,0.1595,0.213,2
F,0.55,0.425,0.125,0.964,0.5475,0.159,0.215,1
F,0.555,0.425,0.14,0.963,0.44,0.224,0.24,1
F,0.57,0.445,0.15,0.995,0.504,0.185,0.2505,2
F,0.57,0.435,0.14,0.8585,0.3905,0.196,0.2295,1
M,0.575,0.45,0.155,0.948,0.429,0.206,0.259,1
F,0.58,0.445,0.145,0.888,0.41,0.1815,0.2425,1
F,0.585,0.45,0.16,0.9045,0.405,0.2215,0.2335,1
M,0.59,0.465,0.14,1.046,0.4695,0.263,0.263,1
F,0.595,0.47,0.155,1.1775,0.542,0.269,0.31,2
F,0.595,0.465,0.15,1.0765,0.491,0.22,0.287,2
F,0.595,0.465,0.15,1.0255,0.412,0.2745,0.289,3
F,0.6,0.46,0.145,0.9325,0.3985,0.2245,0.248,1
F,0.6,0.46,0.15,1.235,0.6025,0.274,0.29,1
M,0.6,0.46,0.15,1.247,0.5335,0.2735,0.29,2
M,0.61,0.48,0.15,1.1495,0.564,0.274,0.264,1
F,0.615,0.485,0.16,1.1575,0.5005,0.2495,0.315,2
F,0.615,0.5,0.165,1.327,0.6,0.3015,0.355,2
M,0.615,0.47,0.155,1.2,0.5085,0.32,0.292,1
F,0.62,0.51,0.175,1.2705,0.5415,0.323,0.3225,2
F,0.62,0.485,0.175,1.2155,0.545,0.253,0.345,2
F,0.62,0.475,0.16,1.3245,0.6865,0.233,0.3275,2
M,0.625,0.48,0.17,1.3555,0.671,0.268,0.3385,2
F,0.625,0.49,0.165,1.127,0.477,0.2365,0.3185,2
F,0.625,0.49,0.175,1.1075,0.4485,0.2165,0.3595,1
F,0.63,0.495,0.2,1.4255,0.659,0.336,0.38,3
F,0.63,0.495,0.145,1.147,0.5455,0.266,0.2885,2
M,0.63,0.48,0.165,1.286,0.604,0.271,0.35,1
F,0.635,0.495,0.18,1.596,0.617,0.317,0.37,3
F,0.635,0.495,0.195,1.297,0.556,0.2985,0.37,3
M,0.645,0.49,0.16,1.251,0.5355,0.3345,0.3165,2
M,0.645,0.5,0.175,1.5105,0.6735,0.3755,0.3775,3
F,0.65,0.5,0.185,1.4415,0.741,0.2955,0.341,2
M,0.67,0.52,0.19,1.6385,0.8115,0.369,0.391,2
F,0.69,0.545,0.205,1.933,0.7855,0.429,0.498,3
M,0.69,0.54,0.185,1.71,0.7725,0.3855,0.4325,1
F,0.695,0.55,0.155,1.8495,0.767,0.442,0.4175,2
M,0.695,0.525,0.175,1.742,0.696,0.389,0.505,3
F,0.7,0.575,0.205,1.7975,0.7295,0.3935,0.5165,3
F,0.705,0.56,0.205,2.381,0.9915,0.5005,0.624,2
M,0.765,0.585,0.18,2.398,1.128,0.512,0.5335,3
M,0.77,0.6,0.215,2.1945,1.0515,0.482,0.584,2
I,0.22,0.16,0.05,0.049,0.0215,0.01,0.015,1
I,0.275,0.205,0.07,0.1055,0.495,0.019,0.0315,1
I,0.29,0.21,0.06,0.1045,0.0415,0.022,0.035,1
I,0.33,0.24,0.075,0.163,0.0745,0.033,0.048,1
I,0.355,0.285,0.095,0.2275,0.0955,0.0475,0.0715,1
I,0.375,0.29,0.1,0.219,0.0925,0.038,0.075,1
I,0.415,0.315,0.1,0.3645,0.1765,0.0795,0.095,1
I,0.425,0.33,0.115,0.3265,0.1315,0.077,0.103,1
I,0.425,0.34,0.1,0.3515,0.1625,0.082,0.094,1
I,0.43,0.32,0.1,0.3465,0.1635,0.08,0.09,1
I,0.44,0.34,0.1,0.407,0.209,0.0735,0.103,1
I,0.44,0.335,0.115,0.4215,0.173,0.0765,0.113,1
I,0.46,0.345,0.11,0.3755,0.1525,0.058,0.125,1
I,0.46,0.37,0.12,0.5335,0.2645,0.108,0.1345,1
I,0.465,0.355,0.105,0.442,0.2085,0.0975,0.1185,1
I,0.475,0.365,0.1,0.1315,0.2025,0.0875,0.123,1
I,0.475,0.375,0.115,0.5205,0.233,0.119,0.1455,1
I,0.485,0.375,0.13,0.5535,0.266,0.112,0.157,1
I,0.49,0.375,0.125,0.5445,0.279,0.115,0.13,1
M,0.49,0.38,0.11,0.554,0.2935,0.1005,0.15,1
I,0.495,0.38,0.12,0.512,0.233,0.1205,0.136,1
I,0.5,0.39,0.125,0.583,0.294,0.132,0.1605,1
M,0.5,0.38,0.12,0.5765,0.273,0.135,0.145,2
M,0.505,0.4,0.135,0.723,0.377,0.149,0.178,1
I,0.51,0.395,0.155,0.5395,0.2465,0.1085,0.167,1
I,0.51,0.385,0.15,0.625,0.3095,0.119,0.1725,1
I,0.515,0.4,0.125,0.5925,0.265,0.1175,0.168,2
I,0.52,0.395,0.135,0.633,0.2985,0.1295,0.175,2
F,0.545,0.43,0.14,0.832,0.4355,0.17,0.201,2
M,0.545,0.42,0.145,0.778,0.3745,0.1545,0.205,1
M,0.545,0.42,0.12,0.7865,0.403,0.185,0.17,1
F,0.545,0.4,0.14,0.778,0.368,0.215,0.18,2
I,0.55,0.42,0.13,0.636,0.294,0.144,0.1755,1
F,0.55,0.44,0.135,0.8435,0.434,0.1995,0.185,1
I,0.555,0.425,0.13,0.648,0.2835,0.133,0.2105,1
M,0.565,0.43,0.13,0.784,0.3495,0.1885,0.213,2
F,0.57,0.45,0.18,0.908,0.4015,0.217,0.255,2
M,0.57,0.45,0.135,1.02,0.546,0.204,0.25,2
F,0.57,0.43,0.16,0.811,0.3875,0.159,0.2285,2
F,0.575,0.48,0.15,0.897,0.4235,0.1905,0.248,1
M,0.58,0.455,0.13,0.852,0.41,0.1725,0.225,1
F,0.585,0.45,0.15,0.938,0.467,0.203,0.225,1
F,0.585,0.435,0.14,0.6955,0.3085,0.129,0.2245,1
M,0.59,0.47,0.15,0.861,0.413,0.164,0.249,1
M,0.59,0.46,0.14,1.004,0.496,0.2165,0.26,2
F,0.59,0.46,0.16,1.0115,0.445,0.2615,0.2565,1
F,0.595,0.465,0.15,1.1005,0.5415,0.166,0.265,1
M,0.595,0.47,0.165,1.108,0.4915,0.2325,0.3345,2
M,0.595,0.46,0.14,0.852,0.4215,0.2255,0.227,2
M,0.6,0.49,0.21,1.9875,1.005,0.419,0.491,2
F,0.605,0.48,0.15,1.079,0.4505,0.2835,0.293,2
F,0.615,0.475,0.17,1.055,0.543,0.246,0.2345,2
M,0.615,0.45,0.15,1.198,0.707,0.2095,0.2505,1
F,0.615,0.47,0.155,1.084,0.5885,0.209,0.246,2
M,0.615,0.475,0.175,1.103,0.4635,0.3095,0.2725,2
M,0.62,0.49,0.155,1.1,0.505,0.2475,0.31,2
M,0.62,0.48,0.15,1.1015,0.4965,0.243,0.305,2
M,0.625,0.495,0.185,1.3835,0.7105,0.3005,0.345,3
F,0.625,0.49,0.155,1.115,0.484,0.277,0.3095,2
M,0.625,0.48,0.145,1.085,0.4645,0.2445,0.327,2
M,0.63,0.505,0.15,1.3165,0.6325,0.2465,0.37,3
M,0.63,0.51,0.175,1.3415,0.6575,0.262,0.375,2
M,0.63,0.465,0.15,1.027,0.537,0.188,0.176,1
M,0.645,0.515,0.16,1.1845,0.506,0.311,0.335,2
M,0.645,0.48,0.15,1.192,0.6055,0.2595,0.285,2
F,0.645,0.52,0.18,1.285,0.5775,0.352,0.317,2
M,0.65,0.515,0.125,1.1805,0.5235,0.283,0.3275,2
M,0.65,0.52,0.175,1.2655,0.615,0.2775,0.336,2
F,0.65,0.535,0.175,1.2895,0.6095,0.2765,0.344,2
M,0.65,0.51,0.155,1.407,0.7215,0.298,0.335,2
F,0.65,0.49,0.155,1.122,0.545,0.228,0.3055,2
M,0.66,0.515,0.165,1.4465,0.694,0.298,0.3755,2
F,0.665,0.505,0.165,1.349,0.5985,0.3175,0.36,2
M,0.67,0.5,0.2,1.269,0.576,0.2985,0.351,3
M,0.67,0.51,0.18,1.68,0.926,0.2975,0.3935,3
F,0.675,0.55,0.19,1.551,0.7105,0.3685,0.412,3
M,0.68,0.52,0.165,1.4775,0.724,0.279,0.406,3
M,0.68,0.53,0.18,1.529,0.7635,0.3115,0.4025,3
M,0.7,0.525,0.175,1.7585,0.8745,0.3615,0.47,2
M,0.7,0.55,0.2,1.523,0.693,0.306,0.4405,3
F,0.725,0.53,0.19,1.7315,0.83,0.398,0.405,3
M,0.725,0.55,0.2,1.51,0.8735,0.4265,0.5085,2
M,0.735,0.57,0.175,1.88,0.9095,0.387,0.488,3
F,0.74,0.575,0.22,2.012,0.8915,0.5265,0.471,3
M,0.75,0.555,0.215,2.201,1.0615,0.5235,0.5285,3
I,0.19,0.14,0.03,0.0315,0.0125,0.005,0.0105,1
I,0.21,0.15,0.045,0.04,0.0135,0.008,0.0105,1
I,0.25,0.175,0.06,0.0635,0.0275,0.008,0.02,1
I,0.29,0.215,0.065,0.0985,0.0425,0.021,0.031,1
I,0.335,0.25,0.08,0.167,0.0675,0.0325,0.0575,1
I,0.34,0.245,0.085,0.2015,0.1005,0.038,0.053,1
I,0.345,0.255,0.095,0.183,0.075,0.0385,0.06,1
I,0.355,0.255,0.08,0.187,0.078,0.0505,0.058,1
I,0.36,0.26,0.08,0.1795,0.074,0.0315,0.06,1
I,0.37,0.275,0.09,0.2065,0.096,0.0395,0.058,1
I,0.375,0.29,0.14,0.3,0.14,0.0625,0.0825,1
I,0.375,0.275,0.095,0.2295,0.095,0.0545,0.066,1
I,0.385,0.3,0.125,0.343,0.1705,0.0735,0.081,1
I,0.385,0.285,0.085,0.244,0.1215,0.0445,0.068,1
I,0.395,0.32,0.1,0.3075,0.149,0.0535,0.09,1
I,0.4,0.305,0.1,0.3415,0.176,0.0625,0.0865,1
I,0.405,0.305,0.1,0.271,0.0965,0.061,0.091,1
I,0.405,0.31,0.11,0.91,0.416,0.2075,0.0995,1
I,0.405,0.305,0.1,0.268,0.1145,0.053,0.085,1
I,0.405,0.3,0.09,0.2885,0.138,0.0635,0.0765,1
I,0.41,0.315,0.1,0.3,0.124,0.0575,0.1,1
I,0.41,0.325,0.11,0.326,0.1325,0.075,0.101,1
I,0.415,0.335,0.1,0.358,0.169,0.067,0.105,1
I,0.42,0.325,0.115,0.314,0.1295,0.0635,0.1,1
I,0.42,0.315,0.11,0.4025,0.1855,0.083,0.1015,1
I,0.43,0.34,0.11,0.3645,0.159,0.0855,0.105,1
I,0.445,0.36,0.11,0.4235,0.182,0.0765,0.14,2
M,0.45,0.325,0.115,0.4305,0.2235,0.0785,0.1155,1
I,0.45,0.335,0.095,0.3505,0.1615,0.0625,0.1185,1
I,0.455,0.34,0.115,0.486,0.261,0.0655,0.1315,1
I,0.46,0.35,0.1,0.471,0.252,0.077,0.123,1
I,0.46,0.345,0.105,0.415,0.187,0.087,0.11,1
I,0.475,0.355,0.115,0.5195,0.279,0.088,0.1325,1
M,0.48,0.375,0.12,0.5895,0.2535,0.128,0.172,3
I,0.485,0.38,0.125,0.5215,0.2215,0.118,0.16,1
I,0.485,0.365,0.14,0.4475,0.1895,0.0925,0.2305,1
I,0.49,0.365,0.125,0.5585,0.252,0.126,0.1615,2
I,0.505,0.385,0.125,0.596,0.245,0.097,0.21,2
I,0.505,0.38,0.135,0.5385,0.2645,0.095,0.165,2
I,0.51,0.385,0.145,0.7665,0.3985,0.14,0.1805,1
F,0.515,0.395,0.135,0.516,0.2015,0.132,0.162,2
M,0.515,0.41,0.14,0.7355,0.3065,0.137,0.2,1
I,0.515,0.39,0.11,0.531,0.2415,0.098,0.1615,1
I,0.525,0.385,0.13,0.607,0.2355,0.125,0.195,1
F,0.525,0.415,0.15,0.7055,0.329,0.147,0.199,2
I,0.525,0.4,0.13,0.6445,0.345,0.1285,0.2,1
I,0.525,0.375,0.12,0.6315,0.3045,0.114,0.19,2
M,0.535,0.43,0.155,0.7845,0.3285,0.169,0.245,2
F,0.545,0.44,0.15,0.9475,0.366,0.239,0.275,1
I,0.55,0.43,0.145,0.712,0.3025,0.152,0.225,2
I,0.55,0.425,0.145,0.89,0.4325,0.171,0.236,2
I,0.55,0.42,0.155,0.912,0.495,0.1805,0.205,2
I,0.55,0.425,0.135,0.656,0.257,0.17,0.203,2
I,0.55,0.465,0.15,0.936,0.481,0.174,0.2435,2
I,0.555,0.435,0.145,0.6975,0.262,0.1575,0.24,3
F,0.555,0.445,0.175,1.1465,0.551,0.244,0.2785,1
I,0.56,0.44,0.14,0.825,0.402,0.139,0.245,2
I,0.56,0.435,0.135,0.72,0.329,0.103,0.251,3
I,0.565,0.43,0.15,0.8215,0.332,0.1685,0.29,3
F,0.57,0.445,0.155,1.017,0.5265,0.2025,0.265,2
F,0.575,0.435,0.155,0.8975,0.4115,0.2325,0.23,2
M,0.58,0.44,0.175,1.2255,0.5405,0.2705,0.3265,2
F,0.58,0.465,0.145,0.9865,0.47,0.2155,0.25,3
F,0.58,0.425,0.15,0.844,0.3645,0.185,0.2705,2
I,0.585,0.46,0.145,0.8465,0.339,0.167,0.295,2
M,0.585,0.465,0.165,0.885,0.4025,0.1625,0.274,2
I,0.585,0.42,0.145,0.6735,0.2895,0.1345,0.22,2
F,0.585,0.455,0.13,0.8755,0.411,0.2065,0.225,1
M,0.59,0.47,0.145,0.9235,0.4545,0.173,0.254,2
M,0.59,0.475,0.14,0.977,0.4625,0.2025,0.275,2
M,0.595,0.475,0.14,1.0305,0.4925,0.217,0.278,2
M,0.6,0.48,0.09,1.05,0.457,0.2685,0.28,1
M,0.6,0.495,0.185,1.1145,0.5055,0.2635,0.367,3
M,0.6,0.45,0.145,0.877,0.4325,0.155,0.24,2
M,0.6,0.51,0.185,1.285,0.6095,0.2745,0.315,2
M,0.61,0.48,0.185,1.3065,0.6895,0.2915,0.29,2
F,0.61,0.45,0.13,0.8725,0.389,0.1715,0.272,3
F,0.615,0.46,0.15,1.0265,0.4935,0.201,0.2745,2
F,0.62,0.465,0.14,1.1605,0.6005,0.2195,0.307,2
F,0.62,0.48,0.165,1.0125,0.5325,0.4365,0.324,2
M,0.625,0.5,0.14,1.096,0.5445,0.2165,0.295,2
M,0.625,0.49,0.165,1.205,0.5175,0.3105,0.3465,2
M,0.63,0.505,0.175,1.221,0.555,0.252,0.34,3
F,0.63,0.475,0.155,1.0005,0.452,0.252,0.265,2
M,0.63,0.47,0.15,1.1355,0.539,0.2325,0.3115,3
M,0.63,0.525,0.195,1.3135,0.4935,0.2565,0.465,2
M,0.64,0.505,0.155,1.1955,0.5565,0.211,0.346,3
M,0.64,0.485,0.15,1.098,0.5195,0.222,0.3175,2
M,0.64,0.495,0.17,1.139,0.5395,0.282,0.285,2
F,0.64,0.495,0.17,1.2265,0.49,0.377,0.2875,3
M,0.64,0.515,0.08,1.042,0.515,0.1755,0.175,2
M,0.65,0.52,0.155,1.368,0.6185,0.288,0.365,2
M,0.65,0.51,0.175,1.446,0.6485,0.2705,0.45,3
F,0.66,0.505,0.19,1.4045,0.6255,0.3375,0.3745,2
F,0.66,0.525,0.2,1.463,0.6525,0.2995,0.422,3
F,0.675,0.525,0.17,1.711,0.8365,0.352,0.475,2
M,0.7,0.54,0.205,1.74,0.7885,0.373,0.4865,3
F,0.705,0.54,0.205,1.757,0.8265,0.417,0.461,2
M,0.71,0.565,0.2,1.601,0.706,0.321,0.45,3
M,0.72,0.55,0.205,2.165,1.1055,0.525,0.404,2
M,0.725,0.57,0.19,2.3305,1.253,0.541,0.52,2
I,0.24,0.17,0.05,0.0545,0.0205,0.016,0.0155,1
I,0.255,0.195,0.055,0.0725,0.0285,0.017,0.021,1
I,0.275,0.2,0.055,0.0925,0.038,0.021,0.026,1
I,0.32,0.235,0.09,0.183,0.098,0.0335,0.042,1
I,0.325,0.24,0.075,0.1525,0.072,0.0645,0.043,1
I,0.33,0.225,0.075,0.187,0.0945,0.0395,0.0425,1
I,0.36,0.27,0.09,0.232,0.12,0.0435,0.056,1
I,0.375,0.265,0.095,0.196,0.085,0.042,0.0585,1
I,0.375,0.285,0.09,0.2545,0.119,0.0595,0.0675,1
I,0.39,0.29,0.09,0.2625,0.117,0.054,0.077,1
I,0.45,0.335,0.105,0.362,0.1575,0.0795,0.1095,1
I,0.455,0.35,0.105,0.4445,0.213,0.107,0.1115,1
I,0.46,0.365,0.115,0.511,0.2365,0.118,0.123,1
I,0.495,0.375,0.12,0.589,0.3075,0.1215,0.1405,1
M,0.5,0.365,0.13,0.5945,0.309,0.1085,0.1535,2
I,0.5,0.375,0.12,0.529,0.2235,0.123,0.16,1
M,0.52,0.4,0.105,0.872,0.4515,0.1615,0.1985,2
I,0.52,0.395,0.145,0.77,0.424,0.142,0.1895,1
F,0.525,0.43,0.135,0.8435,0.4325,0.18,0.1815,2
M,0.535,0.405,0.14,0.818,0.402,0.1715,0.189,1
F,0.54,0.42,0.14,0.8035,0.38,0.1805,0.21,2
F,0.54,0.415,0.15,0.8115,0.3875,0.1875,0.2035,2
F,0.57,0.425,0.13,0.782,0.3695,0.1745,0.1965,1
M,0.57,0.42,0.14,0.8745,0.416,0.165,0.25,1
M,0.58,0.445,0.16,0.984,0.49,0.201,0.27,2
F,0.58,0.445,0.135,0.95,0.484,0.182,0.2325,1
M,0.59,0.47,0.155,1.1735,0.6245,0.233,0.2595,2
F,0.59,0.455,0.15,0.976,0.465,0.2055,0.2765,2
M,0.59,0.485,0.155,1.0785,0.4535,0.2435,0.31,2
M,0.595,0.435,0.16,1.057,0.4255,0.224,0.31,2
M,0.6,0.475,0.175,1.11,0.5105,0.256,0.285,2
M,0.6,0.45,0.16,1.142,0.539,0.225,0.307,2
M,0.605,0.475,0.19,1.1255,0.59,0.247,0.26,2
F,0.62,0.48,0.17,1.1045,0.535,0.25,0.287,2
M,0.625,0.475,0.175,1.3405,0.656,0.283,0.337,2
M,0.625,0.5,0.13,1.082,0.5785,0.2045,0.25,1
F,0.625,0.485,0.16,1.254,0.591,0.259,0.3485,2
M,0.63,0.49,0.165,1.2005,0.575,0.273,0.294,2
M,0.63,0.485,0.16,1.243,0.623,0.275,0.3,2
F,0.635,0.51,0.185,1.286,0.526,0.295,0.4105,3
F,0.645,0.49,0.16,1.1665,0.4935,0.3155,0.299,2
F,0.645,0.49,0.16,1.144,0.5015,0.289,0.319,1
F,0.65,0.525,0.19,1.385,0.8875,0.3095,0.405,3
F,0.655,0.515,0.155,1.309,0.524,0.346,0.385,3
F,0.655,0.515,0.17,1.527,0.8485,0.2635,0.331,3
M,0.665,0.515,0.19,1.6385,0.831,0.3575,0.371,3
M,0.695,0.54,0.195,1.691,0.768,0.363,0.4755,3
F,0.72,0.565,0.18,1.719,0.8465,0.407,0.3875,3
F,0.72,0.55,0.18,1.52,0.637,0.325,0.435,2
F,0.72,0.565,0.17,1.613,0.723,0.3255,0.4945,3
M,0.735,0.57,0.21,2.2355,1.1705,0.463,0.5315,2
M,0.74,0.595,0.19,2.3235,1.1495,0.5115,0.505,3
I,0.31,0.23,0.07,0.1245,0.0505,0.0265,0.038,1
I,0.315,0.235,0.075,0.1285,0.051,0.028,0.0405,1
I,0.32,0.205,0.08,0.181,0.088,0.034,0.0495,1
I,0.325,0.25,0.075,0.1585,0.075,0.0305,0.0455,1
I,0.335,0.26,0.09,0.1965,0.0875,0.041,0.056,1
I,0.37,0.28,0.085,0.198,0.0805,0.0455,0.058,1
I,0.37,0.27,0.09,0.1855,0.07,0.0425,0.065,1
I,0.375,0.28,0.085,0.2145,0.0855,0.0485,0.072,1
I,0.4,0.315,0.09,0.3245,0.151,0.073,0.088,1
I,0.41,0.305,0.095,0.2625,0.1,0.0515,0.09,1
I,0.425,0.34,0.1,0.371,0.15,0.0865,0.115,1
I,0.435,0.335,0.095,0.298,0.109,0.058,0.115,1
I,0.445,0.31,0.09,0.336,0.1555,0.09,0.0855,1
I,0.46,0.36,0.14,0.447,0.161,0.087,0.16,2
F,0.465,0.35,0.11,0.4085,0.165,0.102,0.131,1
I,0.47,0.385,0.13,0.587,0.264,0.117,0.174,1
I,0.475,0.375,0.11,0.494,0.211,0.109,0.1545,1
I,0.495,0.375,0.12,0.614,0.2855,0.1365,0.161,1
I,0.5,0.39,0.13,0.5075,0.2115,0.104,0.1755,2
I,0.5,0.37,0.12,0.5445,0.249,0.1065,0.152,1
I,0.505,0.425,0.125,0.6115,0.245,0.1375,0.2,2
I,0.505,0.4,0.125,0.5605,0.2255,0.1435,0.17,1
M,0.505,0.365,0.115,0.521,0.25,0.096,0.15,1
I,0.51,0.4,0.145,0.5775,0.231,0.143,0.177,2
I,0.51,0.4,0.125,0.5935,0.239,0.13,0.204,1
I,0.52,0.4,0.11,0.597,0.2935,0.1155,0.16,1
M,0.52,0.465,0.15,0.9505,0.456,0.199,0.255,1
I,0.53,0.38,0.125,0.616,0.292,0.113,0.185,1
M,0.53,0.405,0.15,0.8315,0.352,0.187,0.2525,2
F,0.535,0.445,0.125,0.8725,0.417,0.199,0.24,1
I,0.54,0.425,0.13,0.8155,0.3675,0.1365,0.246,3
I,0.54,0.415,0.11,0.619,0.2755,0.15,0.1765,2
I,0.545,0.43,0.13,0.7595,0.358,0.153,0.2055,1
I,0.545,0.43,0.15,0.742,0.3525,0.158,0.208,2
I,0.55,0.435,0.165,0.804,0.34,0.194,0.244,1
I,0.55,0.425,0.13,0.664,0.2695,0.163,0.21,1
F,0.55,0.435,0.14,0.745,0.347,0.174,0.2265,2
I,0.56,0.43,0.13,0.728,0.3355,0.1435,0.2175,1
I,0.56,0.435,0.13,0.777,0.354,0.173,0.222,2
F,0.575,0.425,0.15,0.8765,0.455,0.18,0.228,1
I,0.575,0.455,0.16,0.9895,0.495,0.195,0.246,2
M,0.575,0.45,0.165,0.9655,0.498,0.19,0.23,1
M,0.58,0.465,0.15,0.9065,0.371,0.1965,0.29,1
M,0.58,0.46,0.15,1.049,0.5205,0.1935,0.305,2
F,0.58,0.45,0.17,0.9705,0.4615,0.232,0.248,2
F,0.58,0.45,0.15,0.92,0.393,0.212,0.2895,2
M,0.58,0.445,0.15,0.9525,0.4315,0.1945,0.287,3
F,0.58,0.44,0.125,0.7855,0.363,0.1955,0.195,3
I,0.585,0.45,0.135,0.855,0.3795,0.187,0.26,2
M,0.59,0.5,0.15,1.142,0.485,0.265,0.345,2
I,0.59,0.46,0.125,0.755,0.334,0.15,0.238,2
I,0.59,0.475,0.145,0.9745,0.4675,0.207,0.259,2
M,0.595,0.47,0.155,1.2015,0.492,0.3865,0.265,2
M,0.595,0.46,0.17,1.1295,0.57,0.2555,0.265,2
I,0.6,0.445,0.135,0.9205,0.445,0.2035,0.253,2
F,0.6,0.48,0.17,1.056,0.4575,0.2435,0.3135,2
M,0.6,0.45,0.195,1.34,0.617,0.3255,0.3605,2
F,0.6,0.45,0.15,0.9625,0.4375,0.2225,0.2775,2
M,0.6,0.465,0.165,1.0475,0.465,0.2345,0.315,3
F,0.605,0.495,0.17,1.0915,0.4365,0.2715,0.335,3
M,0.605,0.49,0.18,1.167,0.457,0.29,0.3745,2
I,0.605,0.48,0.155,0.9995,0.425,0.1985,0.3,2
I,0.61,0.425,0.155,1.0485,0.507,0.1955,0.274,3
F,0.61,0.47,0.195,1.2735,0.469,0.3315,0.398,3
M,0.61,0.48,0.14,1.0625,0.516,0.225,0.2915,3
I,0.61,0.49,0.16,1.1545,0.5865,0.2385,0.2915,3
F,0.615,0.475,0.175,1.194,0.559,0.259,0.3165,3
F,0.615,0.515,0.135,1.1215,0.545,0.2305,0.29,2
M,0.615,0.455,0.15,0.9335,0.382,0.247,0.2615,2
F,0.615,0.495,0.165,1.198,0.5415,0.2865,0.3185,2
F,0.62,0.475,0.15,0.9545,0.455,0.1865,0.277,2
M,0.62,0.475,0.195,1.3585,0.5935,0.3365,0.3745,2
M,0.625,0.495,0.175,1.2075,0.531,0.281,0.3525,3
M,0.625,0.515,0.165,1.217,0.667,0.2065,0.3115,2
F,0.625,0.5,0.16,1.217,0.5725,0.207,0.355,3
F,0.625,0.49,0.145,0.92,0.437,0.1735,0.28,2
M,0.625,0.49,0.12,0.8765,0.456,0.18,0.233,2
F,0.63,0.48,0.165,1.2615,0.5505,0.277,0.3885,2
M,0.63,0.53,0.18,1.2795,0.618,0.256,0.315,2
F,0.63,0.485,0.185,1.167,0.548,0.2485,0.34,2
M,0.63,0.51,0.17,1.1885,0.4915,0.3065,0.348,1
F,0.635,0.485,0.19,1.3765,0.634,0.2885,0.406,3
M,0.635,0.52,0.175,1.292,0.6,0.269,0.367,3
M,0.635,0.485,0.18,1.1795,0.4785,0.2775,0.355,2
F,0.635,0.5,0.19,1.29,0.593,0.3045,0.352,1
M,0.635,0.515,0.16,1.2075,0.5385,0.282,0.345,3
M,0.64,0.505,0.18,1.297,0.59,0.3125,0.363,3
M,0.64,0.575,0.175,1.4585,0.625,0.266,0.4395,3
F,0.645,0.485,0.15,1.151,0.5935,0.2315,0.293,3
F,0.645,0.52,0.17,1.197,0.526,0.2925,0.317,3
M,0.645,0.495,0.19,1.539,0.6115,0.408,0.445,3
M,0.65,0.52,0.195,1.676,0.693,0.44,0.47,3
F,0.65,0.565,0.2,1.6645,0.753,0.367,0.43,3
F,0.655,0.5,0.205,1.528,0.6215,0.3725,0.4535,3
F,0.655,0.515,0.2,1.494,0.7255,0.309,0.405,3
F,0.66,0.525,0.16,1.277,0.4975,0.319,0.394,3
F,0.66,0.525,0.18,1.5965,0.7765,0.397,0.3605,2
F,0.665,0.51,0.175,1.3805,0.675,0.2985,0.325,2
I,0.67,0.485,0.175,1.2565,0.5355,0.322,0.386,2
F,0.67,0.525,0.19,1.527,0.5755,0.353,0.44,3
M,0.67,0.525,0.17,1.4005,0.715,0.3025,0.387,2
M,0.67,0.525,0.195,1.4405,0.6595,0.2675,0.425,2
M,0.67,0.54,0.175,1.482,0.739,0.2925,0.365,2
M,0.68,0.515,0.16,1.2345,0.618,0.2625,0.325,3
F,0.68,0.505,0.17,1.3435,0.657,0.297,0.355,3
M,0.685,0.505,0.19,1.533,0.667,0.4055,0.41,2
M,0.69,0.515,0.18,1.8445,0.9815,0.4655,0.341,3
M,0.715,0.55,0.175,1.825,0.938,0.3805,0.44,3
M,0.72,0.58,0.19,2.0885,0.9955,0.478,0.5305,3
M,0.735,0.59,0.205,2.087,0.909,0.474,0.625,3
M,0.745,0.575,0.2,1.884,0.954,0.336,0.495,3
I,0.32,0.215,0.095,0.305,0.14,0.067,0.0885,1
I,0.43,0.345,0.115,0.4295,0.212,0.108,0.109,1
I,0.43,0.33,0.1,0.449,0.254,0.0825,0.097,1
M,0.485,0.365,0.155,1.029,0.4235,0.2285,0.313,1
M,0.49,0.355,0.155,0.981,0.465,0.2015,0.2505,1
I,0.5,0.37,0.115,0.5745,0.306,0.112,0.141,1
F,0.505,0.38,0.13,0.693,0.391,0.1195,0.1515,1
F,0.51,0.37,0.21,1.183,0.508,0.292,0.343,2
F,0.525,0.41,0.135,0.7905,0.4065,0.198,0.177,1
F,0.535,0.4,0.15,1.224,0.618,0.275,0.2875,2
I,0.535,0.4,0.135,0.775,0.368,0.208,0.2055,1
M,0.535,0.405,0.175,1.2705,0.548,0.3265,0.337,3
M,0.555,0.405,0.19,1.406,0.6115,0.342,0.389,2
M,0.555,0.425,0.15,0.873,0.4625,0.1845,0.1965,2
M,0.56,0.425,0.135,0.9415,0.509,0.2015,0.1975,2
F,0.59,0.44,0.14,1.007,0.4775,0.2105,0.2925,2
M,0.595,0.485,0.15,1.0835,0.5305,0.231,0.276,1
I,0.595,0.43,0.165,0.9845,0.4525,0.207,0.2725,1
F,0.595,0.43,0.21,1.5245,0.653,0.396,0.41,3
M,0.61,0.475,0.175,1.024,0.409,0.261,0.322,2
M,0.61,0.485,0.17,1.281,0.597,0.3035,0.33,2
F,0.62,0.5,0.17,1.148,0.5475,0.22,0.3315,2
F,0.625,0.49,0.11,1.136,0.5265,0.1915,0.2925,2
F,0.635,0.51,0.17,1.2235,0.532,0.271,0.354,2
F,0.635,0.525,0.18,1.3695,0.634,0.318,0.363,3
M,0.64,0.485,0.16,1.006,0.456,0.2245,0.2835,2
M,0.64,0.495,0.165,1.307,0.678,0.292,0.266,3
M,0.645,0.505,0.185,1.463,0.592,0.3905,0.416,2
F,0.655,0.505,0.175,1.2905,0.6205,0.2965,0.326,2
F,0.67,0.515,0.17,1.4265,0.6605,0.3395,0.37,3
M,0.68,0.54,0.21,1.7885,0.8345,0.408,0.437,3
M,0.7,0.545,0.185,1.6135,0.75,0.4035,0.3685,3
M,0.73,0.585,0.225,2.2305,1.2395,0.422,0.563,3
F,0.75,0.615,0.205,2.2635,0.821,0.423,0.726,3
I,0.255,0.185,0.065,0.074,0.0305,0.0165,0.02,1
I,0.375,0.26,0.08,0.2075,0.09,0.0415,0.07,1
I,0.375,0.285,0.09,0.237,0.106,0.0395,0.08,1
I,0.39,0.3,0.1,0.2665,0.1105,0.059,0.084,1
I,0.39,0.28,0.09,0.215,0.0845,0.034,0.079,1
I,0.395,0.3,0.09,0.253,0.1155,0.05,0.075,1
I,0.42,0.32,0.11,0.309,0.115,0.0645,0.0945,1
I,0.435,0.335,0.105,0.3535,0.156,0.05,0.1135,1
I,0.435,0.325,0.105,0.335,0.136,0.065,0.115,1
I,0.44,0.32,0.105,0.3875,0.1755,0.074,0.12,2
I,0.45,0.33,0.115,0.365,0.14,0.0825,0.1245,1
I,0.45,0.34,0.125,0.4045,0.171,0.07,0.1345,1
I,0.455,0.355,0.105,0.372,0.138,0.0765,0.135,2
I,0.46,0.37,0.11,0.3965,0.1485,0.0855,0.1455,1
I,0.47,0.375,0.125,0.5225,0.2265,0.104,0.162,1
I,0.475,0.375,0.11,0.456,0.182,0.099,0.16,2
I,0.495,0.33,0.1,0.44,0.177,0.095,0.15,1
I,0.495,0.375,0.115,0.507,0.241,0.103,0.15,1
I,0.5,0.38,0.135,0.5285,0.226,0.123,0.209,1
I,0.515,0.385,0.125,0.572,0.237,0.1435,0.165,1
I,0.52,0.41,0.14,0.6625,0.2775,0.1555,0.196,3
I,0.52,0.395,0.115,0.6445,0.3155,0.1245,0.186,3
I,0.525,0.4,0.11,0.6275,0.3015,0.126,0.18,1
I,0.535,0.42,0.145,0.6885,0.273,0.1515,0.237,2
M,0.535,0.41,0.12,0.6835,0.3125,0.1655,0.159,1
M,0.54,0.42,0.19,0.6855,0.293,0.163,0.38,2
I,0.55,0.405,0.15,0.6755,0.3015,0.1465,0.21,2
I,0.55,0.445,0.145,0.783,0.3045,0.157,0.265,3
M,0.56,0.45,0.145,0.894,0.3885,0.2095,0.264,2
I,0.565,0.44,0.135,0.768,0.3305,0.1385,0.2475,2
M,0.57,0.45,0.145,0.95,0.4005,0.2235,0.2845,2
F,0.57,0.47,0.14,0.871,0.385,0.211,0.2315,2
M,0.575,0.47,0.15,0.9785,0.4505,0.196,0.276,2
I,0.575,0.43,0.13,0.7425,0.2895,0.2005,0.22,1
M,0.575,0.445,0.14,0.737,0.325,0.1405,0.237,2
I,0.575,0.445,0.16,0.9175,0.45,0.1935,0.24,2
F,0.58,0.435,0.155,0.8785,0.425,0.1685,0.2425,2
M,0.585,0.45,0.175,1.1275,0.4925,0.262,0.335,3
M,0.59,0.435,0.165,0.9765,0.4525,0.2395,0.235,2
I,0.59,0.47,0.145,0.974,0.453,0.236,0.289,1
M,0.59,0.405,0.15,0.853,0.326,0.2615,0.245,2
M,0.595,0.47,0.175,0.991,0.382,0.2395,0.5,3
M,0.595,0.48,0.14,0.9125,0.4095,0.1825,0.289,2
F,0.595,0.46,0.16,0.921,0.4005,0.2025,0.2875,2
F,0.6,0.45,0.14,0.869,0.3425,0.195,0.291,3
M,0.6,0.45,0.15,0.8665,0.3695,0.1955,0.255,3
F,0.61,0.495,0.16,1.089,0.469,0.198,0.384,3
M,0.615,0.485,0.215,0.9615,0.422,0.176,0.29,3
M,0.615,0.49,0.17,1.145,0.4915,0.208,0.343,3
I,0.62,0.475,0.16,0.907,0.371,0.167,0.3075,3
F,0.625,0.515,0.155,1.1635,0.4875,0.259,0.355,3
M,0.63,0.515,0.175,1.1955,0.492,0.247,0.37,3
M,0.63,0.495,0.18,1.31,0.495,0.295,0.4695,2
F,0.635,0.505,0.165,1.251,0.577,0.227,0.3825,3
F,0.635,0.49,0.155,1.145,0.4775,0.3035,0.3155,2
M,0.635,0.5,0.18,1.154,0.4405,0.2315,0.387,2
F,0.64,0.485,0.145,1.1335,0.5525,0.2505,0.3015,3
F,0.64,0.5,0.15,1.2015,0.559,0.231,0.3355,2
M,0.65,0.505,0.17,1.5595,0.695,0.3515,0.395,3
M,0.65,0.51,0.175,1.3165,0.6345,0.2605,0.364,3
M,0.655,0.54,0.165,1.403,0.6955,0.2385,0.42,3
F,0.655,0.49,0.16,1.204,0.5455,0.2615,0.3225,2
F,0.655,0.455,0.17,1.2895,0.587,0.3165,0.3415,3
F,0.66,0.53,0.18,1.5175,0.7765,0.302,0.401,2
M,0.665,0.525,0.155,1.3575,0.5325,0.3045,0.4485,2
M,0.675,0.52,0.145,1.3645,0.557,0.3405,0.385,3
F,0.68,0.52,0.185,1.494,0.615,0.3935,0.406,3
F,0.68,0.56,0.195,1.664,0.58,0.3855,0.545,3
M,0.685,0.51,0.165,1.545,0.686,0.3775,0.4055,2
F,0.695,0.535,0.2,1.5855,0.667,0.334,0.471,3
F,0.7,0.555,0.22,1.666,0.647,0.4285,0.455,3
M,0.71,0.56,0.175,1.724,0.566,0.4575,0.4625,3
F,0.73,0.55,0.205,1.908,0.5415,0.3565,0.5965,3
F,0.755,0.575,0.2,2.073,1.0135,0.4655,0.48,3
I,0.225,0.17,0.05,0.0515,0.019,0.012,0.017,1
I,0.23,0.17,0.05,0.057,0.026,0.013,0.016,1
I,0.255,0.185,0.06,0.0925,0.039,0.021,0.025,1
I,0.355,0.27,0.075,0.204,0.3045,0.046,0.0595,1
I,0.425,0.31,0.095,0.3075,0.139,0.0745,0.093,1
I,0.425,0.32,0.085,0.262,0.1235,0.067,0.0725,1
M,0.455,0.35,0.11,0.458,0.2,0.111,0.1305,1
M,0.46,0.355,0.14,0.491,0.207,0.115,0.174,2
M,0.495,0.38,0.12,0.474,0.197,0.1065,0.1545,2
M,0.51,0.395,0.125,0.5805,0.244,0.1335,0.188,3
F,0.52,0.43,0.15,0.728,0.302,0.1575,0.235,3
M,0.525,0.4,0.13,0.622,0.2655,0.147,0.184,2
M,0.53,0.415,0.12,0.706,0.3355,0.1635,0.1345,2
F,0.53,0.395,0.115,0.5685,0.249,0.1375,0.161,2
M,0.545,0.435,0.145,0.9385,0.3685,0.1245,0.345,3
F,0.55,0.43,0.15,0.655,0.2635,0.122,0.221,1
M,0.575,0.48,0.15,0.9465,0.4355,0.2605,0.2505,2
M,0.58,0.43,0.125,0.9115,0.446,0.2075,0.121,2
M,0.595,0.455,0.145,0.942,0.43,0.182,0.277,3
M,0.6,0.465,0.18,1.193,0.5145,0.315,0.3055,1
M,0.645,0.5,0.18,1.461,0.5985,0.2425,0.439,3
M,0.66,0.525,0.2,1.489,0.6065,0.3795,0.421,2
I,0.29,0.215,0.06,0.1115,0.053,0.0185,0.032,1
I,0.3,0.22,0.065,0.1235,0.059,0.026,0.0315,1
I,0.37,0.275,0.1,0.2815,0.1505,0.0505,0.068,1
I,0.375,0.285,0.08,0.226,0.0975,0.04,0.0725,1
I,0.38,0.29,0.085,0.2285,0.088,0.0465,0.075,1
I,0.395,0.3,0.12,0.2995,0.1265,0.068,0.0895,1
I,0.41,0.325,0.105,0.361,0.1605,0.0665,0.103,1
I,0.415,0.32,0.115,0.3045,0.1215,0.0735,0.094,1
I,0.425,0.325,0.105,0.3975,0.1815,0.081,0.1175,1
I,0.44,0.34,0.1,0.379,0.1725,0.0815,0.101,1
I,0.44,0.34,0.12,0.4995,0.2965,0.0945,0.1185,1
M,0.465,0.405,0.135,0.7775,0.436,0.1715,0.1455,2
F,0.47,0.36,0.1,0.4705,0.1635,0.089,0.1385,1
M,0.51,0.415,0.145,0.751,0.3295,0.1835,0.203,1
F,0.525,0.4,0.135,0.714,0.318,0.138,0.208,2
F,0.525,0.4,0.13,0.6995,0.3115,0.131,0.223,2
F,0.55,0.425,0.14,0.952,0.4895,0.1945,0.2185,1
M,0.56,0.42,0.15,0.8755,0.44,0.1965,0.2315,1
M,0.575,0.45,0.135,0.9215,0.354,0.209,0.2365,2
F,0.575,0.45,0.135,0.8285,0.362,0.1655,0.236,2
M,0.585,0.46,0.15,1.206,0.581,0.216,0.323,2
M,0.615,0.495,0.155,1.2865,0.435,0.293,0.3245,3
F,0.62,0.485,0.155,1.1945,0.5105,0.271,0.352,2
F,0.63,0.495,0.19,1.1655,0.536,0.2115,0.1625,2
F,0.63,0.49,0.17,1.2155,0.4625,0.2045,0.3105,2
M,0.67,0.515,0.165,1.1735,0.526,0.285,0.316,3
M,0.675,0.505,0.16,1.532,0.74,0.357,0.3815,3
F,0.685,0.53,0.17,1.5105,0.7385,0.3525,0.3725,2
F,0.485,0.39,0.1,0.5565,0.2215,0.1155,0.185,2
M,0.46,0.36,0.125,0.547,0.2165,0.1105,0.19,1
M,0.46,0.35,0.125,0.5165,0.1885,0.1145,0.185,2
M,0.535,0.42,0.125,0.764,0.312,0.1505,0.265,3
M,0.465,0.36,0.105,0.488,0.188,0.0845,0.19,2
M,0.51,0.4,0.14,0.6905,0.259,0.151,0.23,2
I,0.335,0.26,0.09,0.1835,0.078,0.024,0.065,3
M,0.55,0.425,0.16,0.97,0.2885,0.139,0.48,3
I,0.18,0.135,0.08,0.033,0.0145,0.007,0.01,1
I,0.215,0.165,0.055,0.059,0.0265,0.0125,0.0185,1
I,0.2,0.15,0.04,0.046,0.021,0.007,0.0065,1
F,0.625,0.48,0.2,1.3235,0.6075,0.3055,0.355,2
M,0.55,0.42,0.17,0.8465,0.336,0.2405,0.245,3
M,0.585,0.45,0.15,1.047,0.4315,0.276,0.315,3
F,0.645,0.5,0.18,1.2785,0.5345,0.2995,0.345,3
F,0.71,0.53,0.195,1.8745,0.6755,0.4065,0.6855,3
F,0.7,0.54,0.215,1.978,0.6675,0.3125,0.71,3
F,0.655,0.505,0.165,1.367,0.5835,0.3515,0.396,2
F,0.665,0.5,0.175,1.742,0.595,0.3025,0.725,3
F,0.47,0.375,0.105,0.513,0.232,0.142,0.13,3
M,0.425,0.335,0.1,0.4085,0.1755,0.092,0.135,2
M,0.54,0.41,0.13,0.56,0.2375,0.1065,0.175,1
M,0.505,0.395,0.125,0.635,0.29,0.1555,0.175,2
M,0.535,0.44,0.165,0.875,0.279,0.18,0.3,2
F,0.43,0.35,0.09,0.397,0.1575,0.089,0.12,2
M,0.55,0.435,0.11,0.806,0.3415,0.203,0.215,2
F,0.34,0.255,0.085,0.204,0.097,0.021,0.05,1
I,0.275,0.2,0.065,0.1165,0.0565,0.013,0.035,1
F,0.335,0.22,0.07,0.17,0.076,0.0365,0.05,1
M,0.64,0.49,0.14,1.194,0.4445,0.238,0.375,3
F,0.55,0.44,0.125,0.765,0.33,0.2125,0.245,2
F,0.64,0.475,0.19,1.151,0.4365,0.281,0.3805,3
F,0.545,0.41,0.115,0.6765,0.29,0.158,0.22,2
F,0.64,0.54,0.175,1.571,0.627,0.271,0.475,3
M,0.605,0.49,0.155,1.153,0.503,0.2505,0.295,3
M,0.605,0.47,0.115,1.114,0.3925,0.291,0.31,3
M,0.56,0.45,0.155,0.9125,0.3595,0.271,0.35,2
F,0.57,0.465,0.155,0.872,0.3245,0.239,0.285,3
M,0.525,0.405,0.16,0.792,0.316,0.1455,0.28,3
F,0.505,0.405,0.18,0.606,0.239,0.1235,0.18,3
M,0.35,0.265,0.09,0.2265,0.0995,0.0575,0.065,1
M,0.45,0.355,0.12,0.3955,0.147,0.0765,0.145,2
I,0.51,0.405,0.12,0.61,0.229,0.131,0.235,3
F,0.49,0.38,0.13,0.539,0.229,0.1355,0.165,3
F,0.505,0.41,0.135,0.657,0.291,0.133,0.195,3
M,0.38,0.3,0.1,0.2505,0.106,0.0535,0.0775,1
I,0.27,0.195,0.07,0.102,0.045,0.0135,0.034,1
F,0.37,0.295,0.1,0.2685,0.1165,0.056,0.0835,1
M,0.5,0.385,0.135,0.551,0.2245,0.0715,0.206,3
M,0.645,0.505,0.165,1.307,0.4335,0.262,0.52,2
M,0.565,0.44,0.115,0.9185,0.404,0.1785,0.29,3
F,0.67,0.545,0.175,1.707,0.6995,0.387,0.575,3
F,0.59,0.415,0.15,0.8805,0.3645,0.234,0.235,3
F,0.47,0.36,0.11,0.4965,0.237,0.127,0.13,1
F,0.51,0.385,0.135,0.632,0.282,0.145,0.17,1
M,0.72,0.575,0.23,2.2695,0.8835,0.3985,0.665,3
M,0.55,0.405,0.15,0.9235,0.412,0.2135,0.24,1
I,0.2,0.145,0.025,0.0345,0.011,0.0075,0.01,1
M,0.65,0.515,0.18,1.3315,0.5665,0.347,0.405,3
F,0.525,0.405,0.115,0.72,0.3105,0.1915,0.2,3
M,0.565,0.435,0.185,1.032,0.354,0.2045,0.31,3
F,0.61,0.47,0.16,1.017,0.426,0.2255,0.32,3
F,0.545,0.405,0.175,0.98,0.2585,0.207,0.38,3
I,0.325,0.245,0.075,0.1495,0.0605,0.033,0.045,1
I,0.31,0.235,0.075,0.1515,0.056,0.0315,0.05,1
M,0.45,0.335,0.14,0.478,0.1865,0.115,0.16,3
F,0.49,0.38,0.155,0.578,0.2395,0.1255,0.18,2
F,0.505,0.405,0.16,0.6835,0.271,0.145,0.215,2
F,0.385,0.3,0.1,0.2725,0.1115,0.057,0.08,1
F,0.62,0.485,0.22,1.511,0.5095,0.284,0.51,3
F,0.635,0.505,0.185,1.3035,0.501,0.295,0.41,3
F,0.665,0.53,0.185,1.3955,0.456,0.3205,0.49,3
M,0.335,0.265,0.095,0.1975,0.0795,0.0375,0.07,2
I,0.295,0.215,0.075,0.116,0.037,0.0295,0.04,1
I,0.48,0.38,0.125,0.523,0.2105,0.1045,0.175,3
I,0.32,0.25,0.08,0.1565,0.057,0.034,0.06,2
I,0.43,0.34,0.125,0.384,0.1375,0.061,0.146,3
M,0.565,0.45,0.14,1.0055,0.3785,0.244,0.265,3
F,0.6,0.48,0.165,1.1345,0.4535,0.27,0.335,2
F,0.585,0.46,0.17,1.0835,0.3745,0.326,0.325,3
F,0.555,0.42,0.14,0.868,0.33,0.243,0.21,3
F,0.57,0.495,0.16,1.0915,0.452,0.275,0.315,3
F,0.62,0.485,0.175,1.271,0.531,0.3075,0.37,3
M,0.63,0.51,0.19,1.4985,0.4125,0.3075,0.545,3
M,0.425,0.34,0.12,0.388,0.149,0.087,0.125,2
F,0.64,0.505,0.19,1.2355,0.4435,0.3105,0.365,3
M,0.675,0.525,0.175,1.402,0.483,0.3205,0.465,3
M,0.5,0.4,0.145,0.6025,0.216,0.138,0.21,3
M,0.385,0.305,0.09,0.2775,0.109,0.0515,0.1,2
M,0.52,0.435,0.195,0.973,0.2985,0.2135,0.355,3
M,0.52,0.415,0.175,0.753,0.258,0.171,0.255,1
M,0.64,0.525,0.2,1.3765,0.44,0.3075,0.47,3
I,0.44,0.35,0.12,0.375,0.1425,0.0965,0.115,2
F,0.42,0.32,0.13,0.4135,0.1645,0.106,0.119,2
F,0.45,0.35,0.135,0.56,0.231,0.137,0.145,3
I,0.42,0.325,0.125,0.3915,0.1575,0.1025,0.115,2
F,0.64,0.505,0.19,1.2765,0.4835,0.328,0.4,3
M,0.57,0.455,0.15,0.96,0.387,0.2385,0.275,3
M,0.41,0.325,0.12,0.3745,0.158,0.081,0.125,3
M,0.485,0.41,0.15,0.696,0.2405,0.1625,0.265,3
F,0.61,0.48,0.19,1.2955,0.5215,0.3225,0.365,3
F,0.59,0.485,0.205,1.2315,0.4525,0.238,0.42,3
M,0.665,0.535,0.155,1.383,0.596,0.2565,0.485,3
I,0.345,0.285,0.1,0.2225,0.0865,0.058,0.075,1
M,0.635,0.51,0.155,1.156,0.428,0.289,0.315,3
M,0.695,0.53,0.15,1.477,0.6375,0.3025,0.43,3
F,0.69,0.54,0.185,1.5715,0.6935,0.318,0.47,3
M,0.555,0.435,0.135,0.858,0.377,0.1585,0.29,3
M,0.65,0.525,0.19,1.4995,0.6265,0.4005,0.395,3
M,0.635,0.48,0.19,1.467,0.5825,0.303,0.42,3
F,0.655,0.51,0.16,1.092,0.396,0.2825,0.37,3
F,0.69,0.555,0.205,1.8165,0.7785,0.4395,0.515,3
F,0.695,0.55,0.16,1.6365,0.694,0.3005,0.44,3
M,0.55,0.435,0.16,0.906,0.342,0.219,0.295,3
F,0.61,0.495,0.19,1.213,0.464,0.306,0.365,3
M,0.595,0.5,0.165,1.06,0.402,0.28,0.275,3
M,0.3,0.24,0.09,0.161,0.0725,0.039,0.05,1
F,0.435,0.35,0.125,0.459,0.197,0.1145,0.145,2
I,0.455,0.375,0.125,0.533,0.233,0.106,0.185,1
M,0.48,0.38,0.13,0.6175,0.3,0.142,0.175,3
I,0.43,0.35,0.105,0.366,0.1705,0.0855,0.11,1
F,0.435,0.35,0.105,0.4195,0.194,0.1005,0.13,1
I,0.3,0.23,0.075,0.15,0.0605,0.042,0.045,1
F,0.575,0.48,0.15,0.8745,0.375,0.193,0.29,3
M,0.505,0.385,0.11,0.655,0.3185,0.15,0.185,2
M,0.455,0.375,0.125,0.484,0.2155,0.102,0.165,1
M,0.64,0.505,0.165,1.4435,0.6145,0.3035,0.39,3
F,0.56,0.435,0.125,0.8775,0.3345,0.2145,0.29,3
F,0.645,0.52,0.19,1.3105,0.58,0.288,0.37,3
F,0.595,0.485,0.145,1.2515,0.5035,0.2925,0.33,3
M,0.565,0.45,0.115,0.9085,0.398,0.197,0.29,3
F,0.655,0.5,0.14,1.1705,0.5405,0.3175,0.285,3
M,0.48,0.38,0.135,0.528,0.2,0.1395,0.16,3
F,0.495,0.385,0.135,0.6625,0.3005,0.1635,0.185,3
F,0.4,0.335,0.115,0.4335,0.2105,0.1205,0.12,2
M,0.41,0.31,0.125,0.3595,0.1415,0.0885,0.115,3
F,0.595,0.465,0.145,1.107,0.402,0.2415,0.31,3
F,0.625,0.475,0.13,0.8595,0.3195,0.1775,0.24,3
M,0.52,0.425,0.155,0.7735,0.297,0.123,0.255,3
M,0.465,0.36,0.125,0.4365,0.169,0.1075,0.145,3
F,0.475,0.375,0.14,0.501,0.192,0.1175,0.175,3
F,0.5,0.405,0.14,0.6735,0.265,0.124,0.25,3
M,0.46,0.355,0.11,0.415,0.215,0.082,0.13,3
M,0.485,0.385,0.125,0.4775,0.2,0.0785,0.17,3
F,0.465,0.39,0.14,0.5555,0.213,0.1075,0.215,3
M,0.525,0.415,0.16,0.6445,0.26,0.1575,0.22,3
F,0.655,0.53,0.19,1.428,0.493,0.318,0.565,3
M,0.69,0.54,0.185,1.6195,0.533,0.353,0.555,3
M,0.55,0.45,0.17,0.81,0.317,0.157,0.22,3
F,0.58,0.475,0.165,1.0385,0.414,0.26,0.305,3
F,0.59,0.475,0.155,0.9715,0.371,0.235,0.28,3
M,0.565,0.44,0.155,0.868,0.348,0.217,0.26,3
F,0.665,0.57,0.185,1.522,0.6965,0.3025,0.405,3
F,0.62,0.51,0.175,1.1255,0.4985,0.227,0.315,3
M,0.55,0.46,0.13,0.7085,0.305,0.1455,0.205,3
F,0.605,0.475,0.145,1.0185,0.4695,0.225,0.27,3
M,0.535,0.42,0.16,0.72,0.275,0.164,0.225,3
F,0.51,0.395,0.12,0.6175,0.262,0.122,0.193,3
M,0.53,0.405,0.13,0.738,0.2845,0.17,0.193,2
F,0.495,0.375,0.15,0.597,0.2615,0.135,0.178,3
M,0.575,0.455,0.185,1.156,0.5525,0.243,0.295,3
F,0.63,0.5,0.16,1.22,0.4905,0.3,0.345,3
M,0.59,0.45,0.12,0.7485,0.3345,0.1315,0.22,3
F,0.605,0.485,0.165,1.0735,0.437,0.205,0.33,3
M,0.645,0.5,0.19,1.229,0.524,0.278,0.395,3
F,0.62,0.5,0.175,1.146,0.477,0.23,0.39,3
M,0.605,0.485,0.175,1.145,0.4325,0.27,0.405,3
F,0.615,0.5,0.205,1.1055,0.4445,0.227,0.39,3
F,0.66,0.525,0.19,1.67,0.6525,0.4875,0.49,3
F,0.71,0.575,0.175,1.555,0.6465,0.3705,0.52,3
F,0.565,0.45,0.185,0.9285,0.302,0.1805,0.265,3
F,0.57,0.435,0.14,0.8085,0.3235,0.183,0.22,3
I,0.6,0.445,0.175,1.057,0.383,0.216,0.355,3
I,0.41,0.3,0.115,0.2595,0.097,0.0515,0.08,2
F,0.45,0.325,0.135,0.438,0.1805,0.1165,0.11,2
M,0.275,0.2,0.08,0.099,0.037,0.024,0.03,1
I,0.485,0.355,0.12,0.5085,0.21,0.122,0.135,2
F,0.62,0.485,0.165,1.166,0.483,0.238,0.355,3
F,0.48,0.38,0.135,0.507,0.1915,0.1365,0.155,3
F,0.505,0.41,0.15,0.6345,0.243,0.1335,0.215,3
M,0.4,0.31,0.11,0.314,0.138,0.057,0.1,3
I,0.45,0.355,0.115,0.4385,0.184,0.108,0.1125,3
M,0.35,0.26,0.09,0.195,0.0745,0.041,0.0655,2
M,0.44,0.35,0.14,0.451,0.171,0.0705,0.184,3
M,0.265,0.2,0.065,0.084,0.034,0.0105,0.03,1
M,0.165,0.125,0.04,0.0245,0.0095,0.0045,0.008,1
F,0.705,0.555,0.2,1.4685,0.4715,0.3235,0.52,3
F,0.535,0.425,0.155,0.7765,0.302,0.1565,0.25,3
I,0.49,0.385,0.14,0.5425,0.198,0.127,0.175,3
F,0.48,0.37,0.13,0.5885,0.2475,0.1505,0.1595,3
F,0.395,0.3,0.105,0.3375,0.1435,0.0755,0.098,3
I,0.375,0.28,0.1,0.2565,0.1165,0.0585,0.0725,3
M,0.345,0.265,0.09,0.163,0.0615,0.037,0.0485,2
I,0.55,0.415,0.135,0.8095,0.2985,0.2015,0.28,3
I,0.635,0.48,0.2,1.3655,0.6255,0.2595,0.425,3
I,0.575,0.475,0.17,0.967,0.3775,0.284,0.275,3
F,0.545,0.435,0.15,0.6855,0.2905,0.145,0.225,2
F,0.385,0.305,0.125,0.314,0.146,0.0555,0.08,2
F,0.51,0.34,0.18,0.7005,0.312,0.165,0.2,3
I,0.44,0.34,0.125,0.4895,0.1735,0.0875,0.2,3
I,0.45,0.36,0.125,0.45,0.191,0.0865,0.145,3
I,0.39,0.3,0.105,0.259,0.0955,0.038,0.085,1
F,0.425,0.325,0.135,0.382,0.1465,0.079,0.14,3
F,0.45,0.35,0.125,0.4435,0.185,0.09,0.145,3
I,0.66,0.525,0.18,1.6935,0.6025,0.4005,0.42,3
F,0.685,0.525,0.175,1.71,0.5415,0.309,0.58,3
F,0.585,0.475,0.185,0.8575,0.3465,0.1785,0.275,3
I,0.54,0.435,0.145,0.97,0.4285,0.22,0.264,3
F,0.49,0.39,0.135,0.59,0.215,0.125,0.1845,3
M,0.43,0.33,0.095,0.34,0.1315,0.085,0.112,3
F,0.455,0.365,0.11,0.385,0.166,0.046,0.1345,3
I,0.495,0.38,0.145,0.515,0.175,0.098,0.212,3
F,0.48,0.38,0.145,0.59,0.232,0.141,0.23,3
I,0.47,0.4,0.16,0.51,0.1615,0.073,0.198,3
M,0.415,0.32,0.1,0.3005,0.1215,0.0575,0.104,3
I,0.49,0.385,0.115,0.683,0.3265,0.1615,0.165,3
I,0.47,0.375,0.105,0.468,0.1665,0.108,0.17,2
I,0.445,0.345,0.13,0.4075,0.1365,0.0645,0.18,3
F,0.51,0.38,0.13,0.584,0.224,0.1355,0.185,3
F,0.52,0.405,0.145,0.829,0.3535,0.1685,0.205,3
I,0.475,0.365,0.14,0.4545,0.171,0.118,0.158,1
F,0.455,0.36,0.11,0.4385,0.206,0.098,0.125,2
I,0.435,0.34,0.11,0.407,0.1685,0.073,0.13,2
I,0.39,0.3,0.1,0.3085,0.1385,0.0735,0.085,1
I,0.375,0.285,0.1,0.239,0.105,0.0555,0.07,1
M,0.285,0.215,0.075,0.106,0.0415,0.023,0.035,1
I,0.58,0.445,0.17,1.178,0.3935,0.2165,0.315,3
F,0.58,0.44,0.175,1.073,0.4005,0.2345,0.335,3
M,0.41,0.315,0.095,0.306,0.121,0.0735,0.09,2
M,0.41,0.3,0.1,0.301,0.124,0.069,0.09,2
I,0.54,0.405,0.15,0.7585,0.307,0.2075,0.19,2
M,0.33,0.245,0.085,0.171,0.0655,0.0365,0.055,3
I,0.44,0.31,0.115,0.3625,0.134,0.082,0.12,3
M,0.28,0.21,0.065,0.0905,0.035,0.02,0.03,1
I,0.59,0.465,0.195,1.0885,0.3685,0.187,0.375,3
I,0.61,0.48,0.165,1.097,0.4215,0.264,0.335,3
I,0.61,0.46,0.17,1.278,0.41,0.257,0.37,3
M,0.455,0.345,0.125,0.44,0.169,0.1065,0.135,3
M,0.33,0.235,0.09,0.163,0.0615,0.034,0.055,2
I,0.44,0.33,0.135,0.522,0.17,0.0905,0.195,3
M,0.54,0.405,0.155,0.9715,0.3225,0.194,0.29,3
F,0.475,0.375,0.125,0.588,0.237,0.1715,0.155,2
F,0.46,0.33,0.15,0.5325,0.2085,0.1805,0.125,2
I,0.31,0.235,0.09,0.127,0.048,0.031,0.04,1
I,0.255,0.19,0.07,0.0815,0.028,0.016,0.031,1
M,0.335,0.255,0.075,0.1635,0.0615,0.0345,0.057,1
I,0.295,0.21,0.08,0.1,0.038,0.026,0.031,1
I,0.19,0.13,0.045,0.0265,0.009,0.005,0.009,1
M,0.545,0.435,0.165,0.9955,0.3245,0.2665,0.325,3
M,0.495,0.4,0.12,0.6605,0.2605,0.161,0.19,3
M,0.5,0.375,0.13,0.721,0.3055,0.1725,0.22,3
F,0.305,0.225,0.07,0.1485,0.0585,0.0335,0.045,1
F,0.475,0.35,0.115,0.487,0.194,0.1455,0.125,3
M,0.515,0.4,0.125,0.955,0.341,0.2535,0.26,3
M,0.545,0.41,0.145,0.873,0.3035,0.196,0.31,3
M,0.74,0.535,0.185,1.65,0.734,0.4505,0.335,3
M,0.565,0.465,0.15,1.1285,0.377,0.3525,0.33,3
M,0.56,0.44,0.16,1.1115,0.5035,0.2785,0.26,2
M,0.545,0.42,0.125,0.9745,0.353,0.174,0.305,3
M,0.645,0.515,0.185,1.4605,0.5835,0.3155,0.41,3
M,0.575,0.435,0.13,1.0105,0.368,0.222,0.32,2
M,0.62,0.48,0.16,1.0765,0.412,0.253,0.3,3
F,0.605,0.45,0.165,1.2225,0.357,0.202,0.385,3
M,0.605,0.475,0.16,1.616,0.5495,0.332,0.34,3
F,0.475,0.375,0.15,0.559,0.1955,0.1215,0.1945,3
M,0.365,0.285,0.085,0.2205,0.0855,0.0515,0.07,2
F,0.46,0.35,0.115,0.44,0.19,0.1025,0.13,1
M,0.53,0.43,0.135,0.879,0.28,0.2165,0.25,2
M,0.48,0.395,0.15,0.6815,0.2145,0.1405,0.2495,3
M,0.455,0.345,0.15,0.5795,0.1685,0.125,0.215,3
I,0.35,0.265,0.11,0.209,0.066,0.059,0.075,2
M,0.37,0.28,0.105,0.224,0.0815,0.0575,0.075,1
I,0.34,0.25,0.075,0.1765,0.0785,0.0405,0.05,1
I,0.35,0.28,0.075,0.196,0.082,0.04,0.064,1
I,0.35,0.265,0.08,0.192,0.081,0.0465,0.053,1
I,0.39,0.315,0.09,0.3095,0.147,0.05,0.09,1
I,0.395,0.31,0.095,0.313,0.131,0.072,0.093,1
I,0.415,0.31,0.105,0.3595,0.167,0.083,0.0915,1
I,0.43,0.32,0.1,0.3855,0.192,0.0745,0.1,1
I,0.48,0.355,0.115,0.5785,0.25,0.106,0.184,1
M,0.49,0.395,0.12,0.674,0.3325,0.1235,0.185,2
F,0.49,0.37,0.105,0.5265,0.249,0.1005,0.148,1
F,0.56,0.465,0.16,1.0315,0.432,0.2025,0.337,2
M,0.56,0.45,0.14,0.9,0.472,0.182,0.218,1
M,0.58,0.46,0.15,1.0165,0.491,0.221,0.265,2
F,0.58,0.48,0.18,1.2495,0.4945,0.27,0.371,1
M,0.59,0.47,0.135,1.1685,0.539,0.279,0.28,1
F,0.595,0.475,0.165,1.148,0.444,0.214,0.37,2
M,0.6,0.475,0.15,1.089,0.5195,0.223,0.292,3
M,0.61,0.47,0.155,1.0325,0.497,0.2175,0.2785,2
F,0.63,0.475,0.15,1.172,0.536,0.254,0.316,3
M,0.64,0.51,0.17,1.3715,0.567,0.307,0.409,2
F,0.65,0.545,0.185,1.5055,0.6565,0.341,0.43,2
M,0.71,0.55,0.2,1.9045,0.882,0.44,0.5,3
M,0.74,0.605,0.2,2.4925,1.1455,0.575,0.5235,3
I,0.25,0.18,0.065,0.0805,0.0345,0.0185,0.0215,1
I,0.28,0.21,0.065,0.111,0.0425,0.0285,0.03,1
I,0.325,0.24,0.075,0.152,0.065,0.0305,0.045,1
I,0.35,0.265,0.095,0.199,0.073,0.049,0.06,1
I,0.36,0.27,0.09,0.219,0.097,0.0405,0.065,1
I,0.365,0.27,0.105,0.2155,0.0915,0.0475,0.063,1
I,0.37,0.28,0.09,0.2565,0.1255,0.0645,0.0645,1
I,0.375,0.285,0.09,0.257,0.1045,0.062,0.075,1
I,0.38,0.275,0.095,0.2505,0.0945,0.0655,0.075,1
I,0.395,0.3,0.09,0.279,0.134,0.049,0.075,1
I,0.43,0.335,0.105,0.378,0.188,0.0785,0.09,1
I,0.44,0.35,0.125,0.456,0.21,0.0955,0.131,1
I,0.465,0.37,0.1,0.5055,0.234,0.11,0.14,1
F,0.465,0.355,0.115,0.4705,0.1955,0.118,0.126,1
M,0.48,0.37,0.13,0.643,0.349,0.1155,0.135,1
I,0.485,0.37,0.1,0.513,0.219,0.1075,0.13,1
F,0.49,0.4,0.115,0.569,0.256,0.1325,0.145,2
I,0.495,0.4,0.145,0.578,0.2545,0.1305,0.1645,1
I,0.5,0.385,0.11,0.596,0.3015,0.104,0.151,1
F,0.505,0.39,0.12,0.5725,0.2555,0.1325,0.146,1
M,0.52,0.39,0.12,0.6435,0.2885,0.157,0.161,1
M,0.52,0.395,0.125,0.8115,0.4035,0.166,0.2,1
F,0.525,0.44,0.125,0.7115,0.3205,0.159,0.1915,1
M,0.55,0.44,0.155,0.9155,0.3645,0.195,0.25,1
F,0.555,0.44,0.145,0.8815,0.43,0.1975,0.2155,1
F,0.555,0.42,0.11,0.931,0.4445,0.171,0.225,1
F,0.575,0.46,0.165,1.065,0.4985,0.2145,0.2815,1
M,0.6,0.475,0.155,1.1385,0.502,0.2295,0.31,2
F,0.61,0.48,0.16,1.234,0.598,0.238,0.315,3
F,0.61,0.495,0.175,1.2635,0.53,0.315,0.3455,2
F,0.61,0.47,0.16,1.0745,0.4925,0.236,0.29,1
M,0.615,0.505,0.19,1.403,0.6715,0.2925,0.365,1
M,0.62,0.485,0.165,1.1325,0.5235,0.2505,0.2825,2
F,0.625,0.495,0.16,1.1115,0.4495,0.2825,0.345,3
F,0.625,0.47,0.17,1.255,0.525,0.2415,0.405,2
M,0.625,0.485,0.17,1.437,0.5855,0.293,0.475,3
M,0.635,0.495,0.155,1.3635,0.583,0.2985,0.295,2
F,0.64,0.48,0.195,1.1435,0.4915,0.2345,0.353,2
M,0.64,0.5,0.17,1.4545,0.642,0.3575,0.354,2
M,0.66,0.525,0.18,1.478,0.5815,0.381,0.372,2
F,0.665,0.52,0.165,1.6885,0.7295,0.407,0.4265,3
F,0.715,0.585,0.23,2.0725,0.8655,0.4095,0.565,2
M,0.72,0.565,0.2,1.787,0.718,0.385,0.529,3
F,0.725,0.58,0.185,1.523,0.8045,0.3595,0.4375,2
I,0.165,0.12,0.05,0.021,0.0075,0.0045,0.014,1
I,0.21,0.15,0.055,0.0455,0.02,0.0065,0.013,1
I,0.355,0.265,0.085,0.2435,0.122,0.0525,0.06,1
I,0.4,0.315,0.085,0.2675,0.116,0.0585,0.0765,1
I,0.4,0.29,0.1,0.258,0.104,0.059,0.0815,1
I,0.4,0.3,0.11,0.2985,0.1375,0.071,0.075,1
I,0.435,0.335,0.11,0.411,0.2025,0.0945,0.1,1
I,0.44,0.33,0.11,0.38,0.197,0.079,0.09,1
I,0.45,0.34,0.105,0.4385,0.21,0.0925,0.12,1
I,0.465,0.345,0.105,0.4015,0.242,0.0345,0.109,1
I,0.47,0.355,0.145,0.4485,0.156,0.102,0.123,1
I,0.47,0.355,0.115,0.4155,0.167,0.084,0.139,1
I,0.475,0.42,0.16,0.7095,0.35,0.1505,0.1845,1
I,0.485,0.37,0.115,0.637,0.38,0.1335,0.128,1
F,0.505,0.475,0.16,1.1155,0.509,0.239,0.3065,1
I,0.51,0.405,0.13,0.599,0.3065,0.1155,0.1485,1
I,0.52,0.38,0.13,0.5345,0.2375,0.122,0.1535,1
F,0.53,0.42,0.14,0.627,0.2905,0.1165,0.183,1
M,0.535,0.42,0.16,0.7465,0.348,0.1515,0.2185,2
M,0.55,0.44,0.16,0.985,0.4645,0.201,0.27,1
M,0.555,0.44,0.145,0.85,0.4165,0.1685,0.23,1
M,0.555,0.44,0.15,0.838,0.4155,0.146,0.23,1
F,0.555,0.43,0.135,0.812,0.4055,0.163,0.2215,2
M,0.56,0.415,0.13,0.7615,0.3695,0.17,0.1955,1
M,0.575,0.44,0.145,0.87,0.3945,0.2195,0.225,1
F,0.585,0.45,0.145,0.9835,0.4845,0.242,0.22,2
M,0.59,0.46,0.145,0.929,0.38,0.24,0.255,2
F,0.595,0.47,0.165,1.0155,0.491,0.1905,0.289,2
M,0.6,0.41,0.145,0.939,0.4475,0.196,0.268,1
M,0.6,0.475,0.16,1.164,0.5045,0.2635,0.335,3
M,0.61,0.47,0.175,1.214,0.5315,0.2835,0.325,2
F,0.615,0.49,0.19,1.1345,0.4695,0.257,0.348,3
F,0.62,0.51,0.18,1.233,0.592,0.274,0.322,2
M,0.625,0.495,0.18,1.0815,0.4715,0.254,0.3135,2
M,0.625,0.47,0.175,1.179,0.605,0.258,0.271,2
F,0.64,0.5,0.165,1.1635,0.554,0.239,0.32,3
F,0.64,0.475,0.175,1.1545,0.4865,0.341,0.288,2
F,0.645,0.52,0.175,1.3345,0.667,0.2665,0.355,2
M,0.65,0.505,0.18,1.469,0.7115,0.3335,0.38,2
M,0.655,0.52,0.18,1.492,0.7185,0.36,0.355,3
F,0.655,0.54,0.175,1.5585,0.7285,0.402,0.385,3
F,0.66,0.5,0.175,1.3275,0.556,0.2805,0.4085,2
M,0.67,0.525,0.18,1.6615,0.8005,0.3645,0.43,2
F,0.69,0.525,0.19,1.492,0.6425,0.3905,0.42,3
F,0.7,0.575,0.2,1.7365,0.7755,0.3965,0.461,3
F,0.7,0.56,0.175,1.6605,0.8605,0.3275,0.398,3
M,0.71,0.57,0.195,1.348,0.8985,0.4435,0.4535,3
M,0.715,0.545,0.18,1.7405,0.871,0.347,0.449,2
F,0.72,0.545,0.185,1.7185,0.7925,0.401,0.468,3
I,0.215,0.15,0.055,0.041,0.015,0.009,0.0125,1
I,0.24,0.185,0.06,0.0655,0.0295,0.0005,0.02,1
I,0.26,0.205,0.07,0.097,0.0415,0.019,0.0305,1
I,0.32,0.24,0.085,0.131,0.0615,0.0265,0.038,1
I,0.33,0.23,0.085,0.1695,0.079,0.026,0.0505,1
I,0.335,0.26,0.085,0.192,0.097,0.03,0.054,1
I,0.35,0.26,0.09,0.1765,0.072,0.0355,0.0575,1
I,0.35,0.265,0.085,0.1735,0.0775,0.034,0.056,1
I,0.36,0.265,0.075,0.1785,0.0785,0.035,0.054,1
I,0.36,0.265,0.09,0.2055,0.096,0.037,0.0585,1
I,0.365,0.275,0.09,0.2345,0.108,0.051,0.0625,1
I,0.38,0.285,0.09,0.2305,0.1005,0.039,0.0775,1
I,0.4,0.31,0.115,0.314,0.1545,0.0595,0.087,1
I,0.4,0.315,0.09,0.33,0.151,0.068,0.08,1
I,0.4,0.265,0.1,0.2775,0.1245,0.0605,0.08,2
I,0.425,0.325,0.11,0.405,0.1695,0.092,0.1065,1
I,0.43,0.325,0.105,0.309,0.119,0.08,0.098,1
M,0.435,0.335,0.11,0.4385,0.2075,0.0715,0.1315,1
I,0.435,0.34,0.12,0.396,0.1775,0.081,0.125,1
I,0.445,0.355,0.095,0.3615,0.1415,0.0785,0.12,1
I,0.45,0.35,0.11,0.514,0.253,0.1045,0.14,1
I,0.455,0.435,0.11,0.4265,0.195,0.09,0.1205,1
I,0.46,0.34,0.09,0.384,0.1795,0.068,0.11,1
I,0.475,0.355,0.125,0.4865,0.2155,0.1105,0.142,2
I,0.475,0.36,0.135,0.4355,0.196,0.0925,0.125,1
I,0.475,0.35,0.115,0.498,0.2375,0.099,0.14,1
I,0.48,0.355,0.125,0.494,0.2385,0.0835,0.15,2
F,0.495,0.37,0.12,0.594,0.28,0.11,0.1375,1
I,0.5,0.365,0.125,0.528,0.229,0.103,0.1645,2
M,0.505,0.39,0.115,0.5585,0.2575,0.119,0.1535,1
I,0.515,0.4,0.135,0.636,0.3055,0.1215,0.1855,2
I,0.525,0.39,0.105,0.567,0.2875,0.1075,0.16,1
I,0.53,0.405,0.13,0.6615,0.2945,0.1395,0.19,2
I,0.53,0.42,0.13,0.658,0.296,0.1245,0.198,1
M,0.535,0.415,0.135,0.78,0.3165,0.169,0.2365,1
I,0.535,0.41,0.13,0.6075,0.268,0.1225,0.1975,2
I,0.54,0.41,0.135,0.7025,0.31,0.177,0.2,1
I,0.55,0.425,0.155,0.8725,0.412,0.187,0.2425,2
F,0.565,0.45,0.175,1.2365,0.5305,0.2455,0.308,2
M,0.57,0.47,0.155,1.186,0.6355,0.2315,0.277,2
I,0.57,0.42,0.13,0.7745,0.3535,0.1505,0.2365,2
F,0.57,0.42,0.16,0.8875,0.4315,0.1915,0.223,1
I,0.575,0.455,0.155,0.8725,0.349,0.2095,0.285,1
I,0.575,0.44,0.125,0.8515,0.4555,0.1715,0.1965,2
F,0.575,0.475,0.16,0.895,0.3605,0.221,0.271,2
M,0.575,0.45,0.155,0.886,0.3605,0.211,0.2575,2
I,0.58,0.46,0.14,0.9265,0.4135,0.1845,0.27,2
I,0.58,0.46,0.14,0.8295,0.3915,0.165,0.238,2
I,0.58,0.47,0.15,0.907,0.444,0.1855,0.2445,3
M,0.58,0.47,0.165,1.041,0.54,0.166,0.279,2
F,0.585,0.465,0.165,0.9355,0.4035,0.2275,0.259,2
F,0.585,0.46,0.165,1.058,0.486,0.25,0.294,2
F,0.595,0.465,0.145,0.7955,0.3425,0.1795,0.2425,2
F,0.6,0.47,0.17,1.0805,0.4995,0.2245,0.3205,2
M,0.6,0.47,0.15,0.928,0.4225,0.183,0.275,1
F,0.6,0.475,0.155,1.059,0.441,0.19,0.39,3
M,0.6,0.475,0.23,1.157,0.522,0.2235,0.36,3
F,0.6,0.475,0.17,1.088,0.4905,0.2475,0.31,2
F,0.6,0.485,0.145,0.776,0.3545,0.1585,0.239,2
F,0.62,0.48,0.165,1.043,0.4835,0.221,0.31,2
M,0.625,0.48,0.16,1.1415,0.5795,0.2145,0.29,2
F,0.625,0.475,0.16,1.3335,0.605,0.2875,0.319,2
F,0.625,0.5,0.175,1.273,0.564,0.302,0.374,2
M,0.625,0.49,0.165,1.1835,0.517,0.2375,0.39,3
M,0.625,0.485,0.16,1.2135,0.631,0.2235,0.302,2
I,0.63,0.465,0.15,1.0315,0.4265,0.24,0.325,3
M,0.635,0.495,0.17,1.3695,0.657,0.3055,0.365,2
M,0.65,0.515,0.185,1.3745,0.75,0.1805,0.369,3
M,0.65,0.515,0.18,1.463,0.658,0.3135,0.4115,3
F,0.65,0.52,0.195,1.6275,0.689,0.3905,0.432,3
F,0.65,0.475,0.165,1.3875,0.58,0.3485,0.3095,2
M,0.655,0.525,0.16,1.46,0.686,0.311,0.405,3
F,0.655,0.53,0.165,1.2835,0.583,0.1255,0.4,1
F,0.66,0.5,0.155,1.3765,0.6485,0.288,0.335,3
M,0.66,0.515,0.2,1.6465,0.749,0.422,0.401,3
M,0.675,0.515,0.145,1.265,0.6025,0.299,0.325,2
M,0.685,0.53,0.17,1.56,0.647,0.383,0.465,3
M,0.715,0.52,0.18,1.6,0.708,0.3525,0.445,3
M,0.735,0.555,0.22,2.333,1.2395,0.3645,0.6195,3
I,0.175,0.125,0.04,0.028,0.0095,0.008,0.009,1
I,0.37,0.285,0.095,0.226,0.1135,0.0515,0.0675,1
I,0.395,0.3,0.09,0.2855,0.1385,0.0625,0.077,1
I,0.42,0.325,0.11,0.325,0.1245,0.0755,0.1025,1
I,0.455,0.37,0.11,0.514,0.2385,0.1235,0.126,1
I,0.495,0.375,0.115,0.5755,0.31,0.1145,0.1395,1
F,0.51,0.375,0.11,0.5805,0.2865,0.118,0.148,1
M,0.515,0.39,0.14,0.678,0.341,0.1325,0.119,1
M,0.545,0.43,0.155,0.8035,0.409,0.144,0.228,1
F,0.555,0.405,0.12,0.913,0.4585,0.196,0.2065,2
M,0.58,0.45,0.16,0.8675,0.3935,0.221,0.215,2
F,0.59,0.465,0.17,1.0425,0.4635,0.24,0.27,2
M,0.6,0.46,0.18,1.14,0.423,0.2575,0.365,2
F,0.61,0.49,0.17,1.3475,0.7045,0.25,0.3045,3
M,0.615,0.475,0.155,1.0735,0.4375,0.2585,0.31,3
M,0.615,0.475,0.19,1.4335,0.7315,0.305,0.3285,2
M,0.615,0.495,0.2,1.304,0.5795,0.3115,0.371,3
M,0.62,0.46,0.16,0.9505,0.4915,0.2,0.228,2
M,0.63,0.515,0.17,1.385,0.6355,0.2955,0.38,3
F,0.64,0.5,0.17,1.12,0.4955,0.2645,0.32,3
F,0.64,0.5,0.17,1.2645,0.565,0.3375,0.315,2
F,0.655,0.455,0.17,1.275,0.583,0.303,0.333,1
M,0.655,0.505,0.165,1.27,0.6035,0.262,0.335,2
M,0.66,0.53,0.175,1.583,0.7395,0.3505,0.405,2
F,0.665,0.5,0.175,1.4355,0.643,0.345,0.37,2
F,0.67,0.525,0.195,1.42,0.573,0.368,0.3905,2
M,0.69,0.53,0.19,1.5955,0.678,0.331,0.48,2
M,0.715,0.525,0.2,1.89,0.95,0.436,0.4305,2
F,0.735,0.565,0.225,2.037,0.87,0.5145,0.5675,3
I,0.27,0.205,0.05,0.084,0.03,0.0185,0.029,1
I,0.285,0.225,0.07,0.1005,0.0425,0.0185,0.035,1
I,0.295,0.22,0.085,0.1285,0.0585,0.027,0.0365,1
I,0.3,0.225,0.075,0.1345,0.057,0.028,0.044,1
I,0.3,0.22,0.065,0.1195,0.052,0.0155,0.035,1
I,0.36,0.265,0.085,0.1895,0.0725,0.0515,0.055,1
I,0.37,0.275,0.095,0.257,0.1015,0.055,0.0825,1
I,0.39,0.29,0.09,0.2745,0.135,0.0455,0.078,1
I,0.435,0.325,0.1,0.342,0.1335,0.0835,0.105,1
I,0.44,0.34,0.105,0.344,0.123,0.081,0.125,1
I,0.44,0.32,0.095,0.3275,0.1495,0.059,0.1,1
I,0.445,0.345,0.12,0.4035,0.169,0.0825,0.13,1
I,0.465,0.37,0.115,0.4075,0.1515,0.0935,0.1455,2
I,0.465,0.355,0.12,0.4975,0.2375,0.099,0.14,1
I,0.47,0.345,0.12,0.3685,0.1525,0.0615,0.125,1
I,0.475,0.365,0.105,0.4175,0.1645,0.099,0.127,1
I,0.475,0.335,0.1,0.4425,0.1895,0.086,0.135,2
I,0.475,0.35,0.125,0.4225,0.1905,0.079,0.1355,2
I,0.485,0.365,0.125,0.426,0.163,0.0965,0.151,1
I,0.49,0.39,0.12,0.511,0.2205,0.103,0.1745,2
I,0.515,0.405,0.13,0.573,0.213,0.134,0.195,2
I,0.52,0.415,0.14,0.6385,0.2945,0.1405,0.171,1
I,0.525,0.405,0.125,0.657,0.2985,0.1505,0.168,2
F,0.525,0.425,0.14,0.8735,0.4205,0.182,0.2225,2
I,0.53,0.425,0.13,0.781,0.3905,0.2005,0.215,2
I,0.53,0.42,0.14,0.6765,0.256,0.1855,0.208,2
M,0.53,0.41,0.125,0.769,0.346,0.173,0.215,2
I,0.53,0.395,0.125,0.6235,0.2975,0.108,0.195,3
M,0.535,0.405,0.14,0.7315,0.336,0.156,0.19,1
I,0.535,0.45,0.155,0.8075,0.3655,0.148,0.2595,2
M,0.545,0.41,0.14,0.737,0.349,0.15,0.212,2
F,0.545,0.41,0.125,0.654,0.2945,0.1315,0.205,2
I,0.55,0.415,0.15,0.7915,0.3535,0.176,0.236,2
I,0.55,0.45,0.14,0.753,0.3445,0.1325,0.24,1
I,0.55,0.4,0.135,0.717,0.3315,0.1495,0.221,2
I,0.555,0.43,0.15,0.783,0.345,0.1755,0.247,2
I,0.575,0.45,0.145,0.872,0.4675,0.18,0.217,2
I,0.575,0.44,0.15,0.983,0.486,0.215,0.239,1
F,0.585,0.42,0.155,1.034,0.437,0.2225,0.32,3
F,0.585,0.465,0.145,0.9855,0.4325,0.2145,0.2845,2
I,0.585,0.46,0.14,0.7635,0.326,0.153,0.265,2
M,0.59,0.465,0.135,0.9895,0.4235,0.199,0.28,1
I,0.595,0.47,0.135,0.9365,0.434,0.184,0.287,2
F,0.595,0.44,0.135,0.964,0.5005,0.1715,0.2575,2
F,0.595,0.46,0.155,1.0455,0.4565,0.24,0.3085,2
F,0.595,0.45,0.165,1.081,0.49,0.2525,0.279,3
M,0.6,0.47,0.16,1.012,0.441,0.2015,0.305,2
F,0.6,0.5,0.16,1.122,0.5095,0.256,0.309,2
M,0.605,0.49,0.165,1.1245,0.492,0.222,0.3555,3
F,0.605,0.49,0.15,1.1345,0.4305,0.2525,0.35,2
M,0.61,0.45,0.19,1.0805,0.517,0.2495,0.2935,2
F,0.61,0.495,0.165,1.0835,0.4525,0.273,0.317,2
M,0.615,0.47,0.175,1.242,0.5675,0.287,0.317,3
M,0.62,0.5,0.18,1.3915,0.726,0.2795,0.332,3
M,0.62,0.525,0.155,1.085,0.454,0.1965,0.35,2
I,0.62,0.47,0.155,0.966,0.447,0.171,0.284,3
M,0.62,0.48,0.165,1.0855,0.481,0.2575,0.305,2
F,0.625,0.485,0.135,1.3025,0.61,0.2675,0.3605,3
I,0.625,0.485,0.16,1.15,0.5255,0.257,0.3315,3
I,0.63,0.49,0.17,1.217,0.5515,0.212,0.31,3
F,0.63,0.505,0.195,1.306,0.516,0.3305,0.375,2
M,0.64,0.5,0.175,1.273,0.5065,0.2925,0.405,3
M,0.645,0.51,0.19,1.4865,0.6445,0.296,0.425,3
M,0.65,0.52,0.17,1.3655,0.6155,0.2885,0.36,3
M,0.65,0.495,0.17,1.276,0.6215,0.2305,0.399,3
M,0.65,0.495,0.16,1.2075,0.55,0.2695,0.32,2
F,0.65,0.52,0.195,1.281,0.5985,0.246,0.3825,2
M,0.65,0.525,0.205,1.4275,0.69,0.306,0.4355,3
M,0.65,0.51,0.175,1.155,0.4955,0.2025,0.385,3
F,0.65,0.51,0.175,1.35,0.575,0.3155,0.3885,2
M,0.65,0.525,0.19,1.3685,0.5975,0.296,0.4,3
F,0.66,0.53,0.17,1.431,0.622,0.309,0.398,2
M,0.66,0.51,0.18,1.261,0.5,0.2335,0.339,2
F,0.665,0.54,0.195,1.764,0.8505,0.3615,0.47,3
F,0.67,0.51,0.155,1.278,0.5605,0.3045,0.358,3
M,0.67,0.54,0.195,1.217,0.532,0.2735,0.3315,3
F,0.67,0.54,0.2,1.46,0.6435,0.328,0.4165,2
F,0.675,0.535,0.185,1.5575,0.7035,0.402,0.4,3
M,0.675,0.51,0.17,1.527,0.809,0.318,0.341,3
F,0.675,0.53,0.195,1.4985,0.62,0.375,0.425,2
M,0.685,0.55,0.19,1.885,0.89,0.41,0.4895,2
M,0.685,0.535,0.175,1.432,0.637,0.247,0.46,3
M,0.705,0.55,0.21,1.4385,0.655,0.3255,0.462,3
F,0.705,0.53,0.17,1.564,0.612,0.394,0.44,2
M,0.71,0.555,0.175,2.14,1.2455,0.3725,0.434,3
F,0.725,0.56,0.185,1.792,0.873,0.367,0.435,3
M,0.78,0.6,0.21,2.548,1.1945,0.5745,0.6745,3
I,0.235,0.13,0.075,0.1585,0.0685,0.037,0.0465,1
I,0.35,0.25,0.1,0.4015,0.1725,0.063,0.1255,1
I,0.36,0.25,0.115,0.465,0.21,0.1055,0.128,1
I,0.38,0.28,0.095,0.2885,0.165,0.0435,0.067,1
F,0.38,0.32,0.115,0.6475,0.323,0.1325,0.164,1
M,0.43,0.31,0.13,0.6485,0.2735,0.163,0.184,2
I,0.465,0.36,0.105,0.452,0.22,0.159,0.1035,2
I,0.47,0.355,0.12,0.4915,0.1765,0.1125,0.1325,2
F,0.485,0.365,0.15,0.9145,0.4145,0.199,0.273,1
M,0.495,0.375,0.155,0.976,0.45,0.2285,0.2475,2
I,0.5,0.395,0.145,0.7865,0.332,0.1815,0.2455,1
M,0.505,0.4,0.15,0.775,0.3445,0.157,0.185,1
I,0.51,0.375,0.15,0.8415,0.3845,0.156,0.255,2
M,0.51,0.38,0.135,0.681,0.3435,0.142,0.17,2
M,0.515,0.37,0.115,0.6145,0.3415,0.155,0.146,2
F,0.55,0.415,0.18,1.1655,0.502,0.301,0.311,2
F,0.575,0.42,0.19,1.764,0.914,0.377,0.4095,2
M,0.605,0.455,0.16,1.1215,0.533,0.273,0.271,2
M,0.615,0.505,0.165,1.167,0.4895,0.2955,0.345,2
M,0.615,0.475,0.15,1.0375,0.476,0.2325,0.283,2
M,0.625,0.48,0.18,1.223,0.565,0.2975,0.3375,2
M,0.625,0.47,0.15,1.124,0.556,0.2315,0.287,2
F,0.635,0.505,0.17,1.2635,0.512,0.322,0.355,2
F,0.65,0.525,0.165,1.238,0.647,0.2485,0.3005,2
F,0.65,0.5,0.17,1.4045,0.694,0.318,0.3235,3
F,0.67,0.525,0.195,1.37,0.6065,0.2955,0.407,3
F,0.695,0.525,0.205,1.8185,0.819,0.4025,0.4525,3
F,0.705,0.555,0.195,1.7525,0.7105,0.4215,0.516,3
I,0.275,0.205,0.065,0.101,0.041,0.021,0.034,1
I,0.285,0.205,0.07,0.106,0.039,0.0285,0.034,1
I,0.36,0.265,0.085,0.1865,0.0675,0.037,0.0615,1
I,0.385,0.29,0.1,0.2575,0.1,0.061,0.086,1
I,0.4,0.315,0.1,0.3225,0.143,0.0735,0.091,1
I,0.43,0.33,0.095,0.32,0.118,0.065,0.123,1
I,0.435,0.375,0.11,0.4155,0.17,0.076,0.145,1
I,0.45,0.335,0.115,0.3935,0.195,0.071,0.11,1
I,0.475,0.355,0.135,0.4775,0.2145,0.09,0.1435,1
I,0.475,0.36,0.11,0.452,0.191,0.099,0.13,1
I,0.485,0.37,0.14,0.5065,0.2425,0.088,0.1465,1
I,0.51,0.395,0.105,0.5525,0.234,0.127,0.165,1
I,0.515,0.39,0.12,0.565,0.235,0.135,0.179,2
I,0.52,0.41,0.14,0.699,0.3395,0.129,0.1945,2
I,0.525,0.4,0.14,0.6055,0.2605,0.108,0.21,2
M,0.53,0.425,0.155,0.7905,0.307,0.171,0.2595,2
M,0.53,0.425,0.13,0.702,0.2975,0.1395,0.22,2
M,0.53,0.42,0.135,0.675,0.294,0.156,0.1825,2
I,0.53,0.395,0.115,0.475,0.2025,0.101,0.148,1
I,0.53,0.41,0.15,0.612,0.2435,0.1525,0.1895,3
I,0.535,0.4,0.145,0.705,0.3065,0.1365,0.22,2
I,0.535,0.45,0.135,0.728,0.2845,0.1845,0.265,2
F,0.555,0.44,0.14,0.846,0.346,0.1715,0.2735,2
M,0.555,0.46,0.16,0.86,0.3345,0.1935,0.275,2
M,0.56,0.465,0.145,0.8875,0.3345,0.22,0.2695,2
F,0.56,0.43,0.145,0.898,0.3895,0.2325,0.245,2
I,0.565,0.43,0.125,0.6545,0.2815,0.139,0.21,2
I,0.575,0.45,0.145,0.795,0.364,0.1505,0.26,2
M,0.575,0.465,0.12,1.0535,0.516,0.2185,0.235,2
F,0.575,0.46,0.15,0.927,0.333,0.207,0.2985,2
I,0.58,0.42,0.14,0.701,0.3285,0.102,0.2255,2
M,0.58,0.45,0.155,0.8275,0.321,0.1975,0.2445,1
F,0.585,0.42,0.155,0.9845,0.442,0.2155,0.2875,3
M,0.585,0.47,0.145,0.9565,0.4025,0.2365,0.265,2
I,0.59,0.45,0.125,0.86,0.437,0.1515,0.245,2
M,0.595,0.48,0.185,1.1785,0.526,0.2975,0.314,2
M,0.615,0.48,0.185,1.2205,0.4985,0.315,0.33,2
M,0.615,0.455,0.13,0.9685,0.49,0.182,0.2655,2
F,0.62,0.5,0.175,1.107,0.4895,0.24,0.343,3
I,0.62,0.48,0.18,1.1305,0.5285,0.2655,0.306,3
M,0.62,0.48,0.155,1.2555,0.527,0.374,0.3175,3
M,0.625,0.495,0.155,1.177,0.5055,0.278,0.345,2
M,0.625,0.5,0.185,1.2425,0.5995,0.248,0.335,2
M,0.63,0.49,0.16,1.09,0.407,0.224,0.354,3
F,0.63,0.475,0.15,1.072,0.433,0.2975,0.315,1
F,0.645,0.51,0.155,1.129,0.5015,0.24,0.342,2
F,0.65,0.505,0.175,1.2075,0.5105,0.262,0.39,2
F,0.65,0.495,0.175,1.227,0.528,0.258,0.37,3
F,0.655,0.52,0.175,1.472,0.6275,0.27,0.45,3
F,0.665,0.525,0.18,1.5785,0.678,0.229,0.456,3
M,0.67,0.52,0.175,1.4755,0.6275,0.379,0.374,2
M,0.675,0.54,0.175,1.5545,0.6645,0.278,0.512,3
F,0.675,0.54,0.21,1.593,0.686,0.318,0.45,3
M,0.695,0.58,0.2,1.8995,0.675,0.478,0.5295,3
F,0.695,0.535,0.175,1.361,0.5465,0.2815,0.465,2
F,0.705,0.56,0.17,1.4575,0.607,0.318,0.44,3
M,0.74,0.58,0.205,2.381,0.8155,0.4695,0.488,3
I,0.205,0.155,0.045,0.0495,0.0235,0.011,0.014,1
I,0.305,0.23,0.075,0.1455,0.0595,0.0305,0.05,1
I,0.32,0.23,0.06,0.129,0.0615,0.0275,0.0355,1
I,0.355,0.27,0.1,0.2255,0.11,0.042,0.064,1
M,0.425,0.305,0.11,0.359,0.173,0.0875,0.0975,2
I,0.425,0.31,0.095,0.3505,0.1645,0.071,0.1,1
F,0.45,0.365,0.115,0.5885,0.318,0.121,0.1325,1
M,0.515,0.385,0.13,0.623,0.2855,0.1285,0.175,2
F,0.52,0.375,0.135,0.5375,0.221,0.117,0.17,1
I,0.525,0.4,0.125,0.5655,0.2435,0.119,0.175,1
M,0.555,0.445,0.13,0.8625,0.4225,0.155,0.24,2
F,0.61,0.49,0.17,1.137,0.4605,0.2825,0.344,3
I,0.35,0.26,0.095,0.221,0.0985,0.043,0.07,1
I,0.38,0.275,0.095,0.2425,0.106,0.0485,0.21,1
I,0.46,0.34,0.1,0.386,0.1805,0.0875,0.0965,1
M,0.465,0.355,0.12,0.5315,0.2725,0.097,0.1395,1
M,0.475,0.385,0.12,0.562,0.289,0.0905,0.153,1
M,0.565,0.445,0.14,0.836,0.406,0.1605,0.2245,2
M,0.57,0.45,0.14,0.9275,0.477,0.1605,0.2515,1
M,0.57,0.44,0.145,0.8815,0.3605,0.1955,0.2735,2
M,0.595,0.46,0.155,1.03,0.4275,0.207,0.3305,2
F,0.605,0.48,0.175,1.1685,0.4815,0.2305,0.356,2
F,0.615,0.455,0.135,1.059,0.4735,0.263,0.274,2
M,0.62,0.46,0.17,1.127,0.535,0.2635,0.296,1
M,0.625,0.47,0.17,1.1665,0.4605,0.2565,0.3945,3
F,0.68,0.52,0.185,1.541,0.5985,0.395,0.4575,2
M,0.68,0.54,0.195,1.7825,0.5565,0.3235,0.4285,3
M,0.68,0.52,0.175,1.543,0.7525,0.351,0.374,3
F,0.71,0.555,0.17,1.47,0.5375,0.38,0.431,3
M,0.5,0.385,0.12,0.6335,0.2305,0.125,0.235,3
F,0.545,0.42,0.175,0.754,0.256,0.1775,0.275,2
F,0.46,0.365,0.115,0.4485,0.165,0.083,0.17,3
M,0.535,0.41,0.15,0.8105,0.345,0.187,0.24,3
M,0.335,0.26,0.075,0.22,0.0855,0.04,0.085,1
F,0.425,0.35,0.1,0.4425,0.175,0.0755,0.175,1
M,0.41,0.325,0.1,0.3555,0.146,0.072,0.105,2
I,0.17,0.105,0.035,0.034,0.012,0.0085,0.005,1
I,0.335,0.25,0.095,0.185,0.0795,0.0495,0.055,1
M,0.52,0.425,0.125,0.79,0.372,0.205,0.19,1
F,0.53,0.41,0.145,0.8255,0.375,0.204,0.245,2
M,0.5,0.42,0.125,0.62,0.255,0.15,0.205,3
F,0.615,0.475,0.145,0.9525,0.3915,0.195,0.32,2
M,0.575,0.45,0.16,0.955,0.44,0.1685,0.27,3
M,0.57,0.45,0.155,0.91,0.326,0.1895,0.355,3
M,0.455,0.35,0.105,0.416,0.1625,0.097,0.145,3
I,0.37,0.275,0.085,0.2045,0.096,0.056,0.08,1
M,0.445,0.37,0.125,0.515,0.2495,0.087,0.159,2
F,0.675,0.535,0.22,1.604,0.6175,0.4255,0.453,3
M,0.385,0.3,0.115,0.3435,0.1645,0.085,0.1025,1
F,0.375,0.295,0.11,0.3005,0.1255,0.0575,0.1035,1
M,0.56,0.44,0.13,0.8255,0.2425,0.202,0.285,2
M,0.55,0.41,0.15,0.785,0.282,0.186,0.275,3
F,0.57,0.465,0.155,0.9685,0.446,0.261,0.255,2
F,0.485,0.4,0.155,0.731,0.236,0.183,0.255,3
M,0.41,0.335,0.115,0.4405,0.19,0.085,0.135,1
I,0.335,0.255,0.085,0.1785,0.071,0.0405,0.055,2
M,0.655,0.515,0.2,1.373,0.443,0.3375,0.49,3
F,0.565,0.45,0.165,0.9765,0.322,0.244,0.37,3
F,0.57,0.44,0.19,1.018,0.447,0.207,0.265,2
F,0.55,0.465,0.15,1.082,0.3575,0.194,0.19,3
F,0.63,0.475,0.175,1.423,0.4155,0.3385,0.49,3
M,0.475,0.37,0.125,0.655,0.266,0.1725,0.185,2
F,0.655,0.5,0.18,1.4155,0.508,0.314,0.445,3
I,0.32,0.235,0.065,0.1385,0.058,0.0225,0.05,1
M,0.525,0.395,0.165,0.782,0.285,0.1405,0.285,3
F,0.525,0.43,0.165,0.717,0.289,0.1745,0.195,2
F,0.5,0.39,0.13,0.6355,0.2505,0.1635,0.195,3
F,0.44,0.34,0.135,0.3975,0.1505,0.0945,0.135,1
F,0.49,0.385,0.16,0.656,0.2455,0.171,0.205,2
M,0.545,0.44,0.165,0.744,0.2875,0.204,0.25,3
F,0.45,0.36,0.11,0.447,0.203,0.082,0.13,3
F,0.515,0.4,0.115,0.578,0.191,0.1445,0.17,2
I,0.33,0.25,0.075,0.1405,0.056,0.035,0.05,1
F,0.525,0.41,0.15,0.708,0.274,0.151,0.25,3
M,0.295,0.225,0.09,0.1385,0.048,0.046,0.05,2
M,0.545,0.45,0.16,0.8615,0.2925,0.1545,0.365,3
F,0.645,0.5,0.225,1.626,0.587,0.4055,0.41,3
M,0.45,0.355,0.115,0.478,0.18,0.1185,0.155,2
F,0.61,0.49,0.17,1.1775,0.5655,0.2385,0.295,3
I,0.38,0.3,0.1,0.286,0.1305,0.056,0.09,1
F,0.565,0.455,0.13,1.058,0.439,0.2645,0.3,2
F,0.67,0.545,0.16,1.5415,0.5985,0.2565,0.495,3
M,0.54,0.425,0.12,0.817,0.2945,0.153,0.195,2
I,0.29,0.225,0.075,0.152,0.071,0.059,0.045,2
I,0.41,0.33,0.105,0.335,0.1525,0.074,0.11,1
F,0.46,0.375,0.12,0.4915,0.2205,0.088,0.17,1
F,0.56,0.44,0.155,0.9705,0.4315,0.263,0.255,2
F,0.575,0.45,0.1,0.9315,0.431,0.222,0.235,3
M,0.62,0.5,0.2,1.221,0.4605,0.263,0.43,3
M,0.515,0.4,0.14,0.7365,0.2955,0.184,0.185,3
F,0.56,0.46,0.18,0.97,0.342,0.196,0.355,3
F,0.5,0.4,0.15,0.8085,0.273,0.112,0.295,3
I,0.435,0.355,0.125,0.4075,0.1535,0.074,0.165,2
M,0.495,0.38,0.135,0.6295,0.263,0.1425,0.215,3
F,0.595,0.5,0.18,1.053,0.4405,0.192,0.39,3
M,0.76,0.575,0.19,1.829,0.7035,0.386,0.56,3
F,0.615,0.5,0.165,1.1765,0.488,0.244,0.345,3
F,0.565,0.46,0.15,0.8765,0.3455,0.1925,0.275,2
I,0.14,0.105,0.035,0.0145,0.005,0.0035,0.005,1
M,0.445,0.345,0.14,0.476,0.2055,0.1015,0.1085,3
F,0.525,0.43,0.125,0.813,0.3315,0.166,0.1775,3
I,0.16,0.12,0.02,0.018,0.0075,0.0045,0.005,1
M,0.635,0.48,0.235,1.064,0.413,0.228,0.36,3
M,0.575,0.47,0.165,0.853,0.292,0.179,0.35,3
M,0.38,0.27,0.095,0.219,0.0835,0.0515,0.07,1
M,0.245,0.18,0.065,0.0635,0.0245,0.0135,0.02,1
I,0.48,0.39,0.15,0.6275,0.276,0.134,0.185,3
I,0.455,0.365,0.135,0.441,0.1515,0.1165,0.145,2
F,0.455,0.375,0.125,0.458,0.1985,0.111,0.12,2
M,0.455,0.355,0.135,0.4745,0.1865,0.0935,0.168,3
I,0.355,0.27,0.1,0.216,0.083,0.037,0.075,2
I,0.52,0.405,0.14,0.6765,0.2865,0.146,0.205,3
I,0.54,0.4,0.145,0.757,0.315,0.181,0.215,3
I,0.52,0.39,0.14,0.7325,0.2415,0.144,0.26,3
I,0.56,0.445,0.165,1.0285,0.4535,0.253,0.275,3
F,0.52,0.41,0.16,0.712,0.2845,0.153,0.225,2
I,0.615,0.46,0.19,1.066,0.4335,0.226,0.33,3
F,0.645,0.49,0.19,1.3065,0.479,0.3565,0.345,3
I,0.565,0.43,0.135,0.8545,0.321,0.1775,0.275,3
M,0.295,0.23,0.085,0.125,0.042,0.0285,0.043,1
M,0.375,0.28,0.095,0.2225,0.0875,0.043,0.08,2
I,0.525,0.4,0.14,0.6955,0.2405,0.16,0.253,2
M,0.395,0.28,0.08,0.266,0.0995,0.066,0.09,3
F,0.5,0.4,0.165,0.7105,0.27,0.1455,0.225,3
F,0.47,0.35,0.115,0.487,0.1955,0.127,0.155,1
I,0.58,0.42,0.16,0.728,0.2725,0.19,0.19,3
I,0.5,0.38,0.155,0.6675,0.2745,0.156,0.18,3
I,0.725,0.55,0.22,2.0495,0.7735,0.4405,0.655,2
F,0.65,0.515,0.215,1.498,0.564,0.323,0.425,3
F,0.67,0.535,0.185,1.597,0.6275,0.35,0.47,3
I,0.55,0.44,0.165,0.8605,0.312,0.169,0.3,3
F,0.49,0.37,0.115,0.541,0.171,0.1175,0.185,3
I,0.235,0.18,0.06,0.058,0.022,0.0145,0.018,1
I,0.235,0.175,0.08,0.0645,0.0215,0.0175,0.0215,1
M,0.52,0.41,0.115,0.77,0.263,0.157,0.26,3
F,0.475,0.4,0.115,0.541,0.186,0.1025,0.21,3
M,0.53,0.425,0.11,0.739,0.237,0.161,0.295,3
F,0.35,0.275,0.065,0.205,0.0745,0.0465,0.07,2
M,0.555,0.42,0.145,0.8695,0.3075,0.2575,0.25,3
M,0.505,0.39,0.105,0.6555,0.2595,0.18,0.19,3
F,0.54,0.44,0.16,1.0905,0.391,0.2295,0.355,3
F,0.525,0.4,0.115,0.6295,0.2555,0.144,0.18,3
M,0.55,0.45,0.175,1.0985,0.3765,0.215,0.4,3
M,0.55,0.44,0.16,0.991,0.348,0.168,0.375,3
I,0.235,0.175,0.065,0.0615,0.0205,0.02,0.019,1
M,0.525,0.41,0.165,0.8005,0.2635,0.1985,0.25,3
M,0.475,0.365,0.14,0.6175,0.202,0.1445,0.19,3
F,0.53,0.4,0.165,0.772,0.2855,0.1975,0.23,3
F,0.525,0.415,0.15,0.7155,0.2355,0.171,0.27,3
F,0.53,0.425,0.13,0.717,0.2115,0.166,0.255,3
F,0.465,0.39,0.11,0.6355,0.1815,0.157,0.225,3
I,0.315,0.235,0.08,0.18,0.08,0.045,0.047,1
I,0.465,0.355,0.12,0.5805,0.255,0.0915,0.184,1
M,0.485,0.385,0.105,0.556,0.296,0.104,0.133,1
I,0.49,0.385,0.12,0.591,0.271,0.1125,0.1775,2
F,0.515,0.395,0.14,0.686,0.281,0.1255,0.22,3
F,0.555,0.44,0.155,1.016,0.4935,0.1855,0.263,2
F,0.61,0.5,0.18,1.438,0.5185,0.3735,0.3345,2
F,0.68,0.55,0.19,1.807,0.8225,0.3655,0.515,3
M,0.69,0.55,0.195,1.777,0.769,0.38,0.4305,3
M,0.695,0.55,0.205,2.173,1.133,0.4665,0.496,2
F,0.72,0.575,0.195,2.1505,1.0745,0.382,0.585,2
I,0.27,0.205,0.075,0.118,0.059,0.031,0.0305,1
I,0.27,0.19,0.06,0.099,0.0445,0.017,0.03,1
I,0.295,0.22,0.07,0.1365,0.0575,0.0295,0.035,1
I,0.295,0.22,0.065,0.1295,0.052,0.028,0.035,1
I,0.315,0.23,0.07,0.164,0.0625,0.04,0.045,1
I,0.375,0.29,0.095,0.2875,0.123,0.0605,0.08,1
I,0.38,0.3,0.09,0.277,0.1655,0.0625,0.082,1
I,0.385,0.285,0.09,0.248,0.0935,0.066,0.07,1
I,0.4,0.295,0.095,0.252,0.1105,0.0575,0.066,1
M,0.415,0.315,0.12,0.4015,0.199,0.087,0.097,1
I,0.415,0.33,0.1,0.3905,0.1925,0.0755,0.1025,1
I,0.42,0.32,0.115,0.409,0.2055,0.0935,0.105,1
I,0.44,0.33,0.135,0.4095,0.163,0.1005,0.119,1
I,0.45,0.35,0.135,0.494,0.2205,0.0945,0.1405,1
I,0.475,0.35,0.12,0.4905,0.2035,0.13,0.135,1
M,0.485,0.39,0.12,0.599,0.251,0.1345,0.169,1
M,0.495,0.375,0.115,0.6245,0.282,0.143,0.155,1
F,0.525,0.41,0.115,0.7745,0.416,0.163,0.18,1
M,0.565,0.455,0.15,0.9795,0.444,0.205,0.275,1
I,0.58,0.435,0.15,0.8915,0.363,0.1925,0.2515,1
F,0.585,0.45,0.125,0.874,0.3545,0.2075,0.225,1
M,0.6,0.465,0.155,1.262,0.6245,0.2455,0.33,2
M,0.63,0.48,0.185,1.21,0.53,0.2555,0.322,3
F,0.645,0.525,0.17,1.37,0.6135,0.283,0.34,2
F,0.655,0.545,0.185,1.759,0.6865,0.313,0.547,3
M,0.665,0.515,0.165,1.3855,0.621,0.302,0.3445,1
F,0.67,0.52,0.195,1.8065,0.758,0.3735,0.5055,3
M,0.67,0.51,0.2,1.5945,0.6705,0.3845,0.4505,2
M,0.685,0.51,0.18,1.4545,0.6315,0.3105,0.3725,2
M,0.7,0.6,0.23,2.003,0.8105,0.4045,0.5755,2
M,0.72,0.6,0.235,2.2385,0.984,0.411,0.621,3
I,0.185,0.135,0.045,0.032,0.011,0.0065,0.01,1
I,0.245,0.175,0.055,0.0785,0.04,0.018,0.02,1
I,0.315,0.23,0,0.134,0.0575,0.0285,0.3505,1
I,0.36,0.27,0.09,0.2075,0.098,0.039,0.062,1
I,0.375,0.28,0.08,0.2235,0.115,0.043,0.055,1
I,0.415,0.31,0.095,0.34,0.181,0.057,0.083,1
I,0.455,0.35,0.135,0.5365,0.2855,0.0855,0.1325,1
I,0.48,0.35,0.105,0.635,0.352,0.127,0.135,1
I,0.485,0.375,0.125,0.562,0.2505,0.1345,0.1525,1
I,0.51,0.39,0.125,0.597,0.293,0.1265,0.1555,1
M,0.52,0.395,0.125,0.5815,0.2565,0.1265,0.17,2
F,0.555,0.43,0.14,0.7545,0.3525,0.1835,0.2015,2
M,0.585,0.465,0.15,0.98,0.4315,0.2545,0.247,2
F,0.585,0.46,0.15,1.0035,0.503,0.2105,0.2515,3
M,0.585,0.455,0.155,1.133,0.5515,0.223,0.305,3
M,0.61,0.49,0.16,1.146,0.597,0.246,0.265,1
M,0.61,0.475,0.15,1.142,0.62,0.237,0.245,2
M,0.615,0.53,0.17,1.12,0.5775,0.2095,0.286,2
F,0.62,0.465,0.14,1.011,0.479,0.2385,0.255,1
M,0.625,0.505,0.175,1.131,0.5425,0.2265,0.323,1
M,0.625,0.48,0.175,1.065,0.4865,0.259,0.285,2
M,0.635,0.48,0.145,1.181,0.665,0.229,0.225,2
F,0.64,0.525,0.175,1.382,0.646,0.3115,0.37,2
M,0.66,0.505,0.19,1.4385,0.6775,0.285,0.178,3
M,0.66,0.485,0.155,1.2275,0.61,0.274,0.3,1
M,0.66,0.515,0.155,1.4415,0.7055,0.3555,0.335,2
F,0.68,0.55,0.175,1.473,0.713,0.282,0.4295,3
F,0.69,0.58,0.195,1.658,0.708,0.3615,0.4715,2
M,0.72,0.545,0.195,1.7475,0.8215,0.383,0.4705,3
I,0.275,0.2,0.07,0.096,0.037,0.0225,0.03,1
I,0.33,0.245,0.065,0.1445,0.058,0.032,0.0505,1
I,0.33,0.26,0.085,0.1965,0.0915,0.0425,0.055,1
I,0.365,0.28,0.09,0.196,0.0865,0.036,0.0605,1
I,0.365,0.27,0.09,0.2155,0.1005,0.049,0.0655,1
I,0.42,0.31,0.1,0.2805,0.1125,0.0615,0.0925,1
I,0.435,0.335,0.11,0.334,0.1355,0.0775,0.0965,1
I,0.435,0.325,0.1,0.366,0.174,0.0725,0.109,1
I,0.44,0.325,0.11,0.4965,0.258,0.1195,0.1075,1
I,0.485,0.365,0.09,0.651,0.3165,0.132,0.18,1
I,0.495,0.385,0.125,0.5125,0.2075,0.1155,0.172,2
M,0.51,0.405,0.125,0.6925,0.327,0.155,0.1805,1
I,0.52,0.41,0.14,0.5995,0.242,0.1375,0.182,3
I,0.54,0.42,0.14,0.74,0.3595,0.159,0.1985,1
I,0.54,0.415,0.155,0.702,0.322,0.167,0.19,2
I,0.55,0.445,0.125,0.672,0.288,0.1365,0.21,3
I,0.56,0.44,0.155,0.811,0.3685,0.178,0.235,3
F,0.575,0.45,0.12,0.9585,0.447,0.169,0.275,3
I,0.575,0.45,0.15,0.858,0.449,0.166,0.215,2
F,0.575,0.46,0.165,0.9575,0.4815,0.1945,0.236,2
F,0.58,0.46,0.135,0.926,0.4025,0.208,0.275,1
F,0.58,0.425,0.155,0.873,0.3615,0.249,0.239,2
M,0.59,0.45,0.16,0.998,0.445,0.214,0.301,2
M,0.6,0.46,0.155,0.6655,0.285,0.149,0.269,3
M,0.62,0.485,0.145,1.003,0.4655,0.2195,0.28,3
F,0.625,0.495,0.16,1.234,0.6335,0.192,0.35,3
M,0.625,0.495,0.155,1.025,0.46,0.1945,0.34,2
M,0.625,0.495,0.175,1.2935,0.5805,0.317,0.355,2
M,0.625,0.5,0.175,1.0565,0.4615,0.258,0.305,2
M,0.625,0.47,0.145,1.7855,0.675,0.247,0.3245,3
F,0.625,0.485,0.165,1.2255,0.5075,0.296,0.36,2
F,0.635,0.5,0.18,1.2565,0.539,0.292,0.35,2
F,0.645,0.5,0.15,1.159,0.4675,0.3355,0.31,2
M,0.645,0.51,0.165,1.403,0.5755,0.2515,0.4545,3
F,0.69,0.535,0.185,1.826,0.797,0.409,0.499,3
F,0.695,0.56,0.185,1.7715,0.8195,0.331,0.437,2
M,0.515,0.39,0.12,0.6125,0.302,0.1365,0.1415,1
I,0.545,0.405,0.13,0.658,0.327,0.1445,0.174,1
M,0.62,0.465,0.145,0.911,0.375,0.2145,0.278,2
M,0.63,0.49,0.15,1.1955,0.5845,0.257,0.3,2
F,0.63,0.515,0.16,1.336,0.553,0.3205,0.35,3
F,0.64,0.49,0.18,1.36,0.653,0.347,0.305,2
I,0.37,0.275,0.08,0.2325,0.093,0.056,0.072,1
I,0.395,0.31,0.085,0.317,0.153,0.0505,0.0935,1
I,0.4,0.3,0.115,0.318,0.1335,0.0725,0.0935,1
I,0.41,0.305,0.1,0.2645,0.1,0.0655,0.085,1
I,0.455,0.335,0.105,0.4055,0.175,0.092,0.1185,1
I,0.48,0.335,0.125,0.524,0.246,0.1095,0.145,1
I,0.485,0.375,0.11,0.464,0.2015,0.09,0.149,1
I,0.5,0.36,0.12,0.439,0.1875,0.1055,0.1305,1
I,0.515,0.395,0.125,0.5805,0.2365,0.1075,0.19,2
I,0.52,0.4,0.14,0.622,0.278,0.1455,0.169,1
M,0.545,0.45,0.15,0.7805,0.3795,0.1625,0.216,1
I,0.545,0.43,0.14,0.772,0.289,0.19,0.2615,1
I,0.55,0.435,0.125,0.741,0.348,0.1585,0.206,2
M,0.55,0.43,0.18,0.8265,0.4405,0.159,0.225,2
M,0.55,0.385,0.13,0.7275,0.343,0.1625,0.19,1
I,0.555,0.43,0.125,0.7005,0.3395,0.1355,0.2095,1
M,0.56,0.45,0.145,0.9355,0.425,0.1645,0.2725,3
I,0.565,0.465,0.15,1.1815,0.581,0.2215,0.3095,2
M,0.57,0.445,0.16,1.0145,0.516,0.164,0.3,2
F,0.575,0.48,0.17,1.1,0.506,0.2485,0.31,2
M,0.585,0.51,0.16,1.218,0.639,0.241,0.3,3
M,0.59,0.45,0.155,0.874,0.369,0.2135,0.24,1
I,0.595,0.475,0.155,0.984,0.4865,0.184,0.2755,2
M,0.6,0.47,0.13,1.0105,0.423,0.219,0.298,2
M,0.61,0.365,0.155,1.0765,0.488,0.249,0.27,2
M,0.615,0.475,0.205,1.337,0.5995,0.2815,0.37,3
M,0.625,0.5,0.18,1.3705,0.645,0.303,0.3705,3
F,0.625,0.49,0.19,1.7015,0.7465,0.4105,0.3855,3
M,0.63,0.485,0.18,1.2435,0.5175,0.308,0.37,3
M,0.63,0.53,0.175,1.4135,0.667,0.2945,0.3555,3
F,0.635,0.485,0.155,1.073,0.467,0.1975,0.35,3
F,0.635,0.5,0.175,1.477,0.684,0.3005,0.39,3
M,0.635,0.5,0.18,1.2915,0.594,0.2695,0.37,2
F,0.65,0.495,0.16,1.3105,0.577,0.3315,0.355,2
M,0.67,0.525,0.18,1.4915,0.728,0.343,0.381,2
F,0.675,0.52,0.175,1.494,0.7365,0.3055,0.37,2
F,0.675,0.51,0.15,1.1965,0.475,0.304,0.386,3
M,0.68,0.545,0.185,1.672,0.7075,0.364,0.48,3
M,0.7,0.545,0.215,1.9125,0.8825,0.4385,0.506,2
F,0.71,0.545,0.175,1.907,0.8725,0.4565,0.475,3
F,0.715,0.565,0.18,1.79,0.844,0.3535,0.5385,2
F,0.72,0.59,0.205,1.7495,0.7755,0.4225,0.48,3
I,0.42,0.305,0.1,0.3415,0.1645,0.0775,0.086,1
I,0.48,0.35,0.1,0.519,0.2365,0.1275,0.126,1
M,0.48,0.365,0.13,0.5305,0.2405,0.127,0.139,1
M,0.51,0.41,0.155,1.2825,0.569,0.291,0.3795,2
I,0.515,0.4,0.14,0.7165,0.3495,0.1595,0.1785,1
F,0.56,0.42,0.18,1.6645,0.7755,0.35,0.4525,2
I,0.56,0.42,0.14,0.837,0.414,0.214,0.2,1
F,0.57,0.45,0.15,0.9645,0.531,0.189,0.209,2
F,0.605,0.465,0.155,1.1,0.547,0.2665,0.2585,2
M,0.625,0.48,0.16,1.2415,0.6575,0.2625,0.2785,2
F,0.64,0.505,0.175,1.3185,0.6185,0.302,0.3315,2
M,0.65,0.525,0.185,1.3455,0.586,0.278,0.3865,2
I,0.3,0.215,0.05,0.1185,0.048,0.0225,0.042,1
M,0.35,0.265,0.09,0.197,0.073,0.0365,0.077,1
I,0.455,0.35,0.13,0.4725,0.215,0.0745,0.15,2
I,0.46,0.365,0.11,0.4495,0.1755,0.102,0.15,1
I,0.49,0.375,0.115,0.557,0.2275,0.1335,0.1765,1
I,0.5,0.385,0.12,0.516,0.197,0.1305,0.165,1
I,0.54,0.415,0.135,0.709,0.3195,0.174,0.185,2
M,0.55,0.42,0.145,0.7385,0.321,0.1485,0.252,3
I,0.55,0.445,0.11,0.7935,0.378,0.142,0.26,2
M,0.555,0.435,0.145,0.9205,0.404,0.2275,0.255,1
I,0.57,0.425,0.14,0.7655,0.331,0.14,0.24,2
M,0.58,0.45,0.14,0.824,0.3465,0.1765,0.263,2
I,0.58,0.425,0.145,0.83,0.379,0.1605,0.2575,3
I,0.585,0.47,0.17,0.985,0.3695,0.2395,0.315,2
M,0.585,0.45,0.15,0.997,0.4055,0.283,0.251,3
F,0.595,0.455,0.14,0.914,0.3895,0.2225,0.271,2
F,0.6,0.5,0.17,1.13,0.4405,0.267,0.335,3
F,0.615,0.495,0.155,1.0805,0.52,0.19,0.32,2
M,0.63,0.505,0.155,1.105,0.492,0.226,0.325,3
M,0.63,0.49,0.155,1.229,0.535,0.29,0.335,3
F,0.635,0.495,0.175,1.2355,0.5205,0.3085,0.347,2
F,0.645,0.535,0.19,1.2395,0.468,0.2385,0.424,2
F,0.65,0.505,0.165,1.357,0.5725,0.281,0.43,3
M,0.655,0.525,0.18,1.402,0.624,0.2935,0.365,3
F,0.655,0.5,0.22,1.359,0.642,0.3255,0.405,3
M,0.67,0.535,0.19,1.669,0.7465,0.2935,0.508,3
M,0.67,0.525,0.2,1.7405,0.6205,0.297,0.657,3
M,0.695,0.53,0.21,1.51,0.664,0.4095,0.385,2
M,0.695,0.55,0.195,1.6645,0.727,0.36,0.445,3
M,0.77,0.605,0.175,2.0505,0.8005,0.526,0.355,3
I,0.28,0.215,0.07,0.124,0.063,0.0215,0.03,1
I,0.33,0.23,0.08,0.14,0.0565,0.0365,0.046,1
I,0.35,0.25,0.075,0.1695,0.0835,0.0355,0.041,1
I,0.37,0.28,0.09,0.218,0.0995,0.0545,0.0615,1
I,0.43,0.315,0.115,0.384,0.1885,0.0715,0.11,1
I,0.435,0.33,0.095,0.393,0.219,0.075,0.0885,1
I,0.44,0.35,0.11,0.3805,0.1575,0.0895,0.115,1
M,0.475,0.37,0.11,0.4895,0.2185,0.107,0.146,1
M,0.475,0.36,0.14,0.5135,0.241,0.1045,0.155,1
I,0.48,0.355,0.11,0.4495,0.201,0.089,0.14,1
F,0.56,0.44,0.135,0.8025,0.35,0.1615,0.259,2
F,0.585,0.475,0.165,1.053,0.458,0.217,0.3,3
F,0.585,0.455,0.17,0.9945,0.4255,0.263,0.2845,3
M,0.385,0.255,0.1,0.3175,0.137,0.068,0.092,1
I,0.39,0.31,0.085,0.344,0.181,0.0695,0.079,1
I,0.39,0.29,0.1,0.2845,0.1255,0.0635,0.081,1
I,0.405,0.3,0.085,0.3035,0.15,0.0505,0.088,1
I,0.475,0.365,0.115,0.499,0.232,0.0885,0.156,2
M,0.5,0.38,0.125,0.577,0.269,0.1265,0.1535,2
F,0.515,0.4,0.125,0.615,0.2865,0.123,0.1765,1
M,0.52,0.385,0.165,0.791,0.375,0.18,0.1815,2
M,0.55,0.43,0.13,0.8395,0.3155,0.1955,0.2405,2
M,0.56,0.43,0.155,0.8675,0.4,0.172,0.229,1
F,0.565,0.45,0.165,0.887,0.37,0.239,0.249,3
M,0.59,0.44,0.135,0.966,0.439,0.2145,0.2605,2
M,0.6,0.475,0.205,1.176,0.5255,0.2875,0.308,2
F,0.625,0.485,0.15,1.0945,0.531,0.261,0.296,2
M,0.71,0.555,0.195,1.9485,0.9455,0.3765,0.495,3
            """
            temp = "abalone.arff"
            with open(temp, "w") as f:
                f.write(aba)
            self.loader = File(temp).data
        elif hasattr(datasets, "load_" + name):
            self.loader = getattr(datasets, "load_" + name)
        elif hasattr(datasets, "fetch_" + name):
            self.loader = getattr(datasets, "fetch_" + name)
        else:
            raise Exception("Unknown", name)

    def _process_(self, data):
        if data is not Root:
            msg = f"{self.name} only accepts Root as Data. Use Dataset(   ).data or Sink instead {type(data)}"
            raise Exception(msg)
        return self.data

    ###@cached_property
    @property
    def data(self):
        if isinstance(self.loader, Data):
            return self.loader
        d = self.loader(as_frame=True)
        classes = list(map(str, d.target_names))
        X, y = d.data.to_numpy(), np.array([str(l) for l in Categorical.from_codes(d.target, classes)])
        Xd, Yd = d.feature_names, [d.target.name]
        Xt, Yt = [translate_type(str(c)) for c in d.frame.dtypes], [classes]
        return new(X=X, y=y, Xd=Xd, Yd=Yd, Xt=Xt, Yt=Yt)

    def _uuid_(self):  # override uuid to match with New and File
        return self.data.step_uuid


dataset = Dataset()
