"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .alertevent import Alertevent, AlerteventTypedDict
from .extraction import Extraction, ExtractionTypedDict
from .extractionsummary import Extractionsummary, ExtractionsummaryTypedDict
from .latency import Latency, LatencyTypedDict
from .principal import Principal, PrincipalTypedDict
from acuvity.types import BaseModel
from datetime import datetime
from enum import Enum
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class Decision(str, Enum):
    r"""Tell what was the decision about the data."""

    DENY = "Deny"
    ALLOW = "Allow"
    ASK = "Ask"
    BYPASSED = "Bypassed"
    FORBIDDEN_USER = "ForbiddenUser"
    SKIPPED = "Skipped"


class ScanresponseType(str, Enum):
    r"""The type of text."""

    INPUT = "Input"
    OUTPUT = "Output"


class ScanresponseTypedDict(TypedDict):
    r"""This is a scan response."""

    principal: PrincipalTypedDict
    r"""Describe the principal."""
    id: NotRequired[str]
    r"""ID is the identifier of the object."""
    alerts: NotRequired[List[AlerteventTypedDict]]
    r"""List of alerts that got raised during the policy resolution."""
    annotations: NotRequired[Dict[str, str]]
    r"""Annotations attached to the log."""
    client: NotRequired[str]
    r"""The client used to send the request."""
    client_version: NotRequired[str]
    r"""The version of the client used to send the request."""
    decision: NotRequired[Decision]
    r"""Tell what was the decision about the data."""
    extractions: NotRequired[List[ExtractionTypedDict]]
    r"""The extractions to log."""
    hash: NotRequired[str]
    r"""The hash of the input."""
    latency: NotRequired[LatencyTypedDict]
    r"""Holds information about latencies introduced by Apex."""
    namespace: NotRequired[str]
    r"""The namespace of the object."""
    pipeline_name: NotRequired[str]
    r"""The name of the particular pipeline that extracted the text."""
    provider: NotRequired[str]
    r"""the provider to use."""
    reasons: NotRequired[List[str]]
    r"""The various reasons returned by the policy engine."""
    summary: NotRequired[ExtractionsummaryTypedDict]
    r"""Represents the summary of the extractions."""
    time: NotRequired[datetime]
    r"""Set the time of the message request."""
    type: NotRequired[ScanresponseType]
    r"""The type of text."""


class Scanresponse(BaseModel):
    r"""This is a scan response."""

    principal: Principal
    r"""Describe the principal."""

    id: Annotated[Optional[str], pydantic.Field(alias="ID")] = None
    r"""ID is the identifier of the object."""

    alerts: Optional[List[Alertevent]] = None
    r"""List of alerts that got raised during the policy resolution."""

    annotations: Optional[Dict[str, str]] = None
    r"""Annotations attached to the log."""

    client: Optional[str] = None
    r"""The client used to send the request."""

    client_version: Annotated[Optional[str], pydantic.Field(alias="clientVersion")] = (
        None
    )
    r"""The version of the client used to send the request."""

    decision: Optional[Decision] = None
    r"""Tell what was the decision about the data."""

    extractions: Optional[List[Extraction]] = None
    r"""The extractions to log."""

    hash: Optional[str] = None
    r"""The hash of the input."""

    latency: Optional[Latency] = None
    r"""Holds information about latencies introduced by Apex."""

    namespace: Optional[str] = None
    r"""The namespace of the object."""

    pipeline_name: Annotated[Optional[str], pydantic.Field(alias="pipelineName")] = None
    r"""The name of the particular pipeline that extracted the text."""

    provider: Optional[str] = None
    r"""the provider to use."""

    reasons: Optional[List[str]] = None
    r"""The various reasons returned by the policy engine."""

    summary: Optional[Extractionsummary] = None
    r"""Represents the summary of the extractions."""

    time: Optional[datetime] = None
    r"""Set the time of the message request."""

    type: Optional[ScanresponseType] = None
    r"""The type of text."""
