"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from acuvity.types import BaseModel
import pydantic
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ExtractionsummaryTypedDict(TypedDict):
    r"""Represents the summary of the extractions."""

    pi_is: NotRequired[Dict[str, Any]]
    r"""The PIIs found during classification."""
    categories: NotRequired[Dict[str, Any]]
    r"""The categories are remapping of the modalities in a more human friendly way."""
    exploits: NotRequired[Dict[str, Any]]
    r"""The various exploits attempts."""
    intent: NotRequired[Dict[str, Any]]
    r"""The estimated intent embodied into the text."""
    keywords: NotRequired[Dict[str, Any]]
    r"""The keywords found during classification."""
    languages: NotRequired[Dict[str, Any]]
    r"""The language of the classification."""
    malcontents: NotRequired[Dict[str, Any]]
    r"""The various malcontents attempts."""
    modalities: NotRequired[Dict[str, Any]]
    r"""The modalities of data detected in the data."""
    secrets: NotRequired[Dict[str, Any]]
    r"""The secrets found during classification."""
    topics: NotRequired[Dict[str, Any]]
    r"""The topic of the classification."""


class Extractionsummary(BaseModel):
    r"""Represents the summary of the extractions."""

    pi_is: Annotated[Optional[Dict[str, Any]], pydantic.Field(alias="PIIs")] = None
    r"""The PIIs found during classification."""

    categories: Optional[Dict[str, Any]] = None
    r"""The categories are remapping of the modalities in a more human friendly way."""

    exploits: Optional[Dict[str, Any]] = None
    r"""The various exploits attempts."""

    intent: Optional[Dict[str, Any]] = None
    r"""The estimated intent embodied into the text."""

    keywords: Optional[Dict[str, Any]] = None
    r"""The keywords found during classification."""

    languages: Optional[Dict[str, Any]] = None
    r"""The language of the classification."""

    malcontents: Optional[Dict[str, Any]] = None
    r"""The various malcontents attempts."""

    modalities: Optional[Dict[str, Any]] = None
    r"""The modalities of data detected in the data."""

    secrets: Optional[Dict[str, Any]] = None
    r"""The secrets found during classification."""

    topics: Optional[Dict[str, Any]] = None
    r"""The topic of the classification."""
