"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from acuvity.types import BaseModel
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ExtractionrequestTypedDict(TypedDict):
    r"""Represents the extraction that the user wants to extract."""

    annotations: NotRequired[Dict[str, str]]
    r"""Annotations attached to the extraction."""
    data: NotRequired[str]
    r"""The binary data to request extraction for."""
    internal: NotRequired[bool]
    r"""If true, this extraction is for internal use only. This can be used by agentic
    systems to mark an extraction as internal only as opposed to user facing.
    """
    is_file: NotRequired[bool]
    r"""If true, the data of the extraction is a file."""
    is_stored: NotRequired[bool]
    r"""If true, indicates that the file has been stored."""
    label: NotRequired[str]
    r"""A means of distinguishing what was extracted, such as prompt, input file or
    code.
    """


class Extractionrequest(BaseModel):
    r"""Represents the extraction that the user wants to extract."""

    annotations: Optional[Dict[str, str]] = None
    r"""Annotations attached to the extraction."""

    data: Optional[str] = None
    r"""The binary data to request extraction for."""

    internal: Optional[bool] = None
    r"""If true, this extraction is for internal use only. This can be used by agentic
    systems to mark an extraction as internal only as opposed to user facing.
    """

    is_file: Annotated[Optional[bool], pydantic.Field(alias="isFile")] = None
    r"""If true, the data of the extraction is a file."""

    is_stored: Annotated[Optional[bool], pydantic.Field(alias="isStored")] = None
    r"""If true, indicates that the file has been stored."""

    label: Optional[str] = None
    r"""A means of distinguishing what was extracted, such as prompt, input file or
    code.
    """
