"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobDefinitionImageConfig = void 0;
const ecs = require("@aws-cdk/aws-ecs");
const iam = require("@aws-cdk/aws-iam");
/**
 * Batch Job Task Definition
 *
 * Defines a Batch Job Task Definition. The properties of this task definition mirrors
 * those of an {@link ecs.ContainerDefinition}. This class is a wrapper on that structure.
 */
class TaskDefinition {
    constructor(props) {
        this.executionRole = props.executionRole;
    }
    /**
     * Internal function to allow the Batch Job task definition
     * to match the CDK requirements of an EC2 task definition.
     *
     * @internal
     */
    _linkContainer() { }
    /**
     * Retrieves the execution role for this task definition
     */
    obtainExecutionRole() {
        return this.executionRole;
    }
}
/**
 * The configuration for creating a batch container image.
 */
class JobDefinitionImageConfig {
    constructor(scope, container) {
        const config = this.bindImageConfig(scope, container);
        this.imageName = config.imageName;
    }
    bindImageConfig(scope, container) {
        return container.image.bind(scope, new ecs.ContainerDefinition(scope, 'Resource-Batch-Job-Container-Definition', {
            command: container.command,
            cpu: container.vcpus,
            image: container.image,
            environment: container.environment,
            linuxParameters: container.linuxParams,
            memoryLimitMiB: container.memoryLimitMiB,
            privileged: container.privileged,
            readonlyRootFilesystem: container.readOnly,
            gpuCount: container.gpuCount,
            user: container.user,
            taskDefinition: new TaskDefinition({
                executionRole: container.jobRole || new iam.LazyRole(scope, 'Resource-Batch-Task-Definition-Role', {
                    assumedBy: new iam.ServicePrincipal('batch.amazonaws.com'),
                }),
            }),
        }));
    }
}
exports.JobDefinitionImageConfig = JobDefinitionImageConfig;
//# sourceMappingURL=data:application/json;base64,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