/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.tw.jena.query.fulltext.analyzer;

import edu.rpi.tw.jena.query.fulltext.TextIndexException;
import edu.rpi.tw.jena.query.fulltext.assembler.GenericFilterAssembler;
import edu.rpi.tw.jena.query.fulltext.assembler.GenericTokenizerAssembler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class ConfigurableAnalyzer
extends Analyzer {
    private final String tokenizer;
    private final List<String> filters;
    private static Hashtable<String, GenericFilterAssembler.FilterSpec> filterSpecs = new Hashtable();
    private static Hashtable<String, GenericTokenizerAssembler.TokenizerSpec> tokenizerSpecs = new Hashtable();

    public static void defineFilter(String id, GenericFilterAssembler.FilterSpec spec) {
        filterSpecs.put(id, spec);
    }

    public static void defineTokenizer(String id, GenericTokenizerAssembler.TokenizerSpec spec) {
        tokenizerSpecs.put(id, spec);
    }

    private Tokenizer newTokenizer(Class<?> clazz, Class<?>[] paramClasses, Object[] paramValues) {
        String className = clazz.getName();
        try {
            Constructor<?> cstr = clazz.getDeclaredConstructor(paramClasses);
            return (Tokenizer)cstr.newInstance(paramValues);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            Log.error((Object)((Object)this), (String)("Exception while instantiating tokenizer class " + className + ". " + e.getMessage()), (Throwable)e);
        }
        catch (NoSuchMethodException ex) {
            Log.error((Object)((Object)this), (String)("Could not find matching tokenizer class constructor for " + className + " " + ex.getMessage()), (Throwable)ex);
        }
        return null;
    }

    private TokenFilter newFilter(Class<?> clazz, Class<?>[] paramClasses, Object[] paramValues) {
        String className = clazz.getName();
        try {
            Constructor<?> cstr = clazz.getDeclaredConstructor(paramClasses);
            return (TokenFilter)cstr.newInstance(paramValues);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            Log.error((Object)((Object)this), (String)("Exception while instantiating analyzer class " + className + ". " + e.getMessage()), (Throwable)e);
        }
        catch (NoSuchMethodException ex) {
            Log.error((Object)((Object)this), (String)("Could not find matching analyzer class constructor for " + className + " " + ex.getMessage()), (Throwable)ex);
        }
        return null;
    }

    private Tokenizer getTokenizer(String tokenizerName) {
        GenericTokenizerAssembler.TokenizerSpec spec = tokenizerSpecs.get(tokenizerName);
        if (spec == null) {
            throw new TextIndexException("Unknown tokenizer : " + tokenizerName);
        }
        Class<?> clazz = spec.clazz;
        Class<?>[] paramClasses = spec.paramClasses;
        Object[] paramValues = spec.paramValues;
        return this.newTokenizer(clazz, paramClasses, paramValues);
    }

    private TokenFilter getTokenFilter(String filterName, TokenStream source) {
        GenericFilterAssembler.FilterSpec spec = filterSpecs.get(filterName);
        if (spec == null) {
            throw new TextIndexException("Unknown filter : " + filterName);
        }
        Class<?> clazz = spec.clazz;
        Class<?>[] paramClasses = spec.paramClasses;
        Object[] paramValues = spec.paramValues;
        paramValues[0] = source;
        return this.newFilter(clazz, paramClasses, paramValues);
    }

    public ConfigurableAnalyzer(String tokenizer, List<String> filters) {
        this.tokenizer = tokenizer;
        this.filters = filters;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer source;
        Tokenizer stream = source = this.getTokenizer(this.tokenizer);
        for (String filter : this.filters) {
            stream = this.getTokenFilter(filter, (TokenStream)stream);
        }
        return new Analyzer.TokenStreamComponents(source, (TokenStream)stream);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenStream stream = in;
        for (String filter : this.filters) {
            stream = this.getTokenFilter(filter, stream);
        }
        return stream;
    }

    static {
        Class[] paramClasses = new Class[]{};
        Object[] paramValues = new Object[]{};
        tokenizerSpecs.put("http://jena.apache.org/fulltext#KeywordTokenizer", new GenericTokenizerAssembler.TokenizerSpec(KeywordTokenizer.class, paramClasses, paramValues));
        tokenizerSpecs.put("http://jena.apache.org/fulltext#LetterTokenizer", new GenericTokenizerAssembler.TokenizerSpec(LetterTokenizer.class, paramClasses, paramValues));
        tokenizerSpecs.put("http://jena.apache.org/fulltext#StandardTokenizer", new GenericTokenizerAssembler.TokenizerSpec(StandardTokenizer.class, paramClasses, paramValues));
        tokenizerSpecs.put("http://jena.apache.org/fulltext#WhitespaceTokenizer", new GenericTokenizerAssembler.TokenizerSpec(WhitespaceTokenizer.class, paramClasses, paramValues));
        paramClasses = new Class[]{TokenStream.class};
        paramValues = new Object[]{null};
        filterSpecs.put("http://jena.apache.org/fulltext#ASCIIFoldingFilter", new GenericFilterAssembler.FilterSpec(ASCIIFoldingFilter.class, paramClasses, paramValues));
        filterSpecs.put("http://jena.apache.org/fulltext#LowerCaseFilter", new GenericFilterAssembler.FilterSpec(LowerCaseFilter.class, paramClasses, paramValues));
        filterSpecs.put("http://jena.apache.org/fulltext#StandardFilter", new GenericFilterAssembler.FilterSpec(StandardFilter.class, paramClasses, paramValues));
    }
}

