/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.system.Txn;
import org.apache.jena.vocabulary.RDF;

public class InMemDatasetAssembler
extends AssemblerBase
implements Assembler {
    public static Resource getType() {
        return DatasetAssemblerVocab.tMemoryDataset;
    }

    @Override
    public Dataset open(Assembler assembler, Resource root2, Mode mode) {
        if (!root2.hasProperty(RDF.type, DatasetAssemblerVocab.tDatasetTxnMem)) {
            this.checkType(root2, DatasetAssemblerVocab.tMemoryDataset);
        }
        Dataset dataset = DatasetFactory.createTxnMem();
        AssemblerUtils.mergeContext(root2, dataset.getContext());
        Txn.executeWrite(dataset, () -> {
            GraphUtils.multiValueAsString(root2, JA.data).forEach(dataURI -> RDFDataMgr.read(dataset, dataURI));
            GraphUtils.multiValueResource(root2, DatasetAssemblerVocab.pNamedGraph).forEach(namedGraphResource -> {
                String graphName = GraphUtils.getAsStringValue(namedGraphResource, DatasetAssemblerVocab.pGraphName);
                if (namedGraphResource.hasProperty(JA.data)) {
                    GraphUtils.multiValueAsString(namedGraphResource, JA.data).forEach(namedGraphData -> RDFDataMgr.read(dataset.getNamedModel(graphName), namedGraphData));
                }
            });
        });
        return dataset;
    }
}

