/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import org.apache.jena.shex.expressions.DatatypeConstraint;
import org.apache.jena.shex.expressions.NodeKindConstraint;
import org.apache.jena.shex.expressions.NumLengthConstraint;
import org.apache.jena.shex.expressions.NumRangeConstraint;
import org.apache.jena.shex.expressions.ShapeExprAND;
import org.apache.jena.shex.expressions.ShapeExprExternal;
import org.apache.jena.shex.expressions.ShapeExprFalse;
import org.apache.jena.shex.expressions.ShapeExprNOT;
import org.apache.jena.shex.expressions.ShapeExprNone;
import org.apache.jena.shex.expressions.ShapeExprOR;
import org.apache.jena.shex.expressions.ShapeExprRef;
import org.apache.jena.shex.expressions.ShapeExprTripleExpr;
import org.apache.jena.shex.expressions.ShapeExprTrue;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.StrLengthConstraint;
import org.apache.jena.shex.expressions.StrRegexConstraint;
import org.apache.jena.shex.expressions.TripleExprVisitor;
import org.apache.jena.shex.expressions.TripleExprWalker;
import org.apache.jena.shex.expressions.ValueConstraint;

public class ShapeExprWalker
implements ShapeExprVisitor {
    private final ShapeExprVisitor beforeVisitor;
    private final ShapeExprVisitor afterVisitor;
    private final TripleExprVisitor tripleExprWalker;

    public ShapeExprWalker(ShapeExprVisitor beforeVisitor, ShapeExprVisitor afterVisitor, TripleExprVisitor beforeTripleExprVisitor, TripleExprVisitor afterTripleExprVisitor) {
        this.beforeVisitor = beforeVisitor;
        this.afterVisitor = afterVisitor;
        this.tripleExprWalker = new TripleExprWalker(beforeTripleExprVisitor, afterTripleExprVisitor, this);
    }

    private void before(ShapeExpression shape) {
        if (this.beforeVisitor != null) {
            shape.visit(this.beforeVisitor);
        }
    }

    private void after(ShapeExpression shape) {
        if (this.afterVisitor != null) {
            shape.visit(this.afterVisitor);
        }
    }

    @Override
    public void visit(ShapeExprAND shape) {
        this.before(shape);
        shape.expressions().forEach(sh -> sh.visit(this));
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprOR shape) {
        this.before(shape);
        shape.expressions().forEach(sh -> sh.visit(this));
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprNOT shape) {
        this.before(shape);
        shape.subShape().visit(this);
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprRef shape) {
        this.before(shape);
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprFalse shape) {
        this.before(shape);
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprNone shape) {
        this.before(shape);
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprTrue shape) {
        this.before(shape);
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprExternal shape) {
        this.before(shape);
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprTripleExpr shape) {
        this.before(shape);
        if (shape.getTripleExpr() != null) {
            shape.getTripleExpr().visit(this.tripleExprWalker);
        }
        this.after(shape);
    }

    @Override
    public void visit(StrRegexConstraint constraint) {
        this.before(constraint);
        this.after(constraint);
    }

    @Override
    public void visit(StrLengthConstraint constraint) {
        this.before(constraint);
        this.after(constraint);
    }

    @Override
    public void visit(DatatypeConstraint constraint) {
        this.before(constraint);
        this.after(constraint);
    }

    @Override
    public void visit(NodeKindConstraint constraint) {
        this.before(constraint);
        this.after(constraint);
    }

    @Override
    public void visit(NumLengthConstraint constraint) {
        this.before(constraint);
        this.after(constraint);
    }

    @Override
    public void visit(NumRangeConstraint constraint) {
        this.before(constraint);
        this.after(constraint);
    }

    @Override
    public void visit(ValueConstraint constraint) {
        this.before(constraint);
        this.after(constraint);
    }
}

