/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.concurrent.ExecutionException;
import org.apache.jena.atlas.lib.cache.CacheInfo;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ext.com.google.common.cache.Cache;
import org.apache.jena.ext.com.google.common.cache.CacheBuilder;
import org.apache.jena.ext.com.google.common.cache.CacheStats;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.FactoryRDFStd;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.graph.NodeConst;

public class FactoryRDFCaching
extends FactoryRDFStd {
    public static final int DftNodeCacheSize = 5000;
    private final Cache<String, Node> cache;

    public FactoryRDFCaching() {
        this(5000, SyntaxLabels.createLabelToNode());
    }

    public FactoryRDFCaching(int cacheSize, LabelToNode labelMapping) {
        super(labelMapping);
        this.cache = this.setCache(cacheSize);
    }

    private Cache<String, Node> setCache(int cacheSize) {
        return CacheBuilder.newBuilder().maximumSize(cacheSize).initialCapacity(cacheSize / 2).concurrencyLevel(1).build();
    }

    @Override
    public Node createURI(String uriStr) {
        try {
            return this.cache.get(uriStr, () -> RiotLib.createIRIorBNode(uriStr));
        }
        catch (ExecutionException e2) {
            throw new RiotException("Execution exception filling cache <" + uriStr + ">", e2);
        }
    }

    @Override
    public Node createTypedLiteral(String lexical, RDFDatatype datatype) {
        if (XSDDatatype.XSDinteger.equals(datatype)) {
            switch (lexical) {
                case "0": {
                    return NodeConst.nodeZero;
                }
                case "1": {
                    return NodeConst.nodeOne;
                }
                case "2": {
                    return NodeConst.nodeTwo;
                }
                case "-1": {
                    return NodeConst.nodeMinusOne;
                }
            }
        } else if (XSDDatatype.XSDboolean.equals(datatype)) {
            switch (lexical) {
                case "true": {
                    return NodeConst.nodeTrue;
                }
                case "false": {
                    return NodeConst.nodeFalse;
                }
            }
        }
        return super.createTypedLiteral(lexical, datatype);
    }

    @Override
    public Node createStringLiteral(String lexical) {
        if (lexical.isEmpty()) {
            return NodeConst.emptyString;
        }
        return super.createStringLiteral(lexical);
    }

    public CacheInfo stats() {
        CacheStats stats = this.cache.stats();
        if (stats.missCount() == 0L && stats.hitCount() == 0L) {
            return null;
        }
        return new CacheInfo(5000, stats);
    }
}

